/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class BooleanEditor
extends JPanel
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final String fieldName;
    private final JCheckBox checkBox;

    @Override
    public void added() {
    }

    public BooleanEditor(String fieldName, Object obj, Field field, int index, Class<?> type) {
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.checkBox.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.checkBox, "Center");
        this.setOpaque(false);
        this.reset();
    }

    @Override
    public void validateValue() {
    }

    @Override
    public void reset() {
        try {
            this.checkBox.setSelected((Boolean)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            boolean oldValue = (Boolean)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            boolean newValue = this.checkBox.isSelected();
            if (oldValue == newValue) {
                return false;
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)this.checkBox.isSelected());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final BooleanEditor t = this;
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
    }
}

