/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComboBox;

public class EnumEditor
extends JComboBox<ComboBoxItem<Integer>>
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final SWFType swfType;
    private String fieldName;
    private Map<Integer, String> values;

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    @Override
    public void added() {
    }

    public EnumEditor(String fieldName, Object obj, Field field, int index, Class<?> type, SWFType swfType, Map<Integer, String> values) {
        this.setSize(100, this.getSize().height);
        this.setMaximumSize(this.getSize());
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.swfType = swfType;
        this.fieldName = fieldName;
        this.values = values;
        Object[] valuesArray = new Integer[values.size()];
        values.keySet().toArray(valuesArray);
        Arrays.sort(valuesArray);
        Object[] objectArray = valuesArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int value = (Integer)objectArray[i];
            this.addItem(new ComboBoxItem<Integer>(value + " - " + values.get(value), value));
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            int value = (Integer)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            for (int i = 0; i < this.getItemCount(); ++i) {
                ComboBoxItem item = (ComboBoxItem)this.getItemAt(i);
                if ((Integer)item.getValue() != value) continue;
                this.setSelectedItem(item);
                break;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            Integer oldValue = (Integer)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            Integer newValue = (Integer)this.getChangedValue();
            if (newValue == null) {
                return false;
            }
            if (Objects.equals(oldValue, newValue)) {
                return false;
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final EnumEditor t = this;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getChangedValue() {
        ComboBoxItem item = (ComboBoxItem)this.getSelectedItem();
        int value = (Integer)item.getValue();
        return value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
    }
}

