/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.helpers;

import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedAction;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedEvent;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ObservableList<E>
implements List<E> {
    private final List<E> list = new ArrayList();
    private final List<CollectionChangedListener<E>> listeners = new ArrayList<CollectionChangedListener<E>>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public boolean move(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return true;
        }
        if (oldIndex < 0 || oldIndex >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(oldIndex);
        }
        if (newIndex < 0 || newIndex > this.size()) {
            throw new ArrayIndexOutOfBoundsException(newIndex);
        }
        E item = this.list.remove(oldIndex);
        if (newIndex > oldIndex) {
            this.list.add(newIndex - 1, item);
        } else {
            this.list.add(newIndex, item);
        }
        this.fireCollectionChanged(new CollectionChangedEvent<E>(CollectionChangedAction.MOVE, item, item, oldIndex, newIndex));
        return true;
    }

    public boolean move(E item, int newIndex) {
        return this.move(this.indexOf(item), newIndex);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.list.removeAll(c);
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.list.retainAll(c);
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
        return result;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.list.addAll(c);
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this.list.addAll(index, c);
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
        return result;
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E result = this.list.set(index, element);
        this.fireCollectionChanged(new CollectionChangedEvent(CollectionChangedAction.RESET));
        return result;
    }

    @Override
    public boolean add(E e) {
        boolean result = this.list.add(e);
        this.fireCollectionChanged(new CollectionChangedEvent<E>(CollectionChangedAction.ADD, e, this.size() - 1));
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireCollectionChanged(new CollectionChangedEvent<E>(CollectionChangedAction.ADD, element, index));
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.list.indexOf(o);
        if (idx != -1) {
            this.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E result = this.list.remove(index);
        this.fireCollectionChanged(new CollectionChangedEvent<E>(CollectionChangedAction.REMOVE, result, index));
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    private void fireCollectionChanged(CollectionChangedEvent<E> e) {
        for (CollectionChangedListener<E> listener : this.listeners) {
            listener.collectionChanged(e);
        }
    }

    public void addCollectionChangedListener(CollectionChangedListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeCollectionChangedListener(CollectionChangedListener<E> listener) {
        this.listeners.remove(listener);
    }
}

