/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.player;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.ZoomPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PlayerControls
extends JPanel
implements MediaDisplayListener {
    private final JButton pauseButton;
    private final JButton loopButton;
    private MediaDisplay display;
    private JProgressBar progress;
    private final JLabel timeLabel;
    private final JLabel frameLabel;
    private final JLabel totalTimeLabel;
    private final JLabel totalFrameLabel;
    private static final Icon pauseIcon;
    private static final Icon playIcon;
    private static final Icon loopIcon;
    private static final Icon noLoopIcon;
    private final ZoomPanel zoomPanel;
    private final JPanel graphicControls;
    private final JPanel playbackControls;
    private final JPanel frameControls;
    private final JButton snapshotButton;
    private final JToggleButton showButton;
    private final JToggleButton freezeButton;
    private final JToggleButton muteButton;
    private final JTextField statusTextField;
    public static final int ZOOM_DECADE_STEPS = 10;
    public static final double ZOOM_MULTIPLIER;
    private static Font underlinedFont;
    private static Font notUnderlinedFont;
    private final int zeroCharacterWidth;
    private JButton selectColorButton;

    private static String underline(String s) {
        return "<html><font color=\"#000099\"><u>" + s + "</u></font></html>";
    }

    public PlayerControls(final MainPanel mainPanel, MediaDisplay display, JPanel middleButtonsPanel) {
        this.setLayout(new BoxLayout(this, 1));
        this.statusTextField = new JTextField(50);
        this.statusTextField.setEditable(false);
        this.statusTextField.setBorder(null);
        this.statusTextField.setBackground(null);
        this.statusTextField.setOpaque(false);
        this.add(this.statusTextField);
        this.graphicControls = new JPanel(new BorderLayout());
        JPanel graphicButtonsPanel = new JPanel(new FlowLayout());
        this.selectColorButton = new JButton(View.getIcon("color16"));
        this.selectColorButton.addActionListener(this::selectBkColorButtonActionPerformed);
        this.selectColorButton.setToolTipText(AppStrings.translate("button.selectbkcolor.hint"));
        this.zoomPanel = new ZoomPanel(display);
        this.zoomPanel.setVisible(false);
        this.snapshotButton = new JButton(View.getIcon("snapshot16"));
        this.snapshotButton.addActionListener(this::snapShotButtonActionPerformed);
        this.snapshotButton.setToolTipText(AppStrings.translate("button.snapshot.hint"));
        this.snapshotButton.setVisible(false);
        graphicButtonsPanel.add(this.zoomPanel);
        graphicButtonsPanel.add(this.selectColorButton);
        graphicButtonsPanel.add(this.snapshotButton);
        JPanel displayButtonsPanel = new JPanel(new FlowLayout());
        this.showButton = new JToggleButton(View.getIcon("show16"));
        this.showButton.addActionListener(this::showButtonActionPerformed);
        this.showButton.setToolTipText(AppStrings.translate("button.show"));
        this.showButton.setVisible(false);
        this.showButton.setSelected((Boolean)Configuration.autoPlayPreviews.get());
        this.freezeButton = new JToggleButton(View.getIcon("freeze16"));
        this.freezeButton.addActionListener(this::freezeButtonActionPerformed);
        this.freezeButton.setToolTipText(AppStrings.translate("button.freeze"));
        this.freezeButton.setVisible(false);
        this.freezeButton.setSelected((Boolean)Configuration.animateSubsprites.get() == false);
        this.muteButton = new JToggleButton(View.getIcon("soundmute16"));
        this.muteButton.addActionListener(this::muteButtonActionPerformed);
        this.muteButton.setToolTipText(AppStrings.translate("button.mute"));
        this.muteButton.setVisible(false);
        this.muteButton.setSelected((Boolean)Configuration.playFrameSounds.get() == false);
        displayButtonsPanel.add(this.showButton);
        displayButtonsPanel.add(this.freezeButton);
        displayButtonsPanel.add(this.muteButton);
        this.graphicControls.add((Component)displayButtonsPanel, "West");
        if (middleButtonsPanel != null) {
            this.graphicControls.add((Component)middleButtonsPanel, "Center");
        }
        this.graphicControls.add((Component)graphicButtonsPanel, "East");
        this.graphicControls.setVisible(false);
        this.add(this.graphicControls);
        this.graphicControls.setVisible(display.screenAvailable());
        this.playbackControls = new JPanel();
        this.display = display;
        JPanel controlPanel = new JPanel(new BorderLayout());
        this.frameLabel = new JLabel("0", 0);
        this.frameLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.frameLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.frameLabel.setVisible(false);
        this.zeroCharacterWidth = this.frameLabel.getFontMetrics(notUnderlinedFont).stringWidth("0");
        this.frameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PlayerControls.this.frameLabel.setFont(underlinedFont);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PlayerControls.this.frameLabel.setFont(notUnderlinedFont);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int gotoFrame = PlayerControls.this.display.getCurrentFrame();
                if (gotoFrame > 0) {
                    mainPanel.gotoFrame(gotoFrame - 1);
                }
            }
        });
        this.timeLabel = new JLabel("(00:00.00)");
        this.totalTimeLabel = new JLabel("(00:00.00)");
        this.totalFrameLabel = new JLabel("0");
        this.totalFrameLabel.setVisible(false);
        this.frameControls = new JPanel(new FlowLayout());
        JButton prevFrameButton = new JButton(View.getIcon("prevframe16"));
        prevFrameButton.setToolTipText(AppStrings.translate("preview.prevframe"));
        prevFrameButton.setMargin(new Insets(4, 2, 2, 2));
        prevFrameButton.addActionListener(this::prevFrameButtonActionPerformed);
        this.frameControls.add(prevFrameButton);
        this.frameControls.setVisible(display.screenAvailable());
        this.frameControls.add(this.frameLabel);
        JButton nextFrameButton = new JButton(View.getIcon("nextframe16"));
        nextFrameButton.setToolTipText(AppStrings.translate("preview.nextframe"));
        nextFrameButton.setMargin(new Insets(4, 2, 2, 2));
        nextFrameButton.addActionListener(this::nextFrameButtonActionPerformed);
        this.frameControls.add(nextFrameButton);
        JButton gotoFrameButton = new JButton(View.getIcon("gotoframe16"));
        gotoFrameButton.setToolTipText(AppStrings.translate("preview.gotoframe"));
        gotoFrameButton.setMargin(new Insets(4, 2, 2, 2));
        gotoFrameButton.addActionListener(this::gotoFrameButtonActionPerformed);
        this.frameControls.add(gotoFrameButton);
        this.frameControls.setVisible(false);
        JPanel currentPanel = new JPanel(new FlowLayout());
        currentPanel.add(this.frameControls);
        currentPanel.add(this.timeLabel);
        JPanel totalPanel = new JPanel(new FlowLayout());
        totalPanel.add(this.totalFrameLabel);
        totalPanel.add(this.totalTimeLabel);
        controlPanel.add((Component)currentPanel, "West");
        controlPanel.add((Component)totalPanel, "East");
        this.playbackControls.setLayout(new BoxLayout(this.playbackControls, 1));
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.pauseButton = new JButton(pauseIcon);
        this.pauseButton.setToolTipText(AppStrings.translate("preview.pause"));
        this.pauseButton.setMargin(new Insets(4, 2, 2, 2));
        this.pauseButton.addActionListener(this::pauseButtonActionPerformed);
        JButton stopButton = new JButton(View.getIcon("stop16"));
        stopButton.setToolTipText(AppStrings.translate("preview.stop"));
        stopButton.setMargin(new Insets(4, 2, 2, 2));
        stopButton.addActionListener(this::stopButtonActionPerformed);
        this.loopButton = new JButton(pauseIcon);
        this.loopButton.setToolTipText(AppStrings.translate("preview.loop"));
        this.loopButton.setMargin(new Insets(4, 2, 2, 2));
        this.loopButton.addActionListener(this::loopButtonActionPerformed);
        boolean loop = (Boolean)Configuration.loopMedia.get();
        this.loopButton.setIcon(loop ? loopIcon : noLoopIcon);
        buttonsPanel.add(this.pauseButton);
        buttonsPanel.add(stopButton);
        buttonsPanel.add(this.loopButton);
        controlPanel.add((Component)buttonsPanel, "Center");
        this.progress = new JProgressBar();
        Dimension pref = this.progress.getPreferredSize();
        pref.height = 20;
        this.progress.setPreferredSize(pref);
        final PlayerControls t = this;
        this.progress.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int frame = (int)Math.floor((double)(e.getX() * t.display.getTotalFrames()) / (double)PlayerControls.this.progress.getWidth());
                boolean p = t.display.isPlaying();
                t.display.gotoFrame(frame);
                if (p) {
                    t.display.play();
                }
            }
        });
        this.playbackControls.add(this.progress);
        this.playbackControls.add(controlPanel);
        this.add(this.playbackControls);
        this.display.addEventListener(this);
    }

    public void setStatus(String status) {
        this.statusTextField.setText(status);
    }

    private String formatMs(long ms) {
        long s = ms / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        return (h > 0L ? h + ":" : "") + this.pad(m %= 60L) + ":" + this.pad(s %= 60L) + "." + this.pad((ms %= 1000L) / 10L);
    }

    private String pad(long t) {
        String ret = Long.toString(t);
        while (ret.length() < 2) {
            ret = "0" + ret;
        }
        return ret;
    }

    public void setMedia(MediaDisplay media) {
        if (this.display != null) {
            this.display.removeEventListener(this);
        }
        this.display = media;
        this.display.addEventListener(this);
        this.update();
    }

    private void update() {
        if (!this.display.isLoaded()) {
            return;
        }
        View.execInEventDispatchLater(() -> {
            boolean paused1;
            this.muteButton.setVisible(this.display.isMutable());
            int totalFrames = this.display.getTotalFrames();
            int currentFrame = this.display.getCurrentFrame();
            if (currentFrame > totalFrames) {
                currentFrame = totalFrames;
            }
            float frameRate = this.display.getFrameRate();
            this.zoomPanel.update();
            this.zoomPanel.setVisible(this.display.zoomAvailable());
            boolean screenAvailable = this.display.screenAvailable();
            this.showButton.setVisible(!this.display.alwaysDisplay() && screenAvailable);
            this.selectColorButton.setVisible(screenAvailable);
            if (!this.display.alwaysDisplay()) {
                this.showButton.setSelected(this.display.isDisplayed());
            }
            this.freezeButton.setVisible(!this.display.alwaysDisplay() && screenAvailable && totalFrames == 0);
            this.snapshotButton.setVisible(screenAvailable);
            this.graphicControls.setVisible(screenAvailable);
            this.totalFrameLabel.setVisible(screenAvailable);
            this.frameLabel.setVisible(screenAvailable);
            if (screenAvailable) {
                int charCount = Math.max(Integer.toString(totalFrames).length(), 3);
                Dimension min = new Dimension(this.zeroCharacterWidth * charCount, this.frameLabel.getPreferredSize().height);
                this.frameLabel.setMinimumSize(min);
                this.frameLabel.setPreferredSize(min);
            }
            this.frameControls.setVisible(screenAvailable);
            if (totalFrames == 0) {
                this.progress.setIndeterminate(true);
            } else {
                this.progress.setMaximum(totalFrames - 1);
                this.progress.setMinimum(0);
                this.progress.setValue(currentFrame - 1);
                this.progress.setIndeterminate(false);
            }
            this.frameLabel.setText(Integer.toString(currentFrame));
            this.totalFrameLabel.setText(Integer.toString(totalFrames));
            if (frameRate != 0.0f) {
                this.timeLabel.setText("(" + this.formatMs((int)((double)(currentFrame - 1) * 1000.0 / (double)frameRate)) + ")");
                this.totalTimeLabel.setText("(" + this.formatMs((int)((double)totalFrames * 1000.0 / (double)frameRate)) + ")");
            }
            if (totalFrames <= 1 && this.playbackControls.isVisible()) {
                this.playbackControls.setVisible(false);
            }
            if (totalFrames > 1 && !this.playbackControls.isVisible()) {
                this.playbackControls.setVisible(true);
            }
            boolean bl = paused1 = !this.display.isPlaying();
            if (paused1) {
                this.pauseButton.setToolTipText(AppStrings.translate("preview.play"));
                this.pauseButton.setIcon(playIcon);
            } else {
                this.pauseButton.setToolTipText(AppStrings.translate("preview.pause"));
                this.pauseButton.setIcon(pauseIcon);
            }
        });
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        if (this.display.isPlaying()) {
            this.display.pause();
        } else {
            this.display.play();
        }
    }

    private void loopButtonActionPerformed(ActionEvent evt) {
        boolean loop = (Boolean)Configuration.loopMedia.get() == false;
        Configuration.loopMedia.set((Object)loop);
        this.loopButton.setIcon(loop ? loopIcon : noLoopIcon);
        this.display.setLoop(loop);
    }

    private void gotoFrameButtonActionPerformed(ActionEvent evt) {
        final JPanel gotoPanel = new JPanel(new BorderLayout());
        final JTextField frameField = new JTextField("" + this.display.getCurrentFrame());
        gotoPanel.add((Component)new JLabel(AppStrings.translate("preview.gotoframe.dialog.message").replace("%min%", "1").replace("%max%", "" + this.display.getTotalFrames())), "North");
        gotoPanel.add((Component)frameField, "Center");
        gotoPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                4 al = this;
                View.execInEventDispatch(() -> {
                    frameField.selectAll();
                    frameField.requestFocusInWindow();
                    gotoPanel.removeAncestorListener(al);
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        if (ViewMessages.showConfirmDialog(this, gotoPanel, AppStrings.translate("preview.gotoframe.dialog.title"), 2, -1) == 0) {
            int frame = -1;
            try {
                frame = Integer.parseInt(frameField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (frame <= 0 || frame > this.display.getTotalFrames()) {
                ViewMessages.showMessageDialog(this, AppStrings.translate("preview.gotoframe.dialog.frame.error").replace("%min%", "1").replace("%max%", "" + this.display.getTotalFrames()), AppStrings.translate("error"), 0);
                return;
            }
            this.display.gotoFrame(frame - 1);
        }
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        this.display.gotoFrame(this.display.getCurrentFrame() + 1);
    }

    private void prevFrameButtonActionPerformed(ActionEvent evt) {
        this.display.gotoFrame(this.display.getCurrentFrame() - 1);
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.display.stop();
    }

    private void selectBkColorButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(null, AppStrings.translate("dialog.selectbkcolor.title"), View.getSwfBackgroundColor());
        if (newColor != null) {
            View.setSwfBackgroundColor(newColor);
            this.display.setBackground(newColor);
        }
    }

    private void snapShotButtonActionPerformed(ActionEvent evt) {
        this.putImageToClipBoard(this.display.printScreen());
    }

    private void showButtonActionPerformed(ActionEvent evt) {
        this.display.setDisplayed(this.showButton.isSelected());
        if (!this.showButton.isSelected()) {
            if (this.display.getTotalFrames() > 0) {
                this.display.stop();
                this.display.rewind();
            }
        } else {
            this.display.play();
        }
    }

    private void freezeButtonActionPerformed(ActionEvent evt) {
        this.display.setFrozen(this.freezeButton.isSelected());
        Configuration.animateSubsprites.set((Object)(!this.freezeButton.isSelected() ? 1 : 0));
    }

    private void muteButtonActionPerformed(ActionEvent evt) {
        this.display.setMuted(this.muteButton.isSelected());
        Configuration.playFrameSounds.set((Object)(!this.muteButton.isSelected() ? 1 : 0));
    }

    @Override
    public void mediaDisplayStateChanged(MediaDisplay source) {
        if (this.display != source) {
            return;
        }
        this.update();
    }

    @Override
    public void playingFinished(MediaDisplay source) {
    }

    @Override
    public void statusChanged(String status) {
        this.setStatus(status);
    }

    private void putImageToClipBoard(BufferedImage img) {
        if (img == null) {
            return;
        }
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
        TransferableImage trans = new TransferableImage(img);
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(trans, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
        System.setErr(originalErr);
    }

    static {
        Font font;
        pauseIcon = View.getIcon("pause16");
        playIcon = View.getIcon("play16");
        loopIcon = View.getIcon("loopon16");
        noLoopIcon = View.getIcon("loopoff16");
        ZOOM_MULTIPLIER = Math.pow(10.0, 0.1);
        underlinedFont = null;
        notUnderlinedFont = null;
        notUnderlinedFont = font = new JLabel().getFont();
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        underlinedFont = font.deriveFont(fontAttributes);
    }

    private class TransferableImage
    implements Transferable {
        Image img;

        public TransferableImage(Image img) {
            this.img = img;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.img != null) {
                return this.img;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

