/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.soleditor;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.amf.amf0.Amf0Exporter;
import com.jpexs.decompiler.flash.exporters.amf.amf3.Amf3Exporter;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.soleditor.SharedObjectsStorage;
import com.jpexs.decompiler.flash.importers.amf.AmfParseException;
import com.jpexs.decompiler.flash.importers.amf.amf0.Amf0Importer;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3Importer;
import com.jpexs.decompiler.flash.sol.SolFile;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class SolEditorFrame
extends AppFrame {
    private File openedFile = null;
    private boolean modified = false;
    private final JButton saveAsButton;
    private final JButton saveButton;
    private JTextField fileNameField = new JTextField(30);
    private JComboBox<Integer> amfVersionComboBox = new JComboBox();
    private JLabel amfVersionLabel = new JLabel();
    private LineMarkedEditorPane editor = new LineMarkedEditorPane();
    private final DocumentListener modifiedListener;

    public SolEditorFrame(final boolean exitOnClose) {
        File ppApiDirectory;
        this.setDefaultCloseOperation(0);
        this.setTitle(this.translate("dialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SolEditorFrame.this.modified && ViewMessages.showConfirmDialog(SolEditorFrame.this, SolEditorFrame.this.translate("warning.loseChanges"), AppStrings.translate("message.warning"), 2, 2) != 0) {
                    return;
                }
                if (exitOnClose) {
                    System.exit(0);
                } else {
                    SolEditorFrame.this.setVisible(false);
                }
            }
        });
        this.modifiedListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setModified();
            }

            private void setModified() {
                if (SolEditorFrame.this.modified) {
                    return;
                }
                SolEditorFrame.this.modified = true;
                SolEditorFrame.this.updateTitle();
            }
        };
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        JButton newButton = new JButton(this.translate("button.new"), View.getIcon("newswf16"));
        newButton.addActionListener(this::newActionPerformed);
        JButton openButton = new JButton(this.translate("button.open"), View.getIcon("open16"));
        openButton.addActionListener(this::openActionPerformed);
        JButton openNpApiButton = new JButton(this.translate("button.open.npapi"), View.getIcon("open16"));
        openNpApiButton.addActionListener(this::openNpApiActionPerformed);
        JButton openPpApiButton = new JButton(this.translate("button.open.ppapi"), View.getIcon("open16"));
        openPpApiButton.addActionListener(this::openPpApiActionPerformed);
        this.saveButton = new JButton(this.translate("button.save"), View.getIcon("save16"));
        this.saveButton.addActionListener(this::saveActionPerformed);
        this.saveButton.setEnabled(false);
        this.saveAsButton = new JButton(this.translate("button.saveAs"), View.getIcon("saveas16"));
        this.saveAsButton.addActionListener(this::saveAsActionPerformed);
        topPanel.add(newButton);
        topPanel.add(openButton);
        File npApiDirectory = SharedObjectsStorage.getNpApiDirectory();
        if (npApiDirectory != null && npApiDirectory.exists()) {
            topPanel.add(openNpApiButton);
        }
        if ((ppApiDirectory = SharedObjectsStorage.getPpApiDirectory()) != null && ppApiDirectory.exists()) {
            topPanel.add(openPpApiButton);
        }
        topPanel.add(this.saveButton);
        topPanel.add(this.saveAsButton);
        this.fileNameField.setText(this.translate("untitled"));
        this.fileNameField.getDocument().addDocumentListener(this.modifiedListener);
        DefaultComboBoxModel<Integer> amfVersionModel = new DefaultComboBoxModel<Integer>();
        amfVersionModel.addElement(0);
        amfVersionModel.addElement(3);
        this.amfVersionComboBox.setModel(amfVersionModel);
        this.amfVersionComboBox.setSelectedIndex(1);
        this.amfVersionLabel.setText("" + this.amfVersionComboBox.getSelectedItem());
        this.amfVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolEditorFrame.this.amfVersionLabel.setText(SolEditorFrame.this.amfVersionComboBox.getSelectedItem().toString());
            }
        });
        this.amfVersionLabel.setVisible(false);
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        bottomPanel.add(new JLabel(this.translate("filename")));
        bottomPanel.add(this.fileNameField);
        bottomPanel.add(Box.createHorizontalStrut(20));
        bottomPanel.add(new JLabel(this.translate("amfVersion")));
        bottomPanel.add(this.amfVersionComboBox);
        bottomPanel.add(this.amfVersionLabel);
        cnt.add((Component)new FasterScrollPane(this.editor), "Center");
        cnt.add((Component)topPanel, "North");
        cnt.add((Component)bottomPanel, "South");
        this.editor.setText("{\r\n\r\n}");
        this.setSize(800, 600);
        View.centerScreen(this);
        View.setWindowIcon(this, "soleditor");
    }

    private void newActionPerformed(ActionEvent e) {
        if (this.modified && ViewMessages.showConfirmDialog(this, this.translate("warning.loseChanges"), AppStrings.translate("message.warning"), 2, 2) != 0) {
            return;
        }
        this.openedFile = null;
        this.editor.setText("{\r\n\r\n}");
        this.modified = false;
        this.amfVersionComboBox.setEnabled(true);
        this.amfVersionComboBox.setSelectedItem(3);
        this.amfVersionLabel.setVisible(false);
        this.amfVersionComboBox.setVisible(true);
        this.updateTitle();
        this.fileNameField.setText(this.translate("untitled"));
    }

    private void openActionPerformed(ActionEvent e) {
        this.openDirectory(new File((String)Configuration.lastSolEditorDirectory.get()));
    }

    private void openNpApiActionPerformed(ActionEvent e) {
        this.openDirectory(SharedObjectsStorage.getNpApiDirectory());
    }

    private void openPpApiActionPerformed(ActionEvent e) {
        this.openDirectory(SharedObjectsStorage.getPpApiDirectory());
    }

    private void openDirectory(File directory) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".sol");
            }

            @Override
            public String getDescription() {
                return SolEditorFrame.this.translate("filter.sol");
            }
        });
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File newFile = Helper.fixDialogFile((File)fileChooser.getSelectedFile());
        try (FileInputStream fis = new FileInputStream(newFile);){
            SolFile solFile = new SolFile((InputStream)fis);
            Map values = solFile.getAmfValues();
            String newFileName = solFile.getFileName();
            int newAmfVersion = solFile.getAmfVersion();
            switch (newAmfVersion) {
                case 0: {
                    this.editor.setText(Amf0Exporter.amfMapToString((Map)values, (int)0, (String)"\r\n"));
                    break;
                }
                case 3: {
                    this.editor.setText(Amf3Exporter.amfMapToString((Map)values, (String)"  ", (String)"\r\n", (int)0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No AMF version found");
                }
            }
            this.fileNameField.setText(newFileName);
            this.amfVersionComboBox.setSelectedItem(newAmfVersion);
            this.amfVersionLabel.setText("" + newAmfVersion);
        }
        catch (IOException | IllegalArgumentException ex) {
            ViewMessages.showMessageDialog(this, this.translate("error.cannotOpen") + " " + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
            return;
        }
        this.modified = false;
        this.openedFile = newFile;
        this.updateTitle();
        Configuration.lastSolEditorDirectory.set((Object)newFile.getParentFile().getAbsolutePath());
        this.saveButton.setEnabled(true);
        this.saveAsButton.setEnabled(true);
        this.amfVersionComboBox.setEnabled(false);
        this.amfVersionComboBox.setVisible(false);
        this.amfVersionLabel.setVisible(true);
    }

    private void updateTitle() {
        this.setTitle(this.translate("dialog.title") + (this.openedFile != null ? " - " + (this.modified ? "*" : "") + this.openedFile.getAbsolutePath() : ""));
    }

    private void saveActionPerformed(ActionEvent e) {
        if (this.openedFile == null) {
            this.saveAsActionPerformed(e);
            return;
        }
        this.saveAs(this.openedFile);
    }

    private void saveAs(File saveFile) {
        try {
            Map amfValues;
            String amfText = this.editor.getText();
            String fileName = this.fileNameField.getText();
            int amfVersion = (Integer)this.amfVersionComboBox.getSelectedItem();
            switch (amfVersion) {
                case 0: {
                    Amf0Importer amf0Importer = new Amf0Importer();
                    amfValues = amf0Importer.stringToAmfMap(amfText);
                    break;
                }
                case 3: {
                    Amf3Importer amf3Importer = new Amf3Importer();
                    amfValues = amf3Importer.stringToAmfMap(amfText);
                    break;
                }
                default: {
                    return;
                }
            }
            try (FileOutputStream fos = new FileOutputStream(saveFile);){
                SolFile solFile = new SolFile(fileName, amfVersion, amfValues);
                solFile.writeTo((OutputStream)fos);
            }
            this.openedFile = saveFile;
            Configuration.lastSolEditorDirectory.set((Object)saveFile.getParentFile().getAbsolutePath());
            this.modified = false;
            this.updateTitle();
            this.amfVersionComboBox.setEnabled(false);
            this.amfVersionComboBox.setVisible(false);
            this.amfVersionLabel.setVisible(true);
            ViewMessages.showMessageDialog(this, this.translate("info.saved"), AppStrings.translate("message.info"), 1);
        }
        catch (AmfParseException ex) {
            this.editor.gotoLine((int)ex.line);
            this.editor.markError();
            ViewMessages.showMessageDialog(this, this.translate("error.parse").replace("%reason%", ex.text).replace("%line%", "" + ex.line), AppStrings.translate("error"), 0);
        }
        catch (IOException ex) {
            ViewMessages.showMessageDialog(this, ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
        }
    }

    private void saveAsActionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".sol");
            }

            @Override
            public String getDescription() {
                return SolEditorFrame.this.translate("filter.sol");
            }
        });
        fileChooser.setCurrentDirectory(new File((String)Configuration.lastSolEditorDirectory.get()));
        if (fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File newFile = Helper.fixDialogFile((File)fileChooser.getSelectedFile());
        this.saveAs(newFile);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.editor.setContentType("text/javascript");
            this.editor.setText("{\r\n\r\n}");
            this.editor.getDocument().addDocumentListener(this.modifiedListener);
        }
    }
}

