/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.taglistview;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TagListTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Font plainFont;
    private Font boldFont;
    private boolean semiTransparent = false;

    public TagListTreeCellRenderer() {
        if (View.isOceanic()) {
            this.setUI(new BasicLabelUI());
            this.setOpaque(false);
            this.setBackgroundNonSelectionColor(Color.white);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.semiTransparent && this.getIcon() != null) {
            Color color = this.getBackground();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 2));
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreeItem val = null;
        if (value instanceof TreeItem) {
            val = (TreeItem)value;
        }
        if (val != null && !(val instanceof OpenableList) && val.getOpenable() == null) {
            value = null;
        }
        Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.selected = sel;
        if (renderer instanceof JLabel) {
            JLabel lab = (JLabel)renderer;
            if (value instanceof TreeItem) {
                AbstractTagTreeModel model;
                int itemIndex;
                Set<Integer> missingNeededCharacters;
                Font font;
                lab.setIcon(TagTree.getIconForType(TagTree.getTreeNodeType((TreeItem)value)));
                boolean isReadOnly = false;
                if (val instanceof Tag) {
                    isReadOnly = ((Tag)val).isReadOnly();
                }
                boolean isModified = val instanceof Frame ? ((Frame)val).isAllInnerTagsModified() : val.isModified();
                if (isReadOnly) {
                    isModified = false;
                }
                if (isModified) {
                    if (this.boldFont == null) {
                        font = this.getFont();
                        this.boldFont = font.deriveFont(1);
                    }
                } else if (this.plainFont == null) {
                    font = this.getFont();
                    this.plainFont = font.deriveFont(0);
                }
                this.setFont(isModified ? this.boldFont : this.plainFont);
                if (View.isOceanic()) {
                    if (isReadOnly) {
                        this.setForeground(new Color(204, 204, 204));
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                }
                this.setToolTipText(null);
                AbstractTagTree aTree = (AbstractTagTree)tree;
                Map<TreeItem, Set<Integer>> allMissingNeededCharacters = aTree.getMissingNeededCharacters();
                if (allMissingNeededCharacters.containsKey((TreeItem)value) && !(missingNeededCharacters = allMissingNeededCharacters.get(value)).isEmpty()) {
                    ArrayList<String> missingAsStr = new ArrayList<String>();
                    for (int v : missingNeededCharacters) {
                        missingAsStr.add("" + v);
                    }
                    if (missingAsStr.size() == 1) {
                        lab.setToolTipText(AppStrings.translate("error.missing.characterTag.single").replace("%tag%", (CharSequence)missingAsStr.get(0)));
                    } else {
                        lab.setToolTipText(AppStrings.translate("error.missing.characterTag.multi").replace("%tags%", String.join((CharSequence)", ", missingAsStr)));
                    }
                    this.setForeground(Color.red);
                }
                this.semiTransparent = false;
                if (aTree.getMainPanel().isClipboardCut() && aTree.getMainPanel().clipboardContains(val)) {
                    this.semiTransparent = true;
                }
                if ((itemIndex = (model = aTree.getFullModel()).getItemIndex(val)) > 1) {
                    lab.setText(lab.getText() + " [" + itemIndex + "]");
                }
            }
        }
        return renderer;
    }
}

