/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.taglistview;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedAction;
import com.jpexs.decompiler.flash.gui.helpers.CollectionChangedEvent;
import com.jpexs.decompiler.flash.gui.taglistview.TagListTreeRoot;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class TagListTreeModel
extends AbstractTagTreeModel {
    private final TagListTreeRoot root = new TagListTreeRoot();
    private List<OpenableList> swfs;
    private Map<SWF, HeaderItem> swfHeaders = new HashMap<SWF, HeaderItem>();
    private final Map<ABCContainerTag, ClassesListTreeModel> abcTagsClassesTree = new WeakHashMap<ABCContainerTag, ClassesListTreeModel>();
    private final Map<ABC, ClassesListTreeModel> abcClassesTree = new WeakHashMap<ABC, ClassesListTreeModel>();

    public TagListTreeModel(List<OpenableList> swfs) {
        this.swfs = swfs;
    }

    @Override
    public TreeItem getRoot() {
        return this.root;
    }

    private ClassesListTreeModel getTagClassesListTreeModel(ABCContainerTag abcContainer) {
        if (this.abcTagsClassesTree.containsKey(abcContainer)) {
            return this.abcTagsClassesTree.get(abcContainer);
        }
        ClassesListTreeModel model = new ClassesListTreeModel(abcContainer.getABC(), (boolean)((Boolean)Configuration.flattenASPackages.get()));
        this.abcTagsClassesTree.put(abcContainer, model);
        return model;
    }

    private ClassesListTreeModel getClassesListTreeModel(ABC abc) {
        if (this.abcClassesTree.containsKey(abc)) {
            return this.abcClassesTree.get(abc);
        }
        ClassesListTreeModel model = new ClassesListTreeModel(abc, (boolean)((Boolean)Configuration.flattenASPackages.get()));
        this.abcClassesTree.put(abc, model);
        return model;
    }

    private HeaderItem getSwfHeader(SWF swf) {
        if (this.swfHeaders.containsKey(swf)) {
            return this.swfHeaders.get(swf);
        }
        HeaderItem header = new HeaderItem(swf, this.translate("node.header"));
        this.swfHeaders.put(swf, header);
        return header;
    }

    private String translate(String key) {
        return AppStrings.translate(key);
    }

    @Override
    public TreeItem getChild(Object parent, int index) {
        TreeItem result = this.getChildInternal(parent, index);
        if (result != null) {
            this.itemToParentCache.put(result, (TreeItem)parent);
        }
        return result;
    }

    private TreeItem getChildInternal(Object parent, int index) {
        if (this.getChildCount(parent) == 0) {
            return null;
        }
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode == this.root) {
            OpenableList swfList = this.swfs.get(index);
            if (!swfList.isBundle()) {
                return swfList.get(0);
            }
            return swfList;
        }
        if (parentNode instanceof OpenableList) {
            return (TreeItem)((OpenableList)parentNode).items.get(index);
        }
        if (parentNode instanceof SWF) {
            if (index == 0) {
                return this.getSwfHeader((SWF)parentNode);
            }
            return ((SWF)parentNode).getTimeline().getFrame(index - 1);
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrame(index);
        }
        if (parentNode instanceof Frame) {
            return (TreeItem)((Frame)parentNode).allInnerTags.get(index);
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return ((DefineBinaryDataTag)parentNode).innerSwf;
        }
        if (parentNode instanceof ABCContainerTag) {
            ClassesListTreeModel classesListTreeModel = this.getTagClassesListTreeModel((ABCContainerTag)parentNode);
            return classesListTreeModel.getChild(classesListTreeModel.getRoot(), index);
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            return ((AS3Package)parentNode).getChild(index);
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesListTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesListTreeModel.getChild(classesListTreeModel.getRoot(), index);
        }
        if (parentNode instanceof ButtonTag) {
            if (index < ((ButtonTag)parentNode).getRecords().size()) {
                return (TreeItem)((ButtonTag)parentNode).getRecords().get(index);
            }
            index -= ((ButtonTag)parentNode).getRecords().size();
        }
        if (parentNode instanceof ASMSourceContainer) {
            return (TreeItem)((ASMSourceContainer)parentNode).getSubItems().get(index);
        }
        throw new Error("Unsupported parent type: " + parentNode.getClass().getName());
    }

    @Override
    public int getChildCount(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode == this.root) {
            return this.swfs.size();
        }
        if (parentNode instanceof OpenableList) {
            return ((OpenableList)parentNode).items.size();
        }
        if (parentNode instanceof SWF) {
            return ((SWF)parentNode).getTimeline().getFrameCount() + 1;
        }
        if (parentNode instanceof HeaderItem) {
            return 0;
        }
        if (parentNode instanceof Frame) {
            return ((Frame)parentNode).allInnerTags.size();
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrameCount();
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return ((DefineBinaryDataTag)parentNode).innerSwf == null ? 0 : 1;
        }
        if (parentNode instanceof ABCContainerTag) {
            ClassesListTreeModel classesListTreeModel = this.getTagClassesListTreeModel((ABCContainerTag)parentNode);
            return classesListTreeModel.getChildCount(classesListTreeModel.getRoot());
        }
        if (parentNode instanceof AS3Package) {
            return ((AS3Package)parentNode).getChildCount();
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesListTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesListTreeModel.getChildCount(classesListTreeModel.getRoot());
        }
        int size = 0;
        if (parentNode instanceof ButtonTag) {
            size += ((ButtonTag)parentNode).getRecords().size();
        }
        if (parentNode instanceof ASMSourceContainer) {
            size += ((ASMSourceContainer)parentNode).getSubItems().size();
        }
        return size;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index;
        if (this.getChildCount(parent) == 0) {
            return -1;
        }
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode == this.root) {
            OpenableList openableListswfList = child instanceof OpenableList ? (OpenableList)child : ((Openable)child).getOpenableList();
            return this.swfs.indexOf(openableListswfList);
        }
        if (parentNode instanceof OpenableList) {
            return ((OpenableList)parentNode).items.indexOf(child);
        }
        if (parentNode instanceof SWF) {
            HeaderItem header = this.getSwfHeader((SWF)parentNode);
            if (header == child) {
                return 0;
            }
            if (!(child instanceof Frame)) {
                return -1;
            }
            return ((Frame)child).frame + 1;
        }
        if (parentNode instanceof DefineSpriteTag) {
            if (((Frame)child).timeline != ((DefineSpriteTag)parentNode).getTimeline()) {
                return -1;
            }
            return ((Frame)child).frame;
        }
        if (parentNode instanceof Frame) {
            return ((Frame)parentNode).allInnerTags.indexOf(child);
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            return ((DefineBinaryDataTag)parentNode).innerSwf == child ? 0 : -1;
        }
        if (parentNode instanceof ABCContainerTag) {
            ClassesListTreeModel classesListTreeModel = this.getTagClassesListTreeModel((ABCContainerTag)parentNode);
            return classesListTreeModel.getIndexOfChild(classesListTreeModel.getRoot(), child);
        }
        if (parentNode instanceof AS3Package) {
            return ((AS3Package)parentNode).getIndexOfChild((AS3ClassTreeItem)child);
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesListTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesListTreeModel.getIndexOfChild(classesListTreeModel.getRoot(), child);
        }
        int base = 0;
        if (parentNode instanceof ButtonTag) {
            index = ((ButtonTag)parentNode).getRecords().indexOf(child);
            if (index > -1) {
                return index;
            }
            base = ((ButtonTag)parentNode).getRecords().size();
        }
        if (parentNode instanceof ASMSourceContainer) {
            index = ((ASMSourceContainer)parentNode).getSubItems().indexOf(child);
            if (index == -1) {
                return -1;
            }
            return base + index;
        }
        return -1;
    }

    @Override
    public void updateSwfs(CollectionChangedEvent e) {
        if (e.getAction() != CollectionChangedAction.ADD && e.getAction() != CollectionChangedAction.MOVE) {
            ArrayList<SWF> toRemove = new ArrayList<SWF>();
            for (SWF swf : this.swfHeaders.keySet()) {
                SWF swf2 = swf.getRootSwf();
                if (swf2 == null || this.swfs.contains(swf2.openableList)) continue;
                toRemove.add(swf);
            }
            for (SWF swf : toRemove) {
                this.swfHeaders.remove(swf);
                this.uncacheSwf(swf);
            }
        }
        switch (e.getAction()) {
            case ADD: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesInserted(new TreeModelEvent((Object)this, rootPath, new int[]{e.getNewIndex()}, new Object[]{e.getNewItem()}));
                break;
            }
            case REMOVE: {
                TreePath rootPath = new TreePath(new Object[]{this.root});
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, rootPath, new int[]{e.getOldIndex()}, new Object[]{e.getOldItem()}));
                break;
            }
            default: {
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.root)));
            }
        }
        this.calculateCollisions();
    }

    private Frame searchForFrame(Object parent, SWF swf, Timelined t, int frame) {
        int childCount = this.getChildCount(parent);
        Frame lastVisibleFrame = null;
        for (int i = 0; i < childCount; ++i) {
            Frame si;
            TreeItem child = this.getChild(parent, i);
            if (child instanceof DefineSpriteTag && child == t && (si = this.searchForFrame(child, swf, t, frame)) != null) {
                return si;
            }
            if (!(child instanceof Frame)) continue;
            Frame f = (Frame)child;
            if (f.frame > frame) continue;
            lastVisibleFrame = f;
        }
        return lastVisibleFrame;
    }

    @Override
    public Frame getFrame(SWF swf, Timelined t, int frame) {
        return this.searchForFrame(swf, swf, t, frame);
    }

    @Override
    public List<? extends TreeItem> getAllChildren(Object parent) {
        List<? extends TreeItem> ret = this.getAllChildrenInternal(parent);
        for (TreeItem treeItem : ret) {
            this.itemToParentCache.put(treeItem, (TreeItem)parent);
        }
        return ret;
    }

    private List<? extends TreeItem> getAllChildrenInternal(Object parent) {
        TreeItem parentNode = (TreeItem)parent;
        if (parentNode == this.root) {
            ArrayList<Object> result = new ArrayList<Object>(this.swfs.size());
            for (OpenableList swfList : this.swfs) {
                if (!swfList.isBundle()) {
                    result.add(swfList.get(0));
                    continue;
                }
                result.add(swfList);
            }
            return result;
        }
        if (parentNode instanceof OpenableList) {
            return ((OpenableList)parentNode).items;
        }
        if (parentNode instanceof SWF) {
            ArrayList<HeaderItem> ret = new ArrayList<HeaderItem>();
            ret.add(this.getSwfHeader((SWF)parentNode));
            ret.addAll(((SWF)parentNode).getTimeline().getFrames());
            return ret;
        }
        if (parentNode instanceof Frame) {
            return ((Frame)parentNode).allInnerTags;
        }
        if (parentNode instanceof DefineSpriteTag) {
            return ((DefineSpriteTag)parentNode).getTimeline().getFrames();
        }
        if (parentNode instanceof DefineBinaryDataTag) {
            DefineBinaryDataTag binaryDataTag = (DefineBinaryDataTag)parentNode;
            if (binaryDataTag.innerSwf != null) {
                ArrayList<SWF> result = new ArrayList<SWF>(1);
                result.add(((DefineBinaryDataTag)parentNode).innerSwf);
                return result;
            }
            return new ArrayList(0);
        }
        if (parentNode instanceof ABCContainerTag) {
            ClassesListTreeModel classesListTreeModel = this.getTagClassesListTreeModel((ABCContainerTag)parentNode);
            return classesListTreeModel.getAllChildren(classesListTreeModel.getRoot());
        }
        if (parentNode instanceof AS3ClassTreeItem) {
            if (parentNode instanceof AS3Package) {
                return ((AS3Package)parentNode).getAllChildren();
            }
            return new ArrayList();
        }
        if (parentNode instanceof ABC) {
            ClassesListTreeModel classesListTreeModel = this.getClassesListTreeModel((ABC)parentNode);
            return classesListTreeModel.getAllChildren(classesListTreeModel.getRoot());
        }
        ArrayList ret = new ArrayList();
        if (parentNode instanceof ButtonTag) {
            ret.addAll(((ButtonTag)parentNode).getRecords());
        }
        if (parentNode instanceof ASMSourceContainer) {
            ret.addAll(((ASMSourceContainer)parentNode).getSubItems());
        }
        return ret;
    }

    @Override
    protected void searchTreeItemMulti(List<TreeItem> objs, TreeItem parent, List<TreeItem> path, Map<TreeItem, List<TreeItem>> result) {
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
            newPath.addAll(path);
            newPath.add(treeItem);
            for (TreeItem obj : objs) {
                if (obj != treeItem) continue;
                result.put(obj, newPath);
            }
            this.searchTreeItemMulti(objs, treeItem, newPath, result);
        }
    }

    @Override
    protected void searchTreeItemParentMulti(List<TreeItem> objs, TreeItem parent, Map<TreeItem, TreeItem> result) {
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            for (TreeItem obj : objs) {
                if (obj != treeItem) continue;
                result.put(obj, parent);
                if (result.size() != objs.size()) continue;
                return;
            }
            this.searchTreeItemParentMulti(objs, treeItem, result);
            if (result.size() != objs.size()) continue;
            return;
        }
    }

    @Override
    protected List<TreeItem> searchTreeItem(TreeItem obj, TreeItem parent, List<TreeItem> path) {
        List<TreeItem> ret = null;
        for (TreeItem treeItem : this.getAllChildren(parent)) {
            ArrayList<TreeItem> newPath = new ArrayList<TreeItem>();
            newPath.addAll(path);
            newPath.add(treeItem);
            if (obj == treeItem) {
                return newPath;
            }
            ret = this.searchTreeItem(obj, treeItem, newPath);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public TreePath getTreePath(TreeItem obj) {
        List<TreeItem> path = new ArrayList<TreeItem>();
        path.add(this.root);
        if (obj != this.root) {
            path = this.searchTreeItem(obj, this.root, path);
        }
        if (path == null) {
            return null;
        }
        TreePath tp = new TreePath(path.toArray(new Object[path.size()]));
        return tp;
    }

    @Override
    public void updateOpenable(Openable openable) {
        this.swfHeaders.clear();
        this.abcTagsClassesTree.clear();
        this.abcClassesTree.clear();
        TreePath changedPath = this.getTreePath(openable == null ? this.root : openable);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, changedPath));
        this.calculateCollisions();
    }
}

