/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.SWC;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.ZippedBundle;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.soleditor.Cookie;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeContextMenu;
import com.jpexs.decompiler.flash.iggy.conversion.IggySwfBundle;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.CSMSettingsTag;
import com.jpexs.decompiler.flash.tags.CharacterSetTag;
import com.jpexs.decompiler.flash.tags.DebugIDTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineFont3Tag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineFontAlignZonesTag;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.DefineFontTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSceneAndFrameLabelDataTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineTextFormatTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DefineVideoTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EnableDebugger2Tag;
import com.jpexs.decompiler.flash.tags.EnableDebuggerTag;
import com.jpexs.decompiler.flash.tags.EnableTelemetryTag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.FontRefTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.FreeCharacterTag;
import com.jpexs.decompiler.flash.tags.GenCommandTag;
import com.jpexs.decompiler.flash.tags.ImportAssets2Tag;
import com.jpexs.decompiler.flash.tags.ImportAssetsTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.NameCharacterTag;
import com.jpexs.decompiler.flash.tags.PlaceImagePrivateTag;
import com.jpexs.decompiler.flash.tags.ProductInfoTag;
import com.jpexs.decompiler.flash.tags.ProtectTag;
import com.jpexs.decompiler.flash.tags.ScriptLimitsTag;
import com.jpexs.decompiler.flash.tags.SerialNumberTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.SetTabIndexTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.SoundStreamHead2Tag;
import com.jpexs.decompiler.flash.tags.SoundStreamHeadTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.SyncFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagStub;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.FontInfoTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalStreamSound;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.AS3Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.Scene;
import com.jpexs.decompiler.flash.timeline.SceneFrame;
import com.jpexs.decompiler.flash.timeline.SoundStreamFrameRange;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTagTree
extends JTree {
    public TagTreeContextMenu contextPopupMenu;
    protected final MainPanel mainPanel;
    private AbstractTagTreeModel fullModel;
    private static final Map<TreeNodeType, Icon> ICONS = new HashMap<TreeNodeType, Icon>();
    protected Map<TreeItem, Set<Integer>> missingNeededCharacters = new WeakHashMap<TreeItem, Set<Integer>>();

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        if (newModel instanceof AbstractTagTreeModel) {
            this.fullModel = (AbstractTagTreeModel)newModel;
        }
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public Map<TreeItem, Set<Integer>> getMissingNeededCharacters() {
        return this.missingNeededCharacters;
    }

    public void setMissingNeededCharacters(Map<TreeItem, Set<Integer>> missingNeededCharacters) {
        this.missingNeededCharacters = missingNeededCharacters;
        this.repaint();
    }

    public static Icon getIconForType(TreeNodeType t) {
        return ICONS.get((Object)t);
    }

    public static Icon getIconFor(TreeItem val) {
        return AbstractTagTree.getIconFor(val, false);
    }

    public static Icon getIconFor(TreeItem val, boolean folderExpanded) {
        ScriptPack sp;
        FrameScript fs;
        if (val instanceof SoundStreamHeadTypeTag) {
            return View.getIcon("foldersounds16");
        }
        if (val instanceof ClassesListTreeModel) {
            return View.getIcon("folderscripts16");
        }
        TreeNodeType type = AbstractTagTree.getTreeNodeType(val);
        if (val instanceof FrameScript && (fs = (FrameScript)val).getSingleDoActionTag() != null) {
            type = TreeNodeType.AS_FRAME;
        }
        if (type == TreeNodeType.FOLDER && folderExpanded) {
            type = TreeNodeType.FOLDER_OPEN;
        }
        if (val instanceof ScriptPack && (sp = (ScriptPack)val).isDocumentClass()) {
            return View.getIcon("asclassmain16");
        }
        if ((type == TreeNodeType.FOLDER || type == TreeNodeType.FOLDER_OPEN) && val instanceof FolderItem) {
            FolderItem si = (FolderItem)val;
            if (!"root".equals(si.getName())) {
                String itemName = "folder" + si.getName();
                return View.getIcon(itemName.toLowerCase(Locale.ENGLISH) + "16");
            }
        } else {
            return AbstractTagTree.getIconForType(type);
        }
        return null;
    }

    public AbstractTagTree(AbstractTagTreeModel treeModel, final MainPanel mainPanel) {
        super(treeModel);
        this.mainPanel = mainPanel;
        this.setRootVisible(false);
        if (View.isOceanic()) {
            this.setBackground(Color.white);
        }
        this.setRowHeight(Math.max(this.getFont().getSize() + 5, 16));
        this.setLargeModel(true);
        this.setUI(new BasicTreeUI(){
            {
                if (View.isOceanic()) {
                    this.setHashColor(Color.gray);
                }
            }

            @Override
            protected MouseListener createMouseListener() {
                final MouseListener handler = super.createMouseListener();
                return new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        handler.mouseClicked(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        handler.mousePressed(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        handler.mouseReleased(e);
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        handler.mouseEntered(e);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        handler.mouseReleased(e);
                        handler.mouseExited(e);
                    }
                };
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!((Boolean)Configuration.doubleClickNodeToEdit.get()).booleanValue()) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                TreeItem item = AbstractTagTree.this.getCurrentTreeItem();
                if (!AbstractTagTree.this.getModel().isLeaf(item)) {
                    return;
                }
                mainPanel.startEdit();
            }
        });
    }

    public static TreeNodeType getTreeNodeType(TreeItem t) {
        OpenableList slist;
        if (t instanceof TagScript) {
            t = ((TagScript)t).getTag();
        }
        if (t instanceof HeaderItem) {
            return TreeNodeType.HEADER;
        }
        if (t instanceof DefineFontTag || t instanceof DefineFont2Tag || t instanceof DefineFont3Tag || t instanceof DefineFont4Tag || t instanceof DefineCompactedFont) {
            return TreeNodeType.FONT;
        }
        if (t instanceof TextTag) {
            return TreeNodeType.TEXT;
        }
        if (t instanceof CSMSettingsTag) {
            return TreeNodeType.CSM_SETTINGS;
        }
        if (t instanceof ImageTag) {
            return TreeNodeType.IMAGE;
        }
        if (t instanceof ShapeTag) {
            return TreeNodeType.SHAPE;
        }
        if (t instanceof MorphShapeTag) {
            return TreeNodeType.MORPH_SHAPE;
        }
        if (t instanceof DefineSpriteTag) {
            return TreeNodeType.SPRITE;
        }
        if (t instanceof ButtonTag) {
            return TreeNodeType.BUTTON;
        }
        if (t instanceof DefineButtonCxformTag) {
            return TreeNodeType.BUTTON_CXFORM;
        }
        if (t instanceof DefineButtonSoundTag) {
            return TreeNodeType.BUTTON_SOUND;
        }
        if (t instanceof BUTTONRECORD) {
            return TreeNodeType.BUTTON_RECORD;
        }
        if (t instanceof DefineVideoStreamTag) {
            return TreeNodeType.MOVIE;
        }
        if (t instanceof VideoFrameTag) {
            return TreeNodeType.VIDEO_FRAME;
        }
        if (t instanceof DefineSoundTag || t instanceof SoundStreamHeadTag || t instanceof SoundStreamHead2Tag || t instanceof DefineExternalSound || t instanceof DefineExternalStreamSound) {
            return TreeNodeType.SOUND;
        }
        if (t instanceof SoundStreamFrameRange) {
            return TreeNodeType.SOUND_STREAM_RANGE;
        }
        if (t instanceof SoundStreamBlockTag) {
            return TreeNodeType.SOUND_STREAM_BLOCK;
        }
        if (t instanceof BinaryDataInterface) {
            return TreeNodeType.BINARY_DATA;
        }
        if (((Boolean)Configuration.useAsTypeIcons.get()).booleanValue()) {
            if (t instanceof DoInitActionTag) {
                DoInitActionTag doInit = (DoInitActionTag)t;
                if (doInit.getSwf().getExportName(doInit.spriteId) != null) {
                    return TreeNodeType.AS_CLASS;
                }
                return TreeNodeType.AS_INIT;
            }
            if (t instanceof CLIPACTIONRECORD) {
                return TreeNodeType.AS_CLIP;
            }
            if (t instanceof BUTTONCONDACTION) {
                return TreeNodeType.AS_BUTTON;
            }
            if (t instanceof DoActionTag) {
                return TreeNodeType.AS_FRAME;
            }
        }
        if (t instanceof ASMSource) {
            return TreeNodeType.AS;
        }
        if (t instanceof ScriptPack) {
            if (((Boolean)Configuration.useAsTypeIcons.get()).booleanValue()) {
                ScriptPack pack = (ScriptPack)t;
                Trait trait = pack.getPublicTrait();
                if (trait == null) {
                    return TreeNodeType.AS;
                }
                if (trait instanceof TraitFunction) {
                    return TreeNodeType.AS_FUNCTION;
                }
                if (trait instanceof TraitMethodGetterSetter) {
                    return TreeNodeType.AS_FUNCTION;
                }
                if (trait instanceof TraitSlotConst) {
                    TraitSlotConst traitSlotConst = (TraitSlotConst)trait;
                    if (traitSlotConst.isConst()) {
                        return TreeNodeType.AS_CONST;
                    }
                    return TreeNodeType.AS_VAR;
                }
                if (trait instanceof TraitClass) {
                    TraitClass traitClass = (TraitClass)trait;
                    if (((InstanceInfo)pack.abc.instance_info.get(traitClass.class_info)).isInterface()) {
                        return TreeNodeType.AS_INTERFACE;
                    }
                    return TreeNodeType.AS_CLASS;
                }
            }
            return TreeNodeType.AS;
        }
        if (t instanceof AS2Package) {
            return TreeNodeType.PACKAGE;
        }
        if (t instanceof AS3Package) {
            AS3Package pkg = (AS3Package)t;
            if (pkg.isCompoundScript()) {
                return TreeNodeType.AS;
            }
            return TreeNodeType.PACKAGE;
        }
        if (t instanceof Frame || t instanceof FrameScript || t instanceof SceneFrame) {
            return TreeNodeType.FRAME;
        }
        if (t instanceof Scene) {
            return TreeNodeType.SCENE;
        }
        if (t instanceof ShowFrameTag) {
            return TreeNodeType.SHOW_FRAME;
        }
        if (t instanceof FrameLabelTag) {
            return TreeNodeType.FRAME_LABEL;
        }
        if (t instanceof StartSoundTag || t instanceof StartSound2Tag) {
            return TreeNodeType.START_SOUND;
        }
        if (t instanceof SWF) {
            return TreeNodeType.FLASH;
        }
        if (t instanceof OpenableList && (slist = (OpenableList)t).isBundle()) {
            if (slist.bundle.getClass() == ZippedBundle.class) {
                return TreeNodeType.BUNDLE_ZIP;
            }
            if (slist.bundle.getClass() == SWC.class) {
                return TreeNodeType.BUNDLE_SWC;
            }
            if (slist.bundle.getClass() == IggySwfBundle.class) {
                return TreeNodeType.BUNDLE_IGGY;
            }
            return TreeNodeType.BUNDLE_BINARY;
        }
        if (t instanceof SetBackgroundColorTag) {
            return TreeNodeType.SET_BACKGROUNDCOLOR;
        }
        if (t instanceof FileAttributesTag) {
            return TreeNodeType.FILE_ATTRIBUTES;
        }
        if (t instanceof MetadataTag) {
            return TreeNodeType.METADATA;
        }
        if (t instanceof PlaceObjectTypeTag) {
            return TreeNodeType.PLACE_OBJECT;
        }
        if (t instanceof PlaceImagePrivateTag) {
            return TreeNodeType.PLACE_IMAGE_PRIVATE;
        }
        if (t instanceof RemoveTag) {
            return TreeNodeType.REMOVE_OBJECT;
        }
        if (t instanceof DefineScalingGridTag) {
            return TreeNodeType.SCALING_GRID;
        }
        if (t instanceof ABCContainerTag) {
            return TreeNodeType.AS_ABC;
        }
        if (t instanceof DefineFontAlignZonesTag) {
            return TreeNodeType.FONT_ALIGN_ZONES;
        }
        if (t instanceof FontInfoTag) {
            return TreeNodeType.FONT_INFO;
        }
        if (t instanceof DefineFontNameTag) {
            return TreeNodeType.FONT_NAME;
        }
        if (t instanceof EndTag) {
            return TreeNodeType.END;
        }
        if (t instanceof ProtectTag || t instanceof EnableDebuggerTag || t instanceof EnableDebugger2Tag) {
            return TreeNodeType.ENABLE_DEBUGGER;
        }
        if (t instanceof EnableTelemetryTag) {
            return TreeNodeType.ENABLE_TELEMETRY;
        }
        if (t instanceof ExportAssetsTag) {
            return TreeNodeType.EXPORT_ASSETS;
        }
        if (t instanceof ImportAssetsTag || t instanceof ImportAssets2Tag) {
            return TreeNodeType.IMPORT_ASSETS;
        }
        if (t instanceof JPEGTablesTag) {
            return TreeNodeType.JPEG_TABLES;
        }
        if (t instanceof ProductInfoTag) {
            return TreeNodeType.PRODUCT_INFO;
        }
        if (t instanceof ScriptLimitsTag) {
            return TreeNodeType.SCRIPT_LIMITS;
        }
        if (t instanceof SetTabIndexTag) {
            return TreeNodeType.SET_TABINDEX;
        }
        if (t instanceof SymbolClassTag) {
            return TreeNodeType.SYMBOL_CLASS;
        }
        if (t instanceof DefineSceneAndFrameLabelDataTag) {
            return TreeNodeType.SCENE_AND_FRAME_LABEL_DATA;
        }
        if (t instanceof DebugIDTag) {
            return TreeNodeType.DEBUG_ID;
        }
        if (t instanceof DefineVideoTag) {
            return TreeNodeType.MOVIE_REF;
        }
        if (t instanceof FreeCharacterTag) {
            return TreeNodeType.FREE_CHARACTER;
        }
        if (t instanceof SyncFrameTag) {
            return TreeNodeType.SYNC_FRAME;
        }
        if (t instanceof NameCharacterTag) {
            return TreeNodeType.NAME_CHARACTER;
        }
        if (t instanceof DefineTextFormatTag) {
            return TreeNodeType.TEXT_FORMAT;
        }
        if (t instanceof CharacterSetTag) {
            return TreeNodeType.CHARACTER_SET;
        }
        if (t instanceof FontRefTag) {
            return TreeNodeType.FONT_REF;
        }
        if (t instanceof GenCommandTag) {
            return TreeNodeType.GEN_COMMAND;
        }
        if (t instanceof SerialNumberTag) {
            return TreeNodeType.SERIAL_NUMBER;
        }
        if (t instanceof TagStub) {
            return TreeNodeType.ERRORED;
        }
        if (t instanceof UnknownTag) {
            return TreeNodeType.UNKNOWN;
        }
        if (t instanceof Tag) {
            return TreeNodeType.OTHER_TAG;
        }
        if (t instanceof FolderItem) {
            return TreeNodeType.FOLDER;
        }
        if (t instanceof ABC) {
            return TreeNodeType.ABC;
        }
        if (t instanceof Cookie) {
            return TreeNodeType.COOKIE;
        }
        return TreeNodeType.FOLDER;
    }

    public AbstractTagTreeModel getFullModel() {
        return this.fullModel;
    }

    public void expandRoot() {
        TreeModel ttm = this.getModel();
        Object root = ttm.getRoot();
        this.expandPath(new TreePath(new Object[]{root}));
    }

    public void expandFirstLevelNodes() {
        TreeModel ttm = this.getModel();
        Object root = ttm.getRoot();
        int childCount = ttm.getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            this.expandPath(new TreePath(new Object[]{root, ttm.getChild(root, i)}));
        }
    }

    public void setExpandPathString(String pathStr) {
        String[] path;
        TreePath tp;
        if (pathStr != null && pathStr.length() > 0 && (tp = View.getTreePathByPathStrings(this, Arrays.asList(path = pathStr.split("\\|")))) != null) {
            this.expandPath(tp.getParentPath());
        }
    }

    public TreePath getTreePathFromString(String pathStr) {
        if (pathStr == null || pathStr.length() == 0) {
            return null;
        }
        String[] path = pathStr.split("\\|");
        return View.getTreePathByPathStrings(this, Arrays.asList(path));
    }

    public TreeItem getTreeItemFromPathString(String pathStr) {
        TreePath path = this.getTreePathFromString(pathStr);
        if (path == null) {
            return null;
        }
        return (TreeItem)path.getLastPathComponent();
    }

    public void setSelectionPathString(String pathStr) {
        TreeItem item = this.getTreeItemFromPathString(pathStr);
        if (item != null) {
            this.mainPanel.setTagTreeSelectedNode(this, item);
        }
    }

    public void getAllSubs(TreeItem o, List<TreeItem> ret) {
        AbstractTagTreeModel tm = this.getFullModel();
        for (TreeItem treeItem : tm.getAllChildren(o)) {
            ret.add(treeItem);
            this.getAllSubs(treeItem, ret);
        }
    }

    public List<TreeItem> getAllSelected() {
        TreePath[] tps = this.getSelectionPathsSorted();
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        if (tps == null) {
            return ret;
        }
        for (TreePath tp : tps) {
            TreeItem treeNode = (TreeItem)tp.getLastPathComponent();
            ret.add(treeNode);
            this.getAllSubs(treeNode, ret);
        }
        return ret;
    }

    public List<TreeItem> getAllSubsForItems(List<TreeItem> items) {
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        for (TreeItem item : items) {
            ret.add(item);
            this.getAllSubs(item, ret);
        }
        return ret;
    }

    public TreePath[] getSelectionPathsSorted() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Arrays.sort(paths, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return AbstractTagTree.this.getRowForPath(o1) - AbstractTagTree.this.getRowForPath(o2);
            }
        });
        return paths;
    }

    public List<TreeItem> getSelected() {
        if (this.mainPanel.folderPreviewCard.isVisible() && this.mainPanel.folderPreviewPanel.isSomethingSelected()) {
            return this.mainPanel.folderPreviewPanel.getSelectedItemsSorted();
        }
        TreePath[] tps = this.getSelectionPathsSorted();
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        if (tps == null) {
            return ret;
        }
        for (TreePath tp : tps) {
            TreeItem treeNode = (TreeItem)tp.getLastPathComponent();
            ret.add(treeNode);
        }
        return ret;
    }

    public boolean hasExportableNodes() {
        return !this.getSelection((Openable)this.mainPanel.getCurrentSwf()).isEmpty();
    }

    public List<TreeItem> getSelectionAndAllSubs(Openable openable, List<TreeItem> selection) {
        ArrayList<TreeItem> sel = new ArrayList<TreeItem>();
        for (TreeItem treeItem : selection) {
            sel.add(treeItem);
            this.getAllSubs(treeItem, sel);
        }
        return AbstractTagTree.getSelection(openable, sel);
    }

    public abstract List<TreeItem> getSelection(Openable var1);

    public static List<TreeItem> getSelection(Openable openable, List<TreeItem> sel) {
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        for (TreeItem d : sel) {
            AS3Package p;
            Tag tag;
            if (d instanceof OpenableList || openable != null && d.getOpenable() != openable) continue;
            if (d instanceof TagScript && ((tag = ((TagScript)d).getTag()) instanceof DoActionTag || tag instanceof DoInitActionTag)) {
                d = tag;
            }
            if (d instanceof FrameScript && (tag = ((FrameScript)d).getSingleDoActionTag()) != null) {
                d = tag;
            }
            if (d instanceof Tag || d instanceof ASMSource || d instanceof BinaryDataInterface || d instanceof SoundStreamFrameRange) {
                TreeNodeType nodeType = TagTree.getTreeNodeType(d);
                if (nodeType == TreeNodeType.IMAGE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SHAPE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.MORPH_SHAPE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SPRITE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.BUTTON) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.AS || nodeType == TreeNodeType.AS_BUTTON || nodeType == TreeNodeType.AS_CLASS || nodeType == TreeNodeType.AS_CLIP || nodeType == TreeNodeType.AS_CONST || nodeType == TreeNodeType.AS_FRAME || nodeType == TreeNodeType.AS_FUNCTION || nodeType == TreeNodeType.AS_INIT || nodeType == TreeNodeType.AS_INTERFACE || nodeType == TreeNodeType.AS_VAR) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.MOVIE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SOUND) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SOUND_STREAM_RANGE) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.BINARY_DATA) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.TEXT) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.FONT) {
                    ret.add(d);
                }
                if (nodeType == TreeNodeType.SYMBOL_CLASS) {
                    ret.add(d);
                }
            }
            if (d instanceof Frame) {
                ret.add(d);
            }
            if (d instanceof ScriptPack) {
                ret.add(d);
            }
            if (!(d instanceof AS3Package) || !(p = (AS3Package)d).isCompoundScript()) continue;
            ret.add(d);
        }
        return ret;
    }

    public void updateSwfs(Openable[] openables) {
        AbstractTagTreeModel ttm = this.getFullModel();
        if (ttm != null) {
            List<List<String>> expandedNodes = View.getExpandedNodes(this);
            ttm.updateOpenable(null);
            View.expandTreeNodes(this, expandedNodes);
        }
    }

    public static List<Integer> getFrameNestedTagIds() {
        return Arrays.asList(4, 26, 70, 94, 5, 28, 1, 43, 15, 89, 61, 19, 18, 45, 66, 85, 49, 3, 29, 1007);
    }

    public TreeItem getCurrentTreeItem() {
        TreeItem item = (TreeItem)this.getLastSelectedPathComponent();
        return item;
    }

    public String getItemPathString(TreeItem item) {
        TreePath path = this.getFullModel().getTreePath(item);
        if (path == null) {
            return null;
        }
        return this.pathToString(path);
    }

    public final void calculateCollisions() {
        this.getFullModel().calculateCollisions();
    }

    public String pathToString(TreePath path) {
        StringBuilder sb = new StringBuilder();
        AbstractTagTreeModel model = this.getFullModel();
        if (path != null) {
            boolean first = true;
            for (Object p : path.getPath()) {
                if (!first) {
                    sb.append("|");
                }
                first = false;
                sb.append(p.toString());
                int index = model.getItemIndex((TreeItem)p);
                if (index <= 1) continue;
                sb.append(" [").append(index).append("]");
            }
        }
        return sb.toString();
    }

    public String getSelectionPathString() {
        return this.pathToString(this.getSelectionPath());
    }

    public static TreeNodeType getTagNodeTypeFromTagClass(Class<?> cl) {
        if (cl == DefineFontTag.class || cl == DefineFont2Tag.class || cl == DefineFont3Tag.class || cl == DefineFont4Tag.class || cl == DefineCompactedFont.class) {
            return TreeNodeType.FONT;
        }
        if (FontInfoTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.FONT_INFO;
        }
        if (cl == DefineFontNameTag.class) {
            return TreeNodeType.FONT_NAME;
        }
        if (cl == DefineFontAlignZonesTag.class) {
            return TreeNodeType.FONT_ALIGN_ZONES;
        }
        if (ABCContainerTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.AS_ABC;
        }
        if (TextTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.TEXT;
        }
        if (cl == CSMSettingsTag.class) {
            return TreeNodeType.CSM_SETTINGS;
        }
        if (ImageTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.IMAGE;
        }
        if (ShapeTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.SHAPE;
        }
        if (MorphShapeTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.MORPH_SHAPE;
        }
        if (cl == DefineSpriteTag.class) {
            return TreeNodeType.SPRITE;
        }
        if (ButtonTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.BUTTON;
        }
        if (cl == DefineButtonCxformTag.class) {
            return TreeNodeType.BUTTON_CXFORM;
        }
        if (cl == DefineButtonSoundTag.class) {
            return TreeNodeType.BUTTON_SOUND;
        }
        if (cl == DefineVideoStreamTag.class) {
            return TreeNodeType.MOVIE;
        }
        if (cl == VideoFrameTag.class) {
            return TreeNodeType.VIDEO_FRAME;
        }
        if (cl == DefineSoundTag.class || cl == SoundStreamHeadTag.class || cl == SoundStreamHead2Tag.class) {
            return TreeNodeType.SOUND;
        }
        if (cl == SoundStreamBlockTag.class) {
            return TreeNodeType.SOUND_STREAM_BLOCK;
        }
        if (cl == DefineBinaryDataTag.class) {
            return TreeNodeType.BINARY_DATA;
        }
        if (((Boolean)Configuration.useAsTypeIcons.get()).booleanValue()) {
            if (cl == DoInitActionTag.class) {
                return TreeNodeType.AS_INIT;
            }
            if (cl == DoActionTag.class) {
                return TreeNodeType.AS_FRAME;
            }
        }
        if (cl == ShowFrameTag.class) {
            return TreeNodeType.SHOW_FRAME;
        }
        if (cl == FrameLabelTag.class) {
            return TreeNodeType.FRAME_LABEL;
        }
        if (cl == StartSoundTag.class || cl == StartSound2Tag.class) {
            return TreeNodeType.START_SOUND;
        }
        if (cl == SetBackgroundColorTag.class) {
            return TreeNodeType.SET_BACKGROUNDCOLOR;
        }
        if (cl == FileAttributesTag.class) {
            return TreeNodeType.FILE_ATTRIBUTES;
        }
        if (cl == MetadataTag.class) {
            return TreeNodeType.METADATA;
        }
        if (PlaceObjectTypeTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.PLACE_OBJECT;
        }
        if (cl == PlaceImagePrivateTag.class) {
            return TreeNodeType.PLACE_IMAGE_PRIVATE;
        }
        if (RemoveTag.class.isAssignableFrom(cl)) {
            return TreeNodeType.REMOVE_OBJECT;
        }
        if (cl == EndTag.class) {
            return TreeNodeType.END;
        }
        if (cl == DefineScalingGridTag.class) {
            return TreeNodeType.SCALING_GRID;
        }
        if (cl == ProtectTag.class || cl == EnableDebuggerTag.class || cl == EnableDebugger2Tag.class) {
            return TreeNodeType.ENABLE_DEBUGGER;
        }
        if (cl == EnableTelemetryTag.class) {
            return TreeNodeType.ENABLE_TELEMETRY;
        }
        if (cl == ExportAssetsTag.class) {
            return TreeNodeType.EXPORT_ASSETS;
        }
        if (cl == ImportAssetsTag.class || cl == ImportAssets2Tag.class) {
            return TreeNodeType.IMPORT_ASSETS;
        }
        if (cl == JPEGTablesTag.class) {
            return TreeNodeType.JPEG_TABLES;
        }
        if (cl == ProductInfoTag.class) {
            return TreeNodeType.PRODUCT_INFO;
        }
        if (cl == ScriptLimitsTag.class) {
            return TreeNodeType.SCRIPT_LIMITS;
        }
        if (cl == SetTabIndexTag.class) {
            return TreeNodeType.SET_TABINDEX;
        }
        if (cl == SymbolClassTag.class) {
            return TreeNodeType.SYMBOL_CLASS;
        }
        if (cl == DefineSceneAndFrameLabelDataTag.class) {
            return TreeNodeType.SCENE_AND_FRAME_LABEL_DATA;
        }
        if (cl == DebugIDTag.class) {
            return TreeNodeType.DEBUG_ID;
        }
        if (cl == DefineVideoTag.class) {
            return TreeNodeType.MOVIE_REF;
        }
        if (cl == FreeCharacterTag.class) {
            return TreeNodeType.FREE_CHARACTER;
        }
        if (cl == SyncFrameTag.class) {
            return TreeNodeType.SYNC_FRAME;
        }
        if (cl == NameCharacterTag.class) {
            return TreeNodeType.NAME_CHARACTER;
        }
        if (cl == DefineTextFormatTag.class) {
            return TreeNodeType.TEXT_FORMAT;
        }
        if (cl == CharacterSetTag.class) {
            return TreeNodeType.CHARACTER_SET;
        }
        if (cl == FontRefTag.class) {
            return TreeNodeType.FONT_REF;
        }
        if (cl == GenCommandTag.class) {
            return TreeNodeType.GEN_COMMAND;
        }
        if (cl == SerialNumberTag.class) {
            return TreeNodeType.SERIAL_NUMBER;
        }
        if (Tag.class.isAssignableFrom(cl)) {
            return TreeNodeType.OTHER_TAG;
        }
        return TreeNodeType.FOLDER;
    }

    public static List<Integer> getMappedTagIdsForClass(Class<?> cls) {
        if (cls == DefineSpriteTag.class) {
            return Arrays.asList(78, 59, 40);
        }
        if (FontTag.class.isAssignableFrom(cls)) {
            return Arrays.asList(88, 73, 13, 62);
        }
        if (StaticTextTag.class.isAssignableFrom(cls)) {
            return Arrays.asList(74, 42);
        }
        if (TextTag.class.isAssignableFrom(cls)) {
            return Arrays.asList(74);
        }
        if (cls == DefineButtonTag.class) {
            return Arrays.asList(23, 17, 78);
        }
        if (cls == DefineButton2Tag.class) {
            return Arrays.asList(17, 78);
        }
        if (ImageTag.class.isAssignableFrom(cls)) {
            return Arrays.asList(40);
        }
        if (cls == DefineSoundTag.class) {
            return Arrays.asList(40);
        }
        return new ArrayList<Integer>();
    }

    static {
        for (TreeNodeType treeNodeType : TreeNodeType.values()) {
            String tagTypeStr = treeNodeType.toString().toLowerCase(Locale.ENGLISH).replace("_", "");
            ICONS.put(treeNodeType, View.getIcon(tagTypeStr + "16"));
        }
    }
}

