/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.tagtree;

import com.jpexs.decompiler.flash.gui.abc.ClassesListTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.HeaderItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilteredTreeModel
implements TreeModel {
    private String filter;
    private List<String> foldersFilter;
    private TreeItem root;
    private Map<TreeItem, List<TreeItem>> subItems = new WeakHashMap<TreeItem, List<TreeItem>>();
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    private final JTree tree;

    public String getFilter() {
        return this.filter;
    }

    public List<String> getFoldersFilter() {
        return this.foldersFilter;
    }

    public FilteredTreeModel(String filter, List<String> foldersFilter, final AbstractTagTreeModel fullModel, JTree tree) {
        this.filter = filter;
        this.foldersFilter = foldersFilter;
        this.tree = tree;
        fullModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                FilteredTreeModel.this.rebuildTree(fullModel);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                FilteredTreeModel.this.rebuildTree(fullModel);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                FilteredTreeModel.this.rebuildTree(fullModel);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                FilteredTreeModel.this.rebuildTree(fullModel);
            }
        });
        this.rebuildTree(fullModel);
    }

    private void rebuildTree(AbstractTagTreeModel fullModel) {
        this.subItems.clear();
        this.root = fullModel.getRoot();
        ArrayList<String> selectionPathsList = new ArrayList<String>();
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths != null) {
            ArrayList<String> currentPathItems = new ArrayList<String>();
            for (TreePath tp : selectionPaths) {
                for (int i = 0; i < tp.getPathCount(); ++i) {
                    currentPathItems.add(tp.getPathComponent(i).toString());
                }
            }
            selectionPathsList.add(String.join((CharSequence)".", currentPathItems));
        }
        this.buildTree(fullModel, this.root, "root", "", selectionPathsList);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
    }

    private boolean isItemSearchable(TreeItem ti) {
        if (ti instanceof Openable) {
            return false;
        }
        if (ti instanceof OpenableList) {
            return false;
        }
        if (ti instanceof FolderItem) {
            return false;
        }
        return !(ti instanceof ClassesListTreeModel);
    }

    private void buildTree(AbstractTagTreeModel fullModel, TreeItem item, String path, String searchPath, List<String> selectionPaths) {
        String searchSubPath;
        String subPath;
        List<? extends TreeItem> items = fullModel.getAllChildren(item);
        ArrayList<Object> newSubItems = new ArrayList<Object>();
        if (this.filter.trim().isEmpty() && this.foldersFilter.isEmpty()) {
            newSubItems.addAll(items);
        } else {
            for (TreeItem treeItem : items) {
                subPath = path + "." + treeItem.toString();
                searchSubPath = this.isItemSearchable(treeItem) ? searchPath + "." + treeItem.toString() : searchPath;
                boolean matches = searchSubPath.toLowerCase().contains(this.filter.toLowerCase());
                if (!this.foldersFilter.isEmpty()) {
                    FolderItem f;
                    if (treeItem instanceof ClassesListTreeModel && !this.foldersFilter.contains("scripts") || treeItem instanceof FolderItem && !this.foldersFilter.contains((f = (FolderItem)treeItem).getName())) continue;
                    if (treeItem instanceof HeaderItem) {
                        HeaderItem h = (HeaderItem)treeItem;
                        if (!this.foldersFilter.contains("header")) continue;
                    }
                }
                if (fullModel.isLeaf(treeItem)) {
                    if (!matches && !selectionPaths.contains(subPath)) continue;
                    newSubItems.add(treeItem);
                    continue;
                }
                newSubItems.add(treeItem);
            }
        }
        for (int i = 0; i < newSubItems.size(); ++i) {
            TreeItem treeItem = (TreeItem)newSubItems.get(i);
            subPath = path + "." + treeItem.toString();
            searchSubPath = this.isItemSearchable(treeItem) ? searchPath + "." + treeItem.toString() : searchPath;
            this.buildTree(fullModel, treeItem, subPath, searchSubPath, selectionPaths);
            if (selectionPaths.contains(subPath) || fullModel.isLeaf(treeItem) || this.subItems.containsKey(treeItem) && !this.subItems.get(treeItem).isEmpty()) continue;
            newSubItems.remove(i);
            --i;
        }
        if (!newSubItems.isEmpty()) {
            this.subItems.put(item, newSubItems);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.subItems.containsKey(parent)) {
            return this.subItems.get(parent).get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.subItems.containsKey(parent)) {
            return this.subItems.get(parent).size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.subItems.containsKey(node)) {
            return this.subItems.get(node).size() == 0;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (this.subItems.containsKey(parent)) {
            return this.subItems.get(parent).indexOf(child);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesRemoved(e);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeNodesInserted(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(e);
        }
    }
}

