/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.translator;

import com.jpexs.decompiler.flash.configuration.AppDirectoryProvider;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.properties.ParsedSymbol;
import com.jpexs.helpers.properties.PropertiesLexer;
import com.jpexs.helpers.properties.PropertiesParseException;
import com.jpexs.helpers.properties.SymbolType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class Translator
extends JFrame
implements ItemListener {
    private TreeSet<String> locales = new TreeSet();
    private Map<String, TreeSet<String>> resourceLocales = new TreeMap<String, TreeSet<String>>();
    private Set<String> resourceKeys = new TreeSet<String>();
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> resourceValues = new TreeMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>();
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> comments = new TreeMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>();
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> newValues = new TreeMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>>();
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, Integer>>> newLinesBeforeComment = new TreeMap<String, LinkedHashMap<String, LinkedHashMap<String, Integer>>>();
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, Integer>>> newLinesAfterComment = new TreeMap<String, LinkedHashMap<String, LinkedHashMap<String, Integer>>>();
    private Map<String, Set<String>> hiddenKeys = new TreeMap<String, Set<String>>();
    private JTable table;
    private DefaultTableModel tableModel;
    private JComboBox<LocaleItem> localeComboBox;
    private JComboBox<ResourceItem> resourcesComboBox;
    private String lastSaveDir = "";
    private static final String DO_NOT_EDIT = "!!!! FFDec translators - please do not edit anything below this line !!!";
    private List<String> ignoredResources = Arrays.asList("project", "META-INF/services/jsyntaxpane/kitsfortypes", "META-INF/services/jsyntaxpane/syntaxkits/actionscript3syntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/actionscriptsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/flasm3methodinfosyntaxkit/abbreviations", "META-INF/services/jsyntaxpane/syntaxkits/bashsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/clojuresyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/dosbatchsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/flasmsyntaxkit/abbreviations", "META-INF/services/jsyntaxpane/syntaxkits/flasm3syntaxkit/abbreviations", "META-INF/services/jsyntaxpane/syntaxkits/groovysyntaxkit/abbreviations", "META-INF/services/jsyntaxpane/syntaxkits/groovysyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/javascriptsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/javasyntaxkit/abbreviations", "META-INF/services/jsyntaxpane/syntaxkits/javasyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/luasyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/plainsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/propertiessyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/pythonsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/rubysyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/scalasyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/sqlsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/talsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/xhtmlsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/xmlsyntaxkit/config", "META-INF/services/jsyntaxpane/syntaxkits/xpathsyntaxkit/config", "META-INF/maven/jsyntaxpane/jsyntaxpane/pom");

    private String readStreamAsString(InputStream is) throws IOException {
        byte[] buf = new byte[1024];
        int cnt = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((cnt = is.read(buf)) > 0) {
            baos.write(buf, 0, cnt);
        }
        return new String(baos.toByteArray(), "UTF-8");
    }

    private void loadJar(File file, String fileTitle) throws FileNotFoundException, IOException, URISyntaxException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        ZipEntry zipEntry = zis.getNextEntry();
        Pattern pat = Pattern.compile("(?<resource>(.*/)?[^/_]+)(_(?<locale>[^/\\.]+))?\\.properties");
        while (zipEntry != null) {
            String resource;
            String name;
            Matcher m;
            if (!zipEntry.isDirectory() && (m = pat.matcher(name = zipEntry.getName())).matches() && !this.ignoredResources.contains(resource = m.group("resource"))) {
                resource = fileTitle + ": " + resource;
                String locale = m.group("locale");
                if (locale == null) {
                    locale = "en";
                }
                if (!this.resourceLocales.containsKey(resource)) {
                    this.resourceLocales.put(resource, new TreeSet());
                    this.resourceKeys.add(resource);
                    this.resourceValues.put(resource, new LinkedHashMap());
                    this.hiddenKeys.put(resource, new HashSet());
                }
                if (!this.resourceValues.get(resource).containsKey(locale)) {
                    this.resourceValues.get(resource).put(locale, new LinkedHashMap());
                }
                this.resourceLocales.get(resource).add(locale);
                this.locales.add(locale);
                String propertiesData = this.readStreamAsString(zis);
                PropertiesLexer lexer = new PropertiesLexer(propertiesData);
                try {
                    ParsedSymbol s = lexer.lex();
                    boolean hidden = false;
                    String comment = "";
                    int numEmptyLinesBeforeComment = 0;
                    int numEmptyLinesAfterComment = 0;
                    while (s.type != SymbolType.EOF) {
                        if (s.type == SymbolType.COMMENT) {
                            if (((String)s.value).trim().equals(DO_NOT_EDIT)) {
                                hidden = true;
                            }
                            comment = comment.isEmpty() ? (String)s.value : comment + "\r\n" + s.value;
                            s = lexer.lex();
                            continue;
                        }
                        if (s.type == SymbolType.EMPTY_LINE) {
                            if (comment.isEmpty()) {
                                ++numEmptyLinesBeforeComment;
                            } else {
                                ++numEmptyLinesAfterComment;
                            }
                            s = lexer.lex();
                            continue;
                        }
                        if (s.type != SymbolType.EOF) {
                            if (s.type != SymbolType.KEY) {
                                throw new RuntimeException("KEY EXPECTED");
                            }
                            String key = (String)s.value;
                            s = lexer.lex();
                            if (s.type != SymbolType.VALUE) {
                                throw new RuntimeException("VALUE EXPECTED");
                            }
                            String value = (String)s.value;
                            this.resourceValues.get(resource).get(locale).put(key, value);
                            if (hidden) {
                                this.hiddenKeys.get(resource).add(key);
                            }
                            if (!comment.isEmpty()) {
                                if (!this.comments.containsKey(resource)) {
                                    this.comments.put(resource, new LinkedHashMap());
                                }
                                if (!this.comments.get(resource).containsKey(locale)) {
                                    this.comments.get(resource).put(locale, new LinkedHashMap());
                                }
                                this.comments.get(resource).get(locale).put(key, comment);
                            }
                            if (numEmptyLinesAfterComment > 0) {
                                if (!this.newLinesAfterComment.containsKey(resource)) {
                                    this.newLinesAfterComment.put(resource, new LinkedHashMap());
                                }
                                if (!this.newLinesAfterComment.get(resource).containsKey(locale)) {
                                    this.newLinesAfterComment.get(resource).put(locale, new LinkedHashMap());
                                }
                                this.newLinesAfterComment.get(resource).get(locale).put(key, numEmptyLinesAfterComment);
                            }
                            if (numEmptyLinesBeforeComment > 0) {
                                if (!this.newLinesBeforeComment.containsKey(resource)) {
                                    this.newLinesBeforeComment.put(resource, new LinkedHashMap());
                                }
                                if (!this.newLinesBeforeComment.get(resource).containsKey(locale)) {
                                    this.newLinesBeforeComment.get(resource).put(locale, new LinkedHashMap());
                                }
                                this.newLinesBeforeComment.get(resource).get(locale).put(key, numEmptyLinesBeforeComment);
                            }
                            numEmptyLinesAfterComment = 0;
                            numEmptyLinesBeforeComment = 0;
                            comment = "";
                            s = lexer.lex();
                            continue;
                        }
                        break;
                    }
                }
                catch (PropertiesParseException ex) {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private void loadJarTry(String path) throws FileNotFoundException, IOException, URISyntaxException {
        File file = new File("dist/" + path);
        if (!file.exists()) {
            file = new File(path);
        }
        this.loadJar(file, path);
    }

    private void loadItems() throws FileNotFoundException, IOException, URISyntaxException {
        this.loadJarTry("ffdec.jar");
        this.loadJarTry("lib/ffdec_lib.jar");
        this.loadJarTry("lib/jsyntaxpane-0.9.5.jar");
    }

    public Translator() throws IOException, FileNotFoundException, URISyntaxException {
        this.loadItems();
        this.setDefaultCloseOperation(3);
        Container cnt = this.getContentPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    Translator.this.save();
                    Translator.this.saveWindow();
                }
                catch (IOException ex) {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        ArrayList<LocaleItem> localeItems = new ArrayList<LocaleItem>();
        for (String string : this.locales) {
            localeItems.add(new LocaleItem(string));
        }
        this.localeComboBox = new JComboBox<LocaleItem>(localeItems.toArray(new LocaleItem[localeItems.size()]));
        ArrayList<ResourceItem> resources = new ArrayList<ResourceItem>();
        for (String resource : this.resourceLocales.keySet()) {
            resources.add(new ResourceItem(resource));
        }
        this.resourcesComboBox = new JComboBox<ResourceItem>(resources.toArray(new ResourceItem[resources.size()]));
        this.resourcesComboBox.addItemListener(this);
        this.localeComboBox.addItemListener(this);
        this.tableModel = new DefaultTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 1;
            }
        };
        this.tableModel.addColumn("key");
        this.tableModel.addColumn("en");
        this.tableModel.addColumn("translated");
        this.tableModel.addRow(new Object[]{"menu.new", "New", "Nov\u00fd"});
        this.tableModel.addRow(new Object[]{"error.missing", "Error: missing xy", "Chyba: chyb\u00ed xy"});
        this.table.getColumn("key").setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setVerticalAlignment(1);
                String key = (String)value;
                String locale = ((LocaleItem)((Translator)Translator.this).localeComboBox.getSelectedItem()).locale;
                String resource = ((ResourceItem)((Translator)Translator.this).resourcesComboBox.getSelectedItem()).resource;
                if (Translator.this.comments.containsKey(resource) && ((LinkedHashMap)Translator.this.comments.get(resource)).containsKey("en") && ((LinkedHashMap)((LinkedHashMap)Translator.this.comments.get(resource)).get("en")).containsKey(key)) {
                    String comment = (String)((LinkedHashMap)((LinkedHashMap)Translator.this.comments.get(resource)).get("en")).get(key);
                    if (comment.contains("General Public License")) {
                        label.setIcon(null);
                        label.setToolTipText(null);
                    } else {
                        label.setIcon(View.getIcon("about16"));
                        label.setToolTipText(comment);
                    }
                } else {
                    label.setIcon(null);
                    label.setToolTipText(null);
                }
                return label;
            }
        });
        this.table.getColumn("en").setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String valueStr = "" + value;
                label.setText("<html>" + valueStr.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\r\n", "<br/>") + "</html>");
                label.setVerticalAlignment(1);
                return label;
            }
        });
        this.table.getColumn("translated").setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String enValue;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setVerticalAlignment(1);
                String key = (String)table.getValueAt(row, 0);
                String locale = ((LocaleItem)((Translator)Translator.this).localeComboBox.getSelectedItem()).locale;
                String resource = ((ResourceItem)((Translator)Translator.this).resourcesComboBox.getSelectedItem()).resource;
                String oldValue = null;
                if (Translator.this.resourceValues.containsKey(resource) && ((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).containsKey(key)) {
                    oldValue = (String)((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).get(key);
                }
                if ((enValue = (String)((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get("en")).get(key)) == null) {
                    enValue = "";
                }
                if (Translator.this.resourceValues.containsKey(resource) && ((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).containsKey(key)) {
                    if (!Objects.equals(oldValue, value)) {
                        label.setBackground(new Color(170, 170, 255));
                    } else {
                        label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    }
                } else if (Translator.this.newValues.containsKey(resource) && ((LinkedHashMap)Translator.this.newValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).containsKey(key)) {
                    label.setBackground(new Color(170, 255, 170));
                } else if (!(((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).containsKey(key) || enValue.equals(""))) {
                    label.setBackground(new Color(255, 170, 170));
                } else {
                    label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                }
                String valueStr = "" + value;
                label.setText("<html>" + valueStr.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\r\n", "<br/>") + "</html>");
                return label;
            }
        });
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.getColumn("translated").setCellEditor(new JTextAreaColumn(this.resourceValues, this.localeComboBox, this.resourcesComboBox));
        this.table.getColumn("en").setCellEditor(new JTextAreaColumn(this.resourceValues, this.localeComboBox, this.resourcesComboBox));
        final TableCellEditor tableCellEditor = this.table.getColumn("translated").getCellEditor();
        tableCellEditor.addCellEditorListener(this.getEditorListener());
        tableCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String locale = ((LocaleItem)((Translator)Translator.this).localeComboBox.getSelectedItem()).locale;
                String resource = ((ResourceItem)((Translator)Translator.this).resourcesComboBox.getSelectedItem()).resource;
                String key = (String)Translator.this.table.getModel().getValueAt(Translator.this.table.getSelectedRow(), 0);
                String value = (String)tableCellEditor.getCellEditorValue();
                String oldValue = null;
                if (Translator.this.resourceValues.containsKey(resource) && ((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).containsKey(key)) {
                    oldValue = (String)((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).get(key);
                }
                String enValue = null;
                if (Translator.this.resourceValues.containsKey(resource) && ((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey("en") && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get("en")).containsKey(key)) {
                    enValue = (String)((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get("en")).get(key);
                }
                if (Objects.equals(oldValue, value) || "".equals(value) && !enValue.equals("")) {
                    if (Translator.this.newValues.containsKey(resource) && ((LinkedHashMap)Translator.this.newValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).containsKey(key)) {
                        ((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).remove(key);
                        if (((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).isEmpty()) {
                            ((LinkedHashMap)Translator.this.newValues.get(resource)).remove(locale);
                        }
                        if (((LinkedHashMap)Translator.this.newValues.get(resource)).isEmpty()) {
                            Translator.this.newValues.remove(resource);
                        }
                    }
                } else {
                    if (!Translator.this.newValues.containsKey(resource)) {
                        Translator.this.newValues.put(resource, new LinkedHashMap());
                    }
                    if (!((LinkedHashMap)Translator.this.newValues.get(resource)).containsKey(locale)) {
                        ((LinkedHashMap)Translator.this.newValues.get(resource)).put(locale, new LinkedHashMap());
                    }
                    ((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).put(key, value);
                }
                try {
                    Translator.this.save();
                }
                catch (IOException ex) {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                }
                Translator.this.updateCounts();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        cnt.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        topPanel.add((Component)new JLabel("Locale:"), c);
        c.gridx = 1;
        c.gridy = 0;
        topPanel.add(this.localeComboBox, c);
        c.gridx = 2;
        c.gridy = 0;
        JButton newLocaleButton = new JButton("New");
        newLocaleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newLocale = ViewMessages.showInputDialog(Translator.this, "Enter new locale identifier", "New locale", "");
                if (newLocale == null) {
                    return;
                }
                if ((newLocale = newLocale.trim()).equals("")) {
                    return;
                }
                for (int i = 0; i < Translator.this.localeComboBox.getItemCount(); ++i) {
                    String locale = ((LocaleItem)((Translator)Translator.this).localeComboBox.getItemAt((int)i)).locale;
                    if (!locale.equals(newLocale)) continue;
                    ViewMessages.showMessageDialog(Translator.this, "Locale already exists", "Already exists", 0);
                    return;
                }
                Translator.this.locales.add(newLocale);
                ArrayList<LocaleItem> localeItems = new ArrayList<LocaleItem>();
                int index = -1;
                int i = 0;
                for (String locale : Translator.this.locales) {
                    if (locale.equals(newLocale)) {
                        index = i;
                    }
                    ++i;
                    localeItems.add(new LocaleItem(locale));
                }
                Translator.this.localeComboBox.setModel(new DefaultComboBoxModel<LocaleItem>(localeItems.toArray(new LocaleItem[localeItems.size()])));
                Translator.this.localeComboBox.setSelectedIndex(index);
            }
        });
        topPanel.add((Component)newLocaleButton, c);
        c.gridx = 0;
        c.gridy = 1;
        topPanel.add((Component)new JLabel("Resource:"), c);
        c.gridx = 1;
        c.gridy = 1;
        topPanel.add(this.resourcesComboBox, c);
        c.gridx = 2;
        c.gridy = 1;
        JButton nextMissingButton = new JButton("Next missing");
        nextMissingButton.addActionListener(new ActionListener(){

            private void selectFirstMissing() {
                String locale = ((LocaleItem)((Translator)Translator.this).localeComboBox.getSelectedItem()).locale;
                String resource = ((ResourceItem)((Translator)Translator.this).resourcesComboBox.getSelectedItem()).resource;
                int row = 0;
                for (String key : ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get("en")).keySet()) {
                    if (!(Translator.this.resourceValues.containsKey(resource) && ((LinkedHashMap)Translator.this.resourceValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.resourceValues.get(resource)).get(locale)).containsKey(key) || Translator.this.newValues.containsKey(resource) && ((LinkedHashMap)Translator.this.newValues.get(resource)).containsKey(locale) && ((LinkedHashMap)((LinkedHashMap)Translator.this.newValues.get(resource)).get(locale)).containsKey(key))) {
                        Translator.this.table.scrollRectToVisible(Translator.this.table.getCellRect(row, 0, false));
                        break;
                    }
                    ++row;
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceItem item;
                int i;
                for (i = Translator.this.resourcesComboBox.getSelectedIndex() + 1; i < Translator.this.resourcesComboBox.getItemCount(); ++i) {
                    item = (ResourceItem)Translator.this.resourcesComboBox.getItemAt(i);
                    if (item.missingCount <= 0) continue;
                    Translator.this.resourcesComboBox.setSelectedIndex(i);
                    this.selectFirstMissing();
                    return;
                }
                for (i = 0; i < Translator.this.resourcesComboBox.getItemCount(); ++i) {
                    item = (ResourceItem)Translator.this.resourcesComboBox.getItemAt(i);
                    if (item.missingCount <= 0) continue;
                    Translator.this.resourcesComboBox.setSelectedIndex(i);
                    this.selectFirstMissing();
                    return;
                }
            }
        });
        topPanel.add((Component)nextMissingButton, c);
        cnt.add((Component)topPanel, "North");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton exportButton = new JButton("Export JPT");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                FileFilter jptFilter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jpt") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "JPEXS translation files (*.jpt)";
                    }
                };
                fc.setFileFilter(jptFilter);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setSelectedFile(new File("translation.jpt"));
                if (!Translator.this.lastSaveDir.isEmpty()) {
                    fc.setCurrentDirectory(new File(Translator.this.lastSaveDir));
                }
                if (fc.showSaveDialog(Translator.this) == 0) {
                    File targetFile;
                    File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                    String fileName = file.getAbsolutePath();
                    FileFilter selFilter = fc.getFileFilter();
                    if (selFilter == jptFilter && !fileName.toLowerCase(Locale.ENGLISH).endsWith(".jpt")) {
                        fileName = fileName + ".jpt";
                    }
                    if ((targetFile = new File(fileName)).exists()) {
                        targetFile.delete();
                    }
                    try {
                        Files.copy(new File(Translator.this.getStorageFile()).toPath(), targetFile.toPath(), new CopyOption[0]);
                    }
                    catch (IOException ex) {
                        ViewMessages.showMessageDialog(Translator.this, "Error during saving: " + ex.getLocalizedMessage(), "Error", 0);
                    }
                    Translator.this.lastSaveDir = file.getParentFile().getAbsolutePath();
                }
            }
        });
        JButton importButton = new JButton("Import JPT");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ViewMessages.showConfirmDialog(Translator.this, "WARNING: This will erase all your previous work and imports data from other JPT file", "WARNING", 2, 2) == 0) {
                    JFileChooser fc = new JFileChooser();
                    FileFilter jptFilter = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jpt") || f.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "JPEXS translation files (*.jpt)";
                        }
                    };
                    fc.setFileFilter(jptFilter);
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.setSelectedFile(new File("translation.jpt"));
                    if (!Translator.this.lastSaveDir.isEmpty()) {
                        fc.setCurrentDirectory(new File(Translator.this.lastSaveDir));
                    }
                    if (fc.showOpenDialog(Translator.this) == 0) {
                        File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                        String fileName = file.getAbsolutePath();
                        File targetFile = new File(Translator.this.getStorageFile());
                        File tmpFile = new File(Translator.this.getStorageFile() + ".tmp");
                        try {
                            if (targetFile.exists()) {
                                targetFile.renameTo(tmpFile);
                            }
                            Files.copy(new File(fileName).toPath(), targetFile.toPath(), new CopyOption[0]);
                            tmpFile.delete();
                            Translator.this.load();
                        }
                        catch (IOException ex) {
                            tmpFile.renameTo(targetFile);
                            ViewMessages.showMessageDialog(Translator.this, "Error during importing: " + ex.getLocalizedMessage(), "Error", 0);
                        }
                    }
                }
            }
        });
        JButton startOverButton = new JButton("Start over");
        startOverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ViewMessages.showConfirmDialog(Translator.this, "Do you really want to lose all your work? This is unreversable!", "WARNING", 2, 2) == 0) {
                    Translator.this.newValues.clear();
                    try {
                        Translator.this.save();
                        Translator.this.load();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        buttonsPanel.add(importButton);
        buttonsPanel.add(exportButton);
        buttonsPanel.add(startOverButton);
        cnt.add((Component)buttonsPanel, "South");
        cnt.add((Component)new JScrollPane(this.table), "Center");
        this.resizeColumnWidth(this.table);
        this.setSize(800, 600);
        this.setTitle("JPEXS Free Flash Decompiler Translator");
        this.itemStateChanged(null);
        this.table.setRowHeight(this.table.getFont().getSize() + 10);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Translator.this.updateRowHeights(Translator.this.table);
            }
        });
        View.centerScreen(this);
        this.load();
        this.loadWindow();
    }

    private void updateCounts() {
        String selectedLocale = ((LocaleItem)this.localeComboBox.getSelectedItem()).locale;
        for (int j = 0; j < this.localeComboBox.getItemCount(); ++j) {
            LocaleItem localeItem = this.localeComboBox.getItemAt(j);
            String locale = localeItem.locale;
            int localeMissingCount = 0;
            int localeNewCount = 0;
            int localeModifiedCount = 0;
            for (int i = 0; i < this.resourcesComboBox.getItemCount(); ++i) {
                ResourceItem resourceItem = this.resourcesComboBox.getItemAt(i);
                String resource = resourceItem.resource;
                int missingCount = 0;
                int newCount = 0;
                int modifiedCount = 0;
                LinkedHashMap<String, LinkedHashMap<String, String>> map = this.resourceValues.get(resource);
                for (String key : map.get("en").keySet()) {
                    if (this.resourceValues.get(resource).containsKey(locale) && this.resourceValues.get(resource).get(locale).containsKey(key)) {
                        if (!this.newValues.containsKey(resource) || !this.newValues.get(resource).containsKey(locale) || !this.newValues.get(resource).get(locale).containsKey(key)) continue;
                        ++modifiedCount;
                        continue;
                    }
                    if (this.newValues.containsKey(resource) && this.newValues.get(resource).containsKey(locale) && this.newValues.get(resource).get(locale).containsKey(key)) {
                        ++newCount;
                        continue;
                    }
                    ++missingCount;
                }
                if (locale.equals(selectedLocale)) {
                    resourceItem.missingCount = missingCount;
                    resourceItem.modifiedCount = modifiedCount;
                    resourceItem.newCount = newCount;
                }
                localeMissingCount += missingCount;
                localeModifiedCount += modifiedCount;
                localeNewCount += newCount;
            }
            localeItem.missingCount = localeMissingCount;
            localeItem.modifiedCount = localeModifiedCount;
            localeItem.newCount = localeNewCount;
        }
        this.repaint();
    }

    private CellEditorListener getEditorListener() {
        return new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                Translator.this.updateRowHeights(Translator.this.table);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                Translator.this.updateRowHeights(Translator.this.table);
            }
        };
    }

    private void updateRowHeights(JTable table) {
        try {
            for (int row = 0; row < table.getRowCount(); ++row) {
                int rowHeight = table.getRowHeight();
                for (int column = 0; column < table.getColumnCount(); ++column) {
                    JLabel lab;
                    javax.swing.text.View view;
                    Component comp = table.prepareRenderer(table.getCellRenderer(row, column), row, column);
                    int maxHeight = 0;
                    int columnWidth = table.getColumn(table.getColumnName(column)).getWidth();
                    if (comp instanceof JLabel && (view = (javax.swing.text.View)(lab = (JLabel)comp).getClientProperty("html")) != null) {
                        String text = lab.getText();
                        float textWidth = view.getPreferredSpan(0);
                        float charHeight = view.getPreferredSpan(1);
                        double lines = Math.ceil((double)textWidth / (double)columnWidth);
                        double height = lines * (double)charHeight;
                        int heightInt = (int)Math.ceil(height);
                        if (heightInt > maxHeight) {
                            maxHeight = heightInt;
                        }
                    }
                    if (maxHeight == 0) {
                        maxHeight = comp.getPreferredSize().height;
                    }
                    comp.setPreferredSize(new Dimension(columnWidth, maxHeight));
                    rowHeight = Math.max(rowHeight, maxHeight);
                }
                table.setRowHeight(row, rowHeight);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String locale = ((LocaleItem)this.localeComboBox.getSelectedItem()).locale;
        String resource = ((ResourceItem)this.resourcesComboBox.getSelectedItem()).resource;
        this.tableModel.setRowCount(0);
        for (String key : this.resourceValues.get(resource).get("en").keySet()) {
            String value = "";
            if (this.newValues.containsKey(resource) && this.newValues.get(resource).containsKey(locale) && this.newValues.get(resource).get(locale).containsKey(key)) {
                value = this.newValues.get(resource).get(locale).get(key);
            } else if (this.resourceValues.get(resource).containsKey(locale) && this.resourceValues.get(resource).get(locale).containsKey(key)) {
                value = this.resourceValues.get(resource).get(locale).get(key);
            }
            if (this.hiddenKeys.get(resource).contains(key)) continue;
            this.tableModel.addRow(new Object[]{key, this.resourceValues.get(resource).get("en").get(key), value});
        }
        this.updateRowHeights(this.table);
        this.updateCounts();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            int width = 15;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            if (width > 300) {
                width = 300;
            }
            columnModel.getColumn(column).setPreferredWidth(width);
        }
    }

    private String getStorageFile() {
        return AppDirectoryProvider.getFFDecHome() + "translated.zip";
    }

    private String getWindowFile() {
        return AppDirectoryProvider.getFFDecHome() + "translated.ini";
    }

    private String escapeUnicode(String s) {
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c >= '\u0080') {
                b.append("\\u").append(String.format("%04x", c));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private String escapeKey(String s) {
        if (s.startsWith("#") || s.startsWith("!")) {
            s = "\\" + s;
        }
        s = this.escapeUnicode(s);
        return s;
    }

    private String escapeValue(String s) {
        if (s.startsWith(" ")) {
            s = "\\" + s;
        }
        s = s.replace("\r\n", "\n");
        s = s.replace("\n", "\\\r\n ");
        s = this.escapeUnicode(s);
        return s;
    }

    private void load() throws IOException {
        this.newValues.clear();
        File storageFile = new File(this.getStorageFile());
        if (storageFile.exists()) {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(storageFile));
            ZipEntry zipEntry = zis.getNextEntry();
            Pattern pat = Pattern.compile("(?<resource>(.*/)?[^/_]+)(_(?<locale>[^/\\.]+))?\\.properties");
            while (zipEntry != null) {
                String name;
                Matcher m;
                if (!zipEntry.isDirectory() && (m = pat.matcher(name = zipEntry.getName())).matches()) {
                    String resource = m.group("resource");
                    resource = resource.replace(".jar/", ".jar: ");
                    String locale = m.group("locale");
                    if (locale == null) {
                        locale = "en";
                    }
                    this.locales.add(locale);
                    if (!this.newValues.containsKey(resource)) {
                        this.newValues.put(resource, new LinkedHashMap());
                    }
                    if (!this.newValues.get(resource).containsKey(locale)) {
                        this.newValues.get(resource).put(locale, new LinkedHashMap());
                    }
                    this.resourceLocales.get(resource).add(locale);
                    this.locales.add(locale);
                    String propertiesData = this.readStreamAsString(zis);
                    PropertiesLexer lexer = new PropertiesLexer(propertiesData);
                    try {
                        ParsedSymbol s = lexer.lex();
                        boolean hidden = false;
                        while (s.type != SymbolType.EOF) {
                            if (s.type == SymbolType.COMMENT) {
                                if (((String)s.value).trim().equals(DO_NOT_EDIT)) {
                                    hidden = true;
                                }
                                s = lexer.lex();
                                continue;
                            }
                            if (s.type == SymbolType.EMPTY_LINE) {
                                s = lexer.lex();
                                continue;
                            }
                            if (s.type != SymbolType.EOF) {
                                if (s.type != SymbolType.KEY) {
                                    throw new RuntimeException("KEY EXPECTED");
                                }
                                String key = (String)s.value;
                                s = lexer.lex();
                                if (s.type != SymbolType.VALUE) {
                                    throw new RuntimeException("VALUE EXPECTED");
                                }
                                String value = (String)s.value;
                                if (!(hidden || this.resourceValues.containsKey(resource) && this.resourceValues.get(resource).containsKey(locale) && this.resourceValues.get(resource).get(locale).containsKey(key) && Objects.equals(this.resourceValues.get(resource).get(locale).get(key), value))) {
                                    this.newValues.get(resource).get(locale).put(key, value);
                                }
                                s = lexer.lex();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (PropertiesParseException ex) {
                        Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        ArrayList<LocaleItem> localeItems = new ArrayList<LocaleItem>();
        for (String locale : this.locales) {
            localeItems.add(new LocaleItem(locale));
        }
        this.localeComboBox.setModel(new DefaultComboBoxModel<LocaleItem>(localeItems.toArray(new LocaleItem[localeItems.size()])));
        this.itemStateChanged(null);
        this.repaint();
    }

    private void loadWindow() throws FileNotFoundException, IOException {
        if (!new File(this.getWindowFile()).exists()) {
            return;
        }
        FileReader fileReader = new FileReader(this.getWindowFile());
        BufferedReader reader = new BufferedReader(fileReader);
        String s = null;
        block26: while ((s = reader.readLine()) != null) {
            if (!s.contains("=")) continue;
            String key = s.substring(0, s.indexOf("="));
            String value = s.substring(s.indexOf("=") + 1);
            block13 : switch (key) {
                case "locale": {
                    int i;
                    for (i = 0; i < this.localeComboBox.getItemCount(); ++i) {
                        LocaleItem item = this.localeComboBox.getItemAt(i);
                        if (!item.locale.equals(value)) continue;
                        this.localeComboBox.setSelectedIndex(i);
                        break block13;
                    }
                    continue block26;
                }
                case "resource": {
                    int i;
                    for (i = 0; i < this.resourcesComboBox.getItemCount(); ++i) {
                        ResourceItem item = this.resourcesComboBox.getItemAt(i);
                        if (!item.resource.equals(value)) continue;
                        this.resourcesComboBox.setSelectedIndex(i);
                        break block13;
                    }
                    continue block26;
                }
                case "window.x": {
                    int x = Integer.parseInt(value);
                    this.setLocation(x, this.getLocation().y);
                    break;
                }
                case "window.y": {
                    int y = Integer.parseInt(value);
                    this.setLocation(this.getLocation().x, y);
                    break;
                }
                case "window.width": {
                    int width = Integer.parseInt(value);
                    this.setSize(width, this.getSize().height);
                    break;
                }
                case "window.height": {
                    int height = Integer.parseInt(value);
                    this.setSize(this.getSize().width, height);
                    break;
                }
                case "window.maximized": {
                    if (!value.equals("true")) break;
                    this.setExtendedState(this.getExtendedState() | 6);
                    break;
                }
                case "column.key.width": {
                    int valueInt = Integer.parseInt(value);
                    this.table.getColumn("key").setPreferredWidth(valueInt);
                    break;
                }
                case "column.en.width": {
                    int valueInt = Integer.parseInt(value);
                    this.table.getColumn("en").setPreferredWidth(valueInt);
                    break;
                }
                case "column.translated.width": {
                    int valueInt = Integer.parseInt(value);
                    this.table.getColumn("translated").setPreferredWidth(valueInt);
                    break;
                }
                case "export.dir": {
                    this.lastSaveDir = value;
                }
            }
        }
        fileReader.close();
    }

    private void saveWindow() throws IOException {
        FileWriter writer = new FileWriter(new File(this.getWindowFile()));
        PrintWriter pw = new PrintWriter(writer);
        pw.println("locale=" + ((LocaleItem)this.localeComboBox.getSelectedItem()).locale);
        pw.println("resource=" + ((ResourceItem)this.resourcesComboBox.getSelectedItem()).resource);
        pw.println("window.x=" + this.getLocation().x);
        pw.println("window.y=" + this.getLocation().y);
        pw.println("window.width=" + this.getSize().width);
        pw.println("window.height=" + this.getSize().height);
        if ((this.getExtendedState() & 6) > 0) {
            pw.println("window.maximized=true");
        } else {
            pw.println("window.maximized=false");
        }
        pw.println("column.key.width=" + this.table.getColumn("key").getWidth());
        pw.println("column.en.width=" + this.table.getColumn("en").getWidth());
        pw.println("column.translated.width=" + this.table.getColumn("translated").getWidth());
        pw.println("export.dir=" + this.lastSaveDir);
        writer.close();
    }

    private void saveAll() throws FileNotFoundException, IOException {
        String storageFile = AppDirectoryProvider.getFFDecHome() + "alltranslated.zip";
        this.save(storageFile, this.resourceValues);
    }

    private void save() throws FileNotFoundException, IOException {
        this.save(this.getStorageFile(), this.newValues);
    }

    private void save(String storageFile, Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> values) throws FileNotFoundException, IOException {
        String storageFileTmp = storageFile + ".tmp";
        FileOutputStream fos = new FileOutputStream(storageFileTmp);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        for (String resource : values.keySet()) {
            for (String locale : values.get(resource).keySet()) {
                String resourceZipName = resource.replace(": ", "/");
                String propertiesPath = resourceZipName + (locale.equals("en") ? "" : "_" + locale) + ".properties";
                ZipEntry zipEntry = new ZipEntry(propertiesPath);
                zipOut.putNextEntry(zipEntry);
                for (String key : this.resourceValues.get(resource).get("en").keySet()) {
                    int i;
                    int numLines;
                    String value;
                    if (values.containsKey(resource) && values.get(resource).containsKey(locale) && values.get(resource).get(locale).containsKey(key)) {
                        value = values.get(resource).get(locale).get(key);
                    } else {
                        if (!this.resourceValues.containsKey(resource) || !this.resourceValues.get(resource).containsKey(locale) || !this.resourceValues.get(resource).get(locale).containsKey(key)) continue;
                        value = this.resourceValues.get(resource).get(locale).get(key);
                    }
                    if (this.newLinesBeforeComment.containsKey(resource) && this.newLinesBeforeComment.get(resource).containsKey(locale) && this.newLinesBeforeComment.get(resource).get(locale).containsKey(key)) {
                        numLines = this.newLinesBeforeComment.get(resource).get(locale).get(key);
                        for (i = 0; i < numLines; ++i) {
                            zipOut.write("\r\n".getBytes("UTF-8"));
                        }
                    }
                    if (this.comments.containsKey(resource) && this.comments.get(resource).containsKey("en") && this.comments.get(resource).get("en").containsKey(key)) {
                        String comment = this.comments.get(resource).get("en").get(key);
                        comment = "#" + comment.replace("\r\n", "\r\n#") + "\r\n";
                        zipOut.write(comment.getBytes("UTF-8"));
                    }
                    if (this.newLinesAfterComment.containsKey(resource) && this.newLinesAfterComment.get(resource).containsKey(locale) && this.newLinesAfterComment.get(resource).get(locale).containsKey(key)) {
                        numLines = this.newLinesAfterComment.get(resource).get(locale).get(key);
                        for (i = 0; i < numLines; ++i) {
                            zipOut.write("\r\n".getBytes("UTF-8"));
                        }
                    }
                    zipOut.write((this.escapeKey(key) + " = " + this.escapeValue(value) + "\r\n").getBytes("UTF-8"));
                }
            }
        }
        zipOut.close();
        fos.close();
        if (!new File(storageFile).exists() || new File(storageFile).delete()) {
            new File(storageFileTmp).renameTo(new File(storageFile));
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        try {
            Translator t = new Translator();
            t.setVisible(true);
            t.updateRowHeights(t.table);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class JTextAreaColumn
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextArea textArea = new JTextArea();
        private JTextField textField = new JTextField();
        private JScrollPane pane = new JScrollPane(this.textArea);
        private boolean areaMode = false;
        private Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> resourceValues;
        private JComboBox<LocaleItem> localeComboBox;
        private JComboBox<ResourceItem> resourcesComboBox;

        public JTextAreaColumn(Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> resourceValues, JComboBox<LocaleItem> localeComboBox, JComboBox<ResourceItem> resourcesComboBox) {
            this.pane.setBorder(null);
            this.resourceValues = resourceValues;
            this.localeComboBox = localeComboBox;
            this.resourcesComboBox = resourcesComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.areaMode) {
                return this.textArea.getText().replace("\r\n", "\n").replace("\n", "\r\n");
            }
            return this.textField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String locale = ((LocaleItem)this.localeComboBox.getSelectedItem()).locale;
            String resource = ((ResourceItem)this.resourcesComboBox.getSelectedItem()).resource;
            String key = (String)table.getModel().getValueAt(row, 0);
            String enValue = "";
            if (this.resourceValues.containsKey(resource) && this.resourceValues.get(resource).containsKey("en") && this.resourceValues.get(resource).get("en").containsKey(key)) {
                enValue = this.resourceValues.get(resource).get("en").get(key);
            }
            String valueStr = value == null ? "" : value.toString();
            this.areaMode = true;
            this.textArea.setFont(new JLabel().getFont());
            this.textArea.setText(valueStr);
            this.textArea.setEditable(column == 2);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            return this.pane;
        }
    }

    class ResourceItem {
        public String resource;
        public int missingCount = 0;
        public int modifiedCount = 0;
        public int newCount = 0;

        public ResourceItem(String resource) {
            this.resource = resource;
        }

        public String toString() {
            String ret = this.resource;
            if (this.missingCount > 0 || this.modifiedCount > 0 || this.newCount > 0) {
                ret = ret + " (";
                ArrayList<String> parts = new ArrayList<String>();
                if (this.missingCount > 0) {
                    parts.add("" + this.missingCount + " missing");
                }
                if (this.modifiedCount > 0) {
                    parts.add("" + this.modifiedCount + " modified");
                }
                if (this.newCount > 0) {
                    parts.add("" + this.newCount + " new");
                }
                ret = ret + String.join((CharSequence)", ", parts);
                ret = ret + ")";
            }
            return ret;
        }
    }

    class LocaleItem {
        public String locale;
        public int missingCount = 0;
        public int modifiedCount = 0;
        public int newCount = 0;

        public LocaleItem(String locale) {
            this.locale = locale;
        }

        public String toString() {
            String[] parts = this.locale.split("_");
            Locale loc = parts.length == 2 ? View.createLocale(parts[0], parts[1]) : View.createLocale(parts[0]);
            String ret = loc.getDisplayName() + " [" + this.locale + "]";
            if (this.missingCount > 0 || this.modifiedCount > 0 || this.newCount > 0) {
                ret = ret + " (";
                ArrayList<String> parts2 = new ArrayList<String>();
                if (this.missingCount > 0) {
                    parts2.add("" + this.missingCount + " missing");
                }
                if (this.modifiedCount > 0) {
                    parts2.add("" + this.modifiedCount + " modified");
                }
                if (this.newCount > 0) {
                    parts2.add("" + this.newCount + " new");
                }
                ret = ret + String.join((CharSequence)", ", parts2);
                ret = ret + ")";
            }
            return ret;
        }
    }
}

