/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter;

import com.jpexs.flash.fla.converter.AbstractConverter;
import com.jpexs.flash.fla.converter.FlaFormatVersion;
import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.GradientEntry;
import com.jpexs.flash.fla.converter.TimelineConverter;
import com.jpexs.flash.fla.converter.streams.InputStorageInterface;
import com.jpexs.flash.fla.converter.streams.OutputStorageInterface;
import com.jpexs.flash.fla.converter.swatches.ExtendedSwatchItem;
import com.jpexs.flash.fla.converter.swatches.LinearGradientSwatchItem;
import com.jpexs.flash.fla.converter.swatches.RadialGradientSwatchItem;
import com.jpexs.flash.fla.converter.swatches.SolidSwatchItem;
import com.jpexs.helpers.Reference;
import java.awt.Color;
import java.awt.Font;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FlaConverter
extends AbstractConverter {
    public long timeCreatedMs = Calendar.getInstance().getTimeInMillis();
    public long timeCreated = this.timeCreatedMs / 1000L;
    public static final int RULERUNITS_INCHES = 0;
    public static final int RULERUNITS_INCHES_DECIMAL = 1;
    public static final int RULERUNITS_POINTS = 2;
    public static final int RULERUNITS_CM = 3;
    public static final int RULERUNITS_MM = 4;
    public static final int RULERUNITS_PX = 5;
    public static final int SYMBOLTYPE_GRAPHIC = 0;
    public static final int SYMBOLTYPE_BUTTON = 1;
    public static final int SYMBOLTYPE_MOVIECLIP = 2;
    private static final SecureRandom random = new SecureRandom();
    protected List<SolidSwatchItem> defaultSolidSwatches = Arrays.asList(new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 51, 0, 80, 239, 24), new SolidSwatchItem(0, 102, 0, 80, 239, 48), new SolidSwatchItem(0, 153, 0, 80, 239, 72), new SolidSwatchItem(0, 204, 0, 80, 239, 96), new SolidSwatchItem(0, 255, 0, 80, 239, 120), new SolidSwatchItem(51, 0, 0, 0, 239, 24), new SolidSwatchItem(51, 51, 0, 40, 239, 24), new SolidSwatchItem(51, 102, 0, 60, 239, 48), new SolidSwatchItem(51, 153, 0, 67, 239, 72), new SolidSwatchItem(51, 204, 0, 70, 239, 96), new SolidSwatchItem(51, 255, 0, 72, 239, 120), new SolidSwatchItem(102, 0, 0, 0, 239, 48), new SolidSwatchItem(102, 51, 0, 20, 239, 48), new SolidSwatchItem(102, 102, 0, 40, 239, 48), new SolidSwatchItem(102, 153, 0, 53, 239, 72), new SolidSwatchItem(102, 204, 0, 60, 239, 96), new SolidSwatchItem(102, 255, 0, 64, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(51, 51, 51, 0, 0, 48), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 51, 160, 239, 24), new SolidSwatchItem(0, 51, 51, 120, 239, 24), new SolidSwatchItem(0, 102, 51, 100, 239, 48), new SolidSwatchItem(0, 153, 51, 93, 239, 72), new SolidSwatchItem(0, 204, 51, 90, 239, 96), new SolidSwatchItem(0, 255, 51, 88, 239, 120), new SolidSwatchItem(51, 0, 51, 200, 239, 24), new SolidSwatchItem(51, 51, 51, 0, 0, 48), new SolidSwatchItem(51, 102, 51, 80, 80, 72), new SolidSwatchItem(51, 153, 51, 80, 120, 96), new SolidSwatchItem(51, 204, 51, 80, 144, 120), new SolidSwatchItem(51, 255, 51, 80, 239, 144), new SolidSwatchItem(102, 0, 51, 220, 239, 48), new SolidSwatchItem(102, 51, 51, 0, 80, 72), new SolidSwatchItem(102, 102, 51, 40, 80, 72), new SolidSwatchItem(102, 153, 51, 60, 120, 96), new SolidSwatchItem(102, 204, 51, 67, 144, 120), new SolidSwatchItem(102, 255, 51, 70, 239, 144), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(102, 102, 102, 0, 0, 96), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 102, 160, 239, 48), new SolidSwatchItem(0, 51, 102, 140, 239, 48), new SolidSwatchItem(0, 102, 102, 120, 239, 48), new SolidSwatchItem(0, 153, 102, 107, 239, 72), new SolidSwatchItem(0, 204, 102, 100, 239, 96), new SolidSwatchItem(0, 255, 102, 96, 239, 120), new SolidSwatchItem(51, 0, 102, 180, 239, 48), new SolidSwatchItem(51, 51, 102, 160, 80, 72), new SolidSwatchItem(51, 102, 102, 120, 80, 72), new SolidSwatchItem(51, 153, 102, 100, 120, 96), new SolidSwatchItem(51, 204, 102, 93, 144, 120), new SolidSwatchItem(51, 255, 102, 90, 239, 144), new SolidSwatchItem(102, 0, 102, 200, 239, 48), new SolidSwatchItem(102, 51, 102, 200, 80, 72), new SolidSwatchItem(102, 102, 102, 0, 0, 96), new SolidSwatchItem(102, 153, 102, 80, 48, 120), new SolidSwatchItem(102, 204, 102, 80, 120, 144), new SolidSwatchItem(102, 255, 102, 80, 239, 168), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 153, 153, 0, 0, 144), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 153, 160, 239, 72), new SolidSwatchItem(0, 51, 153, 147, 239, 72), new SolidSwatchItem(0, 102, 153, 133, 239, 72), new SolidSwatchItem(0, 153, 153, 120, 239, 72), new SolidSwatchItem(0, 204, 153, 110, 239, 96), new SolidSwatchItem(0, 255, 153, 104, 239, 120), new SolidSwatchItem(51, 0, 153, 173, 239, 72), new SolidSwatchItem(51, 51, 153, 160, 120, 96), new SolidSwatchItem(51, 102, 153, 140, 120, 96), new SolidSwatchItem(51, 153, 153, 120, 120, 96), new SolidSwatchItem(51, 204, 153, 107, 144, 120), new SolidSwatchItem(51, 255, 153, 100, 239, 144), new SolidSwatchItem(102, 0, 153, 187, 239, 72), new SolidSwatchItem(102, 51, 153, 180, 120, 96), new SolidSwatchItem(102, 102, 153, 160, 48, 120), new SolidSwatchItem(102, 153, 153, 120, 48, 120), new SolidSwatchItem(102, 204, 153, 100, 120, 144), new SolidSwatchItem(102, 255, 153, 93, 239, 168), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(204, 204, 204, 0, 0, 192), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 204, 160, 239, 96), new SolidSwatchItem(0, 51, 204, 150, 239, 96), new SolidSwatchItem(0, 102, 204, 140, 239, 96), new SolidSwatchItem(0, 153, 204, 130, 239, 96), new SolidSwatchItem(0, 204, 204, 120, 239, 96), new SolidSwatchItem(0, 255, 204, 112, 239, 120), new SolidSwatchItem(51, 0, 204, 170, 239, 96), new SolidSwatchItem(51, 51, 204, 160, 144, 120), new SolidSwatchItem(51, 102, 204, 147, 144, 120), new SolidSwatchItem(51, 153, 204, 133, 144, 120), new SolidSwatchItem(51, 204, 204, 120, 144, 120), new SolidSwatchItem(51, 255, 204, 110, 239, 144), new SolidSwatchItem(102, 0, 204, 180, 239, 96), new SolidSwatchItem(102, 51, 204, 173, 144, 120), new SolidSwatchItem(102, 102, 204, 160, 120, 144), new SolidSwatchItem(102, 153, 204, 140, 120, 144), new SolidSwatchItem(102, 204, 204, 120, 120, 144), new SolidSwatchItem(102, 255, 204, 107, 239, 168), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(255, 255, 255, 0, 0, 240), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 255, 160, 239, 120), new SolidSwatchItem(0, 51, 255, 152, 239, 120), new SolidSwatchItem(0, 102, 255, 144, 239, 120), new SolidSwatchItem(0, 153, 255, 136, 239, 120), new SolidSwatchItem(0, 204, 255, 128, 239, 120), new SolidSwatchItem(0, 255, 255, 120, 239, 120), new SolidSwatchItem(51, 0, 255, 168, 239, 120), new SolidSwatchItem(51, 51, 255, 160, 239, 144), new SolidSwatchItem(51, 102, 255, 150, 239, 144), new SolidSwatchItem(51, 153, 255, 140, 239, 144), new SolidSwatchItem(51, 204, 255, 130, 239, 144), new SolidSwatchItem(51, 255, 255, 120, 239, 144), new SolidSwatchItem(102, 0, 255, 176, 239, 120), new SolidSwatchItem(102, 51, 255, 170, 239, 144), new SolidSwatchItem(102, 102, 255, 160, 239, 168), new SolidSwatchItem(102, 153, 255, 147, 239, 168), new SolidSwatchItem(102, 204, 255, 133, 239, 168), new SolidSwatchItem(102, 255, 255, 120, 239, 168), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(255, 0, 0, 0, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 0, 0, 239, 72), new SolidSwatchItem(153, 51, 0, 13, 239, 72), new SolidSwatchItem(153, 102, 0, 27, 239, 72), new SolidSwatchItem(153, 153, 0, 40, 239, 72), new SolidSwatchItem(153, 204, 0, 50, 239, 96), new SolidSwatchItem(153, 255, 0, 56, 239, 120), new SolidSwatchItem(204, 0, 0, 0, 239, 96), new SolidSwatchItem(204, 51, 0, 10, 239, 96), new SolidSwatchItem(204, 102, 0, 20, 239, 96), new SolidSwatchItem(204, 153, 0, 30, 239, 96), new SolidSwatchItem(204, 204, 0, 40, 239, 96), new SolidSwatchItem(204, 255, 0, 48, 239, 120), new SolidSwatchItem(255, 0, 0, 0, 239, 120), new SolidSwatchItem(255, 51, 0, 8, 239, 120), new SolidSwatchItem(255, 102, 0, 16, 239, 120), new SolidSwatchItem(255, 153, 0, 24, 239, 120), new SolidSwatchItem(255, 204, 0, 32, 239, 120), new SolidSwatchItem(255, 255, 0, 40, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 255, 0, 80, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 51, 227, 239, 72), new SolidSwatchItem(153, 51, 51, 0, 120, 96), new SolidSwatchItem(153, 102, 51, 20, 120, 96), new SolidSwatchItem(153, 153, 51, 40, 120, 96), new SolidSwatchItem(153, 204, 51, 53, 144, 120), new SolidSwatchItem(153, 255, 51, 60, 239, 144), new SolidSwatchItem(204, 0, 51, 230, 239, 96), new SolidSwatchItem(204, 51, 51, 0, 144, 120), new SolidSwatchItem(204, 102, 51, 13, 144, 120), new SolidSwatchItem(204, 153, 51, 27, 144, 120), new SolidSwatchItem(204, 204, 51, 40, 144, 120), new SolidSwatchItem(204, 255, 51, 50, 239, 144), new SolidSwatchItem(255, 0, 51, 232, 239, 120), new SolidSwatchItem(255, 51, 51, 0, 239, 144), new SolidSwatchItem(255, 102, 51, 10, 239, 144), new SolidSwatchItem(255, 153, 51, 20, 239, 144), new SolidSwatchItem(255, 204, 51, 30, 239, 144), new SolidSwatchItem(255, 255, 51, 40, 239, 144), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 0, 255, 160, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 102, 213, 239, 72), new SolidSwatchItem(153, 51, 102, 220, 120, 96), new SolidSwatchItem(153, 102, 102, 0, 48, 120), new SolidSwatchItem(153, 153, 102, 40, 48, 120), new SolidSwatchItem(153, 204, 102, 60, 120, 144), new SolidSwatchItem(153, 255, 102, 67, 239, 168), new SolidSwatchItem(204, 0, 102, 220, 239, 96), new SolidSwatchItem(204, 51, 102, 227, 144, 120), new SolidSwatchItem(204, 102, 102, 0, 120, 144), new SolidSwatchItem(204, 153, 102, 20, 120, 144), new SolidSwatchItem(204, 204, 102, 40, 120, 144), new SolidSwatchItem(204, 255, 102, 53, 239, 168), new SolidSwatchItem(255, 0, 102, 224, 239, 120), new SolidSwatchItem(255, 51, 102, 230, 239, 144), new SolidSwatchItem(255, 102, 102, 0, 239, 168), new SolidSwatchItem(255, 153, 102, 13, 239, 168), new SolidSwatchItem(255, 204, 102, 27, 239, 168), new SolidSwatchItem(255, 255, 102, 40, 239, 168), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(255, 255, 0, 40, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 153, 200, 239, 72), new SolidSwatchItem(153, 51, 153, 200, 120, 96), new SolidSwatchItem(153, 102, 153, 200, 48, 120), new SolidSwatchItem(153, 153, 153, 0, 0, 144), new SolidSwatchItem(153, 204, 153, 80, 80, 168), new SolidSwatchItem(153, 255, 153, 80, 239, 192), new SolidSwatchItem(204, 0, 153, 210, 239, 96), new SolidSwatchItem(204, 51, 153, 213, 144, 120), new SolidSwatchItem(204, 102, 153, 220, 120, 144), new SolidSwatchItem(204, 153, 153, 0, 80, 168), new SolidSwatchItem(204, 204, 153, 40, 80, 168), new SolidSwatchItem(204, 255, 153, 60, 239, 192), new SolidSwatchItem(255, 0, 153, 216, 239, 120), new SolidSwatchItem(255, 51, 153, 220, 239, 144), new SolidSwatchItem(255, 102, 153, 227, 239, 168), new SolidSwatchItem(255, 153, 153, 0, 239, 192), new SolidSwatchItem(255, 204, 153, 20, 239, 192), new SolidSwatchItem(255, 255, 153, 40, 239, 192), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(0, 255, 255, 120, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 204, 190, 239, 96), new SolidSwatchItem(153, 51, 204, 187, 144, 120), new SolidSwatchItem(153, 102, 204, 180, 120, 144), new SolidSwatchItem(153, 153, 204, 160, 80, 168), new SolidSwatchItem(153, 204, 204, 120, 80, 168), new SolidSwatchItem(153, 255, 204, 100, 239, 192), new SolidSwatchItem(204, 0, 204, 200, 239, 96), new SolidSwatchItem(204, 51, 204, 200, 144, 120), new SolidSwatchItem(204, 102, 204, 200, 120, 144), new SolidSwatchItem(204, 153, 204, 200, 80, 168), new SolidSwatchItem(204, 204, 204, 0, 0, 192), new SolidSwatchItem(204, 255, 204, 80, 239, 216), new SolidSwatchItem(255, 0, 204, 208, 239, 120), new SolidSwatchItem(255, 51, 204, 210, 239, 144), new SolidSwatchItem(255, 102, 204, 213, 239, 168), new SolidSwatchItem(255, 153, 204, 220, 239, 192), new SolidSwatchItem(255, 204, 204, 0, 239, 216), new SolidSwatchItem(255, 255, 204, 40, 239, 216), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(255, 0, 255, 200, 239, 120), new SolidSwatchItem(0, 0, 0, 0, 0, 0), new SolidSwatchItem(153, 0, 255, 184, 239, 120), new SolidSwatchItem(153, 51, 255, 180, 239, 144), new SolidSwatchItem(153, 102, 255, 173, 239, 168), new SolidSwatchItem(153, 153, 255, 160, 239, 192), new SolidSwatchItem(153, 204, 255, 140, 239, 192), new SolidSwatchItem(153, 255, 255, 120, 239, 192), new SolidSwatchItem(204, 0, 255, 192, 239, 120), new SolidSwatchItem(204, 51, 255, 190, 239, 144), new SolidSwatchItem(204, 102, 255, 187, 239, 168), new SolidSwatchItem(204, 153, 255, 180, 239, 192), new SolidSwatchItem(204, 204, 255, 160, 239, 216), new SolidSwatchItem(204, 255, 255, 120, 239, 216), new SolidSwatchItem(255, 0, 255, 200, 239, 120), new SolidSwatchItem(255, 51, 255, 200, 239, 144), new SolidSwatchItem(255, 102, 255, 200, 239, 168), new SolidSwatchItem(255, 153, 255, 200, 239, 192), new SolidSwatchItem(255, 204, 255, 200, 239, 216), new SolidSwatchItem(255, 255, 255, 0, 0, 240));
    protected List<ExtendedSwatchItem> defaultExtendedSwatches = Arrays.asList(new LinearGradientSwatchItem(new GradientEntry(new Color(255, 255, 255), 0.0f), new GradientEntry(1.0f)), new RadialGradientSwatchItem(new GradientEntry(new Color(255, 255, 255), 0.0f), new GradientEntry(1.0f)), new RadialGradientSwatchItem(new GradientEntry(new Color(255, 0, 0), 0.0f), new GradientEntry(1.0f)), new RadialGradientSwatchItem(new GradientEntry(new Color(0, 255, 0), 0.0f), new GradientEntry(1.0f)), new RadialGradientSwatchItem(new GradientEntry(new Color(0, 0, 255), 0.0f), new GradientEntry(1.0f)), new LinearGradientSwatchItem(new GradientEntry(new Color(0, 102, 253), 0.0f), new GradientEntry(new Color(255, 255, 255), 0.3764706f), new GradientEntry(new Color(255, 255, 255), 0.47843137f), new GradientEntry(new Color(153, 102, 0), 0.5019608f), new GradientEntry(new Color(255, 204, 0), 0.6666667f), new GradientEntry(new Color(255, 255, 255), 1.0f)), new LinearGradientSwatchItem(new GradientEntry(new Color(255, 0, 0), 0.0f), new GradientEntry(new Color(255, 255, 0), 0.16470589f), new GradientEntry(new Color(0, 255, 0), 0.3647059f), new GradientEntry(new Color(0, 255, 255), 0.49803922f), new GradientEntry(new Color(0, 0, 255), 0.6666667f), new GradientEntry(new Color(255, 0, 255), 0.83137256f), new GradientEntry(new Color(255, 0, 0), 1.0f)));

    public FlaConverter(FlaFormatVersion flaFormatVersion, String charset) {
        super(flaFormatVersion, charset);
        if (flaFormatVersion.ordinal() < FlaFormatVersion.F5.ordinal()) {
            throw new UnsupportedOperationException("Version " + (Object)((Object)flaFormatVersion) + " is not supported yet");
        }
    }

    private void writeTime(FlaWriter fg, long time) throws IOException {
        if (this.debugRandom) {
            fg.write(88, 88, 88, 88);
        } else {
            fg.writeUI32(time);
        }
    }

    private void writeTimeCreated(FlaWriter fg) throws IOException {
        if (this.debugRandom) {
            fg.write(88, 88, 88, 88);
        } else {
            fg.writeUI32(this.timeCreated);
        }
    }

    private String getTimeCreatedAsString() {
        if (this.debugRandom) {
            return "XXXXXXXXXX";
        }
        return "" + this.timeCreated;
    }

    private String getTimeAsString(long time) {
        if (this.debugRandom) {
            return "XXXXXXXXXX";
        }
        return "" + time;
    }

    private String generateGUID() {
        int length = 32;
        if (this.debugRandom) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append('X');
            }
            return sb.toString();
        }
        String HEX_CHARS = "ABCDEF0123456789";
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt("ABCDEF0123456789".length());
            sb.append("ABCDEF0123456789".charAt(index));
        }
        return sb.toString();
    }

    private String generateXmppId() {
        int length = 24;
        if (this.debugRandom) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append('X');
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(length);
        String ALPHA_NUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        String ALPHA_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int firstCharIndex = random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length());
        sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(firstCharIndex));
        for (int i = 1; i < length; ++i) {
            int index = random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(index));
        }
        return sb.toString();
    }

    private void writeAsLinkage(FlaWriter dw, Element element) throws IOException {
        boolean linkageExportForAS = false;
        if (element.hasAttribute("linkageExportForAS")) {
            linkageExportForAS = "true".equals(element.getAttribute("linkageExportForAS"));
        }
        String linkageClassName = "";
        if (element.hasAttribute("linkageClassName")) {
            linkageClassName = element.getAttribute("linkageClassName");
        }
        boolean linkageExportInFirstFrame = true;
        if (element.hasAttribute("linkageExportInFirstFrame")) {
            linkageExportInFirstFrame = !"false".equals(element.getAttribute("linkageExportInFirstFrame"));
        }
        String linkageBaseClass = "";
        if (element.hasAttribute("linkageBaseClass")) {
            linkageBaseClass = element.getAttribute("linkageBaseClass");
        }
        boolean linkageExportForRS = false;
        if (element.hasAttribute("linkageExportForRS")) {
            linkageExportForRS = "true".equals(element.getAttribute("linkageExportForRS"));
        }
        String linkageURL = "";
        if (element.hasAttribute("linkageURL")) {
            linkageURL = element.getAttribute("linkageURL");
        }
        boolean linkageImportForRS = false;
        if (element.hasAttribute("linkageImportForRS")) {
            linkageImportForRS = "true".equals(element.getAttribute("linkageImportForRS"));
        }
        String sourceLibraryItemHRef = "";
        if (element.hasAttribute("sourceLibraryItemHRef")) {
            sourceLibraryItemHRef = element.getAttribute("sourceLibraryItemHRef");
        }
        String linkageIdentifier = "";
        if (element.hasAttribute("linkageIdentifier")) {
            linkageIdentifier = element.getAttribute("linkageIdentifier");
        }
        dw.write(0, 0, 0, 0);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
            dw.write(this.flaFormatVersion.getAsLinkageVersion());
            dw.write((linkageExportForAS ? 1 : 0) + (linkageImportForRS ? 2 : 0));
            dw.write(0, 0, 0);
            dw.writeBomString(linkageIdentifier);
            dw.writeBomString(linkageURL);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.writeBomString(linkageClassName);
        }
        int linkageFlags = 0;
        if (linkageExportInFirstFrame) {
            linkageFlags |= 4;
        }
        if (linkageExportForAS) {
            linkageFlags |= 1;
        }
        if (linkageExportForRS) {
            linkageFlags |= 2;
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
            dw.write(this.debugRandom ? 88 : linkageFlags, this.flaFormatVersion.getAsLinkageVersionB(), 0, 0, 0);
            dw.writeBomString("");
            dw.writeBomString(sourceLibraryItemHRef);
            dw.write(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            dw.write(0);
            dw.writeBomString(linkageBaseClass);
        }
    }

    private String getParentFolderItemID(Element document, String itemName) {
        if (!itemName.contains("/")) {
            return null;
        }
        String folderName = itemName.substring(0, itemName.lastIndexOf("/"));
        Element foldersElement = this.getSubElementByName(document, "folders");
        if (foldersElement == null) {
            return null;
        }
        List<Element> domFolderItems = this.getAllSubElementsByName(foldersElement, "DOMFolderItem");
        for (Element domFolderItem : domFolderItems) {
            if (!domFolderItem.getAttribute("name").equals(folderName)) continue;
            if (domFolderItem.hasAttribute("itemID")) {
                return domFolderItem.getAttribute("itemID");
            }
            return null;
        }
        return null;
    }

    private int writeSymbols(FlaWriter fg, Element document, DocumentBuilder docBuilder, InputStorageInterface sourceDir, OutputStorageInterface outputDir, Reference<Long> generatedItemIdOrder, Map<String, Integer> definedClasses, Reference<Integer> objectsCount) throws SAXException, IOException, FileNotFoundException, ParserConfigurationException {
        int symbolCount = 0;
        List<Element> includes = this.getSymbols(document);
        ArrayList<Element> sorted = new ArrayList<Element>(includes);
        sorted.sort(new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                int itemIcon1 = -1;
                int itemIcon2 = -1;
                if (o1.hasAttribute("itemIcon")) {
                    itemIcon1 = Integer.parseInt(o1.getAttribute("itemIcon"));
                }
                if (o2.hasAttribute("itemIcon")) {
                    itemIcon2 = Integer.parseInt(o2.getAttribute("itemIcon"));
                }
                return itemIcon1 - itemIcon2;
            }
        });
        for (int i = 0; i < includes.size(); ++i) {
            Element domTimelineElement;
            Element include = includes.get(i);
            if (!include.hasAttribute("href")) continue;
            String href = include.getAttribute("href");
            Document symbolDocument = docBuilder.parse(sourceDir.readFile("LIBRARY/" + href));
            Element symbolElement = symbolDocument.getDocumentElement();
            Element timelineElement = this.getSubElementByName(symbolElement, "timeline");
            if (timelineElement == null || (domTimelineElement = this.getSubElementByName(timelineElement, "DOMTimeline")) == null) continue;
            ++symbolCount;
            int symbolId = i + 1;
            long symbolTime = this.timeCreated;
            String symbolFile = "S " + symbolId + " " + this.getTimeAsString(symbolTime);
            if (this.debugRandom) {
                int symbolIdOrdered = sorted.indexOf(includes.get(i)) + 1;
                symbolFile = "S " + symbolIdOrdered + " " + this.getTimeAsString(symbolTime);
            }
            String symbolName = "Symbol " + symbolId;
            if (domTimelineElement.hasAttribute("name")) {
                symbolName = domTimelineElement.getAttribute("name");
            }
            String symbolFullName = symbolElement.getAttribute("name");
            String parentFolderItemId = this.getParentFolderItemID(document, symbolFullName);
            float scaleGridLeft = 0.0f;
            if (symbolElement.hasAttribute("scaleGridLeft")) {
                scaleGridLeft = Float.parseFloat(symbolElement.getAttribute("scaleGridLeft"));
            }
            float scaleGridRight = 0.0f;
            if (symbolElement.hasAttribute("scaleGridRight")) {
                scaleGridRight = Float.parseFloat(symbolElement.getAttribute("scaleGridRight"));
            }
            float scaleGridTop = 0.0f;
            if (symbolElement.hasAttribute("scaleGridTop")) {
                scaleGridTop = Float.parseFloat(symbolElement.getAttribute("scaleGridTop"));
            }
            float scaleGridBottom = 0.0f;
            if (symbolElement.hasAttribute("scaleGridBottom")) {
                scaleGridBottom = Float.parseFloat(symbolElement.getAttribute("scaleGridBottom"));
            }
            int symbolType = this.getAttributeAsInt(symbolElement, "symbolType", Arrays.asList("graphic", "button", "movie clip"), "movie clip");
            String itemID = this.generateItemID(generatedItemIdOrder);
            if (symbolElement.hasAttribute("itemID")) {
                itemID = symbolElement.getAttribute("itemID");
            }
            this.useClass("CDocumentPage", 1, fg, definedClasses, objectsCount);
            fg.write(this.flaFormatVersion.getDocumentPageVersion());
            fg.writeString(this.debugRandom ? "YYY" : symbolFile);
            fg.writeBomString(symbolName);
            if (this.debugRandom) {
                fg.write(88, 88);
            } else {
                fg.writeUI16(symbolId);
            }
            fg.write(0, 0, symbolType);
            fg.writeBomString("");
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F4.ordinal()) {
                fg.write(1, 0, 0, 0, this.flaFormatVersion.getSpriteVersionE());
                fg.write(0);
                fg.write(0, 0, 1, 0, 0, 0);
                if (parentFolderItemId == null) {
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                } else {
                    fg.writeItemID(parentFolderItemId);
                }
                fg.write(1, 0, 0, 0);
                fg.writeItemID(itemID);
                this.writeAsLinkage(fg, symbolElement);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                fg.write(0);
            }
            this.writeTime(fg, symbolTime);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                fg.writeBomString("");
                fg.writeBomString("");
            }
            if (this.flaFormatVersion.ordinal() == FlaFormatVersion.F5.ordinal()) {
                fg.write(1, 0, 0, 0, 0, 1);
            } else {
                fg.write(2, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, this.flaFormatVersion.getSpriteVersionC());
                fg.write(0, 0, 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    fg.write(0);
                }
                fg.writeBomString("");
                fg.writeBomString("");
                fg.writeBomString("");
                fg.write(0, this.flaFormatVersion.getSpriteVersionF(), 0, 0, 0);
                fg.writeBomString("");
                fg.writeBomString("");
                fg.write(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                        fg.write(0);
                        fg.writeBomString("");
                    }
                    fg.write(this.flaFormatVersion.getSpriteVersionD(), 0, 0, 0, 0);
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0);
                    fg.writeBomString("");
                    fg.write(3);
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0, 3);
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0, 3);
                    fg.writeBomString("");
                } else {
                    fg.write(0, this.flaFormatVersion.getSpriteVersionD());
                }
                fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                fg.writeBomString("");
                fg.write(2, 0, 0, 0, 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    fg.write(1, 0);
                }
                fg.write(0, 0);
                fg.writeBomString("");
                fg.write(0, 0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                fg.write(0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                fg.write(1, 0, 0, 0);
                fg.writeBomString("");
                fg.write(0, 0, 0, 0, 0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                fg.writeBomString("");
                fg.writeBomString("");
                fg.write(0, 0, 0, 0);
                fg.writeBomString("");
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                if (scaleGridLeft != 0.0f || scaleGridRight != 0.0f || scaleGridTop != 0.0f || scaleGridBottom != 0.0f) {
                    fg.write(1, 0, 0, 0);
                    fg.writeUI32(Math.round(scaleGridRight * 20.0f));
                    fg.writeUI32(Math.round(scaleGridLeft * 20.0f));
                    fg.writeUI32(Math.round(scaleGridBottom * 20.0f));
                    fg.writeUI32(Math.round(scaleGridTop * 20.0f));
                } else {
                    fg.write(0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128);
                }
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                fg.write(0, 0, 0, 0, 0, 0, 0, 0, 0);
            }
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                fg.write(0, 0);
            }
            TimelineConverter symbolPageGenerator = new TimelineConverter(this.flaFormatVersion, this.charset, symbolName);
            symbolPageGenerator.setDebugRandom(this.debugRandom);
            try (OutputStream sos = outputDir.getOutputStream(symbolFile);){
                symbolPageGenerator.convert(domTimelineElement, document, sos);
                continue;
            }
        }
        return symbolCount;
    }

    /*
     * WARNING - void declaration
     */
    public void convert(InputStorageInterface sourceDir, OutputStorageInterface outputDir) throws SAXException, IOException, ParserConfigurationException {
        InputStream domDocumentIs = sourceDir.readFile("DOMDocument.xml");
        InputStream publishSettingsIs = sourceDir.readFile("PublishSettings.xml");
        InputStream metadataIs = sourceDir.readFile("META-INF/metadata.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(false);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document domDocument = docBuilder.parse(domDocumentIs);
        Document publishSettings = publishSettingsIs == null ? null : docBuilder.parse(publishSettingsIs);
        Document metadata = metadataIs == null ? null : docBuilder.parse(metadataIs);
        Color backgroundColor = Color.white;
        Element document = domDocument.getDocumentElement();
        if (document.hasAttribute("backgroundColor")) {
            backgroundColor = this.parseColor(document.getAttribute("backgroundColor"));
        }
        int width = 550;
        int height = 400;
        if (document.hasAttribute("width")) {
            width = Integer.parseInt(document.getAttribute("width"));
        }
        if (document.hasAttribute("height")) {
            height = Integer.parseInt(document.getAttribute("height"));
        }
        float frameRate = 24.0f;
        if (document.hasAttribute("frameRate")) {
            frameRate = Float.parseFloat(document.getAttribute("frameRate"));
        }
        List<Element> timelinesElements = this.getAllSubElementsByName(document, "timelines");
        HashMap<String, Integer> definedClasses = new HashMap<String, Integer>();
        Reference<Integer> objectsCount = new Reference<Integer>(0);
        try (OutputStream os = outputDir.getOutputStream("Contents");){
            FlaWriter fg = new FlaWriter(os, this.flaFormatVersion, this.charset);
            fg.setTitle("Contents");
            if (this.debugRandom) {
                fg.setDebugRandom(true);
            }
            fg.write(this.flaFormatVersion.getContentsVersion());
            fg.write(this.flaFormatVersion.getContentsVersionB());
            fg.write(0, 0, 0);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F3.ordinal()) {
                fg.write(0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F4.ordinal()) {
                fg.write(0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                fg.write(0, 0, 0, 0);
            }
            int pageCount = 0;
            Reference<Long> generatedItemIdOrder = new Reference<Long>(0L);
            for (Element timelinesElement : timelinesElements) {
                Element domTimeline = this.getSubElementByName(timelinesElement, "DOMTimeline");
                if (domTimeline == null || !domTimeline.hasAttribute("name")) continue;
                String sceneName = domTimeline.getAttribute("name");
                this.useClass("CDocumentPage", 1, fg, definedClasses, objectsCount);
                fg.write(this.flaFormatVersion.getDocumentPageVersion());
                String pageName = "P " + ++pageCount + " " + this.getTimeCreatedAsString();
                String debugPageName = "YYY";
                fg.writeString(this.debugRandom ? debugPageName : pageName);
                fg.writeBomString(sceneName);
                fg.write(0, 0);
                fg.write(0, 0);
                fg.write(0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F4.ordinal()) {
                    fg.writeBomString("");
                    fg.write(1, 0, 0, 0, this.flaFormatVersion.getDocumentPageVersionE(), 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0);
                    String pageItemID = this.generateItemID(generatedItemIdOrder);
                    fg.writeItemID(pageItemID);
                    fg.write(0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                    fg.write(this.flaFormatVersion.getAsLinkageVersion(), 0, 0, 0, 0);
                    fg.writeBomString("");
                    fg.writeBomString("");
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        fg.writeBomString("");
                    }
                    fg.write(this.debugRandom ? 88 : 0);
                    fg.write(this.flaFormatVersion.getAsLinkageVersionB());
                    fg.write(0, 0, 0);
                    fg.writeBomString("");
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    fg.write(0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                    fg.writeBomString("");
                    fg.write(0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F4.ordinal()) {
                    this.writeTimeCreated(fg);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                    fg.writeBomString("");
                    fg.writeBomString("");
                }
                if (this.flaFormatVersion.ordinal() == FlaFormatVersion.F5.ordinal()) {
                    fg.write(1, 0, 0, 0, 0, 1);
                } else {
                    fg.write(2, 0, 0, 0, 0, this.debugRandom ? 85 : 1, 0, 0, 0, 1, 0, 0, 0, this.flaFormatVersion.getSpriteVersionC());
                    fg.write(0, 0, 0);
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        fg.write(0);
                    }
                    fg.writeBomString("");
                    fg.writeBomString("");
                    fg.writeBomString("");
                    fg.write(0, this.flaFormatVersion.getSpriteVersionF(), 0, 0, 0);
                    fg.writeBomString("");
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255);
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                            fg.write(0);
                            fg.writeBomString("");
                        }
                        fg.write(this.flaFormatVersion.getSpriteVersionD(), 0, 0, 0, 0);
                        fg.writeBomString("");
                        fg.write(0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0);
                        fg.writeBomString("");
                        fg.write(3);
                        fg.writeBomString("");
                        fg.write(0, 0, 0, 0, 0, 0, 0, 0, 3);
                        fg.writeBomString("");
                        fg.write(0, 0, 0, 0, 0, 0, 0, 0, 3);
                        fg.writeBomString("");
                    } else {
                        fg.write(0, this.flaFormatVersion.getSpriteVersionD());
                    }
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                    fg.writeBomString("");
                    fg.write(2, 0, 0, 0, 0);
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        fg.write(this.debugRandom ? 85 : 1, 0);
                    }
                    fg.write(0, 0);
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                    fg.write(0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                    fg.write(0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                    fg.write(1, 0, 0, 0);
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                    fg.writeBomString("");
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0);
                    fg.writeBomString("");
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                    fg.write(0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0, 0);
                }
                if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                    fg.write(0, 0);
                }
                TimelineConverter pageGenerator = new TimelineConverter(this.flaFormatVersion, this.charset, "Page " + pageCount);
                pageGenerator.setDebugRandom(this.debugRandom);
                OutputStream pos = outputDir.getOutputStream(pageName);
                try {
                    pageGenerator.convert(domTimeline, document, pos);
                }
                finally {
                    if (pos == null) continue;
                    pos.close();
                }
            }
            int currentTimeline = 1;
            if (document.hasAttribute("currentTimeline")) {
                currentTimeline = Integer.parseInt(document.getAttribute("currentTimeline"));
            }
            int nextSceneIdentifier = timelinesElements.size() + 1;
            if (document.hasAttribute("nextSceneIdentifier")) {
                nextSceneIdentifier = Integer.parseInt(document.getAttribute("nextSceneIdentifier"));
            }
            fg.write(0, 0);
            if (this.debugRandom) {
                fg.write(85);
            } else if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                fg.write(2);
            } else {
                fg.write(3);
            }
            fg.write(0);
            fg.write(1, 0, 1 + currentTimeline, 0);
            int symbolCount = this.writeSymbols(fg, document, docBuilder, sourceDir, outputDir, generatedItemIdOrder, definedClasses, objectsCount);
            fg.write(0, 0);
            fg.write(this.debugRandom ? 85 : 1);
            fg.write(0);
            int mediaCount = this.writeMedia(fg, document, generatedItemIdOrder, definedClasses, objectsCount, outputDir, sourceDir);
            fg.write(0, 0);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F2.ordinal()) {
                if (this.debugRandom) {
                    fg.write(88, 88);
                } else {
                    fg.writeUI16(1 + mediaCount);
                }
                int rulerUnitType = this.getAttributeAsInt(document, "rulerUnitType", Arrays.asList("inches", "decimal inches", "points", "centimeters", "millimeters", "pixels"), "pixels");
                boolean gridVisible = false;
                if (document.hasAttribute("gridVisible")) {
                    gridVisible = !"false".equals(document.getAttribute("gridVisible"));
                }
                fg.write(rulerUnitType, 0, gridVisible ? 3 : 0, 0);
            }
            fg.write(0, 0, 0);
            fg.writeUI16(width * 20);
            fg.write(0, 0, 0, 0, 0, 0);
            fg.writeUI16(height * 20);
            fg.write(0, 0, 0, 0);
            boolean gridSnapTo = false;
            if (document.hasAttribute("gridSnapTo")) {
                gridSnapTo = !"false".equals(document.getAttribute("gridSnapTo"));
            }
            boolean snapAlign = true;
            if (document.hasAttribute("snapAlign")) {
                snapAlign = !"false".equals(document.getAttribute("snapAlign"));
            }
            int gridSpacingX = 10;
            if (document.hasAttribute("gridSpacingX")) {
                gridSpacingX = Integer.parseInt(document.getAttribute("gridSpacingX"));
            }
            int gridSpacingY = 10;
            if (document.hasAttribute("gridSpacingY")) {
                gridSpacingY = Integer.parseInt(document.getAttribute("gridSpacingY"));
            }
            int gridSnapAccuracy = 1;
            if (document.hasAttribute("gridSnapAccuracy")) {
                switch (document.getAttribute("gridSnapAccuracy")) {
                    case "Must be close": {
                        gridSnapAccuracy = 0;
                        break;
                    }
                    case "Can be distant": {
                        gridSnapAccuracy = 2;
                        break;
                    }
                    case "Always snap": {
                        gridSnapAccuracy = 3;
                    }
                }
            }
            boolean pixelSnap = false;
            if (document.hasAttribute("pixelSnap")) {
                pixelSnap = "true".equals(document.getAttribute("pixelSnap"));
            }
            boolean objectsSnapTo = true;
            if (document.hasAttribute("objectsSnapTo")) {
                objectsSnapTo = !"false".equals(document.getAttribute("objectsSnapTo"));
            }
            long snapAlignBorderSpacing = 0L;
            if (document.hasAttribute("snapAlignBorderSpacing")) {
                snapAlignBorderSpacing = Long.parseLong(document.getAttribute("snapAlignBorderSpacing"));
            }
            long snapAlignHorizontalSpacing = 0L;
            if (document.hasAttribute("snapAlignHorizontalSpacing")) {
                snapAlignHorizontalSpacing = Long.parseLong(document.getAttribute("snapAlignHorizontalSpacing"));
            }
            long snapAlignVerticalSpacing = 0L;
            if (document.hasAttribute("snapAlignVerticalSpacing")) {
                snapAlignVerticalSpacing = Long.parseLong(document.getAttribute("snapAlignVerticalSpacing"));
            }
            boolean snapAlignHorizontalCenter = false;
            if (document.hasAttribute("snapAlignHorizontalCenter")) {
                snapAlignHorizontalCenter = "true".equals(document.getAttribute("snapAlignHorizontalCenter"));
            }
            boolean snapAlignVerticalCenter = false;
            if (document.hasAttribute("snapAlignVerticalCenter")) {
                snapAlignVerticalCenter = "true".equals(document.getAttribute("snapAlignVerticalCenter"));
            }
            boolean rulerVisible = false;
            if (document.hasAttribute("rulerVisible")) {
                rulerVisible = "true".equals(document.getAttribute("rulerVisible"));
            }
            Color gridColor = new Color(148, 148, 148);
            if (document.hasAttribute("gridColor")) {
                gridColor = this.parseColor(document.getAttribute("gridColor"));
            }
            fg.writeUI16(gridSpacingX * 20);
            boolean pageTabsVisible = false;
            int previewMode = this.getAttributeAsInt(document, "previewMode", Arrays.asList("outlines", "fast", "anti alias", "anti alias text", "full"), "anti alias text");
            fg.write(previewMode, rulerVisible ? 1 : 0, pageTabsVisible ? 1 : 0);
            int viewOptions = 0;
            if (!document.getAttribute("viewOptionsAnimationControlVisible").equals("false")) {
                ++viewOptions;
            }
            if (document.getAttribute("viewOptionsButtonsActive").equals("true")) {
                viewOptions += 2;
            }
            if (!document.getAttribute("viewOptionsPasteBoardView").equals("false")) {
                viewOptions += 4;
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal() && !document.getAttribute("viewOptionsLivePreview").equals("false")) {
                viewOptions += 8;
            }
            int playOptions = 0;
            if (!document.getAttribute("playOptionsPlayLoop").equals("false")) {
                ++playOptions;
            }
            if (!document.getAttribute("playOptionsPlayPages").equals("false")) {
                playOptions += 2;
            }
            if (!document.getAttribute("playOptionsPlayFrameActions").equals("false")) {
                playOptions += 4;
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F2.ordinal() && !document.getAttribute("playOptionsPlaySounds").equals("false")) {
                playOptions += 8;
            }
            fg.write((playOptions << 4) + viewOptions);
            fg.write(0, 104, 1, 0, 0, 104, 1, 0, 0, 104, 1, 0, 0, 104, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 255, gridColor.getRed(), gridColor.getGreen(), gridColor.getBlue(), 255, 0, (int)Math.round(((double)frameRate - Math.floor(frameRate)) * 256.0), (int)Math.floor(frameRate), 0, 0, 0, 3, 180, 0, 0, 0);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F3.ordinal()) {
                if (this.flaFormatVersion == FlaFormatVersion.F3) {
                    this.writeMap(fg, new HashMap<String, String>());
                } else {
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        this.writeMap(fg, this.getLegacyProperties());
                    }
                    if (publishSettings == null) {
                        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                            fg.writeUI32(1L);
                        }
                        this.writeMap(fg, this.getProperties("Untitled-1", width, height, this.flaFormatVersion));
                    } else {
                        List<Element> flashProfiles = this.getAllSubElementsByName(publishSettings.getDocumentElement(), "flash_profile");
                        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                            fg.writeUI32(flashProfiles.size());
                        }
                        for (Element element : flashProfiles) {
                            Map<String, String> map = this.getProperties("Untitled-1", width, height, this.flaFormatVersion);
                            for (Element propertiesSet : this.getAllSubElements(element)) {
                                String namespace = propertiesSet.getTagName();
                                if ("PublishFlashProperties".equals(namespace)) {
                                    namespace = "Vector";
                                }
                                for (Element property : this.getAllSubElements(propertiesSet)) {
                                    String nsKey;
                                    String string = property.getTagName();
                                    String value = property.getTextContent();
                                    if ("Vector".equals(namespace) && ("LibraryPath".equals(string) || "LibraryVersions".equals(string)) || !map.containsKey(nsKey = namespace + "::" + string)) continue;
                                    if (nsKey.equals("Vector::RSLPreloaderMethod")) {
                                        switch (value) {
                                            case "wrap": {
                                                value = "0";
                                                break;
                                            }
                                            case "event": {
                                                value = "1";
                                            }
                                        }
                                    }
                                    if (nsKey.equals("Vector::DefaultLibraryLinkage")) {
                                        switch (value) {
                                            case "rsl": {
                                                value = "0";
                                                break;
                                            }
                                            case "merge": {
                                                value = "1";
                                            }
                                        }
                                    }
                                    if (nsKey.equals("PublishRNWKProperties::flashBitRate")) {
                                        value = "1200";
                                    }
                                    map.put(nsKey, value);
                                }
                            }
                            if (this.debugRandom) {
                                for (String key : map.keySet()) {
                                    map.put(key, "YYY");
                                }
                            }
                            this.writeMap(fg, map);
                            if (this.flaFormatVersion.ordinal() > FlaFormatVersion.MX.ordinal()) continue;
                            break;
                        }
                    }
                }
                fg.write(255, 255, 255, 255);
                fg.writeBomString("");
                fg.writeBomString("");
                fg.write(1, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F4.ordinal()) {
                fg.write(0, 0);
                this.writeColorDef(document, fg, this.flaFormatVersion, definedClasses, objectsCount);
                Element foldersElement = this.getSubElementByName(document, "folders");
                List<Object> domFolderItems = new ArrayList();
                if (foldersElement != null) {
                    domFolderItems = this.getAllSubElementsByName(foldersElement, "DOMFolderItem");
                }
                fg.writeUI32(domFolderItems.size());
                for (Element element : domFolderItems) {
                    String folderFullName;
                    fg.write(this.flaFormatVersion.getLibraryFolderVersionB(), 0, 0, 0);
                    String folderName = folderFullName = element.getAttribute("name");
                    String parentFolder = "";
                    if (folderFullName.contains("/")) {
                        folderName = folderFullName.substring(folderFullName.lastIndexOf("/") + 1);
                        parentFolder = folderFullName.substring(0, folderFullName.lastIndexOf("/"));
                    }
                    fg.writeBomString(folderName);
                    fg.write(this.flaFormatVersion.getLibraryFolderVersionC(), 0, 0, 0, 1, 0, 0, 0);
                    if (parentFolder.isEmpty()) {
                        fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                    } else {
                        boolean parentFound = false;
                        for (Element element2 : domFolderItems) {
                            if (!element2.getAttribute("name").equals(parentFolder)) continue;
                            String parentItemID = element2.getAttribute("itemID");
                            fg.writeItemID(parentItemID);
                            parentFound = true;
                            break;
                        }
                        if (!parentFound) {
                            fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                        }
                    }
                    fg.write(1, 0, 0, 0);
                    String itemID = this.generateItemID(generatedItemIdOrder);
                    if (element.hasAttribute("itemID")) {
                        itemID = element.getAttribute("itemID");
                    }
                    fg.writeItemID(itemID);
                    boolean isExpanded = false;
                    if (element.hasAttribute("isExpanded")) {
                        isExpanded = "true".equals(element.getAttribute("isExpanded"));
                    }
                    fg.write(isExpanded ? 1 : 0, 0, 0, 0);
                    fg.write(this.flaFormatVersion.getLibraryFolderVersion(), 0, 0, 0, 0);
                    fg.writeBomString("");
                    fg.writeBomString("");
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                        fg.writeBomString("");
                    }
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        fg.write(0);
                    }
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                        fg.write(this.flaFormatVersion.getLibraryFolderVersionD(), 0, 0, 0);
                        fg.writeBomString("");
                        fg.writeBomString("");
                        fg.write(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255);
                    }
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        fg.write(0);
                    }
                    if (this.flaFormatVersion.ordinal() < FlaFormatVersion.F8.ordinal()) continue;
                    fg.writeBomString("");
                    fg.write(0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    fg.write(0, 0);
                }
                fg.write(1);
                fg.write(0);
                fg.writeBomString("PublishQTProperties::QTSndSettings");
                this.writeQTAudioSettings(fg);
                fg.write(1, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F5.ordinal()) {
                void var51_82;
                boolean bl;
                boolean guidesLocked = false;
                if (document.hasAttribute("guidesLocked")) {
                    guidesLocked = "true".equals(document.getAttribute("guidesLocked"));
                }
                boolean guidesVisible = true;
                if (document.hasAttribute("guidesVisible")) {
                    guidesVisible = !"false".equals(document.getAttribute("guidesVisible"));
                }
                boolean bl2 = true;
                if (document.hasAttribute("guidesSnapTo")) {
                    bl = !"false".equals(document.getAttribute("guidesSnapTo"));
                }
                Color color = new Color(88, 255, 255);
                if (document.hasAttribute("guidesColor")) {
                    Color color2 = this.parseColor(document.getAttribute("guidesColor"));
                }
                fg.write(var51_82.getRed(), var51_82.getGreen(), var51_82.getBlue());
                fg.write(255);
                fg.write(guidesVisible ? 1 : 0, guidesLocked ? 1 : 0, bl ? 1 : 0, 0, 0, 0, 0);
                int fontCount = this.writeFonts(fg, document, generatedItemIdOrder);
                String sharedLibraryURL = "";
                if (document.hasAttribute("sharedLibraryURL")) {
                    sharedLibraryURL = document.getAttribute("sharedLibraryURL");
                }
                fg.writeBomString(sharedLibraryURL);
                fg.write(gridSnapTo ? 1 : 0, objectsSnapTo ? 1 : 0, gridSnapAccuracy, 0, 0, 0);
                int guidesSnapAccuracy = 1;
                if (document.hasAttribute("guidesSnapAccuracy")) {
                    switch (document.getAttribute("guidesSnapAccuracy")) {
                        case "Must be close": {
                            guidesSnapAccuracy = 0;
                            break;
                        }
                        case "Can be distant": {
                            guidesSnapAccuracy = 2;
                        }
                    }
                }
                fg.write(guidesSnapAccuracy, 0, 0, 0, 0, 0);
                fg.writeUI16(gridSpacingY * 20);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                fg.writeBomString("");
                fg.writeBomString("");
                fg.write(0, 0, 0, 0, 0, 0, 0, 0, pixelSnap ? 1 : 0);
                fg.write(0, 0, 0);
                this.writeAccessibleData(fg, document, true);
                fg.write(0, 0, 0, 0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                fg.write(snapAlign ? 1 : 0, snapAlignVerticalCenter ? 1 : 0, snapAlignHorizontalCenter ? 1 : 0, 0);
                fg.writeUI32(snapAlignHorizontalSpacing);
                fg.writeUI32(snapAlignVerticalSpacing);
                fg.writeUI32(snapAlignBorderSpacing);
                fg.write(1, 0, 1, 0, 0, 0, this.debugRandom ? 85 : 0, 0, 0, 0, 1, 0, 0, 0, 255, 255, 255, 255);
                fg.writeBomString("");
                fg.write(1, 0, 0, 0);
                fg.writeBomString("");
                fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                    String string;
                    String majorStr;
                    if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                        String creatorInfo = "";
                        if (document.hasAttribute("creatorInfo")) {
                            creatorInfo = document.getAttribute("creatorInfo");
                        }
                        if (this.debugRandom) {
                            fg.writeBomString("YYY");
                        } else {
                            fg.writeBomString(this.getXmpp(creatorInfo));
                        }
                    } else {
                        fg.writeBomString("");
                    }
                    fg.writeBomString("");
                    fg.write(0, 0, 0, 0, 0, 0, 0, 0);
                    fg.write(255, 255, 255, 255, 255, 255, 255, 255);
                    fg.write(0, 0, 0, 0, 0);
                    int majorVersion = 0;
                    if (document.hasAttribute("majorVersion") && (majorStr = document.getAttribute("majorVersion")).matches("^[0-9]+$")) {
                        majorVersion = Integer.parseInt(majorStr);
                    }
                    fg.write(this.debugRandom ? 88 : majorVersion);
                    fg.write(0, 0, 0);
                    int buildNumber = 0;
                    if (document.hasAttribute("buildNumber") && (string = document.getAttribute("buildNumber")).matches("^[0-9]+$")) {
                        buildNumber = Integer.parseInt(string);
                    }
                    if (this.debugRandom) {
                        fg.write(88, 88);
                    } else {
                        fg.writeUI16(buildNumber);
                    }
                    fg.write(0, 0);
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                        fg.write(67);
                    } else {
                        fg.write(66);
                    }
                    fg.write(0);
                    String string2 = "";
                    if (document.hasAttribute("versionInfo")) {
                        String string3 = document.getAttribute("versionInfo");
                    }
                    if (this.debugRandom) {
                        fg.write(78, 78, 78);
                    } else {
                        void var50_76;
                        fg.write(var50_76.getBytes());
                        String string4 = " timecount = " + this.getTimeCreatedAsString();
                        fg.write(string4.getBytes());
                    }
                    fg.write(0);
                    if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                        if (this.debugRandom) {
                            fg.write(85, 85, 85, 85, 85, 85, 85, 85);
                        } else {
                            fg.write(0, 0, 0, 0, 0, 128, 75, 64);
                        }
                        fg.write(124, 21, 0, 0, 160, 15, 0, 0, 1);
                        fg.write(0, 0, 0);
                    }
                }
            }
        }
    }

    private String generateItemID(Reference<Long> generatedItemIdOrder) {
        if (this.debugRandom) {
            return "XXXXXXXX-XXXXXXXX";
        }
        String itemID = String.format("%1$08x-%2$08x", this.timeCreated, generatedItemIdOrder.getVal());
        generatedItemIdOrder.setVal(generatedItemIdOrder.getVal() + 1L);
        return itemID;
    }

    protected void writeDomSoundItem(FlaWriter dw, Element domSoundItem, Map<String, Integer> definedClasses, Reference<Integer> objectsCount, int mediaCount, Reference<Long> generatedItemIdOrder, OutputStorageInterface outputDir, InputStorageInterface sourceDir) throws IOException {
        String name;
        this.useClass("CMediaSound", 1, dw, definedClasses, objectsCount);
        dw.write(this.flaFormatVersion.getMediaSoundVersion());
        String mediaFile = "M " + mediaCount + " " + this.getTimeCreatedAsString();
        dw.writeString(this.debugRandom ? "YYY" : mediaFile);
        String fullName = "";
        if (domSoundItem.hasAttribute("name")) {
            fullName = domSoundItem.getAttribute("name");
        }
        if ((name = fullName).contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        String parentFolderItemID = this.getParentFolderItemID(domSoundItem.getOwnerDocument().getDocumentElement(), fullName);
        dw.writeBomString(name);
        String importFilePath = "";
        if (this.debugRandom) {
            dw.write(88, 88);
        } else {
            dw.writeUI16(mediaCount);
        }
        dw.writeBomString(this.debugRandom ? "YYY" : importFilePath);
        this.writeTimeCreated(dw);
        dw.write(this.flaFormatVersion.getMediaSoundVersionC(), 0, 0, 0, 1, 0, 0, 0);
        if (parentFolderItemID == null) {
            dw.write(0, 0, 0, 0, 0, 0, 0, 0);
        } else {
            dw.writeItemID(parentFolderItemID);
        }
        dw.write(1, 0, 0, 0);
        String itemID = this.generateItemID(generatedItemIdOrder);
        if (domSoundItem.hasAttribute("itemID")) {
            itemID = domSoundItem.getAttribute("itemID");
        }
        dw.writeItemID(itemID);
        String format = "";
        if (domSoundItem.hasAttribute("format")) {
            format = domSoundItem.getAttribute("format");
        }
        String[] fparts = format.split(" ", -1);
        boolean stereo = true;
        boolean is16bit = true;
        int samplingRate = 3;
        if (fparts.length == 3) {
            if ("Mono".equals(fparts[2])) {
                stereo = false;
            }
            if ("8bit".equals(fparts[1])) {
                is16bit = false;
            }
            switch (fparts[0]) {
                case "44kHz": {
                    samplingRate = 3;
                    break;
                }
                case "22kHz": {
                    samplingRate = 2;
                    break;
                }
                case "11kHz": {
                    samplingRate = 1;
                    break;
                }
                case "5kHz": {
                    samplingRate = 0;
                }
            }
        }
        int formatAsNum = (samplingRate << 2) + (is16bit ? 2 : 0) + (stereo ? 1 : 0);
        long sampleCount = 0L;
        if (domSoundItem.hasAttribute("sampleCount")) {
            sampleCount = Long.parseLong(domSoundItem.getAttribute("sampleCount"));
        }
        int exportFormat = -1;
        if (domSoundItem.hasAttribute("exportFormat")) {
            exportFormat = Integer.parseInt(domSoundItem.getAttribute("exportFormat"));
        }
        int exportBits = -1;
        if (domSoundItem.hasAttribute("exportBits")) {
            exportBits = Integer.parseInt(domSoundItem.getAttribute("exportBits"));
        }
        this.writeAsLinkage(dw, domSoundItem);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.write(0);
        }
        dw.write(1, 0, 0, 0, this.flaFormatVersion.getMediaSoundVersionB(), formatAsNum, 0);
        dw.writeUI32(sampleCount);
        dw.writeUI16(exportFormat);
        dw.writeUI16(exportBits);
        String deviceSoundHRef = "";
        if (domSoundItem.hasAttribute("deviceSoundHRef")) {
            deviceSoundHRef = domSoundItem.getAttribute("deviceSoundHRef");
        }
        dw.write(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.writeBomString(deviceSoundHRef);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            dw.write(0, 0, 0, 0);
        }
        boolean hasBinData = false;
        if (domSoundItem.hasAttribute("soundDataHRef")) {
            String videoDataHRef = domSoundItem.getAttribute("soundDataHRef");
            if (sourceDir.fileExists("bin/" + videoDataHRef)) {
                try (OutputStream fos = outputDir.getOutputStream(mediaFile);
                     InputStream fis = sourceDir.readFile("bin/" + videoDataHRef);){
                    int cnt;
                    byte[] buf = new byte[4096];
                    while ((cnt = fis.read(buf)) > 0) {
                        fos.write(buf, 0, cnt);
                    }
                }
                hasBinData = true;
            }
        }
        if (!hasBinData) {
            Logger.getLogger(FlaConverter.class.getName()).log(Level.WARNING, "Missing bin/*.dat file for {0}", name);
        }
    }

    protected void writeDomVideoItem(FlaWriter dw, Element domVideoItem, Map<String, Integer> definedClasses, Reference<Integer> objectsCount, int mediaCount, Reference<Long> generatedItemIdOrder, OutputStorageInterface outputDir, InputStorageInterface sourceDir) throws IOException {
        String name;
        this.useClass("CMediaVideoStream", 1, dw, definedClasses, objectsCount);
        dw.write(this.flaFormatVersion.getMediaVideoVersion());
        String mediaFile = "M " + mediaCount + " " + this.getTimeCreatedAsString();
        dw.writeString(this.debugRandom ? "YYY" : mediaFile);
        String fullName = "";
        if (domVideoItem.hasAttribute("name")) {
            fullName = domVideoItem.getAttribute("name");
        }
        if ((name = fullName).contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        String parentFolderItemID = this.getParentFolderItemID(domVideoItem.getOwnerDocument().getDocumentElement(), fullName);
        dw.writeBomString(name);
        String importFilePath = "";
        if (this.debugRandom) {
            dw.write(88, 88);
        } else {
            dw.writeUI16(mediaCount);
        }
        dw.writeBomString(this.debugRandom ? "YYY" : importFilePath);
        this.writeTimeCreated(dw);
        dw.write(this.flaFormatVersion.getMediaVideoVersionC(), 0, 0, 0, 1, 0, 0, 0);
        if (parentFolderItemID == null) {
            dw.write(0, 0, 0, 0, 0, 0, 0, 0);
        } else {
            dw.writeItemID(parentFolderItemID);
        }
        dw.write(1, 0, 0, 0);
        String itemID = this.generateItemID(generatedItemIdOrder);
        if (domVideoItem.hasAttribute("itemID")) {
            itemID = domVideoItem.getAttribute("itemID");
        }
        dw.writeItemID(itemID);
        dw.write(0, 0, 0, 0, this.flaFormatVersion.getMediaVideoVersionB(), 0, 0, 0, 0);
        dw.writeBomString("");
        dw.writeBomString("");
        dw.writeBomString("");
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.write(0);
        }
        dw.write(this.flaFormatVersion.getMediaVideoVersionD(), 0, 0, 0);
        dw.writeBomString("");
        dw.writeBomString("");
        dw.write(0, 0, 0, 0, 0, 0, 0, 0);
        dw.write(1, 0, 0, 0, 0, 0, 0, 0);
        dw.write(255, 255, 255, 255);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.write(0);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            dw.writeBomString("");
            dw.write(0);
        }
        dw.write(1, 0, 0, 0);
        boolean hasBinData = false;
        if (domVideoItem.hasAttribute("videoDataHRef")) {
            String videoDataHRef = domVideoItem.getAttribute("videoDataHRef");
            if (sourceDir.fileExists("bin/" + videoDataHRef)) {
                try (OutputStream fos = outputDir.getOutputStream(mediaFile);
                     InputStream fis = sourceDir.readFile("bin/" + videoDataHRef);){
                    int cnt;
                    DataInputStream dais = new DataInputStream(fis);
                    byte[] buf = new byte[49];
                    dais.readFully(buf);
                    fos.write(buf);
                    fis.read();
                    fos.write(0);
                    fis.read();
                    fos.write(0);
                    buf = new byte[4];
                    dais.readFully(buf);
                    fos.write(buf);
                    fis.read();
                    fos.write(0);
                    buf = new byte[4096];
                    while ((cnt = fis.read(buf)) > 0) {
                        fos.write(buf, 0, cnt);
                    }
                }
                hasBinData = true;
            }
        }
        if (!hasBinData) {
            Logger.getLogger(FlaConverter.class.getName()).log(Level.WARNING, "Missing bin/*.dat file for {0}", name);
        }
    }

    protected void writeDomBitmapItem(FlaWriter dw, Element domBitmapItem, Map<String, Integer> definedClasses, Reference<Integer> objectsCount, int mediaCount, Reference<Long> generatedItemIdOrder, OutputStorageInterface outputDir, InputStorageInterface sourceDir) throws IOException {
        String name;
        this.useClass("CMediaBits", 1, dw, definedClasses, objectsCount);
        dw.write(this.flaFormatVersion.getMediaBitsVersion());
        String mediaFile = "M " + mediaCount + " " + this.getTimeCreatedAsString();
        dw.writeString(this.debugRandom ? "YYY" : mediaFile);
        String fullName = "";
        if (domBitmapItem.hasAttribute("name")) {
            fullName = domBitmapItem.getAttribute("name");
        }
        if ((name = fullName).contains("/")) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        String parentFolderItemID = this.getParentFolderItemID(domBitmapItem.getOwnerDocument().getDocumentElement(), fullName);
        String sourceExternalFilepath = domBitmapItem.getAttribute("sourceExternalFilepath");
        dw.writeBomString(name);
        String importFilePath = "";
        if (this.debugRandom) {
            dw.write(88, 88);
        } else {
            dw.writeUI16(mediaCount);
        }
        dw.writeBomString(this.debugRandom ? "YYY" : importFilePath);
        this.writeTimeCreated(dw);
        dw.write(this.flaFormatVersion.getMediaBitsVersionC(), 0, 0, 0, 1, 0, 0, 0);
        if (parentFolderItemID == null) {
            dw.write(0, 0, 0, 0, 0, 0, 0, 0);
        } else {
            dw.writeItemID(parentFolderItemID);
        }
        dw.write(1, 0, 0, 0);
        String itemID = this.generateItemID(generatedItemIdOrder);
        if (domBitmapItem.hasAttribute("itemID")) {
            itemID = domBitmapItem.getAttribute("itemID");
        }
        dw.writeItemID(itemID);
        boolean allowSmoothing = false;
        if (domBitmapItem.hasAttribute("allowSmoothing")) {
            allowSmoothing = "true".equals(domBitmapItem.getAttribute("allowSmoothing"));
        }
        int quality = 80;
        if (domBitmapItem.hasAttribute("quality")) {
            quality = Integer.parseInt(domBitmapItem.getAttribute("quality"));
        }
        boolean useImportedJPEGData = true;
        if (domBitmapItem.hasAttribute("useImportedJPEGData")) {
            useImportedJPEGData = "true".equals(domBitmapItem.getAttribute("useImportedJPEGData"));
        }
        boolean useDeblocking = false;
        if (domBitmapItem.hasAttribute("useDeblocking")) {
            useDeblocking = "true".equals(domBitmapItem.getAttribute("useDeblocking"));
        }
        long externalFileSize = 0L;
        if (domBitmapItem.hasAttribute("externalFileSize")) {
            externalFileSize = Long.parseLong(domBitmapItem.getAttribute("externalFileSize"));
        }
        boolean isJPEG = false;
        if (domBitmapItem.hasAttribute("isJPEG")) {
            isJPEG = "true".equals(domBitmapItem.getAttribute("isJPEG"));
        }
        if (sourceExternalFilepath != null && sourceExternalFilepath.toLowerCase().endsWith(".jpg")) {
            isJPEG = true;
        }
        boolean compressionTypeLossless = false;
        if (domBitmapItem.hasAttribute("compressionType")) {
            compressionTypeLossless = "lossless".equals(domBitmapItem.getAttribute("compressionType"));
        }
        boolean hasBinData = false;
        if (domBitmapItem.hasAttribute("bitmapDataHRef")) {
            String bitmapDataHRef = domBitmapItem.getAttribute("bitmapDataHRef");
            if (sourceDir.fileExists("bin/" + bitmapDataHRef)) {
                try (OutputStream fos = outputDir.getOutputStream(mediaFile);
                     InputStream fis = sourceDir.readFile("bin/" + bitmapDataHRef);){
                    int cnt;
                    byte[] buf = new byte[4096];
                    while ((cnt = fis.read(buf)) > 0) {
                        fos.write(buf, 0, cnt);
                    }
                }
                hasBinData = true;
            }
        }
        if (!hasBinData) {
            Logger.getLogger(FlaConverter.class.getName()).log(Level.WARNING, "Missing bin/*.dat file for {0}", name);
        }
        this.writeAsLinkage(dw, domBitmapItem);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            dw.write(0);
        }
        dw.write(1, 0, 0, 0);
        dw.write(this.flaFormatVersion.getMediaBitsVersionB());
        if (compressionTypeLossless) {
            dw.write(1);
        } else if (useImportedJPEGData) {
            dw.write(0);
        } else {
            dw.write(2);
        }
        dw.write(quality, allowSmoothing ? 1 : 0);
        if (isJPEG) {
            dw.writeUI32(externalFileSize);
        } else {
            dw.writeUI32(0L);
        }
        if (this.flaFormatVersion == FlaFormatVersion.CS4) {
            dw.write(useDeblocking ? 1 : 0);
        }
    }

    protected int writeMedia(FlaWriter dw, Element document, Reference<Long> generatedItemIdOrder, Map<String, Integer> definedClasses, Reference<Integer> objectsCount, OutputStorageInterface outputDir, InputStorageInterface sourceDir) throws IOException {
        List<Element> media = this.getMedia(document);
        int mediaCount = 0;
        for (Element mediaItem : media) {
            ++mediaCount;
            switch (mediaItem.getTagName()) {
                case "DOMBitmapItem": {
                    this.writeDomBitmapItem(dw, mediaItem, definedClasses, objectsCount, mediaCount, generatedItemIdOrder, outputDir, sourceDir);
                    break;
                }
                case "DOMSoundItem": {
                    this.writeDomSoundItem(dw, mediaItem, definedClasses, objectsCount, mediaCount, generatedItemIdOrder, outputDir, sourceDir);
                    break;
                }
                case "DOMVideoItem": {
                    this.writeDomVideoItem(dw, mediaItem, definedClasses, objectsCount, mediaCount, generatedItemIdOrder, outputDir, sourceDir);
                }
            }
        }
        return mediaCount;
    }

    protected int getNextId(Element document) {
        Element fontsElement = this.getSubElementByName(document, "fonts");
        if (fontsElement == null) {
            return 1;
        }
        List<Element> domFontItems = this.getAllSubElementsByName(fontsElement, "DOMFontItem");
        int id = 0;
        for (Element domFontItem : domFontItems) {
            int nid;
            if (!domFontItem.hasAttribute("id") || (nid = Integer.parseInt(domFontItem.getAttribute("id"))) <= id) continue;
            id = nid;
        }
        return id + 1;
    }

    protected int writeFonts(FlaWriter dw, Element document, Reference<Long> generatedItemIdOrder) throws IOException {
        Element fontsElement = this.getSubElementByName(document, "fonts");
        List<Object> domFontItems = new ArrayList();
        if (fontsElement != null) {
            domFontItems = this.getAllSubElementsByName(fontsElement, "DOMFontItem");
        }
        dw.writeUI32(domFontItems.size());
        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.CS3.ordinal()) {
            Collections.reverse(domFontItems);
        }
        int fontCount = 0;
        for (Element element : domFontItems) {
            String name;
            ++fontCount;
            String fullName = "";
            if (element.hasAttribute("name")) {
                fullName = element.getAttribute("name");
            }
            if ((name = fullName).contains("/")) {
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            String parentFolderItemID = this.getParentFolderItemID(element.getOwnerDocument().getDocumentElement(), fullName);
            String fontPsName = element.getAttribute("font");
            int id = Integer.parseInt(element.getAttribute("id"));
            String itemID = this.generateItemID(generatedItemIdOrder);
            if (element.hasAttribute("itemID")) {
                itemID = element.getAttribute("itemID");
            }
            String fontFamily = fontPsName;
            boolean bold = false;
            boolean italic = false;
            if (psNameToFontName.containsKey(fontPsName)) {
                Font font = (Font)psNameToFontName.get(fontPsName);
                fontFamily = font.getFamily(Locale.US);
                String fontNameLowercase = font.getFontName(Locale.US).toLowerCase();
                bold = fontNameLowercase.contains("bold");
                italic = fontNameLowercase.contains("italic") || fontNameLowercase.contains("oblique");
            } else if (this.debugRandom) {
                fontFamily = "YYY";
            }
            dw.write(this.flaFormatVersion.getFontVersion());
            dw.writeBomString(name);
            dw.writeUI16(id);
            this.writeTimeCreated(dw);
            dw.write(this.flaFormatVersion.getFontVersionB());
            dw.write(0, 0);
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                dw.writeBomString(fontFamily);
            } else {
                dw.writeString(fontFamily);
            }
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                dw.writeBomString(fontPsName);
                if (this.debugRandom) {
                    dw.write(85, 85, 85, 85);
                } else {
                    dw.write(0, 0, 0, 64);
                }
            }
            if (this.debugRandom) {
                dw.write(85, 85, 85, 85);
            } else {
                dw.write(0, 0, 0, 0);
            }
            dw.write(this.debugRandom ? 85 : 18);
            dw.write(0);
            dw.write(this.debugRandom ? 88 : (bold ? 1 : 0));
            dw.write(this.debugRandom ? 88 : (italic ? 1 : 0));
            dw.write(0, this.debugRandom ? 85 : 0, 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, 0);
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                dw.writeBomString("");
            } else {
                dw.writeString("");
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                dw.write(0);
                dw.write(0);
                dw.write(this.debugRandom ? 85 : 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                    dw.write(0);
                }
                if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                    dw.writeBomString("");
                } else {
                    dw.writeString("");
                }
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                dw.write(2, this.debugRandom ? 85 : 1, 0, 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0, 0, 0, this.debugRandom ? 85 : 0, this.debugRandom ? 85 : 0);
                if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                    dw.writeBomString("");
                } else {
                    dw.writeString("");
                }
            }
            dw.write(this.flaFormatVersion.getFontVersionC(), 0, 0, 0, 1, 0, 0, 0);
            if (parentFolderItemID == null) {
                dw.write(0, 0, 0, 0, 0, 0, 0, 0);
            } else {
                dw.writeItemID(parentFolderItemID);
            }
            dw.write(1, 0, 0, 0);
            dw.writeItemID(itemID);
            this.writeAsLinkage(dw, element);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                dw.write(0);
            }
            if (this.flaFormatVersion != FlaFormatVersion.CS4) continue;
            dw.write(0, 0, 0, 0);
        }
        return fontCount;
    }

    protected void writeQTAudioSettings(FlaWriter dw) throws IOException {
        dw.write(255, 255, 1, 0);
        String CQTAudioSettings = "CQTAudioSettings";
        dw.write(CQTAudioSettings.length(), 0);
        dw.write(CQTAudioSettings.getBytes());
        dw.write(0, 0, 0, 0);
    }

    protected void writeColorDef(Element document, FlaWriter dw, FlaFormatVersion flaFormatVersion, Map<String, Integer> definedClasses, Reference<Integer> objectsCount) throws IOException {
        Element extendedSwatchListsElement;
        ArrayList<SolidSwatchItem> solidSwatches = new ArrayList<SolidSwatchItem>();
        ArrayList<ExtendedSwatchItem> extendedSwatches = new ArrayList<ExtendedSwatchItem>();
        Element swatchListsElement = this.getSubElementByName(document, "swatchLists");
        if (swatchListsElement != null) {
            List<Element> swatchLists = this.getAllSubElementsByName(swatchListsElement, "swatchList");
            for (Element element : swatchLists) {
                Element swatchesElement = this.getSubElementByName(element, "swatches");
                if (swatchesElement == null) continue;
                List<Element> solidSwatchItems = this.getAllSubElementsByName(swatchesElement, "SolidSwatchItem");
                for (Element solidSwatchItem : solidSwatchItems) {
                    String brightnessStr;
                    String saturationStr;
                    Color color = this.parseColorWithAlpha(solidSwatchItem);
                    String hueStr = solidSwatchItem.getAttribute("hue");
                    if (hueStr.equals("")) {
                        hueStr = "0";
                    }
                    if ((saturationStr = solidSwatchItem.getAttribute("saturation")).equals("")) {
                        saturationStr = "0";
                    }
                    if ((brightnessStr = solidSwatchItem.getAttribute("brightness")).equals("")) {
                        brightnessStr = "0";
                    }
                    int hue = Integer.parseInt(hueStr);
                    int saturation = Integer.parseInt(saturationStr);
                    int brightness = Integer.parseInt(brightnessStr);
                    solidSwatches.add(new SolidSwatchItem(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), hue, saturation, brightness));
                }
            }
        }
        if ((extendedSwatchListsElement = this.getSubElementByName(document, "extendedSwatchLists")) != null) {
            List<Element> swatchLists = this.getAllSubElementsByName(extendedSwatchListsElement, "swatchList");
            for (Element swatchListElement : swatchLists) {
                Element swatchesElement = this.getSubElementByName(swatchListElement, "swatches");
                if (swatchesElement == null) continue;
                List<Element> swatches = this.getAllSubElements(swatchesElement);
                for (Element swatch : swatches) {
                    ArrayList<GradientEntry> gradientEntries = new ArrayList<GradientEntry>();
                    switch (swatch.getNodeName()) {
                        case "LinearGradientSwatchItem": 
                        case "RadialGradientSwatchItem": {
                            List<Element> gradientEntryElements = this.getAllSubElementsByName(swatch, "GradientEntry");
                            for (Element gradientEntry : gradientEntryElements) {
                                Color gradColor = this.parseColorWithAlpha(gradientEntry);
                                float ratio = 0.0f;
                                if (gradientEntry.hasAttribute("ratio")) {
                                    ratio = Float.parseFloat(gradientEntry.getAttribute("ratio"));
                                }
                                gradientEntries.add(new GradientEntry(gradColor, ratio));
                            }
                            break;
                        }
                    }
                    boolean linearRGB = swatch.getAttribute("interpolationMethod").equals("linearRGB");
                    int spreadMethod = 0;
                    switch (swatch.getAttribute("spreadMethod")) {
                        case "reflect": {
                            spreadMethod = 4;
                            break;
                        }
                        case "repeat": {
                            spreadMethod = 8;
                        }
                    }
                    switch (swatch.getNodeName()) {
                        case "LinearGradientSwatchItem": {
                            extendedSwatches.add(new LinearGradientSwatchItem(gradientEntries, spreadMethod, linearRGB));
                            break;
                        }
                        case "RadialGradientSwatchItem": {
                            extendedSwatches.add(new RadialGradientSwatchItem(gradientEntries, spreadMethod, linearRGB));
                        }
                    }
                }
            }
        }
        if (solidSwatches.isEmpty() && extendedSwatches.isEmpty()) {
            solidSwatches.addAll(this.defaultSolidSwatches);
            extendedSwatches.addAll(this.defaultExtendedSwatches);
        }
        dw.writeUI16(solidSwatches.size());
        for (int s = 0; s < solidSwatches.size(); ++s) {
            this.useClass("CColorDef", 0, dw, definedClasses, objectsCount);
            dw.write(flaFormatVersion.getColorDefVersion());
            SolidSwatchItem solidSwatchItem = (SolidSwatchItem)solidSwatches.get(s);
            dw.write(solidSwatchItem.red, solidSwatchItem.green, solidSwatchItem.blue, solidSwatchItem.alpha, 0, 0, solidSwatchItem.hue, 0, solidSwatchItem.saturation, 0, solidSwatchItem.brightness, 0);
        }
        if (flaFormatVersion == FlaFormatVersion.CS4) {
            dw.write(1);
        }
        dw.write(0);
        dw.writeUI16(extendedSwatches.size());
        for (int x = 0; x < extendedSwatches.size(); ++x) {
            ExtendedSwatchItem extendedSwatchItem = (ExtendedSwatchItem)extendedSwatches.get(x);
            this.useClass("CColorDef", 0, dw, definedClasses, objectsCount);
            dw.write(flaFormatVersion.getColorDefVersion());
            if (this.debugRandom) {
                dw.write(85, 85, 85);
            } else {
                dw.write(0, 0, 0);
            }
            dw.write(255, extendedSwatchItem.getType(), 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, extendedSwatchItem.entries.size());
            if (flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                dw.write(0, 0, 0, 0, extendedSwatchItem.spreadMethod + (extendedSwatchItem.interpolationMethodLinearRGB ? 1 : 0), 0, 0, 0);
            }
            for (GradientEntry en : extendedSwatchItem.entries) {
                int r = Math.round(en.ratio * 255.0f);
                dw.write(r, en.color.getRed(), en.color.getGreen(), en.color.getBlue(), en.color.getAlpha());
            }
            dw.write(0, 0);
            if (this.debugRandom) {
                dw.write(85, 85, 85, 85);
                continue;
            }
            dw.write(0, 0, 0, 0);
        }
        if (flaFormatVersion == FlaFormatVersion.CS4) {
            dw.write(1);
        }
        dw.write(0, 3, 0, 0, 0);
        if (this.debugRandom) {
            dw.write(85, 0, 0, 0, 85, 85, 0, 0, 85, 85, 0, 0, 85, 85, 0, 0, 85, 85, 0, 0, 1, 0, 0, 0, 85);
        } else {
            dw.write(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1);
        }
        dw.write(0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0);
    }

    protected void writeMap(FlaWriter dw, Map<String, String> map) throws IOException {
        if (this.debugRandom) {
            // empty if block
        }
        dw.writeUI16(map.size());
        for (String key : map.keySet()) {
            String val = map.get(key);
            dw.writeBomString(key);
            dw.writeBomString(val);
        }
    }

    private Map<String, String> getLegacyProperties() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("legacyLineSpacing", "0");
        return propertiesMap;
    }

    private Map<String, String> getProperties(String basePublishName, int width, int height, FlaFormatVersion flaFormatVersion) {
        switch (flaFormatVersion) {
            case CS4: {
                return this.getPropertiesCs4(basePublishName, width, height);
            }
            case CS3: {
                return this.getPropertiesCs3(basePublishName, width, height);
            }
            case F8: {
                return this.getPropertiesF8(basePublishName, width, height);
            }
            case MX2004: {
                return this.getPropertiesMx2004(basePublishName, width, height);
            }
            case MX: {
                return this.getPropertiesMx(basePublishName, width, height);
            }
            case F5: {
                return this.getPropertiesF5(basePublishName, width, height);
            }
        }
        return null;
    }

    private Map<String, String> getPropertiesF5(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("Vector::External Player", "");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("Vector::Compress Movie", "0");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", basePublishName + "_alternate.html");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", basePublishName + "_content.html");
        propertiesMap.put("legacyLineSpacing", "0");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::Version", "5");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishJpegProperties::Height", "" + height);
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::ActionScriptVersion", "2");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        return propertiesMap;
    }

    private Map<String, String> getPropertiesMx(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("Vector::External Player", "");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("Vector::Compress Movie", "1");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", basePublishName + "_content.html");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", basePublishName + "_alternate.html");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Version", "6");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("legacyLineSpacing", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("Vector::ActionScriptVersion", "2");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("PublishJpegProperties::Height", "" + height);
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        return propertiesMap;
    }

    private Map<String, String> getPropertiesMx2004(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("Vector::External Player", "");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("Vector::Compress Movie", "1");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", basePublishName + "_content.html");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", basePublishName + "_alternate.html");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Version", "7");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("Vector::ActionScriptVersion", "2");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("PublishJpegProperties::Height", "" + height);
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        return propertiesMap;
    }

    private Map<String, String> getPropertiesF8(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("Vector::External Player", "");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("Vector::Compress Movie", "1");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", basePublishName + "_alternate.html");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", basePublishName + "_content.html");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::Version", "8");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishJpegProperties::Height", "" + height);
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::ActionScriptVersion", "2");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        return propertiesMap;
    }

    private Map<String, String> getPropertiesCs3(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("Vector::External Player", "");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("Vector::Compress Movie", "1");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", basePublishName + "_content.html");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", basePublishName + "_alternate.html");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Version", "9");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("Vector::ActionScriptVersion", "3");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("PublishJpegProperties::Height", "400");
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        return propertiesMap;
    }

    private Map<String, String> getPropertiesCs4(String basePublishName, int width, int height) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        propertiesMap.put("PublishGifProperties::PaletteName", "");
        propertiesMap.put("PublishRNWKProperties::speed256K", "0");
        propertiesMap.put("Vector::AS3 Package Paths", ".");
        propertiesMap.put("PublishHtmlProperties::StartPaused", "0");
        propertiesMap.put("PublishFormatProperties::htmlFileName", basePublishName + ".html");
        propertiesMap.put("Vector::AS3 Library Paths", "$(AppConfig)/ActionScript 3.0/libs");
        propertiesMap.put("PublishQTProperties::LayerOption", "");
        propertiesMap.put("PublishQTProperties::AlphaOption", "");
        propertiesMap.put("PublishQTProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::RSLPreloaderMethod", "0");
        propertiesMap.put("Vector::UseNetwork", "0");
        propertiesMap.put("Vector::Debugging Permitted", "0");
        propertiesMap.put("PublishProfileProperties::name", "Default");
        propertiesMap.put("PublishHtmlProperties::Loop", "1");
        propertiesMap.put("PublishFormatProperties::jpeg", "0");
        propertiesMap.put("PublishQTProperties::Width", "" + width);
        propertiesMap.put("PublishPNGProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::speedSingleISDN", "0");
        propertiesMap.put("PublishRNWKProperties::singleRateAudio", "0");
        propertiesMap.put("Vector::DocumentClass", "");
        propertiesMap.put("Vector::External Player", "FlashPlayer10");
        propertiesMap.put("PublishHtmlProperties::showTagWarnMsg", "1");
        propertiesMap.put("PublishHtmlProperties::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::Units", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultAlternateFilename", "1");
        propertiesMap.put("PublishGifProperties::Smooth", "1");
        propertiesMap.put("PublishRNWKProperties::mediaCopyright", "(c) 2000");
        propertiesMap.put("PublishRNWKProperties::flashBitRate", "1200");
        propertiesMap.put("Vector::ScriptStuckDelay", "15");
        propertiesMap.put("Vector::Compress Movie", "1");
        propertiesMap.put("Vector::Package Paths", "");
        propertiesMap.put("PublishFormatProperties::flashFileName", basePublishName + ".swf");
        propertiesMap.put("PublishFormatProperties::gifDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMac", "0");
        propertiesMap.put("PublishGifProperties::DitherOption", "");
        propertiesMap.put("PublishRNWKProperties::exportSMIL", "1");
        propertiesMap.put("PublishRNWKProperties::speed384K", "0");
        propertiesMap.put("PublishRNWKProperties::exportAudio", "1");
        propertiesMap.put("Vector::AS3ExportFrame", "1");
        propertiesMap.put("Vector::Invisible Layer", "1");
        propertiesMap.put("PublishHtmlProperties::Quality", "4");
        propertiesMap.put("PublishHtmlProperties::VerticalAlignment", "1");
        propertiesMap.put("PublishFormatProperties::pngFileName", basePublishName + ".png");
        propertiesMap.put("PublishFormatProperties::html", "1");
        propertiesMap.put("PublishPNGProperties::FilterOption", "");
        propertiesMap.put("PublishRNWKProperties::mediaDescription", "");
        propertiesMap.put("Vector::Override Sounds", "0");
        propertiesMap.put("PublishHtmlProperties::DeviceFont", "0");
        propertiesMap.put("PublishQTProperties::Flatten", "1");
        propertiesMap.put("PublishPNGProperties::BitDepth", "24-bit with Alpha");
        propertiesMap.put("PublishPNGProperties::Smooth", "1");
        propertiesMap.put("PublishGifProperties::DitherSolids", "0");
        propertiesMap.put("PublishGifProperties::Interlace", "0");
        propertiesMap.put("PublishJpegProperties::DPI", "4718592");
        propertiesMap.put("Vector::Quality", "80");
        propertiesMap.put("Vector::Protect", "0");
        propertiesMap.put("PublishHtmlProperties::DisplayMenu", "1");
        propertiesMap.put("PublishHtmlProperties::HorizontalAlignment", "1");
        propertiesMap.put("PublishHtmlProperties::VersionDetectionIfAvailable", "0");
        propertiesMap.put("PublishFormatProperties::rnwkDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::jpegDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::gif", "0");
        propertiesMap.put("PublishGifProperties::Loop", "1");
        propertiesMap.put("PublishGifProperties::Width", "" + width);
        propertiesMap.put("PublishRNWKProperties::mediaKeywords", "");
        propertiesMap.put("PublishRNWKProperties::mediaTitle", "");
        propertiesMap.put("PublishRNWKProperties::speed28K", "1");
        propertiesMap.put("Vector::AS3Flags", "4102");
        propertiesMap.put("PublishFormatProperties::qtFileName", basePublishName + ".mov");
        propertiesMap.put("PublishPNGProperties::DitherOption", "");
        propertiesMap.put("PublishGifProperties::PaletteOption", "");
        propertiesMap.put("PublishGifProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishRNWKProperties::speedDualISDN", "0");
        propertiesMap.put("PublishRNWKProperties::realVideoRate", "100000");
        propertiesMap.put("PublishJpegProperties::Quality", "80");
        propertiesMap.put("Vector::IncludeXMP", "1");
        propertiesMap.put("PublishFormatProperties::flash", "1");
        propertiesMap.put("PublishPNGProperties::PaletteOption", "");
        propertiesMap.put("PublishPNGProperties::MatchMovieDim", "1");
        propertiesMap.put("PublishJpegProperties::MatchMovieDim", "1");
        propertiesMap.put("Vector::Package Export Frame", "1");
        propertiesMap.put("PublishProfileProperties::version", "1");
        propertiesMap.put("PublishHtmlProperties::Align", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinFileName", basePublishName + ".exe");
        propertiesMap.put("PublishFormatProperties::pngDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PlayEveryFrame", "0");
        propertiesMap.put("PublishPNGProperties::DitherSolids", "0");
        propertiesMap.put("PublishJpegProperties::Progressive", "0");
        propertiesMap.put("Vector::Export Swc", "0");
        propertiesMap.put("Vector::Debugging Password", "");
        propertiesMap.put("Vector::Omit Trace Actions", "0");
        propertiesMap.put("PublishHtmlProperties::Height", "" + height);
        propertiesMap.put("PublishHtmlProperties::Width", "" + width);
        propertiesMap.put("PublishFormatProperties::jpegFileName", basePublishName + ".jpg");
        propertiesMap.put("PublishFormatProperties::flashDefaultName", "1");
        propertiesMap.put("PublishPNGProperties::Interlace", "0");
        propertiesMap.put("PublishGifProperties::Height", "" + height);
        propertiesMap.put("PublishJpegProperties::Size", "0");
        propertiesMap.put("Vector::DefaultLibraryLinkage", "0");
        propertiesMap.put("Vector::UseAS3Namespace", "1");
        propertiesMap.put("Vector::AS3AutoDeclare", "4096");
        propertiesMap.put("Vector::AS3Coach", "4");
        propertiesMap.put("Vector::DeviceSound", "0");
        propertiesMap.put("PublishHtmlProperties::TemplateFileName", "Default.html");
        propertiesMap.put("PublishHtmlProperties::WindowMode", "0");
        propertiesMap.put("PublishHtmlProperties::UsingDefaultContentFilename", "1");
        propertiesMap.put("PublishFormatProperties::projectorMacFileName", basePublishName + ".app");
        propertiesMap.put("PublishFormatProperties::htmlDefaultName", "1");
        propertiesMap.put("PublishFormatProperties::rnwk", "0");
        propertiesMap.put("PublishFormatProperties::png", "0");
        propertiesMap.put("PublishQTProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::RemoveGradients", "0");
        propertiesMap.put("PublishGifProperties::MaxColors", "255");
        propertiesMap.put("PublishGifProperties::TransparentOption", "");
        propertiesMap.put("PublishGifProperties::LoopCount", "");
        propertiesMap.put("PublishRNWKProperties::speed56K", "1");
        propertiesMap.put("Vector::Report", "0");
        propertiesMap.put("PublishHtmlProperties::OwnAlternateFilename", "");
        propertiesMap.put("PublishHtmlProperties::AlternateFilename", "");
        propertiesMap.put("PublishHtmlProperties::ContentFilename", "");
        propertiesMap.put("Vector::AS3 External Library Paths", "$(AppConfig)/ActionScript 3.0/libs/11.0/textLayout.swc");
        propertiesMap.put("PublishGifProperties::OptimizeColors", "1");
        propertiesMap.put("PublishRNWKProperties::audioFormat", "0");
        propertiesMap.put("Vector::RSLPreloaderSWF", "$(AppConfig)/ActionScript 3.0/rsls/loader_animation.swf");
        propertiesMap.put("Vector::HardwareAcceleration", "0");
        propertiesMap.put("Vector::AS3Strict", "2");
        propertiesMap.put("Vector::Version", "10");
        propertiesMap.put("Vector::Event Format", "0");
        propertiesMap.put("Vector::Stream Compress", "7");
        propertiesMap.put("PublishFormatProperties::qt", "0");
        propertiesMap.put("PublishPNGProperties::Height", "" + height);
        propertiesMap.put("PublishPNGProperties::Width", "" + width);
        propertiesMap.put("PublishGifProperties::RemoveGradients", "0");
        propertiesMap.put("PublishRNWKProperties::speed512K", "0");
        propertiesMap.put("PublishJpegProperties::Height", "" + height);
        propertiesMap.put("Vector::EventUse8kSampleRate", "0");
        propertiesMap.put("Vector::StreamUse8kSampleRate", "0");
        propertiesMap.put("Vector::ActionScriptVersion", "3");
        propertiesMap.put("Vector::Event Compress", "7");
        propertiesMap.put("PublishHtmlProperties::Scale", "0");
        propertiesMap.put("PublishFormatProperties::projectorWinDefaultName", "1");
        propertiesMap.put("PublishQTProperties::Looping", "0");
        propertiesMap.put("PublishQTProperties::UseQTSoundCompression", "0");
        propertiesMap.put("PublishPNGProperties::PaletteName", "");
        propertiesMap.put("PublishPNGProperties::Transparent", "0");
        propertiesMap.put("PublishGifProperties::TransparentAlpha", "128");
        propertiesMap.put("PublishGifProperties::Animated", "0");
        propertiesMap.put("PublishRNWKProperties::mediaAuthor", "");
        propertiesMap.put("PublishRNWKProperties::speedCorporateLAN", "0");
        propertiesMap.put("PublishRNWKProperties::showBitrateDlog", "1");
        propertiesMap.put("PublishRNWKProperties::exportFlash", "1");
        propertiesMap.put("PublishJpegProperties::Width", "" + width);
        propertiesMap.put("Vector::Stream Format", "0");
        propertiesMap.put("Vector::DeblockingFilter", "0");
        propertiesMap.put("PublishHtmlProperties::VersionInfo", "10,1,52,0;9,0,124,0;8,0,24,0;7,0,14,0;6,0,79,0;5,0,58,0;4,0,32,0;3,0,8,0;2,0,1,12;1,0,0,1;");
        propertiesMap.put("PublishFormatProperties::gifFileName", basePublishName + ".gif");
        propertiesMap.put("PublishFormatProperties::qtDefaultName", "1");
        propertiesMap.put("PublishQTProperties::PausedAtStart", "0");
        propertiesMap.put("PublishQTProperties::ControllerOption", "0");
        propertiesMap.put("PublishPNGProperties::MaxColors", "255");
        propertiesMap.put("Vector::AS3 Config Const", "CONFIG::FLASH_AUTHORING=\"true\";");
        propertiesMap.put("PublishHtmlProperties::UsingOwnAlternateFile", "0");
        propertiesMap.put("PublishFormatProperties::rnwkFileName", basePublishName + ".smil");
        propertiesMap.put("PublishFormatProperties::projectorWin", "0");
        propertiesMap.put("PublishFormatProperties::defaultNames", "1");
        return propertiesMap;
    }

    private String getXmpp(String creatorInfo) {
        SimpleDateFormat XMPP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        String timeCreatedXmpp = XMPP_DATE_FORMAT.format(new Date(this.timeCreatedMs));
        if (this.debugRandom) {
            String timNotRandom = "";
            for (int i = 0; i < timeCreatedXmpp.length(); ++i) {
                timNotRandom = timNotRandom + 'X';
            }
            timeCreatedXmpp = timNotRandom;
        }
        String xmppDocumentId = this.generateGUID();
        String xmppOriginalDocumentId = this.generateGUID();
        String xmppId = this.generateXmppId();
        String xmppInstanceId = this.generateGUID();
        return "<?xpacket begin=\"\ufeff\" id=\"" + xmppId + "\"?>\n<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 5.0-c060 61.134777, 2010/02/12-17:32:00        \">\n   <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n      <rdf:Description rdf:about=\"\"\n            xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n         <xmp:CreatorTool>" + creatorInfo + "</xmp:CreatorTool>\n         <xmp:CreateDate>" + timeCreatedXmpp + "</xmp:CreateDate>\n         <xmp:MetadataDate>" + timeCreatedXmpp + "</xmp:MetadataDate>\n         <xmp:ModifyDate>" + timeCreatedXmpp + "</xmp:ModifyDate>\n      </rdf:Description>\n      <rdf:Description rdf:about=\"\"\n            xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n         <dc:format>application/vnd.adobe.fla</dc:format>\n      </rdf:Description>\n      <rdf:Description rdf:about=\"\"\n            xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\"\n            xmlns:stRef=\"http://ns.adobe.com/xap/1.0/sType/ResourceRef#\"\n            xmlns:stEvt=\"http://ns.adobe.com/xap/1.0/sType/ResourceEvent#\">\n         <xmpMM:DerivedFrom rdf:parseType=\"Resource\">\n            <stRef:instanceID>xmp.iid:" + xmppInstanceId + "</stRef:instanceID>\n            <stRef:documentID>xmp.did:" + xmppOriginalDocumentId + "</stRef:documentID>\n            <stRef:originalDocumentID>xmp.did:" + xmppOriginalDocumentId + "</stRef:originalDocumentID>\n         </xmpMM:DerivedFrom>\n         <xmpMM:DocumentID>xmp.did:" + xmppDocumentId + "</xmpMM:DocumentID>\n         <xmpMM:InstanceID>xmp.iid:" + xmppDocumentId + "</xmpMM:InstanceID>\n         <xmpMM:OriginalDocumentID>xmp.did:" + xmppOriginalDocumentId + "</xmpMM:OriginalDocumentID>\n         <xmpMM:History>\n            <rdf:Seq>\n               <rdf:li rdf:parseType=\"Resource\">\n                  <stEvt:action>created</stEvt:action>\n                  <stEvt:instanceID>xmp.iid:" + xmppOriginalDocumentId + "</stEvt:instanceID>\n                  <stEvt:when>" + timeCreatedXmpp + "</stEvt:when>\n                  <stEvt:softwareAgent>" + creatorInfo + "</stEvt:softwareAgent>\n               </rdf:li>\n               <rdf:li rdf:parseType=\"Resource\">\n                  <stEvt:action>created</stEvt:action>\n                  <stEvt:instanceID>xmp.iid:" + xmppInstanceId + "</stEvt:instanceID>\n                  <stEvt:when>" + timeCreatedXmpp + "</stEvt:when>\n                  <stEvt:softwareAgent>" + creatorInfo + "</stEvt:softwareAgent>\n               </rdf:li>\n               <rdf:li rdf:parseType=\"Resource\">\n                  <stEvt:action>created</stEvt:action>\n                  <stEvt:instanceID>xmp.iid:" + xmppDocumentId + "</stEvt:instanceID>\n                  <stEvt:when>" + timeCreatedXmpp + "</stEvt:when>\n                  <stEvt:softwareAgent>" + creatorInfo + "</stEvt:softwareAgent>\n               </rdf:li>\n            </rdf:Seq>\n         </xmpMM:History>\n      </rdf:Description>\n   </rdf:RDF>\n</x:xmpmeta>\n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                                                                                                    \n                           \n<?xpacket end=\"w\"?>";
    }
}

