/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.coloreffects;

import com.jpexs.flash.fla.converter.coloreffects.ColorEffectInterface;
import java.awt.Color;

public class BrightnessColorEffect
implements ColorEffectInterface {
    private final double brightness;

    public BrightnessColorEffect(double brightness) {
        this.brightness = brightness;
    }

    public int getMultiplier() {
        return (int)Math.round((1.0 - Math.abs(this.brightness)) * 256.0);
    }

    @Override
    public int getRedMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getGreenMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getBlueMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getAlphaMultiplier() {
        return 256;
    }

    public int getOffset() {
        int offset = 0;
        if (this.brightness > 0.0) {
            offset = (int)Math.round(this.brightness * 255.0);
        }
        return offset;
    }

    @Override
    public int getRedOffset() {
        return this.getOffset();
    }

    @Override
    public int getGreenOffset() {
        return this.getOffset();
    }

    @Override
    public int getBlueOffset() {
        return this.getOffset();
    }

    @Override
    public int getAlphaOffset() {
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getValuePercent() {
        return (int)Math.round(this.brightness * 100.0);
    }

    @Override
    public Color getValueColor() {
        return new Color(0, 0, 0);
    }
}

