/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.filters;

import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.GradientEntry;
import com.jpexs.flash.fla.converter.filters.FilterInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GradientBevelFilter
implements FilterInterface {
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private float angle = 45.0f;
    private float distance = 5.0f;
    private boolean knockout = false;
    private int type = 2;
    private List<GradientEntry> gradientEntries = new ArrayList<GradientEntry>();
    private boolean enabled = true;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_OUTER = 2;
    public static final int TYPE_FULL = 3;

    public GradientBevelFilter(float blurX, float blurY, float strength, int quality, float angle, float distance, boolean knockout, int type, List<GradientEntry> gradientEntries, boolean enabled) {
        this.blurX = blurX;
        this.blurY = blurY;
        this.strength = strength;
        this.quality = quality;
        this.angle = angle;
        this.distance = distance;
        this.knockout = knockout;
        this.type = type;
        this.gradientEntries = gradientEntries;
        this.enabled = enabled;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public float getStrength() {
        return this.strength;
    }

    public int getQuality() {
        return this.quality;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public int getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<GradientEntry> getGradientEntries() {
        return this.gradientEntries;
    }

    @Override
    public void write(FlaWriter os) throws IOException {
        int strengthPercent = Math.round(this.strength * 100.0f);
        os.write(new byte[]{7, 1, 1, 4, 1, (byte)(this.enabled ? 1 : 0), 0, 0, 0, 0, 0, 0, -1});
        os.writeFloat(this.distance);
        os.writeFloat(this.blurX);
        os.writeFloat(this.blurY);
        os.writeFloat((float)((double)this.angle * 3.1415927410125732 / 180.0));
        os.write(new byte[]{(byte)(this.type == 1 ? 1 : 0), 0, 0, 0, (byte)(this.knockout ? 1 : 0), 0, 0, 0, (byte)this.quality, 0, 0, 0, (byte)(strengthPercent & 0xFF), (byte)(strengthPercent >> 8 & 0xFF), 0, 0, 0, 0, 0, 0, (byte)this.gradientEntries.size(), 0, 0, 0, 0, 0, 0, 0, (byte)(this.type == 3 ? 1 : 0), 0, 0, 0});
        for (GradientEntry entry : this.gradientEntries) {
            os.write(Math.round(entry.ratio * 255.0f), 0, 0, 0, entry.color.getRed(), entry.color.getGreen(), entry.color.getBlue(), os.isDebugRandom() ? 88 : entry.color.getAlpha());
        }
    }
}

