/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.streams;

import com.jpexs.flash.fla.converter.streams.OutputStorageInterface;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class CombinedOutputStorage
implements OutputStorageInterface {
    private final OutputStorageInterface[] storages;

    public CombinedOutputStorage(OutputStorageInterface ... storages) {
        this.storages = storages;
    }

    @Override
    public OutputStream getOutputStream(String fileName) throws IOException {
        final ArrayList<OutputStream> oss = new ArrayList<OutputStream>();
        for (OutputStorageInterface storage : this.storages) {
            oss.add(storage.getOutputStream(fileName));
        }
        return new OutputStream(this){
            final /* synthetic */ CombinedOutputStorage this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void write(int b) throws IOException {
                for (OutputStream os : oss) {
                    os.write(b);
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                for (OutputStream os : oss) {
                    os.write(b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (OutputStream os : oss) {
                    os.write(b, off, len);
                }
            }

            @Override
            public void close() throws IOException {
                for (OutputStream os : oss) {
                    os.close();
                }
            }
        };
    }

    @Override
    public void storeData(String fileName, byte[] data) throws IOException {
        for (OutputStorageInterface storage : this.storages) {
            storage.storeData(fileName, data);
        }
    }

    @Override
    public void storeFile(String fileName, File file) throws IOException {
        for (OutputStorageInterface storage : this.storages) {
            storage.storeFile(fileName, file);
        }
    }

    @Override
    public void close() throws Exception {
        for (OutputStorageInterface storage : this.storages) {
            storage.close();
        }
    }
}

