/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.gui;

import com.jpexs.flash.fla.gui.MainMenuFrame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Gui {
    private static GraphicsEnvironment env;
    private static final File UNSPECIFIED_FILE;
    private static File directory;
    private static final String SHORT_APPLICATION_NAME = "FlaComDoc";
    private static final String VENDOR = "JPEXS";
    private static final String CONFIG_NAME = "config.ini";
    private static final Map<String, String> configuration;

    private static OSId getOSId() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0) {
            return OSId.OSX;
        }
        if (OS.indexOf("win") >= 0) {
            return OSId.WINDOWS;
        }
        return OSId.UNIX;
    }

    public static void setWindowIcon(Window w) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(Gui.loadImage("fla16"));
        images.add(Gui.loadImage("fla32"));
        w.setIconImages(images);
    }

    public static BufferedImage loadImage(String name) {
        URL imageURL = Gui.class.getResource("/com/jpexs/flash/fla/gui/graphics/" + name + ".png");
        try {
            return ImageIO.read(imageURL);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void saveConfig() {
        try {
            String configFile = Gui.getConfigFile();
            PrintWriter writer = new PrintWriter(configFile);
            for (String key : configuration.keySet()) {
                writer.println(key + "=" + configuration.get(key));
            }
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadConfig() {
        block8: {
            configuration.clear();
            try {
                String configFilePath = Gui.getConfigFile();
                File configFile = new File(configFilePath);
                if (!configFile.exists()) break block8;
                try (FileInputStream fis = new FileInputStream(configFile);){
                    String s;
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                    while ((s = br.readLine()) != null) {
                        if (s.startsWith(";") || !s.contains("=")) continue;
                        String key = s.substring(0, s.indexOf("="));
                        String value = s.substring(s.indexOf("=") + 1);
                        configuration.put(key, value);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setConfigByKey(String key, String value) {
        configuration.put(key, value);
    }

    public static String getConfigByKey(String key, String defaultValue) {
        if (configuration.containsKey(key)) {
            return configuration.get(key);
        }
        return defaultValue;
    }

    private static String getConfigFile() throws IOException {
        return Gui.getAppHome() + CONFIG_NAME;
    }

    public static String getAppHome() {
        String ret;
        if (directory == UNSPECIFIED_FILE) {
            directory = null;
            String userHome = null;
            try {
                userHome = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (userHome != null) {
                String applicationId = SHORT_APPLICATION_NAME;
                OSId osId = Gui.getOSId();
                if (osId == OSId.WINDOWS) {
                    File appDataDir = null;
                    try {
                        String appDataEV = System.getenv("APPDATA");
                        if (appDataEV != null && appDataEV.length() > 0) {
                            appDataDir = new File(appDataEV);
                        }
                    }
                    catch (SecurityException appDataEV) {
                        // empty catch block
                    }
                    String vendorId = VENDOR;
                    if (appDataDir != null && appDataDir.isDirectory()) {
                        String path = vendorId + "\\" + applicationId + "\\";
                        directory = new File(appDataDir, path);
                    } else {
                        String path = "Application Data\\" + vendorId + "\\" + applicationId + "\\";
                        directory = new File(userHome, path);
                    }
                } else if (osId == OSId.OSX) {
                    String path = "Library/Application Support/" + applicationId + "/";
                    directory = new File(userHome, path);
                } else {
                    String path;
                    File xdgConfigHome = null;
                    File oldConfigDir = new File(userHome, "." + applicationId + "/");
                    try {
                        String xdgConfigHomeEV = System.getenv("XDG_CONFIG_HOME");
                        if (xdgConfigHomeEV != null && xdgConfigHomeEV.length() > 0) {
                            xdgConfigHome = new File(xdgConfigHomeEV);
                        }
                    }
                    catch (SecurityException xdgConfigHomeEV) {
                        // empty catch block
                    }
                    if (xdgConfigHome != null && xdgConfigHome.isDirectory()) {
                        path = applicationId + "/";
                        directory = new File(xdgConfigHome, path);
                    } else if (oldConfigDir.isDirectory()) {
                        directory = oldConfigDir;
                    } else {
                        path = ".config/" + applicationId + "/";
                        directory = new File(userHome, path);
                    }
                }
            } else {
                directory = new File(".");
            }
        }
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            directory = new File(".");
        }
        if (!(ret = directory.getAbsolutePath()).endsWith(File.separator)) {
            ret = ret + File.separator;
        }
        return ret;
    }

    private static GraphicsEnvironment getEnv() {
        if (env == null) {
            env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        return env;
    }

    public static void centerScreen(Window f) {
        GraphicsDevice device = Gui.getEnv().getDefaultScreenDevice();
        int topLeftX = device.getDefaultConfiguration().getBounds().x;
        int topLeftY = device.getDefaultConfiguration().getBounds().y;
        int screenX = device.getDefaultConfiguration().getBounds().width;
        int screenY = device.getDefaultConfiguration().getBounds().height;
        Insets bounds = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
        int windowPosX = ((screenX -= bounds.right) - f.getWidth()) / 2 + topLeftX;
        int windowPosY = ((screenY -= bounds.bottom) - f.getHeight()) / 2 + topLeftY;
        f.setLocation(windowPosX, windowPosY);
    }

    public static void start() {
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("sun.java2d.uiScale", "1.0");
        System.setProperty("sun.java2d.opengl", "false");
        System.setProperty("sun.java2d.uiScale.enabled", "false");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        Gui.loadConfig();
        MainMenuFrame mainMenuFrame = new MainMenuFrame();
        mainMenuFrame.setVisible(true);
    }

    static {
        directory = UNSPECIFIED_FILE = new File("unspecified");
        configuration = new LinkedHashMap<String, String>();
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

