/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.fullscreen.windows;

import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.fullscreen.windows.Win32FullScreenHandler;

public class Win32FullScreenStrategy
implements FullScreenStrategy {
    private final Win32FullScreenHandler handler;
    private boolean isFullScreenMode;

    public Win32FullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.handler = new Win32FullScreenHandler(window);
    }

    @Override
    public final void enterFullScreenMode() {
        if (!this.isFullScreenMode) {
            this.onBeforeEnterFullScreenMode();
            this.handler.setFullScreen(true);
            this.isFullScreenMode = true;
        }
    }

    @Override
    public final void exitFullScreenMode() {
        if (this.isFullScreenMode) {
            this.handler.setFullScreen(false);
            this.isFullScreenMode = false;
            this.onAfterExitFullScreenMode();
        }
    }

    @Override
    public final boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

