/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash.messages.in;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.InDebuggerMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InSwfInfo
extends InDebuggerMessage {
    public static final int ID = 42;
    public List<SwfInfo> swfInfos;

    @Override
    public String toString() {
        return super.toString() + "(swfInfo.count=" + this.swfInfos.size() + ")";
    }

    public InSwfInfo(DebuggerConnection c, byte[] data) {
        super(c, 42, data);
        int count = this.readWord();
        this.swfInfos = new ArrayList<SwfInfo>();
        for (int i = 0; i < count; ++i) {
            SwfInfo s = new SwfInfo();
            s.index = this.readDWord();
            s.id = this.readPtr(c);
            if (s.id != 0L) {
                s.debugComing = this.readByte() != 0;
                s.vmVersion = this.readByte();
                s.rsvd1 = this.readWord();
                s.swfSize = this.readDWord();
                s.swdSize = this.readDWord();
                s.scriptCount = this.readDWord();
                s.offsetCount = this.readDWord();
                s.breakpointCount = this.readDWord();
                s.port = this.readDWord();
                s.path = this.readString();
                s.url = this.readString();
                s.host = this.readString();
                s.local2global = new HashMap<Long, Integer>();
                if (s.swdSize > 0L) {
                    long num = this.readDWord();
                    int j = 0;
                    while ((long)j < num && this.available() >= c.sizeOfPtr) {
                        long local = this.readPtr(c);
                        int global = (int)this.readDWord();
                        s.local2global.put(local, global);
                        ++j;
                    }
                }
            }
            this.swfInfos.add(s);
        }
    }

    public static class SwfInfo {
        public long index;
        public long id;
        public boolean debugComing;
        public int vmVersion;
        public int rsvd1;
        public long swfSize;
        public long swdSize;
        public long scriptCount;
        public long offsetCount;
        public long breakpointCount;
        public long port;
        public String path;
        public String url;
        public String host;
        public Map<Long, Integer> local2global = new HashMap<Long, Integer>();

        public String toString() {
            return "SwfInfo(index=" + this.index + ", id=" + this.id + ", vmVersion=" + this.vmVersion + ", swfSize=" + this.swfSize + ", swdSize=" + this.swdSize + ", scriptCount=" + this.scriptCount + ", path=" + this.path + ", url=" + this.url + ", host=" + this.host + ")";
        }
    }
}

