/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.bitmap.CompositeBitmapGlyph;
import com.google.typography.font.sfntly.table.bitmap.SimpleBitmapGlyph;

public abstract class BitmapGlyph
extends SubTable {
    private int format;

    public static BitmapGlyph createGlyph(ReadableFontData readableFontData, int n) {
        BitmapGlyph bitmapGlyph = null;
        Builder<BitmapGlyph> builder = Builder.createGlyphBuilder(readableFontData, n);
        if (builder != null) {
            bitmapGlyph = (BitmapGlyph)builder.build();
        }
        return bitmapGlyph;
    }

    protected BitmapGlyph(ReadableFontData readableFontData, int n) {
        super(readableFontData);
        this.format = n;
    }

    protected BitmapGlyph(ReadableFontData readableFontData, int n, int n2, int n3) {
        super(readableFontData, n, n2);
        this.format = n3;
    }

    public int format() {
        return this.format;
    }

    @Override
    public String toString() {
        return "BitmapGlyph [format=" + this.format + ", data = " + super.toString() + "]";
    }

    public static abstract class Builder<T extends BitmapGlyph>
    extends SubTable.Builder<T> {
        private final int format;

        public static Builder<? extends BitmapGlyph> createGlyphBuilder(ReadableFontData readableFontData, int n) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return new SimpleBitmapGlyph.Builder(readableFontData, n);
                }
                case 8: 
                case 9: {
                    return new CompositeBitmapGlyph.Builder(readableFontData, n);
                }
            }
            return null;
        }

        protected Builder(WritableFontData writableFontData, int n) {
            super(writableFontData);
            this.format = n;
        }

        protected Builder(ReadableFontData readableFontData, int n) {
            super(readableFontData);
            this.format = n;
        }

        public int format() {
            return this.format;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return this.internalReadData().length();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return this.internalReadData().copyTo(writableFontData);
        }
    }

    protected static enum Offset {
        version(0),
        smallGlyphMetricsLength(5),
        bigGlyphMetricsLength(8),
        glyphFormat1_imageData(Offset.smallGlyphMetricsLength.offset),
        glyphFormat2_imageData(Offset.smallGlyphMetricsLength.offset),
        glyphFormat5_imageData(0),
        glyphFormat6_imageData(Offset.bigGlyphMetricsLength.offset),
        glyphFormat7_imageData(Offset.bigGlyphMetricsLength.offset),
        glyphFormat8_numComponents(Offset.smallGlyphMetricsLength.offset + 1),
        glyphFormat8_componentArray(Offset.glyphFormat8_numComponents.offset + FontData.DataSize.USHORT.size()),
        glyphFormat9_numComponents(Offset.bigGlyphMetricsLength.offset),
        glyphFormat9_componentArray(Offset.glyphFormat9_numComponents.offset + FontData.DataSize.USHORT.size()),
        ebdtComponentLength(FontData.DataSize.USHORT.size() + 2 * FontData.DataSize.CHAR.size()),
        ebdtComponent_glyphCode(0),
        ebdtComponent_xOffset(2),
        ebdtComponent_yOffset(3);

        protected final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

