/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class EbdtTable
extends SubTableContainerTable {
    protected EbdtTable(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public BitmapGlyph glyph(int n, int n2, int n3) {
        ReadableFontData readableFontData = this.data.slice(n, n2);
        return BitmapGlyph.createGlyph(readableFontData, n3);
    }

    public static class Builder
    extends SubTableContainerTable.Builder<EbdtTable> {
        private final int version = 131072;
        private List<Map<Integer, BitmapGlyphInfo>> glyphLoca;
        private List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilders;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        public static Builder createBuilder(Header header, ReadableFontData readableFontData) {
            return new Builder(header, readableFontData);
        }

        protected Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        protected Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        public void setLoca(List<Map<Integer, BitmapGlyphInfo>> list) {
            this.revert();
            this.glyphLoca = list;
        }

        public List<Map<Integer, BitmapGlyphInfo>> generateLocaList() {
            if (this.glyphBuilders == null) {
                if (this.glyphLoca == null) {
                    return new ArrayList<Map<Integer, BitmapGlyphInfo>>(0);
                }
                return this.glyphLoca;
            }
            ArrayList arrayList = new ArrayList(this.glyphBuilders.size());
            int n = Offset.headerLength.offset;
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> map : this.glyphBuilders) {
                TreeMap<Integer, BitmapGlyphInfo> treeMap = new TreeMap<Integer, BitmapGlyphInfo>();
                int n2 = 0;
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> entry : map.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = entry.getValue();
                    int n3 = builder.subDataSizeToSerialize();
                    BitmapGlyphInfo bitmapGlyphInfo = new BitmapGlyphInfo(entry.getKey(), n + n2, n3, builder.format());
                    treeMap.put(entry.getKey(), bitmapGlyphInfo);
                    n2 += n3;
                }
                n += n2;
                arrayList.add(Collections.unmodifiableMap(treeMap));
            }
            return Collections.unmodifiableList(arrayList);
        }

        public List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilders() {
            return this.getGlyphBuilders();
        }

        public void setGlyphBuilders(List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> list) {
            this.glyphBuilders = list;
            this.setModelChanged();
        }

        private List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> getGlyphBuilders() {
            if (this.glyphBuilders == null) {
                if (this.glyphLoca == null) {
                    throw new IllegalStateException("Loca values not set - unable to parse glyph data.");
                }
                this.glyphBuilders = Builder.initialize(this.internalReadData(), this.glyphLoca);
                this.setModelChanged();
            }
            return this.glyphBuilders;
        }

        public void revert() {
            this.glyphLoca = null;
            this.glyphBuilders = null;
            this.setModelChanged(false);
        }

        private static List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> initialize(ReadableFontData readableFontData, List<Map<Integer, BitmapGlyphInfo>> list) {
            ArrayList<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> arrayList = new ArrayList<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>>(list.size());
            if (readableFontData != null) {
                for (Map<Integer, BitmapGlyphInfo> map : list) {
                    TreeMap<Integer, BitmapGlyph.Builder<BitmapGlyph>> treeMap = new TreeMap<Integer, BitmapGlyph.Builder<BitmapGlyph>>();
                    for (Map.Entry<Integer, BitmapGlyphInfo> entry : map.entrySet()) {
                        BitmapGlyphInfo bitmapGlyphInfo = entry.getValue();
                        BitmapGlyph.Builder<BitmapGlyph> builder = BitmapGlyph.Builder.createGlyphBuilder(readableFontData.slice(bitmapGlyphInfo.offset(), bitmapGlyphInfo.length()), bitmapGlyphInfo.format());
                        treeMap.put(entry.getKey(), builder);
                    }
                    arrayList.add(treeMap);
                }
            }
            return arrayList;
        }

        @Override
        protected EbdtTable subBuildTable(ReadableFontData readableFontData) {
            return new EbdtTable(this.header(), readableFontData);
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.glyphBuilders == null || this.glyphBuilders.size() == 0) {
                return 0;
            }
            boolean bl = true;
            int n = Offset.headerLength.offset;
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> map : this.glyphBuilders) {
                TreeMap treeMap = new TreeMap();
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> entry : map.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = entry.getValue();
                    int n2 = builder.subDataSizeToSerialize();
                    n += Math.abs(n2);
                    bl = n2 <= 0 ? false : bl;
                }
            }
            return (bl ? 1 : -1) * n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.glyphBuilders != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = 0;
            n += writableFontData.writeFixed(Offset.version.offset, this.version);
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> map : this.glyphBuilders) {
                TreeMap treeMap = new TreeMap();
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> entry : map.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = entry.getValue();
                    n += builder.subSerialize(writableFontData.slice(n));
                }
            }
            return n;
        }
    }

    protected static enum Offset {
        version(0),
        headerLength(FontData.DataSize.Fixed.size());

        protected final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

