/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.tools.conversion.eot.MtxWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class EOTWriter {
    private final boolean compressed;
    private final FontFactory factory = FontFactory.getInstance();
    private static final long RESERVED = 0L;
    private static final short PADDING = 0;
    private static final long VERSION = 131074L;
    private static final short MAGIC_NUMBER = 20556;
    private static final long DEFAULT_FLAGS = 0L;
    private static final long FLAGS_TT_COMPRESSED = 4L;
    private static final byte DEFAULT_CHARSET = 1;
    private static final long CS_XORKEY = 1346851650L;

    public EOTWriter() {
        this.compressed = false;
    }

    public EOTWriter(boolean bl) {
        this.compressed = bl;
    }

    public WritableFontData convert(Font font) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.factory.serializeFont(font, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        NameTable nameTable = (NameTable)font.getTable(Tag.name);
        byte[] byArray2 = this.convertUTF16StringToLittleEndian(nameTable.nameAsBytes(3, 1, 1033, 1));
        byte[] byArray3 = this.convertUTF16StringToLittleEndian(nameTable.nameAsBytes(3, 1, 1033, 2));
        byte[] byArray4 = this.convertUTF16StringToLittleEndian(nameTable.nameAsBytes(3, 1, 1033, 5));
        byte[] byArray5 = this.convertUTF16StringToLittleEndian(nameTable.nameAsBytes(3, 1, 1033, 4));
        long l = 0L;
        if (this.compressed) {
            l |= 4L;
            MtxWriter mtxWriter = new MtxWriter();
            byArray = mtxWriter.compress(font);
        }
        long l2 = this.computeEotSize(byArray2.length, byArray3.length, byArray4.length, byArray5.length, byArray.length);
        WritableFontData writableFontData = this.createWritableFontData((int)l2);
        OS2Table oS2Table = (OS2Table)font.getTable(Tag.OS_2);
        int n = 0;
        n += writableFontData.writeULongLE(n, l2);
        n += writableFontData.writeULongLE(n, byArray.length);
        n += writableFontData.writeULongLE(n, 131074L);
        n += writableFontData.writeULongLE(n, l);
        n += this.writeFontPANOSE(n, oS2Table, writableFontData);
        n += writableFontData.writeByte(n, (byte)1);
        n += writableFontData.writeByte(n, (byte)(oS2Table.fsSelectionAsInt() & 1));
        n += writableFontData.writeULongLE(n, oS2Table.usWeightClass());
        n += writableFontData.writeUShortLE(n, (short)oS2Table.fsTypeAsInt());
        n += writableFontData.writeUShortLE(n, 20556);
        n += this.writeUnicodeRanges(n, oS2Table, writableFontData);
        n += this.writeCodePages(n, oS2Table, writableFontData);
        FontHeaderTable fontHeaderTable = (FontHeaderTable)font.getTable(Tag.head);
        n += writableFontData.writeULongLE(n, fontHeaderTable.checkSumAdjustment());
        n += this.writeReservedFields(n, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += this.writeUTF16String(n, byArray2, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += this.writeUTF16String(n, byArray3, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += this.writeUTF16String(n, byArray4, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += this.writeUTF16String(n, byArray5, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += writableFontData.writeULongLE(n, 1346851650L);
        n += writableFontData.writeULongLE(n, 0L);
        n += this.writePadding(n, writableFontData);
        n += this.writePadding(n, writableFontData);
        n += writableFontData.writeULongLE(n, 0L);
        n += writableFontData.writeULongLE(n, 0L);
        writableFontData.writeBytes(n, byArray, 0, byArray.length);
        return writableFontData;
    }

    private long computeEotSize(int n, int n2, int n3, int n4, int n5) {
        return 16 * FontData.DataSize.ULONG.size() + 12 * FontData.DataSize.BYTE.size() + 12 * FontData.DataSize.USHORT.size() + n * FontData.DataSize.BYTE.size() + n2 * FontData.DataSize.BYTE.size() + n3 * FontData.DataSize.BYTE.size() + n4 * FontData.DataSize.BYTE.size() + n5 * FontData.DataSize.BYTE.size() + 5 * FontData.DataSize.ULONG.size();
    }

    private int writeFontPANOSE(int n, OS2Table oS2Table, WritableFontData writableFontData) {
        byte[] byArray = oS2Table.panose();
        return writableFontData.writeBytes(n, byArray, 0, byArray.length);
    }

    private int writeReservedFields(int n, WritableFontData writableFontData) {
        int n2 = n;
        for (int i = 0; i < 4; ++i) {
            n2 += writableFontData.writeULongLE(n2, 0L);
        }
        return n2 - n;
    }

    private int writeUnicodeRanges(int n, OS2Table oS2Table, WritableFontData writableFontData) {
        int n2 = n;
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulUnicodeRange1());
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulUnicodeRange2());
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulUnicodeRange3());
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulUnicodeRange4());
        return n2 - n;
    }

    private int writeCodePages(int n, OS2Table oS2Table, WritableFontData writableFontData) {
        int n2 = n;
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulCodePageRange1());
        n2 += writableFontData.writeULongLE(n2, oS2Table.ulCodePageRange2());
        return n2 - n;
    }

    private int writePadding(int n, WritableFontData writableFontData) {
        return writableFontData.writeUShortLE(n, 0);
    }

    private int writeUTF16String(int n, byte[] byArray, WritableFontData writableFontData) {
        int n2 = n;
        n2 += writableFontData.writeUShortLE(n2, (short)byArray.length);
        n2 += writableFontData.writeBytes(n2, byArray, 0, byArray.length);
        return n2 - n;
    }

    private byte[] convertUTF16StringToLittleEndian(byte[] byArray) {
        if (byArray == null) {
            return new byte[0];
        }
        for (int i = 0; i < byArray.length; i += 2) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 1];
            byArray[i + 1] = by;
        }
        return byArray;
    }

    private WritableFontData createWritableFontData(int n) {
        return WritableFontData.createWritableFontData(n);
    }
}

