/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class MarkingPushbackInputStream
extends PushbackInputStream {
    private PushbackInputStream is;
    private long pos = 0L;

    public long getPosition() {
        return this.pos;
    }

    public MarkingPushbackInputStream(InputStream in, int size) {
        super(in, size);
        this.is = new PushbackInputStream(in, size);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public synchronized void close() throws IOException {
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        int ret = this.is.read();
        if (ret > -1) {
            ++this.pos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.is.read(b, off, len);
        if (ret > -1) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.is.read(b);
        if (ret > -1) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public void unread(byte[] b) throws IOException {
        this.pos -= (long)b.length;
        this.is.unread(b);
    }

    @Override
    public void unread(int b) throws IOException {
        --this.pos;
        this.is.unread(b);
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        this.pos -= (long)len;
        this.is.unread(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = this.is.skip(n);
        this.pos += ret;
        return ret;
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.pos += n;
        this.is.skipNBytes(n);
    }
}

