/*
 * Decompiled with CFR 0.152.
 */
package com.realityinteractive.imageio.tga;

import com.realityinteractive.imageio.tga.TGAImageMetadataFormat;
import com.realityinteractive.imageio.tga.TGAImageReaderSpi;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TGAImageMetadata
extends IIOMetadata {
    public TGAImageMetadata() {
        super(false, TGAImageReaderSpi.NATIVE_IMAGE_METADATA_FORMAT_NAME, TGAImageReaderSpi.NATIVE_IMAGE_METADATA_FORMAT_CLASSNAME, TGAImageReaderSpi.EXTRA_IMAGE_METADATA_FORMAT_NAMES, TGAImageReaderSpi.EXTRA_IMAGE_METADATA_FORMAT_CLASSNAMES);
    }

    private void checkFormatName(String formatName) {
        if (!TGAImageReaderSpi.NATIVE_IMAGE_METADATA_FORMAT_NAME.equals(formatName)) {
            throw new IllegalArgumentException("Unknown image metadata format name \"" + formatName + "\".");
        }
    }

    @Override
    public Node getAsTree(String formatName) {
        this.checkFormatName(formatName);
        IIOMetadataNode root = new IIOMetadataNode(TGAImageReaderSpi.NATIVE_IMAGE_METADATA_FORMAT_NAME);
        return root;
    }

    @Override
    public IIOMetadataFormat getMetadataFormat(String formatName) {
        this.checkFormatName(formatName);
        return TGAImageMetadataFormat.getInstance();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.checkFormatName(formatName);
    }

    @Override
    public void reset() {
    }
}

