/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class UniTools {
    private static List<String> backupFonts = new ArrayList<String>();
    private static String[] backupCandidates = new String[]{"Unifont", "Arial Unicode MS"};
    private static Font defaultUniFont = null;

    private static boolean fontExists(String name) {
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List<String> availFonts = Arrays.asList(g.getAvailableFontFamilyNames());
        for (int i = 0; i < availFonts.size(); ++i) {
            availFonts.set(i, availFonts.get(i).toLowerCase());
        }
        return availFonts.contains(name.toLowerCase());
    }

    private static void getSegments(Font f, Segment segment, List<Segment> segments, List<Boolean> unis) {
        int start = 0;
        int len = 0;
        boolean uni = false;
        for (int i = 0; i < segment.length(); ++i) {
            boolean newuni = false;
            if (!f.canDisplay(segment.charAt(i))) {
                newuni = true;
            }
            if (i > 0 && uni != newuni) {
                Segment s = new Segment(segment.array, segment.offset + start, len);
                segments.add(s);
                unis.add(uni);
                start = i;
                len = 0;
            }
            uni = newuni;
            ++len;
        }
        if (len > 0) {
            Segment s = new Segment(segment.array, segment.offset + start, len);
            segments.add(s);
            unis.add(uni);
        }
    }

    public static int getTabbedTextWidth(Graphics g, Segment segment, int x, TabExpander e, int startOffset) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        FontMetrics metrics = g.getFontMetrics(origFont);
        FontMetrics uniMetrics = g.getFontMetrics(uniFont);
        int ret = 0;
        int pos = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            int segw = Utilities.getTabbedTextWidth(seg, (Boolean)unis.get(i) != false ? uniMetrics : metrics, x, e, startOffset + pos);
            ret += segw;
            x += segw;
            pos += seg.length();
        }
        return ret;
    }

    public static int drawTabbedText(Segment segment, int x, int y, Graphics g, TabExpander e, int startOffset) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ret = x;
        int pos = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            if (((Boolean)unis.get(i)).booleanValue()) {
                g.setFont(uniFont);
            } else {
                g.setFont(origFont);
            }
            ret = Utilities.drawTabbedText(seg, ret, y, g, e, startOffset + pos);
            pos += seg.length();
        }
        g.setFont(origFont);
        return ret;
    }

    public static int stringWidth(Graphics g, String string) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<Boolean> unis = new ArrayList<Boolean>();
        Segment segment = new Segment(string.toCharArray(), 0, string.length());
        UniTools.getSegments(g.getFont(), segment, segments, unis);
        Font origFont = g.getFont();
        Font uniFont = defaultUniFont.deriveFont(origFont.getStyle(), origFont.getSize2D());
        int ret = 0;
        for (int i = 0; i < segments.size(); ++i) {
            Segment seg = (Segment)segments.get(i);
            ret += g.getFontMetrics((Boolean)unis.get(i) != false ? uniFont : origFont).stringWidth(seg.toString());
        }
        return ret;
    }

    public static final int getTabbedTextOffset(Graphics g, Segment s, FontMetrics metrics, float x0, float x, TabExpander e, int startOffset) {
        if (x0 >= x) {
            return 0;
        }
        float nextX = x0;
        char[] txt = s.array;
        int txtOffset = s.offset;
        int txtCount = s.count;
        boolean spaceAddon = false;
        int spaceAddonLeftoverEnd = -1;
        int startJustifiableContent = 0;
        int endJustifiableContent = 0;
        int n = s.offset + s.count;
        for (int i = s.offset; i < n; ++i) {
            if (txt[i] == '\t' || (spaceAddon || i <= spaceAddonLeftoverEnd) && txt[i] == ' ' && startJustifiableContent <= i && i <= endJustifiableContent) {
                if (txt[i] == '\t') {
                    nextX = e != null ? e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += UniTools.getFontCharWidth(g, ' ', metrics));
                } else if (txt[i] == ' ') {
                    nextX += UniTools.getFontCharWidth(g, ' ', metrics);
                    nextX += (float)spaceAddon;
                    if (i <= spaceAddonLeftoverEnd) {
                        nextX += 1.0f;
                    }
                }
            } else {
                nextX += UniTools.getFontCharWidth(g, txt[i], metrics);
            }
            if (!(x < nextX)) continue;
            float span = x - x0;
            int offset = i + 1 - txtOffset;
            float width = UniTools.getFontCharsWidth(g, txt, txtOffset, offset, metrics);
            if (span < width) {
                while (offset > 0) {
                    float nextWidth;
                    float charsWidth = UniTools.getFontCharsWidth(g, txt, txtOffset, offset - 1, metrics);
                    float f = nextWidth = offset > 1 ? charsWidth : 0.0f;
                    if (span >= nextWidth) {
                        if (!(span - nextWidth < width - span)) break;
                        --offset;
                        break;
                    }
                    width = nextWidth;
                    --offset;
                }
            }
            return offset;
        }
        return txtCount;
    }

    private static float getFontCharWidth(Graphics g, char c, FontMetrics fm) {
        return UniTools.getFontCharsWidth(g, new char[]{c}, 0, 1, fm);
    }

    private static float getFontCharsWidth(Graphics g, char[] data, int offset, int len, FontMetrics fm) {
        if (len == 0) {
            return 0.0f;
        }
        Font uniFont = defaultUniFont.deriveFont(fm.getFont().getStyle(), fm.getFont().getSize2D());
        FontMetrics uniMetrics = g.getFontMetrics(uniFont);
        int w = 0;
        int batchStart = offset;
        boolean lastUni = false;
        for (int i = offset; i < offset + len; ++i) {
            char c = data[i];
            boolean uni = fm.getFont().canDisplay(c);
            if (uni != lastUni && i > offset) {
                w = !lastUni ? (w += uniMetrics.charsWidth(data, batchStart, i - batchStart)) : (w += fm.charsWidth(data, batchStart, i - batchStart));
                batchStart = i;
            }
            lastUni = uni;
        }
        w = !lastUni ? (w += uniMetrics.charsWidth(data, batchStart, offset + len - batchStart)) : (w += fm.charsWidth(data, batchStart, offset + len - batchStart));
        return w;
    }

    static {
        for (String bc : backupCandidates) {
            if (!UniTools.fontExists(bc)) continue;
            defaultUniFont = new Font(bc, 0, 10);
        }
        if (defaultUniFont == null) {
            defaultUniFont = new JLabel().getFont();
        }
    }
}

