/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;

public class Markers {
    private static final Logger LOG = Logger.getLogger(Markers.class.getName());

    public static void removeMarkers(JTextComponent component, SimpleMarker marker) {
        Highlighter hilite = component.getHighlighter();
        if (hilite == null) {
            return;
        }
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof SimpleMarker)) continue;
            SimpleMarker hMarker = (SimpleMarker)hilites[i].getPainter();
            if (marker != null && !hMarker.equals(marker)) continue;
            hilite.removeHighlight(hilites[i]);
        }
    }

    public static void removeMarkers(JTextComponent editorPane) {
        Markers.removeMarkers(editorPane, null);
    }

    public static void markToken(JTextComponent pane, Token token, SimpleMarker marker) {
        Markers.markText(pane, token.start, token.end(), marker);
    }

    public static void markText(JTextComponent pane, int start, int end, SimpleMarker marker) {
        try {
            Highlighter hiliter = pane.getHighlighter();
            int selStart = pane.getSelectionStart();
            int selEnd = pane.getSelectionEnd();
            if (selStart == selEnd || end < selStart || start > selStart) {
                hiliter.addHighlight(start, end, marker);
                return;
            }
            if (selStart > start && selStart < end) {
                hiliter.addHighlight(start, selStart, marker);
            }
            if (selEnd > start && selEnd < end) {
                hiliter.addHighlight(selEnd, end, marker);
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static void markAll(JTextComponent pane, Pattern pattern, SimpleMarker marker) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(pane);
        if (sDoc == null || pattern == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(pattern);
        if (matcher == null) {
            return;
        }
        while (matcher.find()) {
            Markers.markText(pane, matcher.start(), matcher.end(), marker);
        }
    }

    public static class SimpleMarker
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SimpleMarker(Color color) {
            super(color);
        }
    }
}

