/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.adapter;

import java.util.ArrayList;
import org.doubletype.ossa.adapter.CubicSegment;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;

public class QuadraticSegment {
    public static final int LINE = 0;
    public static final int CURVE = 1;
    private EContourPoint m_startPoint;
    private EContourPoint m_offCurvePoint;
    private EContourPoint m_endPoint;
    private int m_type = 0;

    public static ArrayList<QuadraticSegment> toSegments(EContour a_contour) {
        ArrayList<QuadraticSegment> retval = new ArrayList<QuadraticSegment>();
        ArrayList<EContourPoint> points = QuadraticSegment.toConcreatePoints(a_contour);
        if (points.size() < 3) {
            return retval;
        }
        for (int i = 0; i < points.size() - 1; ++i) {
            EContourPoint startPoint = points.get(i);
            EContourPoint nextPoint = points.get(i + 1);
            if (nextPoint.isOn()) {
                retval.add(new QuadraticSegment(startPoint, null, nextPoint));
                continue;
            }
            EContourPoint offCurvePoint = nextPoint;
            nextPoint = points.get(++i + 1);
            retval.add(new QuadraticSegment(startPoint, offCurvePoint, nextPoint));
        }
        return retval;
    }

    public static EContour toContour(ArrayList<QuadraticSegment> a_segments) {
        EContour retval = new EContour();
        retval.setType("quadratic");
        for (QuadraticSegment segment : a_segments) {
            EContourPoint p = segment.m_startPoint;
            EContourPoint startPoint = new EContourPoint(p.getX(), p.getY(), p.isOn());
            startPoint.setControlPoint1(null);
            startPoint.setControlPoint2(null);
            if (segment.m_type == 0) {
                retval.addContourPoint(startPoint);
                continue;
            }
            retval.addContourPoint(startPoint);
            retval.addContourPoint(segment.m_offCurvePoint);
        }
        return retval;
    }

    private static ArrayList<EContourPoint> toConcreatePoints(EContour a_contour) {
        ArrayList<EContourPoint> retval = new ArrayList<EContourPoint>();
        ArrayList<EContourPoint> points = a_contour.getContourPoints();
        if (points.size() < 3) {
            return retval;
        }
        EContourPoint fromPoint = points.get(points.size() - 1);
        for (EContourPoint point : points) {
            EContourPoint toPoint = point;
            if (!toPoint.isOn() && !fromPoint.isOn()) {
                double xMidpoint = (toPoint.getX() + fromPoint.getX()) / 2.0;
                double yMidpoint = (toPoint.getY() + fromPoint.getY()) / 2.0;
                retval.add(new EContourPoint(xMidpoint, yMidpoint, true));
            }
            retval.add(toPoint);
            fromPoint = toPoint;
        }
        EContourPoint firstPoint = retval.get(0);
        if (!firstPoint.isOn()) {
            retval.remove(0);
            retval.add(firstPoint);
        }
        retval.add(retval.get(0));
        return retval;
    }

    public QuadraticSegment(EContourPoint a_startPoint, EContourPoint a_offCurvePoint, EContourPoint a_endPoint) {
        this.m_startPoint = a_startPoint;
        this.m_offCurvePoint = a_offCurvePoint;
        this.m_endPoint = a_endPoint;
        if (this.m_offCurvePoint != null) {
            this.m_type = 1;
        }
    }

    public CubicSegment toCubicSegment() {
        if (this.m_type == 0) {
            return new CubicSegment(this.m_startPoint, this.m_endPoint);
        }
        double x = this.m_startPoint.getX() + 0.6666666666666666 * (this.m_offCurvePoint.getX() - this.m_startPoint.getX());
        double y = this.m_startPoint.getY() + 0.6666666666666666 * (this.m_offCurvePoint.getY() - this.m_startPoint.getY());
        EContourPoint controlPoint1 = new EContourPoint(x, y, false);
        x = this.m_offCurvePoint.getX() + 0.3333333333333333 * (this.m_endPoint.getX() - this.m_offCurvePoint.getX());
        y = this.m_offCurvePoint.getY() + 0.3333333333333333 * (this.m_endPoint.getY() - this.m_offCurvePoint.getY());
        EContourPoint controlPoint2 = new EContourPoint(x, y, false);
        return new CubicSegment(this.m_startPoint, controlPoint1, controlPoint2, this.m_endPoint);
    }
}

