/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.module;

import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.doubletype.ossa.OutOfRangeException;
import org.doubletype.ossa.module.GlyphFile;
import org.doubletype.ossa.truetype.FontFileWriter;
import org.doubletype.ossa.truetype.TTCodePage;
import org.doubletype.ossa.truetype.TTGlyph;
import org.doubletype.ossa.truetype.TTUnicodeRange;

public class TypefaceFile
extends GlyphFile {
    private final double k_defaultTopSideBearing = 170.0;
    private final double k_defaultAscender = 683.0;
    private final double k_defaultXHeight = 424.0;
    private final double k_defaultDescender = 171.0;
    private final double k_defaultBottomSideBearing = 0.0;
    private final double k_em = 1024.0;
    private final int k_defaultAdvanceWidth = 512;
    private final String k_dotTtf = ".ttf";
    private File m_dir;
    private File m_ttfFile;
    private Font m_font = null;
    private List<GlyphFile> m_glyphFiles = new ArrayList<GlyphFile>();
    private List<String> m_unicodeRanges = new ArrayList<String>();
    private List<String> m_codePages = new ArrayList<String>();
    private String m_fontFamilyName;
    private String m_version;
    private Double m_topSideBearing = null;
    private Double m_ascender = null;
    private Double m_xHeight = null;
    private Double m_descender = null;
    private Double m_bottomSideBearing = null;
    private String m_name;

    public TypefaceFile(String a_name, File a_dir) throws FileNotFoundException {
        super(a_dir);
        this.m_dir = a_dir;
        this.m_name = a_name;
        this.initFileName();
    }

    public TypefaceFile(File a_file) {
        super(a_file);
        this.m_dir = a_file.getParentFile();
        this.m_name = a_file.getName();
        this.initFileName();
    }

    private void initFileName() {
        String fileName = this.m_name + ".ttf";
        this.m_ttfFile = new File(this.m_dir, fileName);
    }

    public GlyphFile createGlyph(long a_unicode) {
        return new GlyphFile(this.getGlyphPath(), a_unicode);
    }

    private GlyphFile getGlyphFileByUnicode(long code) {
        for (GlyphFile glyphFile : this.m_glyphFiles) {
            if (glyphFile.getUnicode() != code) continue;
            return glyphFile;
        }
        return null;
    }

    public boolean addRequiredGlyphs() {
        GlyphFile glyph;
        boolean retval = false;
        if (this.getGlyphFileByUnicode(1L) == null) {
            glyph = new GlyphFile(this.getGlyphPath(), 1L);
            glyph.initNotDef(512);
            this.addGlyph(0, glyph);
            retval = true;
        }
        if (this.getGlyphFileByUnicode(0L) == null) {
            glyph = new GlyphFile(this.getGlyphPath(), 0L);
            glyph.initNullGlyph();
            this.addGlyph(1, glyph);
            retval = true;
        }
        if (this.getGlyphFileByUnicode(13L) == null) {
            glyph = new GlyphFile(this.getGlyphPath(), 13L);
            glyph.initSpace(512);
            this.addGlyph(2, glyph);
            retval = true;
        }
        if (this.getGlyphFileByUnicode(32L) == null) {
            glyph = new GlyphFile(this.getGlyphPath(), 32L);
            glyph.initSpace(512);
            this.addGlyph(3, glyph);
            retval = true;
        }
        return retval;
    }

    public void addBasicLatinGlyphs() {
        String basicLatin = Character.UnicodeBlock.BASIC_LATIN.toString();
        TTUnicodeRange.find(basicLatin);
        TTUnicodeRange range = TTUnicodeRange.getLastFound();
        this.addUnicodeRange(basicLatin);
        for (long i = range.getStartCode(); i <= range.getEndCode(); ++i) {
            if (i == 32L) continue;
            this.addGlyph(this.createGlyph(i));
        }
    }

    public File getGlyphPath() {
        return this.m_dir;
    }

    public void setGlyphUnicode(GlyphFile a_glyphFile, long a_unicode) {
        a_glyphFile.setUnicode(a_unicode);
    }

    public void addGlyph(GlyphFile a_file) {
        this.m_glyphFiles.add(a_file);
    }

    public void addGlyph(int a_index, GlyphFile a_file) {
        this.m_glyphFiles.add(a_index, a_file);
    }

    public Object[] getCodePages() {
        Object[] retval = new Object[]{};
        return retval;
    }

    public boolean containsUnicodeRange(String a_unicodeRange) {
        return this.m_unicodeRanges.contains(a_unicodeRange);
    }

    public void addUnicodeRange(String a_unicodeRange) {
        if (this.containsUnicodeRange(a_unicodeRange)) {
            return;
        }
        this.m_unicodeRanges.add(a_unicodeRange);
    }

    public boolean containsCodePage(String a_codePage) {
        return this.m_codePages.contains(a_codePage);
    }

    public void addCodePage(String a_codePage) {
        if (this.containsCodePage(a_codePage)) {
            return;
        }
        this.m_codePages.add(a_codePage);
    }

    public void removeCodePage(String a_codePage) {
        if (!this.containsCodePage(a_codePage)) {
            return;
        }
        this.m_codePages.remove(a_codePage);
    }

    public void setFontFamilyName(String a_value) {
        this.m_fontFamilyName = a_value;
    }

    public String getFontFamilyName() {
        return this.m_fontFamilyName;
    }

    public String getVersion() {
        return this.m_version == null ? "0.1" : this.m_version;
    }

    public void setVersion(String a_value) {
        this.m_version = a_value;
    }

    public void setDefaultMetrics() {
        this.m_topSideBearing = 170.0;
        this.m_ascender = 683.0;
        this.m_xHeight = 424.0;
        this.m_descender = 171.0;
        this.m_bottomSideBearing = 0.0;
    }

    public double getEm() {
        return 1024.0;
    }

    public double getBaseline() {
        return this.getBottomSideBearing() + this.getDescender();
    }

    public double getMeanline() {
        return this.getBottomSideBearing() + this.getDescender() + this.getXHeight();
    }

    public double getBodyBottom() {
        return this.getBottomSideBearing();
    }

    public double getBodyTop() {
        return this.getEm() - this.getTopSideBearing();
    }

    public double getTopSideBearing() {
        if (this.m_topSideBearing == null) {
            this.setDefaultMetrics();
        }
        return this.m_topSideBearing;
    }

    public double getAscender() {
        if (this.m_ascender == null) {
            this.setDefaultMetrics();
        }
        return this.m_ascender;
    }

    public double getXHeight() {
        if (this.m_xHeight == null) {
            this.setDefaultMetrics();
        }
        return this.m_xHeight;
    }

    public double getDescender() {
        if (this.m_descender == null) {
            this.setDefaultMetrics();
        }
        return this.m_descender;
    }

    public double getBottomSideBearing() {
        if (this.m_bottomSideBearing == null) {
            this.setDefaultMetrics();
        }
        return this.m_bottomSideBearing;
    }

    public void setTopSideBearing(double a_value) throws OutOfRangeException {
        this.checkBoundary(a_value);
        this.m_topSideBearing = a_value;
    }

    private void checkBoundary(double a_value) throws OutOfRangeException {
        if (a_value > 1024.0 || a_value < 0.0) {
            throw new OutOfRangeException(a_value);
        }
    }

    public void setAscender(double a_value) throws OutOfRangeException {
        this.checkBoundary(a_value);
        this.m_ascender = a_value;
    }

    public void setXHeight(double a_value) throws OutOfRangeException {
        this.checkBoundary(a_value);
        if (a_value > this.getAscender()) {
            throw new OutOfRangeException(a_value);
        }
        this.m_xHeight = a_value;
    }

    public void setDescender(double a_value) throws OutOfRangeException {
        this.checkBoundary(a_value);
        this.m_descender = a_value;
    }

    public void setBottomSideBearing(double a_value) throws OutOfRangeException {
        this.checkBoundary(a_value);
        this.m_bottomSideBearing = a_value;
    }

    public double getBodyHeight() {
        return 1024.0 - this.getTopSideBearing() - this.getBottomSideBearing();
    }

    public void buildTTF() throws Exception {
        String randomString = UUID.randomUUID().toString().substring(0, 4);
        File tempFile = new File(this.m_dir, this.m_name + "_" + randomString + ".ttf");
        File target = this.m_ttfFile;
        String fontFamilyName = this.getFontFamilyName();
        target.delete();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(target, "rw");){
            FontFileWriter writer = new FontFileWriter(randomAccessFile);
            writer.setFontFamilyName(fontFamilyName);
            writer.setCopyrightYear(this.getCopyrightYear());
            writer.setCreationDate(this.getCreationDate());
            writer.setModificationDate(this.getModificationDate());
            writer.setFontVersion(this.getVersion());
            writer.setManufacturer(this.getAuthor());
            writer.setAscent((int)this.getAscender());
            writer.setXHeight((int)this.getXHeight());
            writer.setDescent((int)this.getDescender());
            writer.setLineGap((int)(this.getTopSideBearing() + this.getBottomSideBearing()));
            this.loadCodePages(writer);
            this.loadUnicodeRanges(writer);
            this.loadGlyphs(writer);
            writer.write();
        }
        if (target.exists()) {
            this.copyFile(target, tempFile);
        }
        FileInputStream in = new FileInputStream(tempFile);
        this.m_font = Font.createFont(0, in);
        in.close();
    }

    private void copyFile(File a_in, File a_out) throws Exception {
        FileInputStream in = new FileInputStream(a_in);
        FileOutputStream out = new FileOutputStream(a_out);
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = in.read(buffer)) != -1) {
            out.write(buffer, 0, i);
        }
        in.close();
        out.close();
    }

    public Font getFont() {
        return this.m_font;
    }

    private void loadCodePages(FontFileWriter a_writer) {
        for (String codePageName : this.m_codePages) {
            TTCodePage codePage = TTCodePage.forName(codePageName);
            if (codePage == null) continue;
            a_writer.setCodeRangeFlag(codePage.getOsTwoFlag());
        }
    }

    private void loadUnicodeRanges(FontFileWriter a_writer) {
        for (String unicodeRange : this.m_unicodeRanges) {
            if (!TTUnicodeRange.find(unicodeRange)) continue;
            a_writer.addUnicodeRange(TTUnicodeRange.getLastFound());
        }
    }

    private void loadGlyphs(FontFileWriter a_writer) throws Exception {
        for (GlyphFile glyphFile : this.m_glyphFiles) {
            this.loadGlyph(glyphFile, a_writer);
        }
    }

    private void loadGlyph(GlyphFile a_glyphFile, FontFileWriter a_writer) throws Exception {
        TTGlyph glyph = null;
        glyph = a_glyphFile.isSimple() ? a_glyphFile.toSimpleGlyph() : this.createCompoundGlyph(a_glyphFile, a_writer);
        if (glyph == null) {
            glyph = new TTGlyph();
        }
        int glyphIndex = a_writer.addGlyph(glyph);
        long unicode = a_glyphFile.getUnicode();
        if (unicode != -1L) {
            long existingIndex = a_writer.getCharacterMapping(unicode);
            if (existingIndex != 0L) {
                throw new Exception(Long.toHexString(unicode) + " is mapped already.");
            }
            a_writer.addCharacterMapping(unicode, glyphIndex);
        }
    }

    private TTGlyph createCompoundGlyph(GlyphFile a_glyphFile, FontFileWriter a_writer) throws Exception {
        TTGlyph retval = new TTGlyph();
        ArrayList<Point> locs = new ArrayList<Point>();
        ArrayList<Integer> indeces = new ArrayList<Integer>();
        retval.setSimple(false);
        retval.setAdvanceWidth(a_glyphFile.getAdvanceWidth());
        TTGlyph simple = a_glyphFile.toSimpleGlyph();
        if (simple != null) {
            int glyphIndex = a_writer.addGlyph(simple);
            locs.add(new Point(0, 0));
            indeces.add(glyphIndex);
        }
        int i = 0;
        int flag = 7;
        int numOfCompositePoints = 0;
        int numOfCompositeContours = 0;
        int componentDepth = 0;
        Iterator iterator = indeces.iterator();
        while (iterator.hasNext()) {
            int glyfIndex = (Integer)iterator.next();
            TTGlyph glyph = a_writer.getGlyph(glyfIndex);
            numOfCompositePoints += glyph.getNumOfCompositePoints();
            numOfCompositeContours += glyph.getNumOfCompositeContours();
            if (glyph.getComponentDepth() > componentDepth) {
                componentDepth = glyph.getComponentDepth();
            }
            retval.addGlyfIndex(glyfIndex);
            if (i < indeces.size() - 1) {
                retval.addFlag(flag | 0x20);
            } else {
                retval.addFlag(flag);
            }
            Point loc = (Point)locs.get(i);
            retval.addArg1(loc.x);
            retval.addArg2(loc.y);
        }
        retval.setNumOfCompositePoints(numOfCompositePoints);
        retval.setNumOfCompositeContours(numOfCompositeContours);
        retval.setComponentDepth(componentDepth + 1);
        return retval;
    }
}

