/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFAnnot;
import gnu.jpdf.PDFDocument;
import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFPage;
import gnu.jpdf.RawPrintWriter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFJob
extends PrintJob
implements Serializable {
    protected transient OutputStream os;
    protected PDFDocument pdfDocument;
    protected PDFPage page;
    protected int pagenum;

    public PDFJob() {
        this(null);
    }

    public PDFJob(OutputStream os) {
        this(os, "PDF Doc");
    }

    public PDFJob(OutputStream os, String title) {
        this.os = os;
        this.pdfDocument = new PDFDocument();
        this.pagenum = 0;
        this.pdfDocument.getPDFInfo().setTitle(title);
    }

    public Graphics getGraphics(int orient) {
        this.page = new PDFPage(orient);
        this.pdfDocument.add(this.page);
        ++this.pagenum;
        return new graphic(this.page, this);
    }

    public Graphics getGraphics(PageFormat pageFormat) {
        this.page = new PDFPage(pageFormat);
        this.pdfDocument.add(this.page);
        ++this.pagenum;
        return new graphic(this.page, this);
    }

    @Override
    public void end() {
        try {
            this.pdfDocument.write(this.os);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.os = null;
        this.pdfDocument = null;
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(1);
    }

    @Override
    public Dimension getPageDimension() {
        if (this.page == null) {
            System.err.println("PDFJob.getPageDimension(), page is null");
        }
        return this.page.getDimension();
    }

    @Override
    public int getPageResolution() {
        return 72;
    }

    @Override
    public boolean lastPageFirst() {
        return false;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDocument;
    }

    public PDFPage getCurrentPage() {
        return this.page;
    }

    public int getCurrentPageNumber() {
        return this.pagenum;
    }

    public PDFOutline addOutline(String title) {
        return this.page.addOutline(title);
    }

    public PDFOutline addOutline(String title, int x, int y, int w, int h) {
        return this.page.addOutline(title, x, y, w, h);
    }

    public PDFAnnot addNote(String note, int x, int y, int w, int h) {
        return this.page.addNote(note, x, y, w, h);
    }

    class graphic
    extends PDFGraphics
    implements PrintGraphics {
        private PDFJob job;

        graphic(PDFPage page, PDFJob job) {
            this.init(page);
            this.job = job;
        }

        graphic(PDFPage page, PDFJob job, RawPrintWriter pw) {
            this.init(page, pw);
            this.job = job;
        }

        @Override
        public Graphics create() {
            this.closeBlock();
            graphic g = new graphic(this.getPage(), this.job, this.getWriter());
            g.clipRectangle = new Rectangle(this.clipRectangle);
            return g;
        }

        @Override
        public PrintJob getPrintJob() {
            return this.job;
        }
    }
}

