/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.decompiler.flash.SWFSearch;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.helpers.SwfHeaderStreamSearch;
import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BinarySWFBundle
implements Bundle {
    private final SWFSearch search;

    public BinarySWFBundle(InputStream is, boolean noCheck, SearchMode searchMode) throws IOException {
        this.search = new SWFSearch(new SwfHeaderStreamSearch(is), noCheck, searchMode);
        this.search.process();
    }

    @Override
    public int length() {
        return this.search.length();
    }

    @Override
    public Set<String> getKeys() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (Long address : this.search.getAddresses()) {
            ret.add("[" + address + "]");
        }
        return ret;
    }

    @Override
    public SeekableInputStream getOpenable(String key) {
        if (!key.startsWith("[")) {
            return null;
        }
        if (!key.endsWith("]")) {
            return null;
        }
        key = key.substring(1, key.length() - 1);
        try {
            int address = Integer.parseInt(key);
            return this.search.get(null, address);
        }
        catch (IOException | NumberFormatException iex) {
            return null;
        }
    }

    @Override
    public Map<String, SeekableInputStream> getAll() {
        LinkedHashMap<String, SeekableInputStream> ret = new LinkedHashMap<String, SeekableInputStream>();
        for (String key : this.getKeys()) {
            ret.put(key, this.getOpenable(key));
        }
        return ret;
    }

    @Override
    public String getExtension() {
        return "bin";
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean putOpenable(String key, InputStream is) {
        throw new UnsupportedOperationException("Save not supported for this type of bundle");
    }
}

