/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.deobfuscation;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.usages.multinames.MultinameUsage;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.Tag;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class AbcMultiNameCollisionFixer {
    public int fixCollisions(SWF swf) {
        int ret = 0;
        for (ABCContainerTag tag : swf.getAbcList()) {
            ret += this.fixCollisions(tag.getABC());
        }
        return ret;
    }

    public int fixCollisions(ABC abc) {
        Set<MultinameUsage> collidingUsages = abc.getCollidingMultinameUsages();
        HashSet<Integer> collidingMultinameIndices = new HashSet<Integer>();
        for (MultinameUsage usage : collidingUsages) {
            collidingMultinameIndices.add(usage.getMultinameIndex());
        }
        HashSet<String> newNames = new HashSet<String>();
        int ret = 0;
        Iterator iterator = collidingMultinameIndices.iterator();
        while (iterator.hasNext()) {
            int newNameIndex;
            String selectedBaseName;
            int multiNameIndex = (Integer)iterator.next();
            Multiname multiName = abc.constants.getMultiname(multiNameIndex);
            int namespace = multiName.namespace_index;
            String oldName = abc.constants.getString(multiName.name_index);
            String selectedName = selectedBaseName = oldName + "_" + multiName.namespace_index;
            int cnt = 0;
            while (!newNames.contains(selectedName) && abc.constants.getStringId(selectedName, false) > -1) {
                selectedName = selectedBaseName + "_" + ++cnt;
            }
            newNames.add(selectedName);
            multiName.name_index = newNameIndex = abc.constants.getStringId(selectedName, true);
            for (int m = 1; m < abc.constants.getMultinameCount(); ++m) {
                int otherNamespace;
                if (collidingMultinameIndices.contains(m)) continue;
                Multiname other = abc.constants.getMultiname(m);
                if (other.hasOwnName() && other.hasOwnNamespace()) {
                    int otherNamespace2 = other.namespace_index;
                    if (namespace != otherNamespace2 || !Objects.equals(oldName, abc.constants.getString(other.name_index))) continue;
                    other.name_index = newNameIndex;
                    ++ret;
                    continue;
                }
                if (!other.hasOwnName() || !other.hasOwnNamespaceSet()) continue;
                NamespaceSet otherNamespaceSet = abc.constants.getNamespaceSet(other.namespace_set_index);
                if (otherNamespaceSet.namespaces.length != 1 || namespace != (otherNamespace = otherNamespaceSet.namespaces[0]) || !Objects.equals(oldName, abc.constants.getString(other.name_index))) continue;
                other.name_index = newNameIndex;
                ++ret;
            }
            ++ret;
        }
        if (ret > 0) {
            ((Tag)((Object)abc.parentTag)).setModified(true);
        }
        return ret;
    }
}

