/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.FinalProcessLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2FinalProcessLocalData;
import com.jpexs.decompiler.flash.abc.avm2.CodeStats;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphSource;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewCatchIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugLineIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfStrictEqIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.IfStrictNeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.DecLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.IncLocalIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.KillIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.HasNext2Ins;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.LabelIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.NopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.DecLocalPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.decimalsupport.IncLocalPIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushByteIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceAIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.ConvertIIns;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.CoerceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConstructAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FilteredCheckAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.HasNextAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewFunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NextNameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NextValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullCoalesceAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ReturnValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ReturnVoidAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThrowAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.WithAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.WithEndAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.WithObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.FilterAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForEachInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ForInAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.TryAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.EqAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.NeqAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.StrictEqAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.StrictNeqAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.graph.AbstractGraphTargetRecursiveVisitor;
import com.jpexs.decompiler.graph.AbstractGraphTargetVisitor;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphPartMarkedArrayList;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.StopPartKind;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.AnyItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.GotoItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LoopItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AVM2Graph
extends Graph {
    private final AVM2Code avm2code;
    private final ABC abc;
    private final MethodBody body;
    private final int swfVersion;
    private final AbcIndexing abcIndex;
    private final Logger logger = Logger.getLogger(AVM2Graph.class.getName());
    final int FINALLY_KIND_STACK_BASED = 0;
    final int FINALLY_KIND_REGISTER_BASED = 1;
    final int FINALLY_KIND_INLINED = 2;
    final int FINALLY_KIND_UNKNOWN = -1;

    public AVM2Code getCode() {
        return this.avm2code;
    }

    private static List<GraphException> getExceptionEntries(MethodBody body) {
        ArrayList<GraphException> ret = new ArrayList<GraphException>();
        AVM2Code code = body.getCode();
        for (ABCException e : body.exceptions) {
            ret.add(new GraphException(code.adr2pos(e.start, true), code.adr2pos(e.end, true), code.adr2pos(e.target)));
        }
        return ret;
    }

    public AVM2Graph(int swfVersion, AbcIndexing abcIndex, AVM2Code code, ABC abc, MethodBody body, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, ScopeStack scopeStack, ScopeStack localScopeStack, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames, HashMap<Integer, Integer> localRegAssignmentIps) {
        super(AVM2GraphTargetDialect.INSTANCE, new AVM2GraphSource(code, isStatic, scriptIndex, classIndex, localRegs, abc, body, localRegNames, fullyQualifiedNames, localRegAssignmentIps), AVM2Graph.getExceptionEntries(body), 0);
        this.avm2code = code;
        this.abc = abc;
        this.body = body;
        this.swfVersion = swfVersion;
        this.abcIndex = abcIndex;
    }

    @Override
    protected boolean canBeBreakCandidate(BaseLocalData localData, GraphPart part, List<ThrowState> throwStates) {
        for (ThrowState ts : throwStates) {
            if (ts.targetPart != part) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void beforeGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts, List<ThrowState> throwStates) throws InterruptedException {
        AVM2LocalData avm2LocalData = (AVM2LocalData)localData;
        for (int e = 0; e < this.body.exceptions.length; ++e) {
            ABCException ex = this.body.exceptions[e];
            if (!ex.isFinally()) continue;
            avm2LocalData.finallyTargetParts.put(e, this.searchPart(this.code.adr2pos(ex.target), allParts));
        }
        this.getIgnoredSwitches((AVM2LocalData)localData, allParts);
        HashSet<Integer> integerSwitchesIps = new HashSet<Integer>();
        for (GraphPart p : avm2LocalData.ignoredSwitches.values()) {
            integerSwitchesIps.add(p.end);
        }
        for (GraphPart finallySwitchTarget : avm2LocalData.finallyJumps.values()) {
            if (avm2LocalData.defaultParts.values().contains(finallySwitchTarget)) continue;
            for (ThrowState ts : throwStates) {
                ts.throwingParts.remove(finallySwitchTarget);
            }
        }
        Map<Integer, Set<Integer>> setLocalPosToGetLocalPos = this.calculateLocalRegsUsage(throwStates, avm2LocalData, integerSwitchesIps, path, allParts);
        avm2LocalData.setLocalPosToGetLocalPos = setLocalPosToGetLocalPos;
        avm2LocalData.inGetLoops = true;
    }

    @Override
    protected void afterGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts) throws InterruptedException {
        ((AVM2LocalData)localData).inGetLoops = false;
    }

    private void getIgnoredSwitches(AVM2LocalData localData, Set<GraphPart> allParts) throws InterruptedException {
        for (int e = 0; e < this.body.exceptions.length; ++e) {
            ABCException ex = this.body.exceptions[e];
            if (!ex.isFinally()) continue;
            GraphPart finallyTryTargetPart = null;
            int targetIp = this.code.adr2pos(ex.target);
            for (GraphPart p : allParts) {
                if (targetIp < p.start || targetIp > p.end) continue;
                finallyTryTargetPart = p;
                break;
            }
            GraphPart finallyPart = finallyTryTargetPart.nextParts.size() > 0 ? finallyTryTargetPart.nextParts.get(0) : null;
            TranslateStack finallyTryTargetStack = new TranslateStack("try_target");
            AVM2LocalData localData2 = new AVM2LocalData(localData);
            localData2.localScopeStack = new ScopeStack();
            GraphPartMarkedArrayList<GraphTargetItem> targetOutput = new GraphPartMarkedArrayList<GraphTargetItem>();
            finallyTryTargetStack.setConnectedOutput(0, targetOutput, localData);
            try {
                this.translatePart(targetOutput, localData2, finallyTryTargetPart, finallyTryTargetStack, 0, "try_target");
            }
            catch (GraphPartChangeException ex1) {
                targetOutput.clear();
            }
            int switchedReg = -1;
            int finallyKind = -1;
            Integer finallyThrowPushByte = null;
            if (finallyTryTargetStack.size() == 1 && finallyTryTargetStack.peek() instanceof IntegerValueAVM2Item) {
                finallyKind = 0;
                finallyThrowPushByte = ((IntegerValueAVM2Item)finallyTryTargetStack.peek()).intValue();
            } else if (targetOutput.size() >= 2 && targetOutput.get(targetOutput.size() - 1) instanceof SetLocalAVM2Item && targetOutput.get(targetOutput.size() - 2) instanceof SetLocalAVM2Item && ((SetLocalAVM2Item)targetOutput.get((int)(targetOutput.size() - 1))).value instanceof IntegerValueAVM2Item) {
                SetLocalAVM2Item setLocal = (SetLocalAVM2Item)targetOutput.get(targetOutput.size() - 1);
                switchedReg = setLocal.regIndex;
                finallyThrowPushByte = ((IntegerValueAVM2Item)setLocal.value).intValue();
                finallyKind = 1;
            } else if (!targetOutput.isEmpty() && targetOutput.get(targetOutput.size() - 1) instanceof ThrowAVM2Item) {
                finallyKind = 2;
            }
            localData.finallyKinds.put(e, finallyKind);
            Integer defaultPushByte = null;
            GraphPart switchPart = null;
            if (finallyKind == 0) {
                int finEndIp;
                GraphPart prevFinallyEndPart;
                ArrayList<Integer> foundIps = new ArrayList<Integer>();
                ArrayList<GraphPart> foundParts = new ArrayList<GraphPart>();
                int stackAfter = localData.codeStats.instructionStats[finallyTryTargetPart.end].stackpos_after;
                this.findAllPops(localData, stackAfter, finallyPart, foundIps, foundParts, new HashSet<GraphPart>());
                block4: for (int i = 0; i < foundIps.size(); ++i) {
                    int ip = (Integer)foundIps.get(i);
                    if (this.avm2code.code.get((int)ip).definition instanceof LookupSwitchIns) {
                        switchPart = (GraphPart)foundParts.get(i);
                        continue;
                    }
                    if (!(this.avm2code.code.get((int)ip).definition instanceof PopIns)) continue;
                    GraphPart popPart = this.searchPart(ip, allParts);
                    boolean isEmpty = true;
                    --ip;
                    while (isEmpty) {
                        for (int j = ip; j >= popPart.start; --j) {
                            if (this.avm2code.code.get((int)j).definition instanceof LookupSwitchIns) {
                                switchPart = this.searchPart(j, allParts);
                                localData.finallyIndicesWithDoublePush.add(e);
                                break block4;
                            }
                            if (this.avm2code.code.get((int)j).definition instanceof LabelIns) continue;
                            isEmpty = false;
                            continue block4;
                        }
                        if (popPart.refs.size() != 1) continue block4;
                        popPart = popPart.refs.get(0);
                        ip = popPart.end;
                    }
                }
                if ((prevFinallyEndPart = this.searchPart(finEndIp = this.avm2code.adr2pos(ex.end, true) - 1, allParts)) != null) {
                    for (int j = prevFinallyEndPart.start; j <= prevFinallyEndPart.end; ++j) {
                        AVM2Instruction ins = this.avm2code.code.get(j);
                        if (ins.definition instanceof NopIns) continue;
                        if (ins.definition instanceof PushByteIns) {
                            defaultPushByte = ins.operands[0];
                            localData.pushDefaultPart.put(e, prevFinallyEndPart);
                            continue;
                        }
                        if (ins.definition instanceof JumpIns) continue;
                        if (localData.pushDefaultPart.containsKey(e)) {
                            localData.pushDefaultPart.remove(e);
                        }
                        defaultPushByte = null;
                        break;
                    }
                }
                if (defaultPushByte == null && prevFinallyEndPart != null && this.avm2code.code.get((int)prevFinallyEndPart.end).definition instanceof JumpIns) {
                    prevFinallyEndPart = prevFinallyEndPart.nextParts.get(0);
                    if (prevFinallyEndPart.nextParts.size() == 1 && prevFinallyEndPart.nextParts.get((int)0).refs.size() > 1) {
                        for (int j = prevFinallyEndPart.start; j <= prevFinallyEndPart.end; ++j) {
                            AVM2Instruction ins = this.avm2code.code.get(j);
                            if (ins.definition instanceof NopIns) continue;
                            if (!(ins.definition instanceof PushByteIns)) break;
                            defaultPushByte = ins.operands[0];
                            localData.pushDefaultPart.put(e, prevFinallyEndPart);
                            break;
                        }
                    }
                }
            } else if (finallyKind == 1) {
                GraphPart beforeTryPart;
                List<GraphPart> tryPartRefs;
                switchPart = this.findLookupSwitchWithGetLocal(switchedReg, finallyPart);
                int startIp = this.code.adr2pos(ex.start, true);
                GraphPart tryPart = this.searchPart(startIp, allParts);
                if (tryPart != null && (tryPartRefs = this.getRealRefs(tryPart)).size() == 1 && (beforeTryPart = tryPartRefs.get(0)).getHeight() >= 2) {
                    for (int pos = beforeTryPart.end; beforeTryPart.start <= pos; --pos) {
                        if (this.avm2code.code.get((int)pos).definition instanceof SetLocalTypeIns) {
                            int setLocalRegister = ((SetLocalTypeIns)this.avm2code.code.get((int)pos).definition).getRegisterId(this.avm2code.code.get(beforeTryPart.end));
                            if (setLocalRegister != switchedReg || !(this.avm2code.code.get((int)(pos - 1)).definition instanceof PushByteIns) || switchPart == null) break;
                            defaultPushByte = this.avm2code.code.get((int)(pos - 1)).operands[0];
                            break;
                        }
                        if (this.avm2code.code.get((int)pos).definition instanceof DebugLineIns) {
                            continue;
                        }
                        break;
                    }
                }
            }
            localData.switchedRegs.put(e, switchedReg);
            if (switchPart == null) continue;
            localData.defaultWays.put(switchPart, defaultPushByte);
            if (defaultPushByte != null) {
                GraphPart defaultPart = defaultPushByte == null || defaultPushByte < 0 || defaultPushByte > switchPart.nextParts.size() - 2 ? switchPart.nextParts.get(0) : switchPart.nextParts.get(1 + defaultPushByte);
                localData.defaultParts.put(e, defaultPart);
            }
            if (finallyThrowPushByte != null) {
                GraphPart finallyThrowPart = finallyThrowPushByte == null || finallyThrowPushByte < 0 || finallyThrowPushByte > switchPart.nextParts.size() - 2 ? switchPart.nextParts.get(0) : switchPart.nextParts.get(1 + finallyThrowPushByte);
                localData.finallyThrowParts.put(e, finallyThrowPart);
            }
            block10: for (GraphPart r : finallyPart.refs) {
                if (r.start < 0) continue;
                GraphPart rr = r;
                boolean needsPrev = true;
                while (true) {
                    for (int ip = rr.end; ip >= rr.start; --ip) {
                        AVM2Instruction ins = this.avm2code.code.get(ip);
                        if (ins.definition instanceof JumpIns) continue;
                        if (ins.definition instanceof PushByteIns) {
                            int val = ins.operands[0];
                            if (val < 0 || val > switchPart.nextParts.size() - 2) {
                                localData.finallyJumps.put(rr, switchPart.nextParts.get(0));
                            } else {
                                localData.finallyJumps.put(rr, switchPart.nextParts.get(1 + val));
                            }
                            localData.finallyJumpsToFinallyIndex.put(rr, e);
                            needsPrev = false;
                            break;
                        }
                        if (ins.definition instanceof SetLocalTypeIns && ((SetLocalTypeIns)ins.definition).getRegisterId(ins) == switchedReg || ins.definition instanceof CoerceAIns) continue;
                        needsPrev = false;
                        break;
                    }
                    if (!needsPrev) continue block10;
                    ArrayList<GraphPart> prevs = new ArrayList<GraphPart>();
                    for (GraphPart prevR : rr.refs) {
                        if (prevR.start < 0) continue;
                        prevs.add(prevR);
                    }
                    if (prevs.size() != 1) continue block10;
                    rr = (GraphPart)prevs.get(0);
                }
            }
            localData.ignoredSwitches.put(e, switchPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkLocalRegsUsage(List<ThrowState> throwStates, AVM2LocalData localData, Set<Integer> getLocalPos, GraphPart startPart, GraphPart part, Set<GraphPart> visited, int ip, int searchRegId) {
        block20: {
            block21: {
                GraphPart targetPart;
                block19: {
                    if (visited.contains(part) && part != startPart) {
                        return;
                    }
                    if (localData.finallyThrowParts.containsValue(part)) {
                        visited.add(part);
                        return;
                    }
                    for (int i = ip; i <= part.end; ++i) {
                        int regId2;
                        int regId;
                        AVM2Instruction aVM2Instruction = this.avm2code.code.get(i);
                        if (aVM2Instruction.definition instanceof SetLocalTypeIns && searchRegId == (regId = ((SetLocalTypeIns)aVM2Instruction.definition).getRegisterId(aVM2Instruction))) {
                            return;
                        }
                        if (aVM2Instruction.definition instanceof GetLocalTypeIns && (regId = ((GetLocalTypeIns)aVM2Instruction.definition).getRegisterId(aVM2Instruction)) == searchRegId) {
                            getLocalPos.add(i);
                        }
                        if ((aVM2Instruction.definition instanceof IncLocalIns || aVM2Instruction.definition instanceof IncLocalIIns || aVM2Instruction.definition instanceof IncLocalPIns || aVM2Instruction.definition instanceof DecLocalIns || aVM2Instruction.definition instanceof DecLocalIIns || aVM2Instruction.definition instanceof DecLocalPIns) && (regId = aVM2Instruction.operands[0]) == searchRegId) {
                            getLocalPos.add(i);
                        }
                        if ((aVM2Instruction.definition instanceof IncLocalPIns || aVM2Instruction.definition instanceof DecLocalPIns) && (regId = aVM2Instruction.operands[1]) == searchRegId) {
                            getLocalPos.add(i);
                        }
                        if (!(aVM2Instruction.definition instanceof HasNext2Ins)) continue;
                        int regId1 = aVM2Instruction.operands[0];
                        if (regId1 == searchRegId) {
                            getLocalPos.add(i);
                        }
                        if ((regId2 = aVM2Instruction.operands[1]) != searchRegId) continue;
                        getLocalPos.add(i);
                    }
                    if (visited.contains(part)) {
                        return;
                    }
                    visited.add(part);
                    if (!localData.ignoredSwitches.values().contains(part)) break block19;
                    for (ThrowState throwState : throwStates) {
                        if (!throwState.throwingParts.contains(part)) continue;
                        GraphPart p = throwState.targetPart;
                        this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, p, visited, p.start, searchRegId);
                    }
                    return;
                }
                if (!localData.finallyJumps.containsKey(part) || localData.defaultParts.containsValue(targetPart = localData.finallyJumps.get(part))) break block20;
                if (targetPart.nextParts.size() != 1) break block21;
                this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, targetPart.nextParts.get(0), visited, ip, searchRegId);
                for (ThrowState ts : throwStates) {
                    if (!ts.throwingParts.contains(part)) continue;
                    GraphPart p = ts.targetPart;
                    this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, p, visited, p.start, searchRegId);
                }
                return;
            }
            for (ThrowState ts : throwStates) {
                if (!ts.throwingParts.contains(part)) continue;
                GraphPart p = ts.targetPart;
                this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, p, visited, p.start, searchRegId);
            }
            return;
        }
        try {
            for (GraphPart graphPart : part.nextParts) {
                this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, graphPart, visited, graphPart.start, searchRegId);
            }
        }
        catch (Throwable throwable) {
            for (ThrowState ts : throwStates) {
                if (!ts.throwingParts.contains(part)) continue;
                GraphPart p = ts.targetPart;
                this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, p, visited, p.start, searchRegId);
            }
            throw throwable;
        }
        for (ThrowState throwState : throwStates) {
            if (!throwState.throwingParts.contains(part)) continue;
            GraphPart p = throwState.targetPart;
            this.walkLocalRegsUsage(throwStates, localData, getLocalPos, startPart, p, visited, p.start, searchRegId);
        }
    }

    public Map<Integer, Set<Integer>> calculateLocalRegsUsage(List<ThrowState> throwStates, AVM2LocalData localData, Set<Integer> ignoredSwitches, String path, Set<GraphPart> allParts) {
        this.logger.log(Level.FINE, "--- {0} ---", path);
        TreeMap<Integer, Set<Integer>> setLocalPosToGetLocalPos = new TreeMap<Integer, Set<Integer>>();
        HashMap<GraphPart, GraphPart> reverseFinallyJumps = new HashMap<GraphPart, GraphPart>();
        for (GraphPart p : localData.finallyJumps.keySet()) {
            reverseFinallyJumps.put(localData.finallyJumps.get(p), p);
        }
        HashMap<Integer, Integer> setLocalPosToRegisterId = new HashMap<Integer, Integer>();
        for (GraphPart p : allParts) {
            if (p.start < 0) continue;
            for (int ip = p.start; ip <= p.end; ++ip) {
                if (ip >= this.avm2code.code.size()) continue;
                AVM2Instruction ins = this.avm2code.code.get(ip);
                if (!(ins.definition instanceof SetLocalTypeIns)) continue;
                int regId = ((SetLocalTypeIns)ins.definition).getRegisterId(ins);
                setLocalPosToGetLocalPos.put(ip, new TreeSet());
                setLocalPosToRegisterId.put(ip, regId);
            }
        }
        Iterator<GraphPart> iterator = setLocalPosToGetLocalPos.keySet().iterator();
        while (iterator.hasNext()) {
            int ip = (Integer)((Object)iterator.next());
            GraphPart part = this.searchPart(ip + 1, allParts);
            if (part == null) continue;
            this.walkLocalRegsUsage(throwStates, localData, (Set)setLocalPosToGetLocalPos.get(ip), part, part, new HashSet<GraphPart>(), ip + 1, (Integer)setLocalPosToRegisterId.get(ip));
        }
        return setLocalPosToGetLocalPos;
    }

    public static List<GraphTargetItem> translateViaGraph(Set<String> usedDeobfuscations, int swfVersion, SecondPassData secondPassData, List<MethodBody> callStack, AbcIndexing abcIndex, String path, AVM2Code code, ABC abc, MethodBody body, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, ScopeStack scopeStack, HashMap<Integer, String> localRegNames, HashMap<Integer, GraphTargetItem> localRegTypes, List<DottedChain> fullyQualifiedNames, int staticOperation, HashMap<Integer, Integer> localRegAssignmentIps, boolean thisHasDefaultToPrimitive) throws InterruptedException {
        ScopeStack localScopeStack = new ScopeStack();
        AVM2Graph g = new AVM2Graph(swfVersion, abcIndex, code, abc, body, isStatic, scriptIndex, classIndex, localRegs, scopeStack, localScopeStack, localRegNames, fullyQualifiedNames, localRegAssignmentIps);
        AVM2LocalData localData = new AVM2LocalData();
        localData.secondPassData = secondPassData;
        localData.thisHasDefaultToPrimitive = thisHasDefaultToPrimitive;
        localData.isStatic = isStatic;
        localData.classIndex = classIndex;
        localData.localRegs = localRegs;
        localData.scopeStack = scopeStack;
        localData.localScopeStack = localScopeStack;
        localData.methodBody = body;
        localData.callStack = callStack;
        localData.abc = abc;
        localData.abcIndex = abcIndex;
        localData.localRegNames = localRegNames;
        localData.localRegTypes = localRegTypes;
        localData.fullyQualifiedNames = fullyQualifiedNames;
        localData.scriptIndex = scriptIndex;
        localData.ip = 0;
        localData.code = code;
        localData.swfVersion = swfVersion;
        localData.usedDeobfuscations = usedDeobfuscations;
        g.init(localData);
        HashSet<GraphPart> allParts = new HashSet<GraphPart>();
        for (GraphPart head : g.heads) {
            AVM2Graph.populateParts(head, allParts);
        }
        return g.translate(localData, staticOperation, path);
    }

    @Override
    protected void checkGraph(List<GraphPart> allBlocks) {
        for (ABCException ex : this.body.exceptions) {
            GraphPart targetPart = this.searchPart(this.avm2code.adr2pos(ex.target), allBlocks);
            for (GraphPart p : allBlocks) {
                if (this.avm2code.pos2adr(p.start) >= (long)ex.start && this.avm2code.pos2adr(p.end) <= (long)ex.end && targetPart == null) continue;
            }
        }
    }

    private GraphPart findLookupSwitchWithGetLocal(int registerId, GraphPart part, Set<GraphPart> visited) {
        int getLocalRegId;
        if (visited.contains(part)) {
            return null;
        }
        visited.add(part);
        if (part.getHeight() >= 3 && this.avm2code.code.get((int)part.end).definition instanceof LookupSwitchIns && this.avm2code.code.get((int)(part.end - 1)).definition instanceof ConvertIIns && this.avm2code.code.get((int)(part.end - 2)).definition instanceof GetLocalTypeIns && (getLocalRegId = ((GetLocalTypeIns)this.avm2code.code.get((int)(part.end - 2)).definition).getRegisterId(this.avm2code.code.get(part.end - 2))) == registerId) {
            return part;
        }
        for (GraphPart n : part.nextParts) {
            GraphPart found = this.findLookupSwitchWithGetLocal(registerId, n, visited);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private GraphPart findLookupSwitchWithGetLocal(int registerId, GraphPart part) {
        return this.findLookupSwitchWithGetLocal(registerId, part, new HashSet<GraphPart>());
    }

    private void findAllPops(AVM2LocalData localData, int stackLevel, GraphPart part, List<Integer> foundIps, List<GraphPart> foundParts, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        for (int ip = part.start; ip <= part.end; ++ip) {
            if (localData.codeStats.instructionStats[ip].stackpos_after != stackLevel - 1) continue;
            foundIps.add(ip);
            foundParts.add(part);
            return;
        }
        for (GraphPart n : part.nextParts) {
            this.findAllPops(localData, stackLevel, n, foundIps, foundParts, visited);
        }
    }

    private List<GraphPart> getRealRefs(GraphPart part) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (GraphPart r : part.refs) {
            if (r.start < 0) continue;
            ret.add(r);
        }
        return ret;
    }

    private GraphPart searchFirstPartOutSideTryCatch(AVM2LocalData localData, ABCException ex, List<Loop> loops, Collection<? extends GraphPart> allParts) {
        LinkedHashSet<GraphPart> reachable = new LinkedHashSet<GraphPart>();
        int startIp = localData.code.adr2pos(ex.start, true);
        int endIp = localData.code.adr2pos(ex.end, true);
        GraphPart startPart = this.searchPart(startIp, allParts);
        AVM2LocalData subLocalData = new AVM2LocalData(localData);
        subLocalData.defaultParts = new HashMap<Integer, GraphPart>();
        subLocalData.defaultWays = new HashMap<GraphPart, Integer>();
        subLocalData.finallyIndexToDefaultGraphPart = new HashMap<Integer, GraphPart>();
        subLocalData.finallyIndicesWithDoublePush = new HashSet<Integer>();
        subLocalData.finallyJumps = new HashMap<GraphPart, GraphPart>();
        subLocalData.finallyJumpsToFinallyIndex = new HashMap<GraphPart, Integer>();
        subLocalData.finallyThrowParts = new HashMap<Integer, GraphPart>();
        subLocalData.ignoredSwitches = new HashMap<Integer, GraphPart>();
        this.getReachableParts(subLocalData, startPart, reachable, loops, new ArrayList<ThrowState>());
        for (GraphPart r : reachable) {
            if (r.start >= startIp && r.start < endIp) continue;
            return r;
        }
        return null;
    }

    private GraphPart nearestNonEmptyPart(GraphPart part) {
        while (this.isPartEmpty(part)) {
            part = part.nextParts.get(0);
        }
        return part;
    }

    private void getCatchedExceptionIds(GraphPart part, List<Integer> previouslyCatchedExceptionIds, List<Integer> catchedExceptionIds, Reference<Integer> finallyIndex, Collection<? extends GraphPart> allParts, List<Loop> loops, AVM2LocalData localData) {
        long addr = this.avm2code.pos2adr(part.start);
        long maxEndAddr = -1L;
        finallyIndex.setVal(-1);
        ArrayList<Integer> finallysIndicesToBe = new ArrayList<Integer>();
        maxEndAddr = -1L;
        for (int e = 0; e < this.body.exceptions.length; ++e) {
            long fixedExStart = this.avm2code.pos2adr(this.avm2code.adr2pos(this.body.exceptions[e].start, true));
            long fixedExEnd = this.avm2code.pos2adr(this.avm2code.adr2pos(this.body.exceptions[e].end, true));
            if (previouslyCatchedExceptionIds.contains(e) || addr != fixedExStart) continue;
            ABCException ex = this.body.exceptions[e];
            if (ex.isFinally()) {
                if (fixedExEnd < maxEndAddr) continue;
                finallysIndicesToBe.add(e);
                continue;
            }
            long endAddr = fixedExEnd;
            if (endAddr > maxEndAddr) {
                catchedExceptionIds.clear();
                maxEndAddr = fixedExEnd;
                catchedExceptionIds.add(e);
                for (int k = 0; k < finallysIndicesToBe.size(); ++k) {
                    if ((long)this.body.exceptions[((Integer)finallysIndicesToBe.get((int)k)).intValue()].end >= endAddr) continue;
                    finallysIndicesToBe.remove(k);
                    --k;
                }
                continue;
            }
            if (endAddr != maxEndAddr) continue;
            catchedExceptionIds.add(e);
        }
        Collections.sort(finallysIndicesToBe, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return ((AVM2Graph)AVM2Graph.this).body.exceptions[o2.intValue()].end - ((AVM2Graph)AVM2Graph.this).body.exceptions[o1.intValue()].end;
            }
        });
        GraphPart outSideExceptionPart = null;
        if (!catchedExceptionIds.isEmpty()) {
            outSideExceptionPart = this.searchFirstPartOutSideTryCatch(localData, this.body.exceptions[catchedExceptionIds.get(0)], loops, allParts);
        }
        if (!finallysIndicesToBe.isEmpty()) {
            long maxEnd = 0L;
            int maxF = -1;
            Iterator iterator = finallysIndicesToBe.iterator();
            while (iterator.hasNext()) {
                int f = (Integer)iterator.next();
                long fixedExEnd = this.avm2code.pos2adr(this.avm2code.adr2pos(this.body.exceptions[f].end, true));
                if (fixedExEnd <= maxEnd) continue;
                maxEnd = fixedExEnd;
                maxF = f;
            }
            finallysIndicesToBe.clear();
            finallysIndicesToBe.add(maxF);
        }
        Iterator iterator = finallysIndicesToBe.iterator();
        while (iterator.hasNext()) {
            GraphPart outSideFinallyPart;
            int e = (Integer)iterator.next();
            ABCException finallyExceptionToBe = this.body.exceptions[e];
            if (catchedExceptionIds.isEmpty() || outSideExceptionPart == null) break;
            GraphPart outSideExceptionNonEmptyPart = this.nearestNonEmptyPart(outSideExceptionPart);
            if (outSideExceptionNonEmptyPart == (outSideFinallyPart = this.searchFirstPartOutSideTryCatch(localData, finallyExceptionToBe, loops, allParts))) {
                finallyIndex.setVal(e);
                break;
            }
            if (outSideExceptionNonEmptyPart.nextParts.size() != 1 || outSideExceptionNonEmptyPart.nextParts.get(0) != outSideFinallyPart) continue;
            boolean hashPushByteOnly = true;
            for (int ip = outSideExceptionNonEmptyPart.start; ip <= outSideExceptionNonEmptyPart.end; ++ip) {
                AVM2Instruction ins = this.avm2code.code.get(outSideExceptionNonEmptyPart.start);
                if (ins.definition instanceof PushByteIns || ins.definition instanceof JumpIns || ins.definition instanceof NopIns) continue;
                hashPushByteOnly = false;
            }
            if (!hashPushByteOnly) continue;
            finallyIndex.setVal(e);
            break;
        }
        if (finallyIndex.getVal() == -1 && !finallysIndicesToBe.isEmpty()) {
            catchedExceptionIds.clear();
            finallyIndex.setVal((Integer)finallysIndicesToBe.get(0));
        }
    }

    private GraphPart findNearestPartOutsideCatch(GraphPart tryTarget, Set<GraphPart> catchParts) {
        for (GraphPart p : catchParts) {
            for (GraphPart n : p.nextParts) {
                if (catchParts.contains(n)) continue;
                return n;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkTry(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, AVM2LocalData localData, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, Set<GraphPart> allParts, TranslateStack stack, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        if (localData.parsedExceptions == null) {
            localData.parsedExceptions = new ArrayList<ABCException>();
        }
        if (localData.finallyJumps == null) {
            localData.finallyJumps = new HashMap<GraphPart, GraphPart>();
        }
        if (localData.ignoredSwitches == null) {
            localData.ignoredSwitches = new HashMap<Integer, GraphPart>();
        }
        List<ABCException> parsedExceptions = localData.parsedExceptions;
        List<Integer> parsedExceptionIds = localData.parsedExceptionIds;
        ArrayList<Integer> catchedExceptionIds = new ArrayList<Integer>();
        Reference<Integer> finallyIndexRef = new Reference<Integer>(-1);
        this.getCatchedExceptionIds(part, parsedExceptionIds, catchedExceptionIds, finallyIndexRef, allParts, loops, localData);
        ArrayList<ABCException> catchedExceptions = new ArrayList<ABCException>();
        Iterator iterator = catchedExceptionIds.iterator();
        while (iterator.hasNext()) {
            int e = (Integer)iterator.next();
            catchedExceptions.add(this.body.exceptions[e]);
        }
        ABCException finallyException = null;
        int finallyIndex = finallyIndexRef.getVal();
        if (finallyIndex > -1) {
            finallyException = this.body.exceptions[finallyIndex];
        }
        if (finallyException != null) {
            catchedExceptions.add(finallyException);
            catchedExceptionIds.add(finallyIndex);
        }
        int switchedReg = -1;
        if (finallyIndex != -1) {
            int n = switchedReg = localData.switchedRegs.containsKey(finallyIndex) ? localData.switchedRegs.get(finallyIndex) : -1;
        }
        if (catchedExceptions.size() > 0) {
            for (ThrowState ts : throwStates) {
                if (catchedExceptionIds.contains(ts.exceptionId)) {
                    ts.state = 1;
                }
                if (ts.exceptionId != finallyIndex) continue;
                ts.state = 1;
            }
            parsedExceptions.addAll(catchedExceptions);
            parsedExceptionIds.addAll(catchedExceptionIds);
            if (finallyException != null) {
                catchedExceptions.remove(finallyException);
                catchedExceptionIds.remove((Object)finallyIndex);
            }
            if (finallyIndex > -1) {
                parsedExceptionIds.add(finallyIndex);
            }
            List<GraphTargetItem> tryCommands = new GraphPartMarkedArrayList<GraphTargetItem>();
            GraphPartMarkedArrayList<List<GraphTargetItem>> catchCommands = new GraphPartMarkedArrayList<List<GraphTargetItem>>();
            List<GraphTargetItem> finallyCommands = new GraphPartMarkedArrayList<GraphTargetItem>();
            GraphPart afterPart = null;
            ArrayList<GraphPart> partsToCalCommon = new ArrayList<GraphPart>();
            partsToCalCommon.add(part);
            for (ABCException ex : catchedExceptions) {
                partsToCalCommon.add(this.searchPart(localData.code.adr2pos(ex.target), allParts));
            }
            if (partsToCalCommon.size() > 1) {
                afterPart = this.getMostCommonPart(localData, partsToCalCommon, loops, throwStates, new ArrayList<GraphPart>());
            }
            if (catchedExceptions.size() > 0 && afterPart == null) {
                afterPart = this.searchFirstPartOutSideTryCatch(localData, (ABCException)catchedExceptions.get(0), loops, allParts);
            }
            ArrayList<GraphPart> catchAfterParts = new ArrayList<GraphPart>();
            if (afterPart == null) {
                for (int e = 0; e < catchedExceptions.size(); ++e) {
                    ABCException ex = (ABCException)catchedExceptions.get(e);
                    int eId = (Integer)catchedExceptionIds.get(e);
                    for (ThrowState ts : throwStates) {
                        GraphPart possibleAfter;
                        if (ts.exceptionId != eId || (possibleAfter = this.findNearestPartOutsideCatch(ts.targetPart, ts.catchParts)) == null || stopPart.contains(possibleAfter)) continue;
                        catchAfterParts.add(possibleAfter);
                    }
                }
                if (catchAfterParts.size() == 1) {
                    afterPart = (GraphPart)catchAfterParts.iterator().next();
                } else if (catchAfterParts.size() > 1) {
                    afterPart = this.getMostCommonPart(localData, catchAfterParts, loops, throwStates, stopPart);
                }
            }
            if (afterPart == part) {
                afterPart = null;
            }
            GraphPart exAfterPart = afterPart;
            if (finallyException == null) {
                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                if (afterPart != null) {
                    stopPart2.add(afterPart);
                    stopPartKind2.add(StopPartKind.OTHER);
                }
                for (Loop el : loops) {
                    if (el.loopContinue != part || el.phase != 1) continue;
                    el.phase = 4;
                }
                stack = (TranslateStack)stack.clone();
                tryCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, part, stopPart2, stopPartKind2, loops, throwStates, staticOperation, path);
            }
            boolean inlinedFinally = false;
            boolean finallyAsUnnamedException = false;
            GraphPartMarkedArrayList<GraphTargetItem> finallyTargetItems = new GraphPartMarkedArrayList<GraphTargetItem>();
            GraphPart defaultPart = null;
            GraphPart finallyPart = null;
            if (finallyException != null) {
                GraphPart switchPart = localData.ignoredSwitches.get(finallyIndex);
                if (switchPart != null) {
                    defaultPart = localData.defaultParts.containsKey(finallyIndex) ? localData.defaultParts.get(finallyIndex) : null;
                }
                localData.finallyIndexToDefaultGraphPart.put(finallyIndex, defaultPart);
                GraphPart finallyTryTargetPart = null;
                int targetPos = this.avm2code.adr2pos(finallyException.target);
                finallyTryTargetPart = this.searchPart(targetPos, allParts);
                GraphPart graphPart = finallyPart = finallyTryTargetPart.nextParts.isEmpty() ? null : finallyTryTargetPart.nextParts.get(0);
                if (finallyPart != null) {
                    // empty if block
                }
                if (afterPart != null) {
                    // empty if block
                }
                TranslateStack st2 = (TranslateStack)stack.clone();
                st2.clear();
                st2.add(new ExceptionAVM2Item(finallyException));
                AVM2LocalData aVM2LocalData = new AVM2LocalData(localData);
                aVM2LocalData.localScopeStack = new ScopeStack();
                try {
                    this.translatePart(finallyTargetItems, aVM2LocalData, finallyTryTargetPart, st2, staticOperation, path);
                }
                catch (GraphPartChangeException ex) {
                    finallyTargetItems.clear();
                }
                if (!finallyTargetItems.isEmpty() && finallyTargetItems.get(finallyTargetItems.size() - 1) instanceof ThrowAVM2Item) {
                    boolean isEmpty = true;
                    for (int i = 0; i < finallyTargetItems.size(); ++i) {
                        GraphTargetItem graphTargetItem = (GraphTargetItem)finallyTargetItems.get(i);
                        if (graphTargetItem instanceof SetTemporaryItem) {
                            if (graphTargetItem.value.getNotCoerced() instanceof ExceptionAVM2Item) continue;
                            isEmpty = false;
                            break;
                        }
                        if (graphTargetItem instanceof SetLocalAVM2Item) {
                            if (graphTargetItem.value.getNotCoerced() instanceof ExceptionAVM2Item) continue;
                            isEmpty = false;
                            break;
                        }
                        if (graphTargetItem instanceof ThrowAVM2Item || graphTargetItem instanceof IntegerValueAVM2Item) continue;
                        isEmpty = false;
                        break;
                    }
                    if (!isEmpty) {
                        inlinedFinally = true;
                    }
                }
                ArrayList<GraphPart> tryStopPart = new ArrayList<GraphPart>(stopPart);
                ArrayList<StopPartKind> tryStopPartKind = new ArrayList<StopPartKind>(stopPartKind);
                if (finallyPart != null) {
                    tryStopPart.add(finallyPart);
                    tryStopPartKind.add(StopPartKind.OTHER);
                }
                if (defaultPart != null) {
                    tryStopPart.add(defaultPart);
                    tryStopPartKind.add(StopPartKind.OTHER);
                }
                if (afterPart == null) {
                    afterPart = this.searchFirstPartOutSideTryCatch(localData, finallyException, loops, allParts);
                }
                if (afterPart != null) {
                    tryStopPart.add(afterPart);
                    tryStopPartKind.add(StopPartKind.OTHER);
                }
                if (switchPart != null) {
                    afterPart = defaultPart;
                } else {
                    if (!inlinedFinally) {
                        afterPart = null;
                    }
                    boolean bl = finallyAsUnnamedException = localData.finallyKinds.get(finallyIndex) == -1;
                }
                if (localData.pushDefaultPart.containsKey(finallyIndex)) {
                    exAfterPart = localData.pushDefaultPart.get(finallyIndex);
                    tryStopPart.add(exAfterPart);
                    tryStopPartKind.add(StopPartKind.OTHER);
                }
                tryCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, part, tryStopPart, tryStopPartKind, loops, throwStates, staticOperation, path);
                this.makeAllCommands(tryCommands, stack);
                this.processIfs(tryCommands);
                if (!tryCommands.isEmpty() && tryCommands.get(tryCommands.size() - 1) instanceof PushItem && tryCommands.get((int)(tryCommands.size() - 1)).value instanceof IntegerValueAVM2Item) {
                    tryCommands.remove(tryCommands.size() - 1);
                }
                ArrayList<GraphPart> arrayList = new ArrayList<GraphPart>(stopPart);
                ArrayList<StopPartKind> finallyStopPartKind = new ArrayList<StopPartKind>(stopPartKind);
                if (switchPart != null) {
                    arrayList.add(switchPart);
                    finallyStopPartKind.add(StopPartKind.OTHER);
                }
                if (finallyPart != null) {
                    finallyCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, finallyPart, arrayList, finallyStopPartKind, loops, throwStates, staticOperation, path);
                }
                if (switchPart != null) {
                    try {
                        this.translatePart(finallyCommands, localData, switchPart, stack, staticOperation, path);
                    }
                    catch (GraphPartChangeException ex) {
                        finallyCommands.clear();
                    }
                    if (!finallyCommands.isEmpty() && finallyCommands.get(finallyCommands.size() - 1) instanceof SetTemporaryItem) {
                        SetTemporaryItem st = (SetTemporaryItem)finallyCommands.get(finallyCommands.size() - 1);
                        if (st.value instanceof PopItem) {
                            finallyCommands.remove(finallyCommands.size() - 1);
                        }
                    }
                    stack.pop();
                    stack.pop();
                }
            }
            for (ABCException ex : catchedExceptions) {
                TranslateStack st2 = (TranslateStack)stack.clone();
                st2.clear();
                st2.add(new ExceptionAVM2Item(ex));
                GraphPart catchPart = null;
                for (GraphPart p : allParts) {
                    if (p.start != this.avm2code.adr2pos(ex.target)) continue;
                    catchPart = p;
                    break;
                }
                AVM2LocalData aVM2LocalData = new AVM2LocalData(localData);
                aVM2LocalData.localScopeStack = new ScopeStack();
                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                stopPart2.add(exAfterPart);
                stopPartKind2.add(StopPartKind.OTHER);
                if (defaultPart != null) {
                    stopPart2.add(defaultPart);
                    stopPartKind2.add(StopPartKind.OTHER);
                }
                for (GraphPart p : catchAfterParts) {
                    stopPart2.add(p);
                    stopPartKind2.add(StopPartKind.OTHER);
                }
                List<GraphTargetItem> list = this.printGraph(foundGotos, partCodes, partCodePos, visited, aVM2LocalData, st2, allParts, null, catchPart, stopPart2, stopPartKind2, loops, throwStates, staticOperation, path);
                st2.finishBlock(list);
                int tempExceptionPos = 0;
                if (!list.isEmpty() && list.get(0) instanceof WithAVM2Item) {
                    ++tempExceptionPos;
                }
                while (list.size() > tempExceptionPos && list.get(tempExceptionPos) instanceof SetTemporaryItem && list.get((int)tempExceptionPos).value.getNotCoerced() instanceof ExceptionAVM2Item) {
                    list.remove(tempExceptionPos);
                }
                block15: while (!list.isEmpty() && list.get(0) instanceof WithAVM2Item) {
                    WithAVM2Item w = (WithAVM2Item)list.get(0);
                    if (!(w.scope instanceof LocalRegAVM2Item)) break;
                    int regId = ((LocalRegAVM2Item)w.scope).regIndex;
                    for (GraphTargetItem item : localData.localScopeStack) {
                        if (!(item instanceof WithObjectAVM2Item)) continue;
                        WithObjectAVM2Item wo = (WithObjectAVM2Item)item;
                        if (!(wo.scope instanceof SetLocalAVM2Item)) continue;
                        SetLocalAVM2Item setLocal = (SetLocalAVM2Item)wo.scope;
                        if (setLocal.regIndex != regId) continue;
                        list.remove(0);
                        int setLocalIp = localData.code.adr2pos(setLocal.getSrc().getAddress());
                        int getLocalIp = localData.code.adr2pos(w.scope.getSrc().getAddress());
                        localData.setLocalPosToGetLocalPos.get(setLocalIp).remove(getLocalIp);
                        continue block15;
                    }
                }
                if (!list.isEmpty() && list.get(list.size() - 1) instanceof SetLocalAVM2Item) {
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)list.get(list.size() - 1);
                    if (setLocal.regIndex == switchedReg) {
                        list.remove(list.size() - 1);
                    }
                }
                catchCommands.add(list);
            }
            for (ThrowState ts : throwStates) {
                if (catchedExceptionIds.contains(ts.exceptionId)) {
                    ts.state = 2;
                }
                if (ts.exceptionId != finallyIndex) continue;
                ts.state = 2;
            }
            if (!inlinedFinally && catchCommands.isEmpty() && finallyCommands.isEmpty() && tryCommands.isEmpty()) {
                return false;
            }
            if (switchedReg != -1 && !currentRet.isEmpty() && currentRet.get(currentRet.size() - 1) instanceof SetLocalAVM2Item && ((SetLocalAVM2Item)currentRet.get((int)(currentRet.size() - 1))).regIndex == switchedReg) {
                currentRet.remove(currentRet.size() - 1);
            }
            if (!finallyAsUnnamedException && !inlinedFinally && catchedExceptions.isEmpty() && finallyCommands.isEmpty()) {
                currentRet.addAll(tryCommands);
                return true;
            }
            if (finallyAsUnnamedException) {
                catchedExceptions.add(finallyException);
                catchCommands.add(finallyCommands);
                finallyCommands = new ArrayList();
            }
            TryAVM2Item tryItem = new TryAVM2Item(tryCommands, catchedExceptions, catchCommands, finallyCommands, "");
            if (inlinedFinally) {
                ArrayList<List<GraphTargetItem>> parentCatchCommands = new ArrayList<List<GraphTargetItem>>();
                parentCatchCommands.add(finallyTargetItems);
                ArrayList<ABCException> parentCatchedExceptions = new ArrayList<ABCException>();
                parentCatchedExceptions.add(finallyException);
                ArrayList<GraphTargetItem> parentTryCommands = new ArrayList<GraphTargetItem>();
                if (catchedExceptions.isEmpty() && finallyCommands.isEmpty()) {
                    parentTryCommands.addAll(tryCommands);
                } else {
                    parentTryCommands.add(tryItem);
                }
                tryItem = new TryAVM2Item(parentTryCommands, parentCatchedExceptions, parentCatchCommands, new ArrayList<GraphTargetItem>(), "");
            }
            if (tryItem.catchCommands.isEmpty() && !tryItem.finallyCommands.isEmpty() && tryItem.tryCommands.size() == 1 && tryItem.tryCommands.get(0) instanceof TryAVM2Item && ((TryAVM2Item)tryItem.tryCommands.get((int)0)).finallyCommands.isEmpty()) {
                TryAVM2Item subTry = (TryAVM2Item)tryItem.tryCommands.get(0);
                tryItem = new TryAVM2Item(subTry.tryCommands, subTry.catchExceptions, subTry.catchCommands, tryItem.finallyCommands, "");
            }
            currentRet.add(tryItem);
            this.processIfs(tryItem.tryCommands);
            this.processIfs(tryItem.finallyCommands);
            for (List<GraphTargetItem> cc : tryItem.catchCommands) {
                this.processIfs(cc);
            }
            ArrayList<List<GraphTargetItem>> blocksToCheck = new ArrayList<List<GraphTargetItem>>();
            blocksToCheck.add(tryItem.tryCommands);
            blocksToCheck.addAll(tryItem.catchCommands);
            boolean allCntBreExit = true;
            for (List list : blocksToCheck) {
                if (list.isEmpty()) {
                    allCntBreExit = false;
                    break;
                }
                GraphTargetItem last = (GraphTargetItem)list.get(list.size() - 1);
                if (last instanceof ExitItem || last instanceof ContinueItem || last instanceof BreakItem || last instanceof GotoItem) continue;
                allCntBreExit = false;
                break;
            }
            if (allCntBreExit) {
                void var41_57;
                ContinueItem cnt;
                GraphTargetItem last;
                HashMap<Long, Integer> loopIdToCntCount = new HashMap<Long, Integer>();
                Object var41_56 = null;
                int maxCount = 0;
                for (List list : blocksToCheck) {
                    int newCount;
                    last = (GraphTargetItem)list.get(list.size() - 1);
                    if (!(last instanceof ContinueItem)) continue;
                    cnt = (ContinueItem)last;
                    if (!loopIdToCntCount.containsKey(cnt.loopId)) {
                        loopIdToCntCount.put(cnt.loopId, 0);
                    }
                    if ((newCount = (Integer)loopIdToCntCount.get(cnt.loopId) + 1) > maxCount) {
                        maxCount = newCount;
                        ContinueItem continueItem = cnt;
                    }
                    loopIdToCntCount.put(cnt.loopId, newCount);
                }
                if (var41_57 != null) {
                    for (List list : blocksToCheck) {
                        last = (GraphTargetItem)list.get(list.size() - 1);
                        if (!(last instanceof ContinueItem)) continue;
                        cnt = (ContinueItem)last;
                        if (cnt.loopId != var41_57.loopId) continue;
                        list.remove(list.size() - 1);
                    }
                    currentRet.add((GraphTargetItem)var41_57);
                }
            }
            if (afterPart != null) {
                if (finallyIndex > -1 && localData.finallyIndicesWithDoublePush.contains(finallyIndex)) {
                    stack.push(new AnyItem());
                }
                this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, afterPart, stopPart, stopPartKind, loops, throwStates, currentRet, staticOperation, path, recursionLevel);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean canHandleVisited(BaseLocalData localData, GraphPart part) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        for (ABCException ex : this.body.exceptions) {
            int fixStart;
            if (aLocalData.parsedExceptions.contains(ex) || part.start != (fixStart = this.avm2code.adr2pos(ex.start, true))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canHandleLoop(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) {
        Loop toBeLoop = null;
        for (Loop el : loops) {
            if (el.loopContinue != part || el.phase != 0) continue;
            toBeLoop = el;
            break;
        }
        if (toBeLoop == null) {
            return true;
        }
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        boolean inTry = false;
        for (ABCException ex : this.body.exceptions) {
            if (aLocalData.parsedExceptions.contains(ex)) continue;
            int fixStart = this.avm2code.adr2pos(ex.start, true);
            int fixEnd = this.avm2code.adr2pos(ex.end, true);
            if (part.start != fixStart) continue;
            inTry = true;
            for (GraphPart be : toBeLoop.backEdges) {
                if (be.start >= fixStart && be.start < fixEnd) continue;
                return true;
            }
        }
        return !inTry;
    }

    @Override
    protected boolean checkPartOutput(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, Loop currentLoop, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        return this.checkTry(currentRet, foundGotos, partCodes, partCodePos, visited, aLocalData, part, stopPart, stopPartKind, loops, throwStates, allParts, stack, staticOperation, path, recursionLevel);
    }

    @Override
    protected List<GraphTargetItem> check(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> output, Loop currentLoop, int staticOperation, String path) throws InterruptedException {
        ArrayList<GraphTargetItem> ret = null;
        if (part.nextParts.size() == 2 && !stack.isEmpty() && (stack.peek() instanceof StrictEqAVM2Item || stack.peek() instanceof StrictNeqAVM2Item)) {
            int n;
            int branchNum;
            BinaryOpItem set;
            GraphSourceItem switchStartItem = code.get(part.start);
            GraphTargetItem switchedObject = null;
            if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                switchedObject = ((SetLocalAVM2Item)output.get((int)(output.size() - 1))).value;
            }
            ArrayList<GraphTargetItem> caseValuesMapLeft = new ArrayList<GraphTargetItem>();
            ArrayList<GraphTargetItem> caseValuesMapRight = new ArrayList<GraphTargetItem>();
            ArrayList outs = new ArrayList();
            outs.add(new ArrayList());
            BinaryOpItem firstSet = set = (BinaryOpItem)stack.pop();
            caseValuesMapLeft.add(set.leftSide);
            caseValuesMapRight.add(set.rightSide);
            GraphPart origPart = part;
            ArrayList<GraphPart> caseBodyParts = new ArrayList<GraphPart>();
            if (((AVM2Instruction)code.get((int)part.end)).definition instanceof IfStrictNeIns) {
                branchNum = 0;
                caseBodyParts.add(part.nextParts.get(1));
            } else {
                branchNum = 1;
                caseBodyParts.add(part.nextParts.get(0));
            }
            GraphTargetItem top = null;
            int cnt = 1;
            int branchCount = 2;
            try {
                LinkedHashSet<GraphPart> ignoredParts = new LinkedHashSet<GraphPart>();
                for (Loop loop : loops) {
                    ignoredParts.add(loop.loopContinue);
                }
                while (true) {
                    ArrayList<GraphTargetItem> out = new ArrayList<GraphTargetItem>();
                    if (!ignoredParts.contains(part)) {
                        if (part.nextParts.size() == branchCount && part.nextParts.get(branchNum).getHeight() == 2 && ((AVM2Instruction)code.get((int)(part.nextParts.get((int)branchNum).start >= code.size() ? code.size() - 1 : part.nextParts.get((int)branchNum).start))).definition instanceof NopIns && ((AVM2Instruction)code.get((int)(part.nextParts.get((int)branchNum).end >= code.size() ? code.size() - 1 : part.nextParts.get((int)branchNum).end))).definition instanceof JumpIns) {
                            part = part.nextParts.get(branchNum);
                            branchNum = 0;
                            branchCount = 1;
                            continue;
                        }
                        if (part.nextParts.size() == branchCount && part.nextParts.get(branchNum).getHeight() > 1 && ((AVM2Instruction)code.get((int)(part.nextParts.get((int)branchNum).end >= code.size() ? code.size() - 1 : part.nextParts.get((int)branchNum).end))).definition instanceof IfStrictEqIns && (top = this.translatePartGetStack(localData, part.nextParts.get(branchNum), stack, staticOperation, out)) instanceof StrictEqAVM2Item) {
                            ++cnt;
                            part = part.nextParts.get(branchNum);
                            caseBodyParts.add(part.nextParts.get(0));
                            branchNum = 1;
                            outs.add(out);
                            out = new ArrayList();
                            set = (StrictEqAVM2Item)top;
                            caseValuesMapLeft.add(set.leftSide);
                            caseValuesMapRight.add(set.rightSide);
                            branchCount = 2;
                            continue;
                        }
                        if (part.nextParts.size() == branchCount && part.nextParts.get(branchNum).getHeight() > 1 && ((AVM2Instruction)code.get((int)(part.nextParts.get((int)branchNum).end >= code.size() ? code.size() - 1 : part.nextParts.get((int)branchNum).end))).definition instanceof IfStrictNeIns && (top = this.translatePartGetStack(localData, part.nextParts.get(branchNum), stack, staticOperation, out)) instanceof StrictNeqAVM2Item) {
                            ++cnt;
                            part = part.nextParts.get(branchNum);
                            caseBodyParts.add(part.nextParts.get(1));
                            branchNum = 0;
                            outs.add(out);
                            out = new ArrayList();
                            set = (StrictNeqAVM2Item)top;
                            caseValuesMapLeft.add(set.leftSide);
                            caseValuesMapRight.add(set.rightSide);
                            branchCount = 2;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (GraphPartChangeException ignoredParts) {
                // empty catch block
            }
            ArrayList<GraphTargetItem> caseValuesMap = caseValuesMapLeft;
            if (caseBodyParts.size() == 2) {
                boolean isIf = false;
                for (GraphPart r : part.refs) {
                    if (r == origPart || origPart.leadsTo(localData, this, code, r, loops, throwStates)) continue;
                    isIf = true;
                    break;
                }
                if (!isIf) {
                    for (GraphPart r : ((GraphPart)caseBodyParts.get((int)1)).refs) {
                        if (r == origPart || origPart.leadsTo(localData, this, code, r, loops, throwStates)) continue;
                        isIf = true;
                        break;
                    }
                }
                if (isIf) {
                    stack.push(firstSet);
                    return ret;
                }
            }
            int leftReg = -1;
            int n2 = -1;
            for (int cv = 0; cv < caseValuesMapLeft.size(); ++cv) {
                int reg;
                if (caseValuesMapLeft.get(cv) instanceof LocalRegAVM2Item) {
                    reg = ((LocalRegAVM2Item)caseValuesMapLeft.get((int)cv)).regIndex;
                    if (leftReg == -1) {
                        leftReg = reg;
                    } else if (leftReg != reg) {
                        leftReg = -2;
                    }
                }
                if (!(caseValuesMapRight.get(cv) instanceof LocalRegAVM2Item)) continue;
                reg = ((LocalRegAVM2Item)caseValuesMapRight.get((int)cv)).regIndex;
                if (n == -1) {
                    n = reg;
                    continue;
                }
                if (n == reg) continue;
                n = -2;
            }
            ArrayList otherSide = new ArrayList();
            if (leftReg > 0) {
                switchedObject = new LocalRegAVM2Item(null, null, leftReg, null, (GraphTargetItem)TypeItem.UNBOUNDED);
                caseValuesMap = caseValuesMapRight;
                otherSide = caseValuesMapLeft;
            } else if (n > 0) {
                switchedObject = new LocalRegAVM2Item(null, null, n, null, (GraphTargetItem)TypeItem.UNBOUNDED);
                otherSide = caseValuesMapRight;
            }
            for (int i = 0; i < caseValuesMap.size(); ++i) {
                if (((List)outs.get(i)).isEmpty()) continue;
                ((List)outs.get(i)).add(caseValuesMap.get(i));
                caseValuesMap.set(i, new CommaExpressionItem(this.dialect, null, null, (List)outs.get(i)));
            }
            if (leftReg < 0 && n < 0 || cnt == 1) {
                stack.push(firstSet);
            } else {
                GraphPart defaultPart = part = part.nextParts.get(branchNum);
                if (code.size() > defaultPart.start && ((AVM2Instruction)code.get((int)defaultPart.start)).definition instanceof JumpIns && defaultPart.refs.size() == 1 && !this.partIsLoopContBrePre(defaultPart, loops, throwStates)) {
                    defaultPart = defaultPart.nextParts.get(0);
                }
                Reference<Object> nextRef = new Reference<Object>(null);
                Reference<Object> tiRef = new Reference<Object>(null);
                this.makeAllCommands(output, stack);
                SwitchItem sw = this.handleSwitch(switchedObject, switchStartItem, foundGotos, partCodes, partCodePos, visited, allParts, stack, stopPart, stopPartKind, loops, throwStates, localData, staticOperation, path, caseValuesMap, defaultPart, caseBodyParts, nextRef, tiRef);
                ret = new ArrayList<GraphTargetItem>();
                ret.addAll(output);
                this.checkSwitch(localData, sw, otherSide, ret.isEmpty() ? currentRet : ret);
                ret.add(sw);
                if (nextRef.getVal() != null) {
                    if (tiRef.getVal() != null) {
                        ret.add(tiRef.getVal());
                    } else {
                        ret.addAll(this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, nextRef.getVal(), stopPart, stopPartKind, loops, throwStates, staticOperation, path));
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected List<GraphPart> getNextParts(BaseLocalData localData, GraphPart part) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        return super.getNextParts(localData, part);
    }

    @Override
    protected GraphPart checkPartWithOutput(List<GraphTargetItem> output, TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        if (aLocalData.finallyJumps == null) {
            aLocalData.finallyJumps = new HashMap<GraphPart, GraphPart>();
        }
        if (aLocalData.ignoredSwitches == null) {
            aLocalData.ignoredSwitches = new HashMap<Integer, GraphPart>();
        }
        if (aLocalData.finallyThrowParts.containsValue(part)) {
            return null;
        }
        if (prev != null) {
            if (!aLocalData.inGetLoops && aLocalData.ignoredSwitches.containsValue(prev)) {
                return null;
            }
            if (aLocalData.finallyJumps.containsKey(prev)) {
                GraphPart switchPart = null;
                int switchedReg = -1;
                for (GraphPart gp : aLocalData.finallyJumps.get((Object)prev).refs) {
                    if (!aLocalData.ignoredSwitches.containsValue(gp)) continue;
                    int finallyIndex = -1;
                    for (int fi : aLocalData.ignoredSwitches.keySet()) {
                        if (aLocalData.ignoredSwitches.get(fi) != gp) continue;
                        finallyIndex = fi;
                        break;
                    }
                    switchPart = gp;
                    switchedReg = aLocalData.switchedRegs.containsKey(finallyIndex) ? aLocalData.switchedRegs.get(finallyIndex) : -1;
                    break;
                }
                if (output != null && switchedReg > -1 && !output.isEmpty() && output.get(output.size() - 1) instanceof SetLocalAVM2Item) {
                    SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(output.size() - 1);
                    if (setLocal.regIndex == switchedReg) {
                        output.remove(output.size() - 1);
                    }
                }
                int finallyIndex = aLocalData.finallyJumpsToFinallyIndex.get(prev);
                if (output != null && aLocalData.finallyIndicesWithDoublePush.contains(finallyIndex)) {
                    GraphPart defaultPart;
                    GraphPart graphPart = defaultPart = aLocalData.finallyIndexToDefaultGraphPart.containsKey(finallyIndex) ? aLocalData.finallyIndexToDefaultGraphPart.get(finallyIndex) : null;
                    if (defaultPart == null) {
                        stack.push(new AnyItem());
                    } else if (defaultPart != aLocalData.finallyJumps.get(prev)) {
                        stack.push(new AnyItem());
                    }
                }
                if (output != null && switchedReg == -1 && !stack.isEmpty() && stack.peek() instanceof IntegerValueAVM2Item) {
                    stack.pop();
                } else if (output != null && switchedReg == -1 && !output.isEmpty() && output.get(output.size() - 1) instanceof IntegerValueAVM2Item) {
                    output.remove(output.size() - 1);
                }
                return aLocalData.finallyJumps.get(prev);
            }
        }
        return part;
    }

    @Override
    protected GraphPart checkPart(TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        return this.checkPartWithOutput(null, stack, localData, prev, part, allParts);
    }

    @Override
    protected boolean isPartEmpty(GraphPart part) {
        if (part.nextParts.size() > 1) {
            return false;
        }
        if (part.start < 0) {
            return false;
        }
        for (int ip = part.start; ip <= part.end; ++ip) {
            if (this.avm2code.code.get((int)ip).definition instanceof DebugLineIns || this.avm2code.code.get((int)ip).definition instanceof JumpIns) continue;
            return false;
        }
        return true;
    }

    @Override
    protected GraphTargetItem checkLoop(List<GraphTargetItem> output, LoopItem loopItem, BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates, TranslateStack stack) {
        if (this.debugDoNotProcess) {
            return loopItem;
        }
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        if (loopItem instanceof WhileItem) {
            WhileItem w = (WhileItem)loopItem;
            if (!w.expression.isEmpty() && w.expression.get(w.expression.size() - 1) instanceof HasNextAVM2Item) {
                final HasNextAVM2Item hn = (HasNextAVM2Item)w.expression.get(w.expression.size() - 1);
                if (hn.obj != null) {
                    if (hn.obj.getNotCoerced().getThroughRegister().getNotCoerced() instanceof FilteredCheckAVM2Item) {
                        int pushnum = 0;
                        for (int i = output.size() - 2; i >= 0 && output.get(i) instanceof PushItem; --i) {
                            ++pushnum;
                        }
                        int rem = output.size() - 1 - pushnum;
                        for (int i = output.size() - 1 - pushnum; i <= output.size() - 2; ++i) {
                            stack.push(((PushItem)output.remove((int)rem)).value);
                        }
                        if (w.commands.size() >= 3) {
                            int pos = 0;
                            HashSet<Integer> localRegsToKill = new HashSet<Integer>();
                            while (w.commands.get(pos) instanceof SetLocalAVM2Item) {
                                if (w.commands.get((int)pos).value instanceof NextValueAVM2Item) {
                                    NextValueAVM2Item nextValueItem = (NextValueAVM2Item)w.commands.get((int)pos).value;
                                    if (nextValueItem.index instanceof LocalRegAVM2Item) {
                                        localRegsToKill.add(((LocalRegAVM2Item)nextValueItem.index).regIndex);
                                    }
                                    if (nextValueItem.obj instanceof LocalRegAVM2Item) {
                                        localRegsToKill.add(((LocalRegAVM2Item)nextValueItem.obj).regIndex);
                                    }
                                }
                                ++pos;
                            }
                            GraphTargetItem ft = w.commands.get(pos);
                            if (ft instanceof WithAVM2Item) {
                                WithAVM2Item wi = (WithAVM2Item)ft;
                                if (wi.scope instanceof SetLocalAVM2Item && wi.scope.value instanceof NextValueAVM2Item) {
                                    NextValueAVM2Item nextValueItem = (NextValueAVM2Item)wi.scope.value;
                                    if (nextValueItem.index instanceof LocalRegAVM2Item) {
                                        localRegsToKill.add(((LocalRegAVM2Item)nextValueItem.index).regIndex);
                                    }
                                    if (nextValueItem.obj instanceof LocalRegAVM2Item) {
                                        localRegsToKill.add(((LocalRegAVM2Item)nextValueItem.obj).regIndex);
                                    }
                                }
                                ++pos;
                                ArrayList<GraphTargetItem> withCommands = new ArrayList<GraphTargetItem>();
                                while (pos < w.commands.size() && !(w.commands.get(pos) instanceof WithEndAVM2Item)) {
                                    withCommands.add(w.commands.get(pos));
                                    ++pos;
                                }
                                GraphTargetItem expr = null;
                                int getLocalObjectIp = -1;
                                int regIndex = -1;
                                HashMap<Integer, GraphTargetItem> localRegs = aLocalData.localRegs;
                                if (!withCommands.isEmpty()) {
                                    if (withCommands.get(withCommands.size() - 1) instanceof IfItem) {
                                        IfItem ift = (IfItem)withCommands.get(withCommands.size() - 1);
                                        if (ift.onTrue.size() > 0 && (ft = ift.onTrue.get(0)) instanceof SetPropertyAVM2Item) {
                                            SetPropertyAVM2Item spt = (SetPropertyAVM2Item)ft;
                                            if (spt.object instanceof LocalRegAVM2Item) {
                                                getLocalObjectIp = this.avm2code.adr2pos(spt.object.getSrc().getAddress());
                                                regIndex = ((LocalRegAVM2Item)spt.object).regIndex;
                                            }
                                        }
                                        expr = ift.expression.getNotCoerced();
                                        if (withCommands.size() > 1) {
                                            withCommands.remove(withCommands.size() - 1);
                                            withCommands.add(expr);
                                            expr = new CommaExpressionItem(this.dialect, null, localData.lineStartInstruction, withCommands);
                                        }
                                    } else {
                                        withCommands.add(new FalseItem(this.dialect, null, localData.lineStartInstruction));
                                        expr = new CommaExpressionItem(this.dialect, null, localData.lineStartInstruction, withCommands);
                                    }
                                } else {
                                    expr = new FalseItem(this.dialect, null, localData.lineStartInstruction);
                                }
                                FilteredCheckAVM2Item filteredCheck = (FilteredCheckAVM2Item)hn.obj.getThroughRegister().getNotCoerced();
                                FilterAVM2Item filter = new FilterAVM2Item(null, null, filteredCheck.object, expr);
                                if (regIndex == -1) {
                                    for (int i = output.size() - 2; i >= 0; --i) {
                                        if (output.get(i) instanceof SetLocalAVM2Item) {
                                            SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(i);
                                            if (!(setLocal.value instanceof ConstructAVM2Item)) continue;
                                            ConstructAVM2Item construct = (ConstructAVM2Item)setLocal.value;
                                            boolean isXMLList = false;
                                            if (construct.object instanceof GetPropertyAVM2Item) {
                                                GetPropertyAVM2Item gpt = (GetPropertyAVM2Item)construct.object;
                                                if (gpt.object instanceof FindPropertyAVM2Item) {
                                                    FindPropertyAVM2Item fpt = (FindPropertyAVM2Item)gpt.object;
                                                    FullMultinameAVM2Item fptXmlMult = (FullMultinameAVM2Item)fpt.propertyName;
                                                    FullMultinameAVM2Item gptXmlMult = (FullMultinameAVM2Item)gpt.propertyName;
                                                    try {
                                                        isXMLList = fptXmlMult.isTopLevel("XMLList", aLocalData.abc, aLocalData.localRegNames, aLocalData.fullyQualifiedNames, aLocalData.seenMethods) && gptXmlMult.isTopLevel("XMLList", aLocalData.abc, aLocalData.localRegNames, aLocalData.fullyQualifiedNames, aLocalData.seenMethods);
                                                    }
                                                    catch (InterruptedException interruptedException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (construct.object instanceof GetLexAVM2Item) {
                                                GetLexAVM2Item glt = (GetLexAVM2Item)construct.object;
                                                isXMLList = glt.propertyName.getName(new LinkedHashSet<String>(), aLocalData.abc, aLocalData.getConstants(), aLocalData.fullyQualifiedNames, true, true).equals("XMLList");
                                            }
                                            if (!isXMLList) continue;
                                            regIndex = setLocal.regIndex;
                                            continue;
                                        }
                                        if (!(output.get(i) instanceof PushItem)) break;
                                    }
                                }
                                localRegsToKill.add(regIndex);
                                if (hn.obj instanceof LocalRegAVM2Item) {
                                    localRegsToKill.add(((LocalRegAVM2Item)hn.obj).regIndex);
                                }
                                int setLocalIp = -1;
                                for (int i = output.size() - 2; i >= 0; --i) {
                                    if (output.get(i) instanceof SetLocalAVM2Item) {
                                        SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(i);
                                        if (setLocal.regIndex != regIndex) continue;
                                        setLocalIp = this.avm2code.adr2pos(setLocal.getSrc().getAddress());
                                        break;
                                    }
                                    if (!(output.get(i) instanceof PushItem)) break;
                                }
                                HashSet<Object> usages = new HashSet();
                                if (setLocalIp > -1) {
                                    usages = new HashSet<Integer>(aLocalData.getSetLocalUsages(setLocalIp));
                                    usages.remove(getLocalObjectIp);
                                }
                                for (int i = output.size() - 2; i >= 0 && !localRegsToKill.isEmpty(); --i) {
                                    if (output.get(i) instanceof SetLocalAVM2Item) {
                                        SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(i);
                                        if (localRegsToKill.contains(setLocal.regIndex)) {
                                            output.remove(i);
                                        }
                                        if (setLocal.regIndex != regIndex) continue;
                                        setLocal.value = filter;
                                        continue;
                                    }
                                    if (!(output.get(i) instanceof PushItem)) break;
                                }
                                int firstPushPos = -1;
                                int i = output.size() - 2;
                                while (i >= 0 && output.get(i) instanceof PushItem) {
                                    firstPushPos = i--;
                                }
                                if (firstPushPos > -1) {
                                    int max = output.size() - 2;
                                    for (int i2 = firstPushPos; i2 <= max; ++i2) {
                                        PushItem pu = (PushItem)output.remove(firstPushPos);
                                        stack.push(pu.value);
                                    }
                                }
                                if (usages.isEmpty()) {
                                    output.add(filter);
                                } else {
                                    localRegs.put(regIndex, filter);
                                }
                                return null;
                            }
                        }
                    } else if (!w.commands.isEmpty()) {
                        if (w.commands.get(0) instanceof SetTypeAVM2Item) {
                            int nextNameUsage;
                            NextNameAVM2Item nextName;
                            int nextValUsage;
                            NextValueAVM2Item nextVal;
                            int hnUsageIp;
                            HashSet<Integer> objUsages;
                            int setLocalIp;
                            SetLocalAVM2Item setLocal;
                            int i;
                            SetTypeAVM2Item sti = (SetTypeAVM2Item)((Object)w.commands.remove(0));
                            GraphTargetItem gti = sti.getValue().getNotCoerced();
                            GraphTargetItem varName = sti.getObject();
                            GraphTargetItem collection = hn.obj;
                            if (hn.obj instanceof LocalRegAVM2Item) {
                                int objRegIndex = ((LocalRegAVM2Item)hn.obj).regIndex;
                                for (i = output.size() - 2; i >= 0 && output.get(i) instanceof SetLocalAVM2Item; --i) {
                                    LocalRegAVM2Item nextValObjReg;
                                    setLocal = (SetLocalAVM2Item)output.get(i);
                                    if (setLocal.regIndex != objRegIndex) continue;
                                    setLocalIp = aLocalData.code.adr2pos(setLocal.getSrc().getAddress());
                                    objUsages = new HashSet<Integer>(aLocalData.getSetLocalUsages(setLocalIp));
                                    hnUsageIp = aLocalData.code.adr2pos(hn.getSrc().getAddress());
                                    objUsages.remove(hnUsageIp);
                                    if (gti instanceof NextValueAVM2Item) {
                                        nextVal = (NextValueAVM2Item)gti;
                                        if (nextVal.obj instanceof LocalRegAVM2Item) {
                                            nextValObjReg = (LocalRegAVM2Item)nextVal.obj;
                                            if (nextValObjReg.regIndex == objRegIndex) {
                                                nextValUsage = aLocalData.code.adr2pos(nextValObjReg.getSrc().getAddress());
                                                objUsages.remove(nextValUsage);
                                            }
                                        }
                                    }
                                    if (gti instanceof NextNameAVM2Item) {
                                        nextName = (NextNameAVM2Item)gti;
                                        if (nextName.obj instanceof LocalRegAVM2Item) {
                                            nextValObjReg = (LocalRegAVM2Item)nextName.obj;
                                            if (nextValObjReg.regIndex == objRegIndex) {
                                                nextNameUsage = aLocalData.code.adr2pos(nextValObjReg.getSrc().getAddress());
                                                objUsages.remove(nextNameUsage);
                                            }
                                        }
                                    }
                                    if (!objUsages.isEmpty()) continue;
                                    output.remove(i);
                                    collection = setLocal.value;
                                }
                            }
                            if (hn.index instanceof LocalRegAVM2Item) {
                                int indexRegIndex = ((LocalRegAVM2Item)hn.index).regIndex;
                                for (i = output.size() - 2; i >= 0 && output.get(i) instanceof SetLocalAVM2Item; --i) {
                                    LocalRegAVM2Item nextValIndexReg;
                                    setLocal = (SetLocalAVM2Item)output.get(i);
                                    if (setLocal.regIndex != indexRegIndex) continue;
                                    setLocalIp = aLocalData.code.adr2pos(setLocal.getSrc().getAddress());
                                    objUsages = new HashSet<Integer>(aLocalData.getSetLocalUsages(setLocalIp));
                                    hnUsageIp = aLocalData.code.adr2pos(hn.getSrc().getAddress());
                                    objUsages.remove(hnUsageIp);
                                    if (gti instanceof NextValueAVM2Item) {
                                        nextVal = (NextValueAVM2Item)gti;
                                        if (nextVal.index instanceof LocalRegAVM2Item) {
                                            nextValIndexReg = (LocalRegAVM2Item)nextVal.index;
                                            if (nextValIndexReg.regIndex == indexRegIndex) {
                                                nextValUsage = aLocalData.code.adr2pos(nextValIndexReg.getSrc().getAddress());
                                                objUsages.remove(nextValUsage);
                                            }
                                        }
                                    }
                                    if (gti instanceof NextNameAVM2Item) {
                                        nextName = (NextNameAVM2Item)gti;
                                        if (nextName.index instanceof LocalRegAVM2Item) {
                                            nextValIndexReg = (LocalRegAVM2Item)nextName.index;
                                            if (nextValIndexReg.regIndex == indexRegIndex) {
                                                nextNameUsage = aLocalData.code.adr2pos(nextValIndexReg.getSrc().getAddress());
                                                objUsages.remove(nextNameUsage);
                                            }
                                        }
                                    }
                                    if (!objUsages.isEmpty()) continue;
                                    output.remove(i);
                                }
                            }
                            if (gti instanceof NextValueAVM2Item) {
                                return new ForEachInAVM2Item(w.getSrc(), w.getLineStartItem(), w.loop, new InAVM2Item((GraphSourceItem)hn.getInstruction(), (GraphSourceItem)hn.getLineStartIns(), varName, collection), w.commands);
                            }
                            if (gti instanceof NextNameAVM2Item) {
                                return new ForInAVM2Item(w.getSrc(), w.getLineStartItem(), w.loop, new InAVM2Item((GraphSourceItem)hn.getInstruction(), (GraphSourceItem)hn.getLineStartIns(), varName, collection), w.commands);
                            }
                        } else {
                            GraphTargetItem first = w.commands.get(0);
                            final Reference<Integer> kindRef = new Reference<Integer>(0);
                            first.visitRecursively(new AbstractGraphTargetVisitor(){
                                private boolean handled = false;

                                @Override
                                public boolean visit(GraphTargetItem item) {
                                    if (this.handled) {
                                        return false;
                                    }
                                    if (item instanceof NextNameAVM2Item || item instanceof NextValueAVM2Item) {
                                        this.handled = true;
                                        if (item instanceof NextValueAVM2Item) {
                                            NextValueAVM2Item nv = (NextValueAVM2Item)item;
                                            nv.localReg = hn.index;
                                            kindRef.setVal(1);
                                        }
                                        if (item instanceof NextNameAVM2Item) {
                                            NextNameAVM2Item nn = (NextNameAVM2Item)item;
                                            nn.localReg = hn.index;
                                            kindRef.setVal(2);
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                            });
                            if (kindRef.getVal() == 1) {
                                return new ForEachInAVM2Item(w.getSrc(), w.getLineStartItem(), w.loop, new InAVM2Item((GraphSourceItem)hn.getInstruction(), (GraphSourceItem)hn.getLineStartIns(), hn.index, hn.obj), w.commands);
                            }
                            if (kindRef.getVal() == 2) {
                                return new ForInAVM2Item(w.getSrc(), w.getLineStartItem(), w.loop, new InAVM2Item((GraphSourceItem)hn.getInstruction(), (GraphSourceItem)hn.getLineStartIns(), hn.index, hn.obj), w.commands);
                            }
                        }
                    }
                }
            }
        }
        return loopItem;
    }

    @Override
    protected void processOther(List<GraphTargetItem> list, long lastLoopId) {
        if (list.isEmpty()) {
            return;
        }
        int pos = list.size() - 1;
        if (list.get(pos) instanceof ContinueItem) {
            if (((ContinueItem)list.get((int)pos)).loopId != lastLoopId) {
                return;
            }
            --pos;
            if (list.size() < 2) {
                return;
            }
        }
        if (list.get(pos) instanceof TryAVM2Item) {
            ContinueItem ci;
            TryAVM2Item ta = (TryAVM2Item)list.get(pos);
            for (List<GraphTargetItem> cc : ta.catchCommands) {
                if (cc.isEmpty() || !(cc.get(cc.size() - 1) instanceof ContinueItem)) continue;
                ContinueItem ci2 = (ContinueItem)cc.get(cc.size() - 1);
                if (ci2.loopId != lastLoopId) continue;
                cc.remove(cc.size() - 1);
            }
            if (!ta.tryCommands.isEmpty() && ta.tryCommands.get(ta.tryCommands.size() - 1) instanceof ContinueItem) {
                ci = (ContinueItem)ta.tryCommands.get(ta.tryCommands.size() - 1);
                if (ci.loopId == lastLoopId) {
                    ta.tryCommands.remove(ta.tryCommands.size() - 1);
                }
            }
            if (!ta.finallyCommands.isEmpty() && ta.finallyCommands.get(ta.finallyCommands.size() - 1) instanceof ContinueItem) {
                ci = (ContinueItem)ta.finallyCommands.get(ta.finallyCommands.size() - 1);
                if (ci.loopId == lastLoopId) {
                    ta.finallyCommands.remove(ta.finallyCommands.size() - 1);
                }
            }
        }
    }

    @Override
    protected void finalProcessAfter(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) {
        super.finalProcessAfter(list, level, localData, path);
        for (int i = 0; i < list.size(); ++i) {
            int setLocalIp;
            Set<Integer> usages;
            if (!(list.get(i) instanceof SetTypeAVM2Item) || !(((SetTypeAVM2Item)((Object)list.get(i))).getValue().getThroughDuplicate() instanceof ExceptionAVM2Item)) continue;
            boolean doRemove = false;
            if (list.get(i) instanceof SetSlotAVM2Item) {
                doRemove = true;
            }
            if (list.get(i) instanceof SetLocalAVM2Item && (usages = localData.getRegisterUsage(setLocalIp = this.avm2code.adr2pos(list.get(i).getSrc().getAddress()))).isEmpty()) {
                doRemove = true;
            }
            if (!doRemove) continue;
            list.remove(i);
            --i;
        }
    }

    private boolean isIntegerOrPopInteger(GraphTargetItem item) {
        return item instanceof IntegerValueAVM2Item;
    }

    @Override
    protected void finalProcess(GraphTargetItem parent, List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        int i;
        if (this.debugDoNotProcess) {
            return;
        }
        block0: for (int i2 = 1; i2 < list.size(); ++i2) {
            GraphTargetItem item = list.get(i2);
            GraphTargetItem prevItem = list.get(i2 - 1);
            if (!(item instanceof SwitchItem) || !(prevItem instanceof SwitchItem)) continue;
            SwitchItem thisSwitch = (SwitchItem)item;
            SwitchItem prevSwitch = (SwitchItem)prevItem;
            if (!(thisSwitch.switchedObject instanceof PopItem)) continue;
            ArrayList caseValues = new ArrayList();
            LinkedHashMap<Integer, GraphTargetItem> expressionsMap = new LinkedHashMap<Integer, GraphTargetItem>();
            Object defaultCommands = null;
            for (int k = 0; k < thisSwitch.caseValues.size(); ++k) {
                if (!(thisSwitch.caseValues.get(k) instanceof DefaultItem) && !(thisSwitch.caseValues.get(k) instanceof IntegerValueTypeItem)) continue block0;
            }
            int defaultInt = -1;
            for (int j = 0; j < prevSwitch.caseCommands.size(); ++j) {
                int valueIndex = prevSwitch.valuesMapping.indexOf(j);
                if (valueIndex == -1) continue block0;
                GraphTargetItem currentExpression = prevSwitch.caseValues.get(valueIndex);
                if (prevSwitch.caseCommands.get(j).size() > 2) continue block0;
                int delta = 0;
                if (currentExpression instanceof DefaultItem && prevSwitch.caseCommands.size() >= 2 && prevSwitch.caseCommands.get(j).get(0) instanceof IfItem) {
                    IfItem ifi = (IfItem)prevSwitch.caseCommands.get(j).get(0);
                    if (ifi.expression instanceof FalseItem) {
                        ++delta;
                    }
                }
                if (j != prevSwitch.caseCommands.size() - 1 || prevSwitch.caseCommands.get(j).size() != delta + 1) {
                    if (prevSwitch.caseCommands.get(j).size() != 2 + delta || !(prevSwitch.caseCommands.get(j).get(delta + 1) instanceof BreakItem)) continue block0;
                    BreakItem br = (BreakItem)prevSwitch.caseCommands.get(j).get(delta + 1);
                    if (br.loopId != prevSwitch.loop.id) continue block0;
                }
                if (!(prevSwitch.caseCommands.get(j).get(delta) instanceof PushItem)) continue block0;
                PushItem pi = (PushItem)prevSwitch.caseCommands.get(j).get(delta);
                if (!(pi.value instanceof IntegerValueTypeItem)) continue block0;
                Integer pushedInt = ((IntegerValueTypeItem)((Object)pi.value)).intValue();
                expressionsMap.put(pushedInt, currentExpression);
                if (!(currentExpression instanceof DefaultItem)) continue;
                defaultInt = pushedInt;
            }
            int defaultIndex = -1;
            for (int k = 0; k < thisSwitch.caseValues.size(); ++k) {
                if (thisSwitch.caseValues.get(k) instanceof DefaultItem) {
                    defaultIndex = k;
                    continue;
                }
                if (!(thisSwitch.caseValues.get(k) instanceof IntegerValueTypeItem)) continue block0;
            }
            if (defaultIndex > -1 && !thisSwitch.additionalDefaultValues.isEmpty() && thisSwitch.additionalDefaultPosition > -1) {
                int defaultBodyIndex = thisSwitch.valuesMapping.get(defaultIndex);
                if (thisSwitch.additionalDefaultPosition != defaultIndex) {
                    GraphTargetItem lastCmd;
                    int previousBodyIndex = thisSwitch.valuesMapping.get(thisSwitch.additionalDefaultPosition);
                    List<GraphTargetItem> defaultBody = thisSwitch.caseCommands.remove(defaultBodyIndex);
                    thisSwitch.caseCommands.add(previousBodyIndex, defaultBody);
                    for (int p = 0; p < thisSwitch.valuesMapping.size(); ++p) {
                        if (thisSwitch.valuesMapping.get(p) < previousBodyIndex) continue;
                        thisSwitch.valuesMapping.set(p, thisSwitch.valuesMapping.get(p) + 1);
                    }
                    defaultBodyIndex = previousBodyIndex;
                    GraphTargetItem graphTargetItem = lastCmd = defaultBody.isEmpty() ? null : defaultBody.get(defaultBody.size() - 1);
                    if (!(lastCmd == null || lastCmd instanceof ExitItem || lastCmd instanceof BreakItem || lastCmd instanceof ContinueItem)) {
                        defaultBody.add(new BreakItem(thisSwitch.dialect, null, null, thisSwitch.loop.id));
                    }
                }
                thisSwitch.caseValues.remove(defaultIndex);
                thisSwitch.valuesMapping.remove(defaultIndex);
                thisSwitch.caseValues.add(thisSwitch.additionalDefaultPosition, new DefaultItem(thisSwitch.dialect));
                thisSwitch.valuesMapping.add(thisSwitch.additionalDefaultPosition, defaultBodyIndex);
                for (int m = thisSwitch.additionalDefaultValues.size() - 1; m >= 0; --m) {
                    thisSwitch.caseValues.add(thisSwitch.additionalDefaultPosition, thisSwitch.additionalDefaultValues.get(m));
                    thisSwitch.valuesMapping.add(thisSwitch.additionalDefaultPosition, defaultBodyIndex);
                }
            }
            ArrayList<Integer> thisExpressions = new ArrayList<Integer>();
            for (int k = 0; k < thisSwitch.caseValues.size(); ++k) {
                if (thisSwitch.caseValues.get(k) instanceof DefaultItem) continue;
                if (!(thisSwitch.caseValues.get(k) instanceof IntegerValueTypeItem)) continue block0;
                int cv = ((IntegerValueTypeItem)((Object)thisSwitch.caseValues.get(k))).intValue();
                thisExpressions.add(cv);
            }
            ArrayList<Integer> noCaseExpressions = new ArrayList<Integer>();
            Iterator cv = expressionsMap.keySet().iterator();
            while (cv.hasNext()) {
                int key = (Integer)cv.next();
                if (thisExpressions.contains(key)) continue;
                noCaseExpressions.add(key);
            }
            noCaseExpressions.sort(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1 - o2;
                }
            });
            for (int k = 0; k < thisSwitch.caseValues.size(); ++k) {
                if (thisSwitch.caseValues.get(k) instanceof DefaultItem) {
                    int h;
                    int m = thisSwitch.valuesMapping.get(k);
                    thisSwitch.caseValues.remove(k);
                    thisSwitch.valuesMapping.remove(k);
                    Iterator pushedInt = noCaseExpressions.iterator();
                    while (pushedInt.hasNext()) {
                        int e = (Integer)pushedInt.next();
                        thisSwitch.caseValues.add(k, (GraphTargetItem)expressionsMap.get(e));
                        thisSwitch.valuesMapping.add(k, m);
                        ++k;
                    }
                    --k;
                    boolean foundElsewhere = false;
                    for (h = 0; h < thisSwitch.valuesMapping.size(); ++h) {
                        if (thisSwitch.valuesMapping.get(h) != m) continue;
                        foundElsewhere = true;
                        break;
                    }
                    if (foundElsewhere) continue;
                    thisSwitch.caseCommands.remove(m);
                    for (h = 0; h < thisSwitch.valuesMapping.size(); ++h) {
                        if (thisSwitch.valuesMapping.get(h) <= m) continue;
                        thisSwitch.valuesMapping.set(h, thisSwitch.valuesMapping.get(h) - 1);
                    }
                    continue;
                }
                int cv2 = ((IntegerValueTypeItem)((Object)thisSwitch.caseValues.get(k))).intValue();
                if (!expressionsMap.containsKey(cv2)) {
                    thisSwitch.removeValue(k);
                    --k;
                    continue;
                }
                thisSwitch.caseValues.set(k, (GraphTargetItem)expressionsMap.get(cv2));
            }
            thisSwitch.switchedObject = prevSwitch.switchedObject;
            list.remove(i2 - 1);
            --i2;
            this.fixSwitchEnd(thisSwitch);
        }
        if (level == 0 && !list.isEmpty() && list.get(list.size() - 1) instanceof ReturnVoidAVM2Item) {
            list.remove(list.size() - 1);
        }
        if (level == 0) {
            HashMap<Integer, String> localRegNames = this.body.getLocalRegNames(this.abc);
            block12: for (int i3 = 0; i3 < list.size(); ++i3) {
                Object aLocalData;
                if (list.get(i3) instanceof SetPropertyAVM2Item) {
                    SetPropertyAVM2Item sp = (SetPropertyAVM2Item)list.get(i3);
                    if (sp.object instanceof FindPropertyAVM2Item && sp.propertyName instanceof FullMultinameAVM2Item) {
                        FullMultinameAVM2Item propName = (FullMultinameAVM2Item)sp.propertyName;
                        if (sp.value instanceof LocalRegAVM2Item) {
                            LocalRegAVM2Item lr = (LocalRegAVM2Item)sp.value;
                            aLocalData = (AVM2FinalProcessLocalData)localData;
                            if (Objects.equals(propName.resolvedMultinameName, AVM2Item.localRegName(this.abc.getSwf(), ((AVM2FinalProcessLocalData)aLocalData).localRegNames, lr.regIndex, new LinkedHashSet<String>()))) {
                                list.remove(i3);
                                --i3;
                                continue;
                            }
                        }
                    }
                }
                if (!(list.get(i3) instanceof SetSlotAVM2Item)) continue;
                SetSlotAVM2Item sslot = (SetSlotAVM2Item)list.get(i3);
                if (!(sslot.slotObject instanceof NewActivationAVM2Item)) continue;
                String slotName = sslot.slotName.getName(new LinkedHashSet<String>(), this.abc, this.abc.constants, new ArrayList<DottedChain>(), true, true);
                if (!(sslot.value.getNotCoercedNoDup() instanceof LocalRegAVM2Item)) continue;
                LocalRegAVM2Item locReg = (LocalRegAVM2Item)sslot.value.getNotCoercedNoDup();
                if (!localRegNames.containsValue(slotName)) continue;
                aLocalData = localRegNames.keySet().iterator();
                while (aLocalData.hasNext()) {
                    int regIndex = (Integer)aLocalData.next();
                    if (!slotName.equals(localRegNames.get(regIndex)) || locReg.regIndex != regIndex) continue;
                    list.remove(i3);
                    --i3;
                    continue block12;
                }
            }
        }
        List<GraphTargetItem> ret = list;
        for (i = 0; i < list.size(); ++i) {
            List<GraphTargetItem> nextbody;
            HasNextAVM2Item hnt;
            if (!(list.get(i) instanceof IfItem)) continue;
            IfItem ifi = (IfItem)list.get(i);
            if (!(ifi.expression instanceof HasNextAVM2Item) && (!(ifi.expression instanceof NotItem) || !(((NotItem)ifi.expression).getOriginal() instanceof HasNextAVM2Item))) continue;
            List<Object> body = new ArrayList<GraphTargetItem>();
            if (ifi.expression instanceof NotItem) {
                hnt = (HasNextAVM2Item)((NotItem)ifi.expression).getOriginal();
                body.addAll(ifi.onFalse);
                int j = i + 1;
                while (j < list.size()) {
                    body.add(list.remove(i + 1));
                }
                nextbody = ifi.onTrue;
            } else {
                hnt = (HasNextAVM2Item)ifi.expression;
                body = ifi.onTrue;
                nextbody = ifi.onFalse;
            }
            if (body.isEmpty() || !(body.get(0) instanceof SetTypeAVM2Item)) continue;
            SetTypeAVM2Item sti = (SetTypeAVM2Item)body.remove(0);
            GraphTargetItem gti = sti.getValue().getNotCoerced();
            LoopItem repl = null;
            if (gti instanceof NextValueAVM2Item) {
                repl = new ForEachInAVM2Item(ifi.getSrc(), ifi.getLineStartItem(), new Loop(0L, null, null), new InAVM2Item(null, null, sti.getObject(), hnt.obj), body);
            } else if (gti instanceof NextNameAVM2Item) {
                repl = new ForInAVM2Item(ifi.getSrc(), ifi.getLineStartItem(), new Loop(0L, null, null), new InAVM2Item(null, null, sti.getObject(), hnt.obj), body);
            }
            if (repl == null) continue;
            list.remove(i);
            list.add(i, repl);
            list.addAll(i + 1, nextbody);
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof WithAVM2Item) {
                SetLocalAVM2Item setLocal;
                int setLocalIp;
                WithAVM2Item wa = (WithAVM2Item)list.get(i);
                if (wa.scope instanceof SetLocalAVM2Item && localData.getRegisterUsage(setLocalIp = this.avm2code.adr2pos((setLocal = (SetLocalAVM2Item)wa.scope).getSrc().getAddress())).isEmpty()) {
                    for (int j = i + 1; j < list.size(); ++j) {
                        if (!(list.get(j) instanceof WithEndAVM2Item)) continue;
                        WithEndAVM2Item we = (WithEndAVM2Item)list.get(j);
                        if (we.scope != wa.scope) continue;
                        wa.scope = we.scope = setLocal.value;
                    }
                }
            }
            if (list.get(i) instanceof SetLocalAVM2Item) {
                SetLocalAVM2Item ri = (SetLocalAVM2Item)list.get(i);
                int setLocalIp = this.avm2code.adr2pos(ri.getSrc().getAddress());
                Set<Integer> usages = localData.getRegisterUsage(setLocalIp);
                if (ri.value.getNotCoerced() instanceof ExceptionAVM2Item) {
                    ExceptionAVM2Item ea = (ExceptionAVM2Item)ri.value.getNotCoerced();
                    if (ea.exception.isFinally()) {
                        list.remove(i);
                        localData.temporaryRegisters.add(ri.regIndex);
                        --i;
                        continue;
                    }
                }
                if (i + 1 < list.size()) {
                    if (list.get(i + 1) instanceof ReturnValueAVM2Item && list.get((int)(i + 1)).value instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)list.get((int)(i + 1)).value).regIndex == ri.regIndex) {
                        ReturnValueAVM2Item r = (ReturnValueAVM2Item)list.get(i + 1);
                        r.value = ri.value;
                        list.remove(i);
                        --i;
                        continue;
                    }
                    if (list.get(i + 1) instanceof ThrowAVM2Item && list.get((int)(i + 1)).value instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)list.get((int)(i + 1)).value).regIndex == ri.regIndex) {
                        ThrowAVM2Item t = (ThrowAVM2Item)list.get(i + 1);
                        t.value = ri.value;
                        list.remove(i);
                        --i;
                        continue;
                    }
                }
                int numPushes = 0;
                while (i + 1 + numPushes < list.size() && this.isIntegerOrPopInteger(list.get(i + 1 + numPushes))) {
                    ++numPushes;
                }
                if (numPushes > 0) {
                    if (i + 1 + numPushes < list.size()) {
                        int n;
                        if (numPushes > 0 && list.get(i + 1 + numPushes) instanceof ReturnValueAVM2Item && list.get((int)(i + 1 + numPushes)).value instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)list.get((int)(i + 1 + numPushes)).value).regIndex == ri.regIndex) {
                            ReturnValueAVM2Item r = (ReturnValueAVM2Item)list.get(i + 1 + numPushes);
                            r.value = ri.value;
                            for (n = 0; n < numPushes; ++n) {
                                list.remove(i + 1);
                            }
                            list.remove(i);
                            --i;
                            continue;
                        }
                        if (numPushes > 0 && list.get(i + 1 + numPushes) instanceof ThrowAVM2Item && list.get((int)(i + 1 + numPushes)).value instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)list.get((int)(i + 1 + numPushes)).value).regIndex == ri.regIndex) {
                            ThrowAVM2Item t = (ThrowAVM2Item)list.get(i + 1 + numPushes);
                            t.value = ri.value;
                            for (n = 0; n < numPushes; ++n) {
                                list.remove(i + 1);
                            }
                            list.remove(i);
                            --i;
                            continue;
                        }
                    } else if (i + numPushes < list.size() && usages.isEmpty()) {
                        for (int n = 0; n < numPushes; ++n) {
                            list.remove(i + 1);
                        }
                        list.remove(i);
                        --i;
                        continue;
                    }
                }
            }
            if (!(list.get(i) instanceof ContinueItem) && !(list.get(i) instanceof BreakItem) && !(list.get(i) instanceof ReturnVoidAVM2Item)) continue;
            for (int j = i - 1; j >= 0 && this.isIntegerOrPopInteger(list.get(j)); --j) {
                list.remove(j);
                --i;
            }
        }
        final AVM2FinalProcessLocalData adata = (AVM2FinalProcessLocalData)localData;
        if (!adata.bottomSetLocals.isEmpty()) {
            boolean modified = false;
            for (int i4 = 0; i4 < list.size(); ++i4) {
                if (list.get(i4) instanceof LoopItem || list.get(i4) instanceof WithEndAVM2Item) continue;
                final ArrayList foundSetLoc = new ArrayList();
                final ArrayList ignoredItems = new ArrayList();
                list.get(i4).visitRecursivelyNoBlock(new AbstractGraphTargetRecursiveVisitor(){

                    @Override
                    public void visit(GraphTargetItem item, Stack<GraphTargetItem> parentStack) {
                        if (item instanceof AndItem || item instanceof OrItem) {
                            BinaryOpItem bo = (BinaryOpItem)item;
                            bo.getRightSide().visitRecursivelyNoBlock(new AbstractGraphTargetRecursiveVisitor(){

                                @Override
                                public void visit(GraphTargetItem item, Stack<GraphTargetItem> parentStack) {
                                    if (item instanceof SetLocalAVM2Item && adata.bottomSetLocals.contains((SetLocalAVM2Item)item)) {
                                        ignoredItems.add((SetLocalAVM2Item)item);
                                    }
                                }
                            });
                        }
                    }
                });
                list.get(i4).visitRecursivelyNoBlock(new AbstractGraphTargetRecursiveVisitor(){

                    @Override
                    public void visit(GraphTargetItem item, Stack<GraphTargetItem> parentStack) {
                        if (item instanceof SetLocalAVM2Item && adata.bottomSetLocals.contains((SetLocalAVM2Item)item) && !ignoredItems.contains((SetLocalAVM2Item)item)) {
                            int s = parentStack.size() - 1;
                            if (parentStack.get(s) instanceof CoerceAVM2Item) {
                                --s;
                            } else if (parentStack.get(s) instanceof ConvertAVM2Item) {
                                --s;
                            }
                            if (s >= 0) {
                                SetTypeAVM2Item setType;
                                GraphTargetItem parent = (GraphTargetItem)parentStack.get(s);
                                boolean move = true;
                                if (parent instanceof SetTypeAVM2Item && (setType = (SetTypeAVM2Item)((Object)parent)).getValue().getNotCoerced() == item) {
                                    move = false;
                                }
                                if (move) {
                                    foundSetLoc.add(0, (SetLocalAVM2Item)item);
                                }
                            }
                        }
                    }
                });
                for (SetLocalAVM2Item setLoc : foundSetLoc) {
                    list.add(i4, setLoc.clone());
                    setLoc.hideValue = true;
                    ++i4;
                    modified = true;
                    adata.bottomSetLocals.remove(setLoc);
                }
            }
            if (modified && parent instanceof WhileItem) {
                WhileItem wi = (WhileItem)parent;
                if (wi.expression == list && !list.isEmpty()) {
                    GraphTargetItem lastExpr = list.remove(list.size() - 1);
                    ArrayList<GraphTargetItem> onTrue = new ArrayList<GraphTargetItem>();
                    BreakItem bi = new BreakItem(this.dialect, null, null, wi.loop.id);
                    onTrue.add(bi);
                    IfItem ifi = new IfItem(this.dialect, null, null, lastExpr.invert(null), onTrue, new ArrayList<GraphTargetItem>());
                    list.add(ifi);
                    wi.commands.addAll(0, list);
                    list.clear();
                    list.add(new TrueItem(this.dialect, null, null));
                }
            }
        }
        super.finalProcess(parent, list, level, localData, path);
    }

    @Override
    protected FinalProcessLocalData getFinalData(BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates) {
        AVM2FinalProcessLocalData finalProcess = new AVM2FinalProcessLocalData(loops, ((AVM2LocalData)localData).localRegNames, ((AVM2LocalData)localData).setLocalPosToGetLocalPos, ((AVM2LocalData)localData).bottomSetLocals);
        finalProcess.registerUsage = ((AVM2LocalData)localData).setLocalPosToGetLocalPos;
        return finalProcess;
    }

    @Override
    public AVM2LocalData prepareBranchLocalData(BaseLocalData localData) {
        AVM2LocalData aLocalData = (AVM2LocalData)localData;
        AVM2LocalData ret = new AVM2LocalData(aLocalData);
        ScopeStack copyScopeStack = new ScopeStack();
        copyScopeStack.addAll(ret.localScopeStack);
        ret.localScopeStack = copyScopeStack;
        return ret;
    }

    @Override
    protected void checkSwitch(BaseLocalData localData, SwitchItem switchItem, Collection<? extends GraphTargetItem> otherSides, List<GraphTargetItem> output) {
        if (output.isEmpty()) {
            return;
        }
        if (!(output.get(output.size() - 1) instanceof SetLocalAVM2Item)) {
            return;
        }
        AVM2LocalData avm2LocalData = (AVM2LocalData)localData;
        SetLocalAVM2Item setLocal = (SetLocalAVM2Item)output.get(output.size() - 1);
        int setLocalIp = InstructionDefinition.getItemIp(avm2LocalData, setLocal);
        HashSet<Integer> allUsages = new HashSet<Integer>(avm2LocalData.getSetLocalUsages(setLocalIp));
        boolean isOtherSideReg = false;
        for (GraphTargetItem graphTargetItem : otherSides) {
            if (!(graphTargetItem instanceof LocalRegAVM2Item)) continue;
            LocalRegAVM2Item otherLog = (LocalRegAVM2Item)graphTargetItem;
            if (otherLog.regIndex != setLocal.regIndex) break;
            int getLocalIp = InstructionDefinition.getItemIp(avm2LocalData, otherLog);
            allUsages.remove(getLocalIp);
            isOtherSideReg = true;
        }
        if (!isOtherSideReg) {
            return;
        }
        if (allUsages.isEmpty()) {
            output.remove(output.size() - 1);
            switchItem.switchedObject = setLocal.value;
        }
    }

    @Override
    protected boolean partIsSwitch(GraphPart part) {
        if (part.end < 0) {
            return false;
        }
        if (part.end >= this.avm2code.code.size()) {
            return false;
        }
        return this.avm2code.code.get((int)part.end).definition instanceof LookupSwitchIns;
    }

    @Override
    protected List<ThrowState> getThrowStates(BaseLocalData localData, Set<GraphPart> allParts) {
        AVM2LocalData avm2LocalData = (AVM2LocalData)localData;
        avm2LocalData.codeStats = avm2LocalData.code.getStats(avm2LocalData.abc, avm2LocalData.methodBody, avm2LocalData.methodBody.init_scope_depth, false);
        ArrayList<ThrowState> ret = new ArrayList<ThrowState>();
        for (int e = 0; e < this.body.exceptions.length; ++e) {
            int ip;
            ThrowState ts = new ThrowState();
            ts.exceptionId = e;
            ts.state = 0;
            ts.targetPart = this.searchPart(this.code.adr2pos(this.body.exceptions[e].target), allParts);
            int startIp = this.code.adr2pos(this.body.exceptions[e].start, true);
            int endIp = this.code.adr2pos(this.body.exceptions[e].end, true);
            ts.startPart = this.searchPart(startIp, allParts);
            for (GraphPart p : allParts) {
                if (p.start < startIp || p.start >= endIp) continue;
                ts.throwingParts.add(p);
            }
            GraphPart part = ts.targetPart;
            boolean wasNewCatch = false;
            int scopePos = -1;
            for (ip = part.start; ip <= part.end; ++ip) {
                if (this.avm2code.code.get((int)ip).definition instanceof NewCatchIns) {
                    wasNewCatch = true;
                }
                if (this.avm2code.code.get((int)ip).definition instanceof PushScopeIns && wasNewCatch) {
                    scopePos = avm2LocalData.codeStats.instructionStats[ip].scopepos_after;
                    break;
                }
                if (ip != part.end || part.nextParts.size() != 1 || part.nextParts.get((int)0).refs.size() != 1) continue;
                part = part.nextParts.get(0);
                ip = part.start - 1;
            }
            HashSet<GraphPart> catchParts = new HashSet<GraphPart>();
            if (scopePos > -1) {
                this.walkCatchParts(avm2LocalData.codeStats, part, ip, catchParts, scopePos, allParts, this.body.exceptions[e].isFinally());
            } else {
                this.logger.fine("No newcatch..pushscope found in catch, probably swftools");
                part = ts.targetPart;
                int localRegId = -1;
                for (ip = part.start; ip <= part.end; ++ip) {
                    AVM2Instruction ins = this.avm2code.code.get(ip);
                    if (!(ins.definition instanceof NopIns || ins.definition instanceof DebugLineIns || ins.definition instanceof JumpIns)) {
                        if (!(ins.definition instanceof SetLocalTypeIns)) break;
                        localRegId = ((SetLocalTypeIns)ins.definition).getRegisterId(ins);
                        break;
                    }
                    if (ip != part.end || part.nextParts.size() != 1 || part.nextParts.get((int)0).refs.size() != 1) continue;
                    part = part.nextParts.get(0);
                    ip = part.start - 1;
                }
                if (localRegId == -1) {
                    this.logger.fine("Not even local reg assignment found in catch, weird :-(");
                } else {
                    this.walkCatchPartsReg(localRegId, part, ip + 1, catchParts, new ArrayList<GraphPart>(), new HashSet<GraphPart>());
                }
            }
            ts.catchParts = catchParts;
            ret.add(ts);
        }
        return ret;
    }

    private void walkCatchPartsReg(int registerId, GraphPart part, int startIp, Set<GraphPart> catchParts, List<GraphPart> path, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        ArrayList<GraphPart> newPath = new ArrayList<GraphPart>(path);
        newPath.add(part);
        for (int ip = startIp; ip <= part.end; ++ip) {
            int getLocalId;
            int killId;
            int setLocalId;
            AVM2Instruction ins = this.avm2code.code.get(ip);
            if (ins.definition instanceof SetLocalTypeIns && (setLocalId = ((SetLocalTypeIns)ins.definition).getRegisterId(ins)) == registerId) {
                return;
            }
            if (ins.definition instanceof KillIns && (killId = ins.operands[0]) == registerId) {
                return;
            }
            if (!(ins.definition instanceof GetLocalTypeIns) || (getLocalId = ((GetLocalTypeIns)ins.definition).getRegisterId(ins)) != registerId) continue;
            catchParts.addAll(newPath);
        }
        for (GraphPart n : part.nextParts) {
            this.walkCatchPartsReg(registerId, n, n.start, catchParts, newPath, visited);
        }
    }

    private void walkCatchParts(CodeStats stats, GraphPart part, int startIp, Set<GraphPart> catchParts, int scopePos, Set<GraphPart> allParts, boolean isFinally) {
        if (catchParts.contains(part)) {
            return;
        }
        for (int ip = startIp; ip <= part.end; ++ip) {
            if (stats.instructionStats[ip].scopepos_after >= scopePos) continue;
            if (ip >= 0 && ip < this.code.size()) {
                boolean onlyKillJump = true;
                for (int j = ip + 1; j <= part.end; ++j) {
                    AVM2Instruction ins = (AVM2Instruction)this.code.get(j);
                    if (ins.definition instanceof KillIns || ins.definition instanceof JumpIns || ins.definition instanceof DebugLineIns) continue;
                    onlyKillJump = false;
                    break;
                }
                if (onlyKillJump) {
                    catchParts.add(part);
                    return;
                }
            }
            if (ip < part.end && !isFinally) {
                GraphPart secondPart = new GraphPart(ip + 1, part.end);
                part.end = ip;
                for (GraphPart n : part.nextParts) {
                    n.refs.remove(part);
                    n.refs.add(secondPart);
                }
                secondPart.nextParts.addAll(part.nextParts);
                part.nextParts.clear();
                part.nextParts.add(secondPart);
                secondPart.refs.add(part);
                secondPart.discoveredTime = part.discoveredTime;
                secondPart.closedTime = part.closedTime;
                secondPart.finishedTime = part.finishedTime;
                secondPart.level = part.level;
                secondPart.numBlocks = part.numBlocks;
                secondPart.order = part.order;
                secondPart.path = part.path;
                allParts.add(secondPart);
            }
            catchParts.add(part);
            return;
        }
        catchParts.add(part);
        for (GraphPart n : part.nextParts) {
            this.walkCatchParts(stats, n, n.start, catchParts, scopePos, allParts, isFinally);
        }
    }

    @Override
    public void makeAllCommands(List<GraphTargetItem> commands, TranslateStack stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!(stack.get(i) instanceof NewFunctionAVM2Item)) continue;
            stack.remove(i);
            --i;
        }
        super.makeAllCommands(commands, stack);
    }

    @Override
    protected SecondPassData prepareSecondPass(List<GraphTargetItem> list) {
        return new SecondPassData();
    }

    @Override
    protected GraphTargetItem getIfExpression(BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output) {
        GraphTargetItem result = stack.pop();
        if (stack.getMark("firstSetLocal") != null) {
            SetLocalAVM2Item setLocal = (SetLocalAVM2Item)stack.getMark("firstSetLocal");
            if (setLocal.directlyCausedByDup) {
                output.add(setLocal.clone());
                setLocal.hideValue = true;
            }
        }
        return result;
    }

    @Override
    protected GraphTargetItem handleTernar(TernarOpItem ternar, BaseLocalData localData) {
        if (localData.swfVersion < 50) {
            return ternar;
        }
        if (ternar.expression instanceof EqAVM2Item) {
            EqAVM2Item eq = (EqAVM2Item)ternar.expression;
            if (eq.rightSide instanceof NullAVM2Item && ternar.onFalse.getNotCoerced() instanceof GetPropertyAVM2Item) {
                GetPropertyAVM2Item gp = (GetPropertyAVM2Item)ternar.onFalse.getNotCoerced();
                if (gp.object.valueEquals(eq.leftSide)) {
                    gp.nullCondition = true;
                    return gp;
                }
            }
        }
        if (ternar.expression instanceof NeqAVM2Item) {
            NeqAVM2Item neq = (NeqAVM2Item)ternar.expression;
            if (neq.rightSide instanceof NullAVM2Item && ternar.onTrue.valueEquals(neq.leftSide)) {
                return new NullCoalesceAVM2Item(ternar.getSrc(), ternar.getLineStartItem(), ternar.onTrue, ternar.onFalse);
            }
        }
        return ternar;
    }
}

