/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AVM2GraphSource
extends GraphSource {
    private final AVM2Code code;
    boolean isStatic;
    int classIndex;
    int scriptIndex;
    HashMap<Integer, GraphTargetItem> localRegs;
    ABC abc;
    MethodBody body;
    HashMap<Integer, String> localRegNames;
    List<DottedChain> fullyQualifiedNames;
    HashMap<Integer, Integer> localRegAssignmentIps;

    public AVM2Code getCode() {
        return this.code;
    }

    public AVM2GraphSource(AVM2Code code, boolean isStatic, int scriptIndex, int classIndex, HashMap<Integer, GraphTargetItem> localRegs, ABC abc, MethodBody body, HashMap<Integer, String> localRegNames, List<DottedChain> fullyQualifiedNames, HashMap<Integer, Integer> localRegAssignmentIp) {
        this.code = code;
        this.isStatic = isStatic;
        this.classIndex = classIndex;
        this.localRegs = localRegs;
        this.abc = abc;
        this.body = body;
        this.localRegNames = localRegNames;
        this.fullyQualifiedNames = fullyQualifiedNames;
        this.scriptIndex = scriptIndex;
        this.localRegAssignmentIps = localRegAssignmentIp;
        code.calculateDebugFileLine(abc);
    }

    @Override
    public Set<Long> getImportantAddresses() {
        return this.code.getImportantOffsets(this.body, false);
    }

    @Override
    public String insToString(int pos) {
        if (pos < this.code.code.size()) {
            return this.code.code.get(pos).toStringNoAddress(this.abc.constants, this.fullyQualifiedNames);
        }
        return "";
    }

    @Override
    public int size() {
        return this.code.code.size();
    }

    @Override
    public AVM2Instruction get(int pos) {
        return this.code.code.get(pos);
    }

    @Override
    public boolean isEmpty() {
        return this.code.code.isEmpty();
    }

    @Override
    public void translatePart(List<GraphTargetItem> output, Graph graph, GraphPart part, BaseLocalData localData, TranslateStack stack, int start, int end, int staticOperation, String path) throws InterruptedException {
        Reference<GraphSourceItem> lineStartItem = new Reference<GraphSourceItem>(localData.lineStartInstruction);
        this.code.toSourceOutput(localData.maxTempIndex, output, localData.swfVersion, localData.allSwitchParts, ((AVM2LocalData)localData).callStack, ((AVM2LocalData)localData).abcIndex, ((AVM2LocalData)localData).setLocalPosToGetLocalPos, ((AVM2LocalData)localData).thisHasDefaultToPrimitive, lineStartItem, path, part, false, this.isStatic, this.scriptIndex, this.classIndex, this.localRegs, stack, ((AVM2LocalData)localData).scopeStack, ((AVM2LocalData)localData).localScopeStack, this.abc, this.body, start, end, this.localRegNames, ((AVM2LocalData)localData).localRegTypes, this.fullyQualifiedNames, new boolean[this.size()], this.localRegAssignmentIps, ((AVM2LocalData)localData).bottomSetLocals, localData.usedDeobfuscations);
        localData.lineStartInstruction = lineStartItem.getVal();
    }

    @Override
    public int adr2pos(long adr) {
        return this.code.adr2pos(adr);
    }

    @Override
    public int adr2pos(long adr, boolean nearest) {
        return this.code.adr2pos(adr, true);
    }

    @Override
    public long pos2adr(int pos) {
        return this.code.pos2adr(pos);
    }
}

