/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.stack;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import java.util.List;

public class PushScopeIns
extends InstructionDefinition {
    public PushScopeIns() {
        super(48, "pushscope", new int[0], false, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean isNotCompileTimeSupported() {
        return true;
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        lda.scopeStack.push(lda.operandStack.pop());
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        LocalRegAVM2Item getLocal;
        GraphTargetItem top = stack.pop();
        if (top instanceof LocalRegAVM2Item && (getLocal = (LocalRegAVM2Item)top).getSrc() != null) {
            int getLocalIp = localData.code.adr2pos(getLocal.getSrc().getAddress());
            for (int setLocalPos : localData.setLocalPosToGetLocalPos.keySet()) {
                if (!localData.setLocalPosToGetLocalPos.get(setLocalPos).contains(getLocalIp)) continue;
                localData.setLocalPosToGetLocalPos.get(setLocalPos).remove(getLocalIp);
            }
        }
        localData.localScopeStack.push(top);
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    @Override
    public int getScopeStackDelta(AVM2Instruction ins, ABC abc) {
        return 1;
    }
}

