/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CallStaticAVM2Item
extends AVM2Item {
    public GraphTargetItem receiver;
    public String methodName;
    public List<GraphTargetItem> arguments;

    public CallStaticAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem receiver, String methodName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.receiver = receiver;
        this.methodName = methodName;
        this.arguments = arguments;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.receiver);
        visitor.visitAll(this.arguments);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.receiver.getPrecedence() > this.getPrecedence() || this.receiver instanceof IntegerValueAVM2Item) {
            writer.append("(");
            this.receiver.toString(writer, localData);
            writer.append(")");
        } else {
            this.receiver.toString(writer, localData);
        }
        writer.append(".");
        writer.append(this.methodName);
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                writer.append(",");
            }
            this.arguments.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.receiver);
        hash = 29 * hash + Objects.hashCode(this.methodName);
        hash = 29 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallStaticAVM2Item other = (CallStaticAVM2Item)obj;
        if (!Objects.equals(this.methodName, other.methodName)) {
            return false;
        }
        if (!Objects.equals(this.receiver, other.receiver)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

