/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class PackageAVM2Item
extends AVM2Item {
    private final List<GraphTargetItem> items;
    private final String packageName;

    public PackageAVM2Item(List<GraphTargetItem> items, String packageName) {
        super(null, null, 0);
        this.items = items;
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void addItem(GraphTargetItem item) {
        this.items.add(item);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.appendNoHilight("package");
        if (!this.packageName.isEmpty()) {
            writer.appendNoHilight(" " + DottedChain.parseWithSuffix(this.packageName).toPrintableString(localData.usedDeobfuscations, localData.swf, true));
        }
        writer.startBlock();
        Graph.graphToString(this.items, writer, localData);
        writer.endBlock();
        writer.newLine();
        return writer;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return null;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.items);
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }
}

