/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.CompoundableBinaryOp;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class SubtractAVM2Item
extends BinaryOpItem
implements CompoundableBinaryOp {
    public SubtractAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(AVM2GraphTargetDialect.INSTANCE, instruction, lineStartIns, 4, leftSide, rightSide, "-", "Number", "Number");
    }

    @Override
    public Object getResult() {
        return this.leftSide.getResultAsNumber() - this.rightSide.getResultAsNumber();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide.getPrecedence() >= this.precedence) {
            if (this.leftSide.getPrecedence() > this.precedence) {
                writer.append("(");
                this.leftSide.toString(writer, localData);
                writer.append(")");
            } else {
                this.leftSide.toString(writer, localData);
            }
            writer.append(" ");
            writer.append(this.operator);
            writer.append(" ");
            writer.append("(");
            this.rightSide.toString(writer, localData);
            return writer.append(")");
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (localData.numberContext != null) {
            return SubtractAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 182, new int[]{localData.numberContext}));
        }
        return SubtractAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 161, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.NUMBER;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new AVM2Instruction(0L, 161, null));
        return ret;
    }
}

