/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.usages.simple;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.usages.simple.ABCWalker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ABCSimpleUsageDetector {
    private final Map<ItemKind, List<List<String>>> usages = new HashMap<ItemKind, List<List<String>>>();
    private final Map<ItemKind, List<Integer>> zeroUsages = new HashMap<ItemKind, List<Integer>>();
    private final ABC abc;

    public ABCSimpleUsageDetector(ABC abc) {
        this.abc = abc;
    }

    private void initUsages(ItemKind kind, int itemCount) {
        ArrayList list = new ArrayList();
        if (kind.hasReservedZeroIndex() && itemCount == 0) {
            itemCount = 1;
        }
        for (int i = 0; i < itemCount; ++i) {
            list.add(new ArrayList());
        }
        this.usages.put(kind, list);
    }

    public void detect() {
        this.usages.clear();
        this.initUsages(ItemKind.INT, this.abc.constants.getIntCount());
        this.initUsages(ItemKind.UINT, this.abc.constants.getUIntCount());
        this.initUsages(ItemKind.DOUBLE, this.abc.constants.getDoubleCount());
        if (this.abc.hasFloatSupport()) {
            this.initUsages(ItemKind.FLOAT, this.abc.constants.getFloatCount());
        }
        if (this.abc.hasDecimalSupport()) {
            this.initUsages(ItemKind.DECIMAL, this.abc.constants.getDecimalCount());
        }
        this.initUsages(ItemKind.STRING, this.abc.constants.getStringCount());
        this.initUsages(ItemKind.NAMESPACE, this.abc.constants.getNamespaceCount());
        this.initUsages(ItemKind.NAMESPACESET, this.abc.constants.getNamespaceSetCount());
        this.initUsages(ItemKind.MULTINAME, this.abc.constants.getMultinameCount());
        this.initUsages(ItemKind.METADATAINFO, this.abc.metadata_info.size());
        this.initUsages(ItemKind.METHODINFO, this.abc.method_info.size());
        this.initUsages(ItemKind.METHODBODY, this.abc.bodies.size());
        this.initUsages(ItemKind.CLASS, this.abc.class_info.size());
        ABCWalker walker = new ABCWalker(){

            protected void handleUsageNamespace(int index, String usageDescription) {
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.NAMESPACE, index, usageDescription)) {
                    return;
                }
                Namespace ns = ((ABCSimpleUsageDetector)ABCSimpleUsageDetector.this).abc.constants.getNamespace(index);
                if (ns == null) {
                    return;
                }
                ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, ns.name_index, "ns" + index + "/name");
            }

            protected void handleUsageNamespaceSet(int index, String usageDescription) {
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.NAMESPACESET, index, usageDescription)) {
                    return;
                }
                NamespaceSet nss = ((ABCSimpleUsageDetector)ABCSimpleUsageDetector.this).abc.constants.getNamespaceSet(index);
                if (nss == null) {
                    return;
                }
                for (int i = 0; i < nss.namespaces.length; ++i) {
                    this.handleUsageNamespace(nss.namespaces[i], "nss" + index + "/ns" + nss.namespaces[i]);
                }
            }

            protected void handleUsageMultiname(int index, String usageDescription) {
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.MULTINAME, index, usageDescription)) {
                    return;
                }
                Multiname m = ((ABCSimpleUsageDetector)ABCSimpleUsageDetector.this).abc.constants.getMultiname(index);
                if (m == null) {
                    return;
                }
                if (m.hasOwnName()) {
                    ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, m.name_index, "mn" + index + "/name");
                }
                if (m.hasOwnNamespace()) {
                    this.handleUsageNamespace(m.namespace_index, "mn" + index + "/namespace");
                }
                if (m.hasOwnNamespaceSet()) {
                    this.handleUsageNamespaceSet(m.namespace_set_index, "mn" + index + "/namespace_set");
                }
                if (m.kind == 29) {
                    this.handleUsageMultiname(m.qname_index, "mn" + index + "/qname");
                    for (int i = 0; i < m.params.length; ++i) {
                        this.handleUsageMultiname(m.params[i], "mn" + index + "/param" + i);
                    }
                }
            }

            protected void handleUsageMethodInfo(int index, String usageDescription) {
                int i;
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.METHODINFO, index, usageDescription)) {
                    return;
                }
                MethodInfo m = ((ABCSimpleUsageDetector)ABCSimpleUsageDetector.this).abc.method_info.get(index);
                ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, m.name_index, usageDescription + "/name");
                if (m.flagHas_paramnames()) {
                    for (i = 0; i < m.paramNames.length; ++i) {
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, m.paramNames[i], usageDescription + "/param_names/pn" + i);
                    }
                }
                if (m.flagHas_optional()) {
                    for (i = 0; i < m.optional.length; ++i) {
                        this.handleUsageValueKind(ABCSimpleUsageDetector.this.abc, m.optional[i].value_kind, m.optional[i].value_index, usageDescription + "/optional/op" + i);
                    }
                }
                for (i = 0; i < m.param_types.length; ++i) {
                    this.handleUsageMultiname(m.param_types[i], usageDescription + "/param_types/pt" + i);
                }
                this.handleUsageMultiname(m.ret_type, usageDescription + "/return_type");
                int bodyIndex = ABCSimpleUsageDetector.this.abc.findBodyIndex(index);
                if (bodyIndex > -1) {
                    this.handleUsageMethodBody(bodyIndex, usageDescription + "/method_body");
                }
            }

            protected void handleUsageMethodBody(int index, String usageDescription) {
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.METHODBODY, index, usageDescription)) {
                    return;
                }
                MethodBody body = ((ABCSimpleUsageDetector)ABCSimpleUsageDetector.this).abc.bodies.get(index);
                for (int i = 0; i < body.exceptions.length; ++i) {
                    this.handleUsageMultiname(body.exceptions[i].name_index, usageDescription + "/exceptions/ex" + i + "/name");
                    this.handleUsageMultiname(body.exceptions[i].type_index, usageDescription + "/exceptions/ex" + i + "/type");
                }
                List<AVM2Instruction> code = body.getCode().code;
                for (int i = 0; i < code.size(); ++i) {
                    AVM2Instruction ins = code.get(i);
                    block14: for (int operandIndex = 0; operandIndex < ins.definition.operands.length; ++operandIndex) {
                        int operand = ins.operands[operandIndex];
                        String operandDescription = usageDescription + "/code/ins" + i + "/op" + operandIndex;
                        switch (ins.definition.operands[operandIndex]) {
                            case 269: {
                                continue block14;
                            }
                            case 272: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.DOUBLE, operand, operandDescription);
                                continue block14;
                            }
                            case 270: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.INT, operand, operandDescription);
                                continue block14;
                            }
                            case 259: {
                                continue block14;
                            }
                            case 257: {
                                this.handleUsageMultiname(operand, operandDescription);
                                continue block14;
                            }
                            case 279: {
                                this.handleUsageNamespace(operand, operandDescription);
                                continue block14;
                            }
                            case 260: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, operand, operandDescription);
                                continue block14;
                            }
                            case 271: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.UINT, operand, operandDescription);
                                continue block14;
                            }
                            case 277: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.FLOAT, operand, operandDescription);
                                continue block14;
                            }
                            case 273: {
                                ABCSimpleUsageDetector.this.handleUsage(ItemKind.DECIMAL, operand, operandDescription);
                            }
                        }
                    }
                }
            }

            @Override
            protected void handleScript(ABC abc, int index) {
            }

            @Override
            protected void handleMetadataInfo(ABC abc, int index, Trait trait, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, int traitMetadataIndex, ABCWalker.WalkType walkType) {
                int i;
                String description = "si" + scriptIndex + "/traits/t" + scriptTraitIndex;
                if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                    description = description + "/class_info/traits/t" + traitIndex;
                } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                    description = description + "/instance_info/traits/t" + traitIndex;
                }
                description = description + "/metadata/md" + index;
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.METADATAINFO, index, description)) {
                    return;
                }
                MetadataInfo md = abc.metadata_info.get(index);
                ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, md.name_index, description + "/name");
                for (i = 0; i < md.keys.length; ++i) {
                    ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, md.keys[i], description + "/pairs/p" + i + "/key");
                }
                for (i = 0; i < md.values.length; ++i) {
                    ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, md.values[i], description + "/pairs/p" + i + "/value");
                }
            }

            @Override
            protected void handleTraitClass(ABC abc, TraitClass trait, int scriptIndex, int scriptTraitIndex) {
                String description = "si" + scriptIndex + "/traits/t" + scriptTraitIndex;
                if (!ABCSimpleUsageDetector.this.handleUsage(ItemKind.CLASS, trait.class_info, description)) {
                    return;
                }
                InstanceInfo ii = abc.instance_info.get(trait.class_info);
                if ((ii.flags & 8) != 0) {
                    this.handleUsageNamespace(ii.protectedNS, description + "/instance_info/protected_ns");
                }
                this.handleUsageMultiname(ii.name_index, description + "/instance_info/name");
                this.handleUsageMultiname(ii.super_index, description + "/instance_info/super");
                for (int i = 0; i < ii.interfaces.length; ++i) {
                    this.handleUsageMultiname(ii.interfaces[i], description + "/instance_info/interfaces/in" + i);
                }
            }

            @Override
            protected void handleTraitMethodGetterSetter(ABC abc, TraitMethodGetterSetter trait, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, ABCWalker.WalkType walkType) {
                this.handleTraitMethodBase(abc, trait, scriptIndex, scriptTraitIndex, classIndex, traitIndex, walkType);
            }

            protected void handleTraitMethodBase(ABC abc, Trait trait, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, ABCWalker.WalkType walkType) {
                String description = "";
                if (scriptIndex > -1) {
                    description = description + "si" + scriptIndex + "/traits/t" + scriptTraitIndex;
                    if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                        description = description + "/class_info/traits/t" + traitIndex;
                    } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                        description = description + "/instance_info/traits/t" + traitIndex;
                    }
                } else if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                    description = description + "ci" + classIndex + "/class_info/traits/t" + traitIndex;
                } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                    description = description + "ii" + classIndex + "/instance_info/traits/t" + traitIndex;
                }
                this.handleUsageMultiname(trait.name_index, description + "/name");
            }

            @Override
            protected void handleTraitFunction(ABC abc, TraitFunction trait, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, ABCWalker.WalkType walkType) {
                this.handleTraitMethodBase(abc, trait, scriptIndex, scriptTraitIndex, classIndex, traitIndex, walkType);
            }

            protected void handleUsageValueKind(ABC abc, int value_kind, int value_index, String description) {
                switch (value_kind) {
                    case 3: {
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.INT, value_index, description);
                        break;
                    }
                    case 4: {
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.UINT, value_index, description);
                        break;
                    }
                    case 6: {
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.DOUBLE, value_index, description);
                        break;
                    }
                    case 1: {
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.STRING, value_index, description);
                        break;
                    }
                    case 2: {
                        if (abc.hasFloatSupport()) {
                            ABCSimpleUsageDetector.this.handleUsage(ItemKind.FLOAT, value_index, description);
                            break;
                        }
                        ABCSimpleUsageDetector.this.handleUsage(ItemKind.DECIMAL, value_index, description);
                        break;
                    }
                    case 5: 
                    case 8: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        this.handleUsageNamespace(value_index, description);
                    }
                }
            }

            @Override
            protected void handleTraitSlotConst(ABC abc, TraitSlotConst trait, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, int bodyIndex, int bodyTraitIndex, ABCWalker.WalkType walkType, Stack<Integer> callStack) {
                String description = "";
                if (callStack.size() > 1) {
                    if (bodyTraitIndex != -1) {
                        int methodInfo = callStack.peek();
                        description = description + "mi" + methodInfo + "/method_body/traits/t" + bodyTraitIndex;
                    }
                } else if (scriptIndex > -1) {
                    description = description + "si" + scriptIndex + "/traits/t" + scriptTraitIndex;
                    if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                        description = description + "/class_info/traits/t" + traitIndex;
                    } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                        description = description + "/instance_info/traits/t" + traitIndex;
                    }
                    if (bodyTraitIndex != -1) {
                        description = description + "/method_info/method_body/traits/t" + bodyTraitIndex;
                    }
                } else if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                    description = description + "ci" + classIndex + "/class_info/traits/t" + traitIndex;
                } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                    description = description + "ii" + classIndex + "/instance_info/traits/t" + traitIndex;
                } else if (bodyTraitIndex > -1) {
                    description = description + "mb" + bodyIndex + "/traits/t" + bodyTraitIndex;
                }
                this.handleUsageMultiname(trait.name_index, description + "/name");
                this.handleUsageMultiname(trait.type_index, description + "/type");
                this.handleUsageValueKind(abc, trait.value_kind, trait.value_index, description + "/value_index");
            }

            @Override
            protected void handleMethodInfo(ABC abc, int index, int scriptIndex, int scriptTraitIndex, int classIndex, int traitIndex, ABCWalker.WalkType walkType, boolean initializer, Stack<Integer> callStack) {
                if (callStack.size() > 1) {
                    int prevMethod = (Integer)callStack.get(callStack.size() - 2);
                    this.handleUsageMethodInfo(index, "mi" + prevMethod + "/method_body/code");
                    return;
                }
                if (initializer) {
                    switch (walkType) {
                        case Class: {
                            if (scriptIndex != -1) {
                                this.handleUsageMethodInfo(index, "si" + scriptIndex + "/traits/t" + scriptTraitIndex + "/class_info/cinit");
                                break;
                            }
                            this.handleUsageMethodInfo(index, "ci" + classIndex + "/class_info/cinit");
                            break;
                        }
                        case Instance: {
                            if (scriptIndex != -1) {
                                this.handleUsageMethodInfo(index, "si" + scriptIndex + "/traits/t" + scriptTraitIndex + "/instance_info/iinit");
                                break;
                            }
                            this.handleUsageMethodInfo(index, "ii" + classIndex + "/instance_info/iinit");
                            break;
                        }
                        case Script: {
                            this.handleUsageMethodInfo(index, "si" + scriptIndex + "/init");
                        }
                    }
                    return;
                }
                String description = "";
                if (scriptIndex > -1) {
                    description = description + "si" + scriptIndex + "/traits/t" + scriptTraitIndex;
                    if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                        description = description + "/class_info/traits/t" + traitIndex;
                    } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                        description = description + "/instance_info/traits/t" + traitIndex;
                    }
                } else if (walkType == ABCWalker.WalkType.Class && traitIndex > -1) {
                    description = description + "ci" + classIndex + "/class_info/traits/t" + traitIndex;
                } else if (walkType == ABCWalker.WalkType.Instance && traitIndex > -1) {
                    description = description + "ii" + classIndex + "/instance_info/traits/t" + traitIndex;
                }
                description = description + "/method_info";
                this.handleUsageMethodInfo(index, description);
            }
        };
        walker.walkABC(this.abc, false);
        this.zeroUsages.clear();
        for (ItemKind kind : this.usages.keySet()) {
            int i;
            this.zeroUsages.put(kind, new ArrayList());
            int n = i = kind.hasReservedZeroIndex() ? 1 : 0;
            while (i < this.usages.get((Object)kind).size()) {
                if (this.usages.get((Object)kind).get(i).isEmpty()) {
                    this.zeroUsages.get((Object)kind).add(i);
                }
                ++i;
            }
        }
    }

    private boolean handleUsage(ItemKind kind, int index, String usageDescription) {
        if (!this.usages.containsKey((Object)kind) || index < 0 || index > this.usages.get((Object)kind).size() - 1) {
            Logger.getLogger(ABCSimpleUsageDetector.class.getName()).log(Level.WARNING, "{0} with index {1} not found for usage {2}", new Object[]{kind, index, usageDescription});
            return false;
        }
        List<String> kindList = this.usages.get((Object)kind).get(index);
        kindList.add(usageDescription);
        return kindList.size() == 1;
    }

    public Map<ItemKind, List<List<String>>> getUsages() {
        return Collections.unmodifiableMap(this.usages);
    }

    public List<String> getUsages(ItemKind kind, int index) {
        return Collections.unmodifiableList(this.usages.get((Object)kind).get(index));
    }

    public List<List<String>> getUsages(ItemKind kind) {
        return Collections.unmodifiableList(this.usages.get((Object)kind));
    }

    public Map<ItemKind, List<Integer>> getZeroUsages() {
        return Collections.unmodifiableMap(this.zeroUsages);
    }

    public List<Integer> getZeroUsages(ItemKind kind) {
        return this.zeroUsages.get((Object)kind);
    }

    public int getZeroUsagesCount() {
        int cnt = 0;
        for (ItemKind kind : this.zeroUsages.keySet()) {
            cnt += this.zeroUsages.get((Object)kind).size();
        }
        return cnt;
    }

    public int getZeroUsagesCount(ItemKind kind) {
        return this.zeroUsages.get((Object)kind).size();
    }

    public static enum ItemKind {
        INT(true),
        UINT(true),
        DOUBLE(true),
        DECIMAL(true),
        FLOAT(true),
        FLOAT4(true),
        STRING(true),
        NAMESPACE(true),
        NAMESPACESET(true),
        MULTINAME(true),
        METADATAINFO(false),
        METHODINFO(false),
        METHODBODY(false),
        CLASS(false);

        private final boolean reserveZeroIndex;

        private ItemKind(boolean reserveZeroIndex) {
            this.reserveZeroIndex = reserveZeroIndex;
        }

        public boolean hasReservedZeroIndex() {
            return this.reserveZeroIndex;
        }
    }
}

