/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionListReader;
import com.jpexs.decompiler.flash.action.special.ActionNop;
import com.jpexs.decompiler.flash.action.special.ActionStore;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.FileTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionList
extends ArrayList<Action> {
    public int deobfuscationMode;
    public byte[] fileData;
    private String charset;

    public ActionList(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public ActionList(Collection<Action> actions, String charset) {
        super(actions);
        this.charset = charset;
    }

    public void setActions(List<Action> list) {
        this.clear();
        this.addAll(list);
    }

    public void removeActions(List<Action> actionsToRemove) {
        ActionListReader.removeActions(this, actionsToRemove, true);
    }

    public void removeAction(int index) {
        ActionListReader.removeAction(this, index, true);
    }

    public void removeAction(int index, int count) {
        if (this.size() <= index + count - 1) {
            count = this.size() - index;
        }
        for (int i = 0; i < count; ++i) {
            ActionListReader.removeAction(this, index, true);
        }
    }

    public void addAction(int index, Action action) {
        ActionListReader.addAction(this, index, action, false, false);
    }

    public void addActions(int index, List<Action> actions) {
        ActionListReader.addActions(this, index, actions);
    }

    public void fixActionList() {
        ActionListReader.fixActionList(this, null);
    }

    public List<Action> getContainerLastActions(Action action) {
        return ActionListReader.getContainerLastActions(this, action);
    }

    public Iterator<Action> getReferencesFor(final Action target) {
        return new Iterator<Action>(){
            private final Iterator<Action> iterator;
            private Action action;
            {
                this.iterator = ActionList.this.iterator();
                this.action = this.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public Action next() {
                Action a = this.action;
                this.action = this.getNext();
                return a;
            }

            private Action getNext() {
                while (this.iterator.hasNext()) {
                    Action a = this.iterator.next();
                    if (a instanceof ActionJump) {
                        ActionJump aJump = (ActionJump)a;
                        long ref = aJump.getTargetAddress();
                        if (target.getAddress() != ref) continue;
                        return aJump;
                    }
                    if (a instanceof ActionIf) {
                        ActionIf aIf = (ActionIf)a;
                        long ref = aIf.getTargetAddress();
                        if (target.getAddress() != ref) continue;
                        return aIf;
                    }
                    if (a instanceof ActionStore) {
                        ActionStore aStore = (ActionStore)((Object)a);
                        int storeSize = aStore.getStoreSize();
                        int idx = ActionList.this.indexOf(a);
                        int idx2 = ActionList.this.indexOf(target);
                        if (idx == -1 || idx2 != idx + storeSize) continue;
                        return a;
                    }
                    if (!(a instanceof GraphSourceItemContainer)) continue;
                    GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)a);
                    long ref = a.getAddress() + (long)a.getTotalActionLength();
                    for (Long size : container.getContainerSizes()) {
                        if (target.getAddress() != (ref += size.longValue())) continue;
                        return a;
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<ActionConstantPool> getConstantPools() {
        return () -> new Iterator<ActionConstantPool>(){
            private ActionConstantPool action;
            private final Iterator iterator;
            {
                this.iterator = ActionList.this.iterator();
                this.action = this.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public ActionConstantPool next() {
                ActionConstantPool a = this.action;
                this.action = this.getNext();
                return a;
            }

            private ActionConstantPool getNext() {
                while (this.iterator.hasNext()) {
                    Action a = (Action)this.iterator.next();
                    if (!(a instanceof ActionConstantPool)) continue;
                    return (ActionConstantPool)a;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<ActionPush> getPushes() {
        return () -> new Iterator<ActionPush>(){
            private ActionPush action;
            private final Iterator iterator;
            {
                this.iterator = ActionList.this.iterator();
                this.action = this.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public ActionPush next() {
                ActionPush a = this.action;
                this.action = this.getNext();
                return a;
            }

            private ActionPush getNext() {
                while (this.iterator.hasNext()) {
                    Action a = (Action)this.iterator.next();
                    if (!(a instanceof ActionPush)) continue;
                    return (ActionPush)a;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getConstantPoolIndexReferenceCount(int index) {
        int count = 0;
        for (Action action : this) {
            if (!(action instanceof ActionPush)) continue;
            ActionPush push = (ActionPush)action;
            for (Object value : push.values) {
                if (!(value instanceof ConstantIndex)) continue;
                ConstantIndex constantIndex = (ConstantIndex)value;
                if (constantIndex.index != index) continue;
                ++count;
            }
        }
        return count;
    }

    public void inlineConstantPoolString(int index, String str) {
        for (ActionPush push : this.getPushes()) {
            for (int i = 0; i < push.values.size(); ++i) {
                Object value = push.values.get(i);
                if (!(value instanceof ConstantIndex)) continue;
                ConstantIndex constantIndex = (ConstantIndex)value;
                if (constantIndex.index != index) continue;
                push.values.set(i, str);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeNonReferencedConstantPoolItems() {
        int maxSize = 0;
        for (ActionConstantPool actionConstantPool : this.getConstantPools()) {
            maxSize = Math.max(maxSize, actionConstantPool.constantPool.size());
        }
        boolean[] used = new boolean[maxSize];
        for (ActionPush push : this.getPushes()) {
            for (int i = 0; i < push.values.size(); ++i) {
                Object value = push.values.get(i);
                if (!(value instanceof ConstantIndex)) continue;
                ConstantIndex constantIndex = (ConstantIndex)value;
                int index = constantIndex.index;
                if (index < 0 || index >= maxSize) continue;
                used[index] = true;
            }
        }
        boolean bl = false;
        for (int i = 0; i < maxSize; ++i) {
            void var3_6;
            if (used[i]) {
                if (i != var3_6) {
                    for (ActionPush push : this.getPushes()) {
                        for (int j = 0; j < push.values.size(); ++j) {
                            Object value = push.values.get(j);
                            if (!(value instanceof ConstantIndex)) continue;
                            ConstantIndex constantIndex = (ConstantIndex)value;
                            if (constantIndex.index != i) continue;
                            constantIndex.index = var3_6;
                        }
                    }
                }
                ++var3_6;
                continue;
            }
            for (ActionConstantPool constantPool : this.getConstantPools()) {
                if (constantPool.constantPool.size() <= var3_6) continue;
                constantPool.constantPool.remove((int)var3_6);
            }
        }
    }

    public void removeNops() {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof ActionNop)) continue;
            this.removeAction(i);
        }
    }

    public Action getByAddress(long address) {
        int idx = this.getIndexByAddress(address);
        return idx == -1 ? null : (Action)this.get(idx);
    }

    public int getIndexByAction(Action action) {
        return this.getIndexByAddress(action.getAddress());
    }

    public int getIndexByAddress(long address) {
        int min = 0;
        int max = this.size() - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            long midValue = ((Action)this.get(mid)).getAddress();
            if (midValue == address) {
                return mid;
            }
            if (midValue < address) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return -1;
    }

    public GraphSourceItemContainer getContainer(int idx) {
        Action action = (Action)this.get(idx);
        for (int i = idx - 1; i >= 0; --i) {
            List<Action> lastActions;
            Action lastAction;
            Action a = (Action)this.get(i);
            if (!(a instanceof GraphSourceItemContainer) || (lastAction = (lastActions = this.getContainerLastActions(a)).get(lastActions.size() - 1)).getAddress() < action.getAddress()) continue;
            return (GraphSourceItemContainer)((Object)a);
        }
        return null;
    }

    public int getContainerEndIndex(int idx) {
        Action action = (Action)this.get(idx);
        for (int i = idx - 1; i >= 0; --i) {
            List<Action> lastActions;
            Action lastAction;
            Action a = (Action)this.get(i);
            if (!(a instanceof GraphSourceItemContainer) || (lastAction = (lastActions = this.getContainerLastActions(a)).get(lastActions.size() - 1)).getAddress() < action.getAddress()) continue;
            return this.getIndexByAddress(lastAction.getAddress());
        }
        return -1;
    }

    public List<Action> getUnreachableActions() {
        int[] isReachable = this.getUnreachableActionsMap(-1, 0);
        ArrayList<Action> unreachableActions = new ArrayList<Action>();
        for (int i = 0; i < this.size(); ++i) {
            if (isReachable[i] != 0) continue;
            unreachableActions.add((Action)this.get(i));
        }
        if (unreachableActions.isEmpty()) {
            unreachableActions = null;
        }
        return unreachableActions;
    }

    public List<Action> getUnreachableActions(int jumpIndex, int jumpTargetIndex) {
        int[] isReachable = this.getUnreachableActionsMap(jumpIndex, jumpTargetIndex);
        isReachable[jumpIndex] = 0;
        ArrayList<Action> unreachableActions = new ArrayList<Action>();
        for (int i = 0; i < this.size(); ++i) {
            if (isReachable[i] != 0) continue;
            unreachableActions.add((Action)this.get(i));
        }
        if (unreachableActions.isEmpty()) {
            unreachableActions = null;
        }
        return unreachableActions;
    }

    private int[] getUnreachableActionsMap(int jumpIndex, int jumpTargetIndex) {
        int size = this.size();
        int[] isReachable = new int[size];
        isReachable[0] = 1;
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = 0; i < size; ++i) {
                Action action = (Action)this.get(i);
                if (isReachable[i] != 1) continue;
                isReachable[i] = 2;
                modified = true;
                if (i == jumpIndex) {
                    if (isReachable[jumpTargetIndex] != 0) continue;
                    isReachable[jumpTargetIndex] = 1;
                    continue;
                }
                if (!action.isExit() && !(action instanceof ActionJump) && i != size - 1 && isReachable[i + 1] == 0) {
                    isReachable[i + 1] = 1;
                }
                if (action instanceof ActionJump) {
                    ActionJump aJump = (ActionJump)action;
                    long ref = aJump.getTargetAddress();
                    int targetIndex = this.getIndexByAddress(ref);
                    if (targetIndex == -1 || isReachable[targetIndex] != 0) continue;
                    isReachable[targetIndex] = 1;
                    continue;
                }
                if (action instanceof ActionIf) {
                    ActionIf aIf = (ActionIf)action;
                    long ref = aIf.getTargetAddress();
                    int targetIndex = this.getIndexByAddress(ref);
                    if (targetIndex == -1 || isReachable[targetIndex] != 0) continue;
                    isReachable[targetIndex] = 1;
                    continue;
                }
                if (action instanceof ActionStore) {
                    int targetIndex;
                    ActionStore aStore = (ActionStore)((Object)action);
                    int storeSize = aStore.getStoreSize();
                    if (size <= i + storeSize || isReachable[targetIndex = i + storeSize] != 0) continue;
                    isReachable[targetIndex] = 1;
                    continue;
                }
                if (!(action instanceof GraphSourceItemContainer)) continue;
                GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)action);
                long ref = action.getAddress() + (long)action.getTotalActionLength();
                for (Long containerSize : container.getContainerSizes()) {
                    int targetIndex = this.getIndexByAddress(ref += containerSize.longValue());
                    if (targetIndex == -1 || isReachable[targetIndex] != 0) continue;
                    isReachable[targetIndex] = 1;
                }
            }
        }
        return isReachable;
    }

    public void combinePushes() {
        for (int i = 0; i < this.size() - 1; ++i) {
            Action action = (Action)this.get(i);
            Action action2 = (Action)this.get(i + 1);
            if (!(action instanceof ActionPush) || !(action2 instanceof ActionPush) || this.getReferencesFor(action2).hasNext()) continue;
            ActionPush push = (ActionPush)action;
            ActionPush push2 = (ActionPush)action2;
            if (push.constantPool != null && push2.constantPool != null && push.constantPool != push2.constantPool) continue;
            ActionPush newPush = new ActionPush(0, this.charset);
            newPush.constantPool = push.constantPool == null ? push2.constantPool : push.constantPool;
            newPush.values.clear();
            newPush.values.addAll(push.values);
            newPush.values.addAll(push2.values);
            this.addAction(i + 1, newPush);
            this.removeAction(i + 2);
            this.removeAction(i);
            --i;
        }
    }

    public void expandPushes() {
        for (int i = 0; i < this.size(); ++i) {
            Action action = (Action)this.get(i);
            if (!(action instanceof ActionPush)) continue;
            ActionPush push = (ActionPush)action;
            if (push.values.size() <= 1) continue;
            int j = 0;
            for (Object value : push.values) {
                ActionPush newPush = new ActionPush(value, this.charset);
                newPush.constantPool = push.constantPool;
                this.addAction(i + ++j, newPush);
            }
            this.removeAction(i);
            i += j - 1;
        }
    }

    public void saveToFile(String fileName) {
        File file = new File(fileName);
        try (FileTextWriter writer = new FileTextWriter(Configuration.getCodeFormatting(), new FileOutputStream(file));){
            Action.actionsToString(new ArrayList<DisassemblyListener>(), 0L, this, 10, ScriptExportMode.PCODE, writer);
        }
        catch (IOException ex) {
            Logger.getLogger(ActionList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String toString() {
        HighlightedTextWriter writer = new HighlightedTextWriter(new CodeFormatting(), false);
        Action.actionsToString(new ArrayList<DisassemblyListener>(), 0L, this, 10, ScriptExportMode.PCODE, writer);
        writer.finishHilights();
        return writer.toString();
    }
}

