/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.as2;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.as2.ActionScript2Classes;
import com.jpexs.decompiler.flash.action.as2.Method;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.as2.Variable;
import com.jpexs.decompiler.flash.action.model.CallMethodActionItem;
import com.jpexs.decompiler.flash.action.model.DeleteActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.NewMethodActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.SetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.ClassActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.InterfaceActionItem;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.graph.AbstractGraphTargetVisitor;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.ProgressListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import natorder.NaturalOrderComparator;

public class UninitializedClassFieldsDetector {
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    private void fireProgress(ASMSource asm, String asmPath) {
        DoInitActionTag doi;
        String exportName;
        if (asm instanceof DoInitActionTag && (exportName = (doi = (DoInitActionTag)asm).getSwf().getExportName(doi.spriteId)) != null) {
            asmPath = DottedChain.parseNoSuffix(exportName).toPrintableString(new LinkedHashSet<String>(), doi.getSwf(), false);
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.status(asmPath);
        }
    }

    private List<String> getMembersPath(GraphTargetItem item) {
        DirectValueActionItem dv;
        ArrayList<String> ret = new ArrayList<String>();
        while (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            if (!(mem.memberName instanceof DirectValueActionItem)) {
                return null;
            }
            dv = (DirectValueActionItem)mem.memberName;
            if (!dv.isString()) {
                return null;
            }
            ret.add(0, dv.getAsString());
            item = mem.object;
        }
        if (item instanceof DirectValueActionItem) {
            DirectValueActionItem dv1 = (DirectValueActionItem)item;
            if (dv1.value instanceof RegisterNumber) {
                RegisterNumber rn = (RegisterNumber)dv1.value;
                if ("this".equals(rn.name)) {
                    ret.add(0, "this");
                    return ret;
                }
            }
        }
        if (!(item instanceof GetVariableActionItem)) {
            return null;
        }
        GetVariableActionItem gv = (GetVariableActionItem)item;
        if (!(gv.name instanceof DirectValueActionItem)) {
            return null;
        }
        dv = (DirectValueActionItem)gv.name;
        if (!dv.isString()) {
            return null;
        }
        String varName = dv.getAsString();
        ret.add(0, varName);
        return ret;
    }

    private List<String> getFullPath(GraphTargetItem item) {
        GraphTargetItem objectName;
        GraphTargetItem name;
        if (item instanceof GetMemberActionItem) {
            return this.getMembersPath(item);
        }
        if (item instanceof SetVariableActionItem) {
            SetVariableActionItem sv = (SetVariableActionItem)item;
            if (!(sv.name instanceof DirectValueActionItem)) {
                return null;
            }
            DirectValueActionItem nDv = (DirectValueActionItem)sv.name;
            if (!nDv.isString()) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(nDv.getAsString());
            return ret;
        }
        if (item instanceof SetMemberActionItem) {
            SetMemberActionItem sm = (SetMemberActionItem)item;
            name = sm.objectName;
            objectName = sm.object;
        } else if (item instanceof CallMethodActionItem) {
            CallMethodActionItem cm = (CallMethodActionItem)item;
            name = cm.methodName;
            objectName = cm.scriptObject;
        } else if (item instanceof NewMethodActionItem) {
            NewMethodActionItem nm = (NewMethodActionItem)item;
            name = nm.methodName;
            objectName = nm.scriptObject;
        } else if (item instanceof DeleteActionItem) {
            DeleteActionItem d = (DeleteActionItem)item;
            name = d.propertyName;
            objectName = d.object;
        } else {
            return null;
        }
        if (!(name instanceof DirectValueActionItem)) {
            return null;
        }
        DirectValueActionItem onDv = (DirectValueActionItem)name;
        if (!onDv.isString()) {
            return null;
        }
        String currentMemberName = onDv.getAsString();
        List<String> path = this.getMembersPath(objectName);
        if (path == null) {
            return null;
        }
        path.add(currentMemberName);
        return path;
    }

    private boolean containsTrait(Map<String, Map<String, Trait>> classTraits, Map<String, List<String>> classInheritance, String className, String name) {
        if (!classTraits.containsKey(className)) {
            return false;
        }
        if (classTraits.get(className).containsKey(name)) {
            return true;
        }
        for (String parent : classInheritance.get(className)) {
            if (!classTraits.containsKey(parent) || !classTraits.get(parent).containsKey(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Trait>> calculateAs2UninitializedClassTraits(SWF swf) throws InterruptedException {
        if (swf.isAS3()) {
            return new HashMap<String, Map<String, Trait>>();
        }
        final Map resultInstance = Collections.synchronizedMap(new LinkedHashMap());
        final Map resultStatic = Collections.synchronizedMap(new LinkedHashMap());
        Map<String, ASMSource> asms = swf.getASMs(false);
        CancellableWorker worker = CancellableWorker.getCurrent();
        final Map<String, Map<String, Trait>> classTraits = Collections.synchronizedMap(new LinkedHashMap<String, Map<String, Trait>>(ActionScript2Classes.getClassToTraits()));
        final Map<String, List<String>> classInheritance = Collections.synchronizedMap(new HashMap<String, List<String>>(ActionScript2Classes.getClassInheritance()));
        Map cachedTrees = Collections.synchronizedMap(new HashMap());
        final Set subThreads = Collections.synchronizedSet(new HashSet());
        Runnable cancelListener = new Runnable(){

            @Override
            public void run() {
                for (Thread t : subThreads) {
                    t.interrupt();
                }
            }
        };
        if (worker != null) {
            worker.addCancelListener(cancelListener);
        }
        try {
            asms.entrySet().parallelStream().filter(item -> item.getValue() instanceof DoInitActionTag).forEach(entry -> {
                DoInitActionTag doi;
                String exportName;
                if (worker != null && worker.isCancelled()) {
                    return;
                }
                subThreads.add(Thread.currentThread());
                this.fireProgress((ASMSource)entry.getValue(), (String)entry.getKey());
                String key = (String)entry.getKey();
                ASMSource asm = (ASMSource)asms.get(key);
                if (asm instanceof DoInitActionTag && (exportName = (doi = (DoInitActionTag)asm).getSwf().getCharacter(doi.getCharacterId()).getExportName()) != null && exportName.startsWith("__Packages.")) {
                    MyEntry<GraphTargetItem, GraphTargetItem> en;
                    ClassActionItem cai;
                    String className;
                    List<Object> tree = new ArrayList();
                    try {
                        tree = asm.getActionsToTree();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    cachedTrees.put(key, tree);
                    for (GraphTargetItem graphTargetItem : tree) {
                        String imtName;
                        if (graphTargetItem instanceof InterfaceActionItem) {
                            InterfaceActionItem iai = (InterfaceActionItem)graphTargetItem;
                            className = String.join((CharSequence)".", this.getMembersPath(iai.name));
                            classInheritance.put(className, new ArrayList());
                            if (iai.superInterfaces != null) {
                                for (GraphTargetItem imp : iai.superInterfaces) {
                                    imtName = String.join((CharSequence)".", this.getMembersPath(imp));
                                    ((List)classInheritance.get(className)).add(imtName);
                                }
                            }
                        }
                        if (!(graphTargetItem instanceof ClassActionItem)) continue;
                        cai = (ClassActionItem)graphTargetItem;
                        className = String.join((CharSequence)".", this.getMembersPath(cai.className));
                        classInheritance.put(className, new ArrayList());
                        if (!classTraits.containsKey(className)) {
                            classTraits.put(className, new LinkedHashMap());
                        }
                        for (int i = 0; i < cai.traits.size(); ++i) {
                            en = cai.traits.get(i);
                            if (!(en.getKey() instanceof DirectValueActionItem)) continue;
                            DirectValueActionItem dv = (DirectValueActionItem)en.getKey();
                            String name = dv.getAsString();
                            GraphTargetItem value = en.getValue();
                            boolean isStatic = cai.traitsStatic.get(i);
                            if (value instanceof FunctionActionItem) {
                                if (name.startsWith("__get__") || name.startsWith("__set__")) {
                                    String vname = name.substring(7);
                                    Variable v = new Variable(isStatic, vname, vname, className);
                                    ((Map)classTraits.get(className)).put(vname, v);
                                }
                                Method m = new Method(isStatic, name, "Unknown", className);
                                ((Map)classTraits.get(className)).put(name, m);
                                continue;
                            }
                            Variable v = new Variable(isStatic, name, name, className);
                            ((Map)classTraits.get(className)).put(name, v);
                        }
                        if (cai.extendsOp != null) {
                            String parentClassName = String.join((CharSequence)".", this.getMembersPath(cai.extendsOp));
                            ((List)classInheritance.get(className)).add(parentClassName);
                        } else {
                            ((List)classInheritance.get(className)).add("Object");
                        }
                        if (cai.implementsOp == null) continue;
                        for (GraphTargetItem imp : cai.implementsOp) {
                            imtName = String.join((CharSequence)".", this.getMembersPath(imp));
                            ((List)classInheritance.get(className)).add(imtName);
                        }
                    }
                    for (GraphTargetItem graphTargetItem : tree) {
                        if (!(graphTargetItem instanceof ClassActionItem)) continue;
                        cai = (ClassActionItem)graphTargetItem;
                        className = String.join((CharSequence)".", this.getMembersPath(cai.className));
                        for (int i = 0; i < cai.traits.size(); ++i) {
                            GraphTargetItem value;
                            en = cai.traits.get(i);
                            if (!(en.getKey() instanceof DirectValueActionItem) || !((value = en.getValue()) instanceof GraphTargetItem)) continue;
                            AbstractGraphTargetVisitor visitor = new AbstractGraphTargetVisitor(){

                                @Override
                                public boolean visit(GraphTargetItem item) {
                                    List path = UninitializedClassFieldsDetector.this.getFullPath(item);
                                    if (path != null) {
                                        String name;
                                        ArrayList parent = new ArrayList(path);
                                        parent.remove(parent.size() - 1);
                                        if (!(parent.size() != 1 || !((String)parent.get(0)).equals("this") || UninitializedClassFieldsDetector.this.containsTrait(classTraits, classInheritance, className, name = (String)path.get(path.size() - 1)) || resultInstance.containsKey(className) && ((Map)resultInstance.get(className)).containsKey(name))) {
                                            Variable v = new Variable(false, name, null, className);
                                            if (!resultInstance.containsKey(className)) {
                                                resultInstance.put(className, new TreeMap(new NaturalOrderComparator()));
                                            }
                                            ((Map)resultInstance.get(className)).put(name, v);
                                        }
                                    }
                                    return true;
                                }
                            };
                            visitor.visit(value);
                            value.visitRecursively(visitor);
                        }
                    }
                }
            });
            if (worker != null && worker.isCancelled()) {
                throw new InterruptedException();
            }
            for (String className : classInheritance.keySet()) {
                for (int i = 0; i < classInheritance.get(className).size(); ++i) {
                    String parentClass = classInheritance.get(className).get(i);
                    if (!classInheritance.containsKey(parentClass)) continue;
                    for (String p : classInheritance.get(parentClass)) {
                        if (classInheritance.get(className).contains(p)) continue;
                        classInheritance.get(className).add(p);
                    }
                }
            }
            if (worker != null && worker.isCancelled()) {
                throw new InterruptedException();
            }
            asms.entrySet().parallelStream().forEach(entry -> {
                if (worker != null && worker.isCancelled()) {
                    return;
                }
                subThreads.add(Thread.currentThread());
                this.fireProgress((ASMSource)entry.getValue(), (String)entry.getKey());
                String key = (String)entry.getKey();
                ASMSource asm = (ASMSource)asms.get(key);
                List<Object> tree = new ArrayList();
                if (cachedTrees.containsKey(key)) {
                    tree = (List)cachedTrees.get(key);
                } else {
                    try {
                        tree = asm.getActionsToTree();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                for (GraphTargetItem item : tree) {
                    AbstractGraphTargetVisitor visitor = new AbstractGraphTargetVisitor(){

                        @Override
                        public boolean visit(GraphTargetItem item) {
                            List path;
                            if ((item instanceof SetMemberActionItem || item instanceof CallMethodActionItem || item instanceof NewMethodActionItem || item instanceof DeleteActionItem || item instanceof GetMemberActionItem) && (path = UninitializedClassFieldsDetector.this.getFullPath(item)) != null) {
                                ArrayList parent = new ArrayList(path);
                                parent.remove(parent.size() - 1);
                                String name = (String)path.get(path.size() - 1);
                                String className = String.join((CharSequence)".", parent);
                                if (!(!classInheritance.containsKey(className) || UninitializedClassFieldsDetector.this.containsTrait(classTraits, classInheritance, className, name) || resultInstance.containsKey(className) && ((Map)resultInstance.get(className)).containsKey(name) || resultStatic.containsKey(className) && ((Map)resultStatic.get(className)).containsKey(name))) {
                                    if (!resultStatic.containsKey(className)) {
                                        resultStatic.put(className, new TreeMap(new NaturalOrderComparator()));
                                    }
                                    Variable v = new Variable(true, name, null, className);
                                    ((Map)resultStatic.get(className)).put(name, v);
                                }
                            }
                            return true;
                        }
                    };
                    visitor.visit(item);
                    item.visitRecursively(visitor);
                }
            });
            if (worker != null && worker.isCancelled()) {
                throw new InterruptedException();
            }
            LinkedHashMap result = new LinkedHashMap();
            for (String className : resultInstance.keySet()) {
                for (String traitName : ((Map)resultInstance.get(className)).keySet()) {
                    if (!result.containsKey(className)) {
                        result.put(className, new LinkedHashMap());
                    }
                    ((Map)result.get(className)).put(traitName, ((Map)resultInstance.get(className)).get(traitName));
                }
            }
            for (String className : resultStatic.keySet()) {
                for (String traitName : ((Map)resultStatic.get(className)).keySet()) {
                    if (!result.containsKey(className)) {
                        result.put(className, new LinkedHashMap());
                    }
                    ((Map)result.get(className)).put(traitName, ((Map)resultStatic.get(className)).get(traitName));
                }
            }
            LinkedHashMap linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            for (String key : asms.keySet()) {
                DoInitActionTag doi;
                String exportName;
                ASMSource asm = asms.get(key);
                if (!(asm instanceof DoInitActionTag) || (exportName = (doi = (DoInitActionTag)asm).getSwf().getCharacter(doi.getCharacterId()).getExportName()) == null || !exportName.startsWith("__Packages.")) continue;
                SWF.uncache(doi);
            }
            if (worker != null) {
                worker.removeCancelListener(cancelListener);
            }
        }
    }
}

