/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf7.ActionCastOp;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CastOpActionItem
extends ActionItem {
    public GraphTargetItem constructor;
    public GraphTargetItem object;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.constructor);
        visitor.visit(this.object);
    }

    public CastOpActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem constructor, GraphTargetItem object) {
        super(instruction, lineStartIns, 0);
        this.constructor = constructor;
        this.object = object;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.stripQuotes(this.constructor, localData, writer);
        writer.append("(");
        this.object.toString(writer, localData);
        writer.append(")");
        return writer;
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.constructor.getNeededSources());
        ret.addAll(this.object.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return CastOpActionItem.toSourceMerge(localData, generator, this.constructor, this.object, new ActionCastOp());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.constructor);
        hash = 29 * hash + Objects.hashCode(this.object);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CastOpActionItem other = (CastOpActionItem)obj;
        if (!Objects.equals(this.constructor, other.constructor)) {
            return false;
        }
        return Objects.equals(this.object, other.object);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CastOpActionItem other = (CastOpActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.constructor, other.constructor)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.object, other.object);
    }
}

