/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionGetVariable;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GetVariableActionItem
extends ActionItem {
    public final GraphTargetItem name;
    private GraphTargetItem computedValue;
    private Object computedResult;
    private boolean computedCompiletime = false;
    private boolean computedVariableComputed = false;
    public boolean printObfuscatedName = false;

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.name);
    }

    public GetVariableActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(instruction, lineStartIns, 0);
        this.name = value;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.name instanceof DirectValueActionItem && this.printObfuscatedName) {
            HighlightData srcData = this.getSrcData();
            srcData.localName = this.name.toStringNoQuotes(localData);
            StringBuilder sb = new StringBuilder();
            StringBuilderTextWriter sbw = new StringBuilderTextWriter(new CodeFormatting(), sb);
            this.stripQuotes(this.name, localData, sbw);
            writer.append(IdentifiersDeobfuscation.printIdentifier(localData.swf, localData.usedDeobfuscations, false, sb.toString(), new String[0]));
            return writer;
        }
        if (this.name instanceof DirectValueActionItem && ((DirectValueActionItem)this.name).isString() && (this.printObfuscatedName || IdentifiersDeobfuscation.isValidNameWithDot(false, ((DirectValueActionItem)this.name).toStringNoQuotes(localData), "this", "super"))) {
            HighlightData srcData = this.getSrcData();
            srcData.localName = this.name.toStringNoQuotes(localData);
            return this.stripQuotes(this.name, localData, writer);
        }
        writer.append("eval(");
        this.name.appendTry(writer, localData);
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.name.getNeededSources());
        return ret;
    }

    @Override
    public boolean isVariableComputed() {
        return true;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return false;
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void setComputedValue(GraphTargetItem computedValue) {
        this.computedValue = computedValue;
        if (computedValue != null) {
            this.computedCompiletime = computedValue.isCompileTime();
            if (this.computedCompiletime) {
                this.computedResult = computedValue.getResult();
            }
            this.computedVariableComputed = computedValue.isVariableComputed();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetVariableActionItem other = (GetVariableActionItem)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetVariableActionItem other = (GetVariableActionItem)obj;
        return this.name == other.name || this.name != null && this.name.valueEquals(other.name);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return GetVariableActionItem.toSourceMerge(localData, generator, this.name, new ActionGetVariable());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

