/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.ActionGraphTargetDialect;
import com.jpexs.decompiler.flash.action.model.CompoundableBinaryOpAs12;
import com.jpexs.decompiler.flash.action.swf5.ActionBitURShift;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import java.util.ArrayList;
import java.util.List;

public class URShiftActionItem
extends BinaryOpItem
implements CompoundableBinaryOpAs12 {
    public URShiftActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(ActionGraphTargetDialect.INSTANCE, instruction, lineStartIns, 5, leftSide, rightSide, ">>>", "Number", "Number");
    }

    @Override
    public Object getResult() {
        return URShiftActionItem.getResult(this.rightSide.getResultAsNumber(), this.leftSide.getResultAsNumber());
    }

    public static long getResult(Double rightResult, Double leftResult) {
        long leftResult2 = (long)leftResult.doubleValue() & 0xFFFFFFFFL;
        long rightResult2 = (long)rightResult.doubleValue() & 0x1FL;
        return leftResult2 >>> (int)rightResult2;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return URShiftActionItem.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new ActionBitURShift());
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionBitURShift());
        return ret;
    }
}

