/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf4;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraphSource;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=4)
public class ActionIf
extends Action {
    private int offset;
    public String identifier;
    public boolean jumpUsed = true;
    public boolean ignoreUsed = true;

    public int getJumpOffset() {
        return this.offset;
    }

    public final void setJumpOffset(int offset) {
        this.offset = offset;
    }

    public ActionIf(int offset, String charset) {
        super(157, 2, charset);
        this.setJumpOffset(offset);
    }

    public ActionIf(int actionLength, SWFInputStream sis) throws IOException {
        super(157, actionLength, sis.getCharset());
        this.setJumpOffset(sis.readSI16("offset"));
    }

    @Override
    public void getRef(Set<Long> refs) {
        refs.add(this.getTargetAddress());
    }

    public long getTargetAddress() {
        return this.getAddress() + 5L + (long)this.offset;
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeSI16(this.offset);
    }

    @Override
    protected int getContentBytesLength() {
        return 2;
    }

    @Override
    public String getASMSource(ActionList container, Set<Long> knownAddresses, ScriptExportMode exportMode) {
        long address = this.getTargetAddress();
        String ofsStr = Helper.formatAddress(address);
        return "If loc" + ofsStr + (!this.jumpUsed ? " ;compileTimeIgnore" : (!this.ignoreUsed ? " ;compileTimeJump" : ""));
    }

    public ActionIf(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(157, 2, charset);
        this.identifier = this.lexIdentifier(lexer);
    }

    @Override
    public String toString() {
        return "ActionIf " + this.offset;
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        if (lda.stackIsEmpty()) {
            return false;
        }
        if (EcmaScript.toBoolean(lda.pop())) {
            lda.jump = this.getTargetAddress();
        }
        return true;
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public List<Integer> getBranches(GraphSource code) {
        List<Integer> ret = super.getBranches(code);
        int length = this.getTotalActionLength();
        long targetAddress = this.getTargetAddress();
        int jmp = code.adr2pos(targetAddress);
        int after = code.adr2pos(this.getAddress() + (long)length);
        if (jmp == -1) {
            Logger.getLogger(ActionIf.class.getName()).log(Level.SEVERE, "Invalid IF jump to ofs{0} from ofs{1} in {2}", new Object[]{Helper.formatAddress(targetAddress), Helper.formatAddress(this.getAddress()), ((ActionGraphSource)code).getPath()});
            ret.add(after);
        } else {
            ret.add(jmp);
        }
        ret.add(after);
        return ret;
    }
}

