/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf5;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=5)
public class ActionConstantPool
extends Action {
    public List<String> constantPool = new ArrayList<String>();

    public ActionConstantPool(List<String> constantPool, String charset) {
        super(136, 0, charset);
        this.constantPool = constantPool;
    }

    public ActionConstantPool(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(136, actionLength, sis.getCharset());
        int count = sis.readUI16("count");
        for (int i = 0; i < count; ++i) {
            this.constantPool.add(sis.readString("constant"));
        }
    }

    public ActionConstantPool(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(136, 0, charset);
        ASMParsedSymbol symb;
        boolean first = true;
        while (true) {
            boolean valueRequired = false;
            symb = lexer.lex();
            if (!first && symb.type == 18) {
                symb = lexer.lex();
                valueRequired = true;
            }
            if (symb.type != 1) {
                if (valueRequired) {
                    throw new ActionParseException("String expected", lexer.yyline());
                }
                break;
            }
            this.constantPool.add((String)symb.value);
            first = false;
        }
        lexer.pushback(symb);
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.constantPool.size());
        for (String s : this.constantPool) {
            sos.writeString(s);
        }
    }

    @Override
    protected int getContentBytesLength() {
        return ActionConstantPool.calculateSize(this.constantPool, this.charset);
    }

    public static int calculateSize(String str, String charset) {
        return Utf8Helper.getBytesLength(str, charset) + 1;
    }

    public static int calculateSize(List<String> strings, String charset) {
        int res = 2;
        for (String s : strings) {
            res += Utf8Helper.getBytesLength(s, charset) + 1;
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("ConstantPool");
        for (int i = 0; i < this.constantPool.size(); ++i) {
            if (i > 0) {
                ret.append(",");
            }
            ret.append(" \"").append(Helper.escapeActionScriptString(this.constantPool.get(i))).append("\"");
        }
        return ret.toString();
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        lda.constantPool = this.constantPool;
        return true;
    }

    @Override
    public void translate(Set<String> usedDeobfuscations, Map<String, Map<String, Trait>> uninitializedClassTraits, SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
    }
}

