/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.asdoc;

import com.jpexs.decompiler.flash.asdoc.ActionScriptDocLexer;
import com.jpexs.decompiler.flash.asdoc.AsDocComment;
import com.jpexs.decompiler.flash.asdoc.AsDocParseException;
import com.jpexs.decompiler.flash.asdoc.AsDocTag;
import com.jpexs.decompiler.flash.asdoc.ParsedSymbol;
import com.jpexs.decompiler.flash.asdoc.SymbolType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ActionScriptDocParser {
    public List<AsDocComment> parse(String str) {
        ArrayList<AsDocComment> comments = new ArrayList<AsDocComment>();
        ActionScriptDocLexer lexer = new ActionScriptDocLexer(str);
        try {
            ParsedSymbol s = lexer.yylex();
            String startText = null;
            ArrayList<AsDocTag> tags = new ArrayList<AsDocTag>();
            while (s.type != SymbolType.EOF) {
                if (s.type == SymbolType.DOC_BEGIN) {
                    startText = s.text;
                }
                if (s.type == SymbolType.DOC_MIDDLE || s.type == SymbolType.DOC_END && s.tag != null) {
                    tags.add(new AsDocTag(s.tag, s.text));
                }
                if (s.type == SymbolType.DOC_END) {
                    comments.add(new AsDocComment(startText, tags));
                    startText = null;
                    tags = new ArrayList();
                }
                s = lexer.yylex();
            }
        }
        catch (AsDocParseException | IOException exception) {
            // empty catch block
        }
        return comments;
    }
}

