/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ImageExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ImageExportSettings;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.HasSeparateAlphaChannel;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageExporter {
    public List<File> exportImages(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, ImageExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Tag t : tags) {
            if (!(t instanceof ImageTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            HasSeparateAlphaChannel hsac;
            ImageFormat fileFormat;
            if (!(t instanceof ImageTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("image", currentIndex, count, t.getName());
            }
            ImageTag imageTag = (ImageTag)t;
            ImageFormat originalFormat = fileFormat = imageTag.getOriginalImageFormat();
            boolean hasSeparateAlpha = false;
            if (imageTag instanceof HasSeparateAlphaChannel) {
                HasSeparateAlphaChannel hsac2 = (HasSeparateAlphaChannel)((Object)imageTag);
                hasSeparateAlpha = hsac2.hasAlphaChannel();
            }
            if (settings.mode == ImageExportMode.PNG_GIF_JPEG && hasSeparateAlpha) {
                fileFormat = ImageFormat.PNG;
            }
            if (settings.mode == ImageExportMode.PNG) {
                fileFormat = ImageFormat.PNG;
            }
            if (settings.mode == ImageExportMode.JPEG) {
                fileFormat = ImageFormat.JPEG;
            }
            if (settings.mode == ImageExportMode.BMP) {
                fileFormat = ImageFormat.BMP;
            }
            if (settings.mode == ImageExportMode.WEBP) {
                fileFormat = ImageFormat.WEBP;
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(imageTag.getCharacterExportFileName() + "." + ImageHelper.getImageFormatString(fileFormat)));
            ImageFormat ffileFormat = fileFormat;
            new RetryTask(() -> {
                if (ffileFormat == originalFormat) {
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                        ((OutputStream)fos).write(Helper.readStream(imageTag.getImageData()));
                    }
                } else if (ffileFormat == ImageFormat.BMP) {
                    BMPFile.saveBitmap(imageTag.getImageCached().getBufferedImage(), file);
                } else if (ffileFormat == ImageFormat.WEBP) {
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                        byte[] webPData = originalFormat == ImageFormat.PNG || originalFormat == ImageFormat.GIF ? WebPCodec.encodeLosslessImage((BufferedImage)imageTag.getImageCached().getBufferedImage()) : WebPCodec.encodeImage((BufferedImage)imageTag.getImageCached().getBufferedImage(), (float)100.0f);
                        ((OutputStream)fos).write(webPData);
                    }
                } else {
                    ImageHelper.write(imageTag.getImageCached().getBufferedImage(), ffileFormat, file);
                }
            }, handler).run();
            File alphaPngFile = new File(outdir + File.separator + Helper.makeFileName(imageTag.getCharacterExportFileName() + ".alpha.png"));
            if (imageTag instanceof HasSeparateAlphaChannel && settings.mode == ImageExportMode.PNG_GIF_JPEG_ALPHA && (hsac = (HasSeparateAlphaChannel)((Object)imageTag)).hasAlphaChannel()) {
                new RetryTask(() -> {
                    byte[] alphaChannel = hsac.getImageAlpha();
                    Dimension dim = imageTag.getImageDimension();
                    BufferedImage img = new BufferedImage(dim.width, dim.height, 2);
                    int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < pixels.length; ++i) {
                        int v;
                        int a = alphaChannel[i] & 0xFF;
                        int r = v = 0;
                        int g = v;
                        int b = v;
                        pixels[i] = a << 24 | b << 16 | g << 8 | r;
                    }
                    ImageIO.write((RenderedImage)img, "PNG", alphaPngFile);
                }, handler).run();
            }
            LinkedHashSet<String> classNames = imageTag.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
                        className = DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), imageTag.getSwf(), true);
                    }
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(className + "." + ImageHelper.getImageFormatString(fileFormat)));
                    File classAlphaPngFile = new File(outdir + File.separator + Helper.makeFileName(className + ".alpha.png"));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    if (alphaPngFile.exists()) {
                        Files.copy(alphaPngFile.toPath(), classAlphaPngFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    ret.add(classFile);
                }
                file.delete();
                if (alphaPngFile.exists()) {
                    alphaPngFile.delete();
                }
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("image", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }
}

