/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.MorphShapeExportMode;
import com.jpexs.decompiler.flash.exporters.morphshape.CanvasMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.settings.MorphShapeExportSettings;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MorphShapeExporter {
    public List<File> exportMorphShapes(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, MorphShapeExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof MorphShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof MorphShapeTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("morphshape", currentIndex, count, t.getName());
            }
            int characterID = 0;
            if (t instanceof CharacterTag) {
                characterID = ((CharacterTag)t).getCharacterId();
            }
            File file = new File(outdir + File.separator + characterID + settings.getFileExtension());
            File fileStart = new File(outdir + File.separator + characterID + ".start" + settings.getFileExtension());
            File fileEnd = new File(outdir + File.separator + characterID + ".end" + settings.getFileExtension());
            MorphShapeTag mst = (MorphShapeTag)t;
            new RetryTask(() -> MorphShapeExporter.lambda$exportMorphShapes$0(mst, settings, fileStart, fileEnd, file, t), handler).run();
            LinkedHashSet<String> classNames = mst.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
                        className = DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), mst.getSwf(), true);
                    }
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(className + settings.getFileExtension()));
                    File classFileStart = new File(outdir + File.separator + Helper.makeFileName(className + ".start" + settings.getFileExtension()));
                    File classFileEnd = new File(outdir + File.separator + Helper.makeFileName(className + ".end" + settings.getFileExtension()));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    ret.add(classFile);
                    if (fileStart.exists()) {
                        new RetryTask(() -> Files.copy(fileStart.toPath(), classFileStart.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    }
                    if (!fileEnd.exists()) continue;
                    new RetryTask(() -> Files.copy(fileEnd.toPath(), classFileEnd.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                }
                file.delete();
                if (fileStart.exists()) {
                    fileStart.delete();
                }
                if (fileEnd.exists()) {
                    fileEnd.delete();
                }
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("morphshape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == MorphShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$exportMorphShapes$0(MorphShapeTag mst, MorphShapeExportSettings settings, File fileStart, File fileEnd, File file, Tag t) throws IOException, InterruptedException {
        st = mst.getStartShapeTag();
        rect = st.getRect();
        m = Matrix.getScaleInstance(settings.zoom);
        m.translate(-rect.Xmin, -rect.Ymin);
        switch (1.$SwitchMap$com$jpexs$decompiler$flash$exporters$modes$MorphShapeExportMode[settings.mode.ordinal()]) {
            case 1: {
                fos = new BufferedOutputStream(new FileOutputStream(fileStart));
                var10_12 = null;
                try {
                    rect2 = new ExportRectangle(mst.getStartBounds());
                    rect2.xMax *= settings.zoom;
                    rect2.yMax *= settings.zoom;
                    rect2.xMin *= settings.zoom;
                    rect2.yMin *= settings.zoom;
                    exporter = new SVGExporter(rect2, settings.zoom, "shape");
                    mst.getStartShapeTag().toSVG(exporter, -2, new CXFORMWITHALPHA(), 0, m, m);
                    fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                }
                catch (Throwable rect2) {
                    var10_12 = rect2;
                    throw rect2;
                }
                finally {
                    if (fos != null) {
                        if (var10_12 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable rect2) {
                                var10_12.addSuppressed(rect2);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
                fos = new BufferedOutputStream(new FileOutputStream(fileEnd));
                var10_12 = null;
                rect2 = new ExportRectangle(mst.getStartBounds());
                rect2.xMax *= settings.zoom;
                rect2.yMax *= settings.zoom;
                rect2.xMin *= settings.zoom;
                rect2.yMin *= settings.zoom;
                exporter = new SVGExporter(rect2, settings.zoom, "shape");
                mst.getEndShapeTag().toSVG(exporter, -2, new CXFORMWITHALPHA(), 0, m, m);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var10_12 == null) ** GOTO lbl52
                try {
                    fos.close();
                }
                catch (Throwable rect2) {
                    var10_12.addSuppressed(rect2);
                }
                break;
lbl52:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect2) {
                    try {
                        var10_12 = rect2;
                        throw rect2;
                    }
                    catch (Throwable var15_32) {
                        if (fos != null) {
                            if (var10_12 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var16_36) {
                                    var10_12.addSuppressed(var16_36);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var15_32;
                    }
                }
            }
            case 2: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var10_13 = null;
                rect2 = new ExportRectangle(mst.getRect());
                rect2.xMax *= settings.zoom;
                rect2.yMax *= settings.zoom;
                rect2.xMin *= settings.zoom;
                rect2.yMin *= settings.zoom;
                exporter = new SVGExporter(rect2, settings.zoom, "morphshape");
                mst.toSVG(exporter, -2, new CXFORMWITHALPHA(), 0, m, m);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var10_13 == null) ** GOTO lbl89
                try {
                    fos.close();
                }
                catch (Throwable rect2) {
                    var10_13.addSuppressed(rect2);
                }
                break;
lbl89:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect2) {
                    try {
                        var10_13 = rect2;
                        throw rect2;
                    }
                    catch (Throwable var17_47) {
                        if (fos != null) {
                            if (var10_13 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var18_49) {
                                    var10_13.addSuppressed(var18_49);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var17_47;
                    }
                }
            }
            case 3: 
            case 4: 
            case 5: {
                unzoom = settings.zoom;
                st = mst.getStartShapeTag();
                rect = st.getRect();
                newWidth = (int)((double)rect.getWidth() * settings.zoom / 20.0) + 1;
                newHeight = (int)((double)rect.getHeight() * settings.zoom / 20.0) + 1;
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
                if (settings.mode == MorphShapeExportMode.BMP_START_END && (backColor = t.getSwf().getBackgroundColor().backgroundColor) != null) {
                    g = (Graphics2D)img.getGraphics();
                    g.setColor(backColor.toColor());
                    g.fillRect(0, 0, img.getWidth(), img.getHeight());
                }
                m = Matrix.getScaleInstance(settings.zoom);
                m.translate(-rect.Xmin, -rect.Ymin);
                st.toImage(0, 0, 0, new RenderContext(), img, img, false, m, m, m, m, new CXFORMWITHALPHA(), unzoom, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, true);
                if (settings.mode == MorphShapeExportMode.PNG_START_END) {
                    ImageHelper.write(img.getBufferedImage(), ImageFormat.PNG, fileStart);
                } else if (settings.mode == MorphShapeExportMode.WEBP_START_END) {
                    fos = new FileOutputStream(fileStart);
                    g = null;
                    try {
                        fos.write(WebPCodec.encodeImage((BufferedImage)img.getBufferedImage(), (float)100.0f));
                    }
                    catch (Throwable var16_38) {
                        g = var16_38;
                        throw var16_38;
                    }
                    finally {
                        if (fos != null) {
                            if (g != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var16_37) {
                                    g.addSuppressed(var16_37);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                } else {
                    BMPFile.saveBitmap(img.getBufferedImage(), fileStart);
                }
                st = mst.getEndShapeTag();
                rect = st.getRect();
                newWidth = (int)((double)rect.getWidth() * settings.zoom / 20.0) + 1;
                newHeight = (int)((double)rect.getHeight() * settings.zoom / 20.0) + 1;
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
                if (settings.mode == MorphShapeExportMode.BMP_START_END && (backColor = t.getSwf().getBackgroundColor().backgroundColor) != null) {
                    g = (Graphics2D)img.getGraphics();
                    g.setColor(backColor.toColor());
                    g.fillRect(0, 0, img.getWidth(), img.getHeight());
                }
                m = Matrix.getScaleInstance(settings.zoom);
                m.translate(-rect.Xmin, -rect.Ymin);
                st.toImage(0, 0, 0, new RenderContext(), img, img, false, m, m, m, m, new CXFORMWITHALPHA(), unzoom, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, true);
                if (settings.mode == MorphShapeExportMode.PNG_START_END) {
                    ImageHelper.write(img.getBufferedImage(), ImageFormat.PNG, fileEnd);
                    break;
                }
                if (settings.mode != MorphShapeExportMode.WEBP_START_END) ** GOTO lbl191
                fos = new FileOutputStream(fileEnd);
                var15_33 = null;
                fos.write(WebPCodec.encodeLosslessImage((BufferedImage)img.getBufferedImage()));
                if (fos == null) break;
                if (var15_33 == null) ** GOTO lbl174
                try {
                    fos.close();
                }
                catch (Throwable var16_39) {
                    var15_33.addSuppressed(var16_39);
                }
                break;
lbl174:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var16_40) {
                    try {
                        var15_33 = var16_40;
                        throw var16_40;
                    }
                    catch (Throwable var21_55) {
                        if (fos != null) {
                            if (var15_33 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var22_57) {
                                    var15_33.addSuppressed(var22_57);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var21_55;
                    }
                }
lbl191:
                // 1 sources

                BMPFile.saveBitmap(img.getBufferedImage(), fileEnd);
                break;
            }
            case 6: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var15_34 = null;
                deltaX = -Math.min(mst.getStartBounds().Xmin, mst.getEndBounds().Xmin);
                deltaY = -Math.min(mst.getStartBounds().Ymin, mst.getEndBounds().Ymin);
                cse = new CanvasMorphShapeExporter(mst.getShapeNum(), mst.getSwf(), mst.getShapeAtRatio(0), mst.getShapeAtRatio(65535), new CXFORMWITHALPHA(), 20.0, deltaX, deltaY);
                cse.export();
                needed = new HashSet<Integer>();
                ct = mst;
                needed.add(ct.getCharacterId());
                ct.getNeededCharactersDeep(needed);
                baos = new ByteArrayOutputStream();
                SWF.libraryToHtmlCanvas(ct.getSwf(), needed, baos);
                fos.write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(mst) + mst.getCharacterId(), mst.getRect())));
                if (fos == null) break;
                if (var15_34 == null) ** GOTO lbl217
                try {
                    fos.close();
                }
                catch (Throwable deltaX) {
                    var15_34.addSuppressed(deltaX);
                }
                break;
lbl217:
                // 1 sources

                fos.close();
                break;
                catch (Throwable deltaX) {
                    try {
                        var15_34 = deltaX;
                        throw deltaX;
                    }
                    catch (Throwable var23_58) {
                        if (fos != null) {
                            if (var15_34 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var24_59) {
                                    var15_34.addSuppressed(var24_59);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var23_58;
                    }
                }
            }
            case 7: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var15_35 = null;
                try {
                    new PreviewExporter().exportSwf(fos, mst, null, 0, false);
                }
                catch (ActionParseException ex) {
                    Logger.getLogger(MorphShapeExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (fos == null) break;
                if (var15_35 == null) ** GOTO lbl252
                try {
                    fos.close();
                }
                catch (Throwable var16_45) {
                    var15_35.addSuppressed(var16_45);
                }
                break;
lbl252:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var16_46) {
                    try {
                        var15_35 = var16_46;
                        throw var16_46;
                    }
                    catch (Throwable var25_60) {
                        if (fos != null) {
                            if (var15_35 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var26_61) {
                                    var15_35.addSuppressed(var26_61);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var25_60;
                    }
                }
            }
        }
    }
}

