/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.MorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ShapeExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShapeExporter {
    public List<File> exportShapes(AbortRetryIgnoreHandler handler, String outdir, SWF swf, ReadOnlyTagList tags, ShapeExportSettings settings, EventListener evl, double unzoom) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof ShapeTag)) continue;
            ShapeTag st = (ShapeTag)t;
            if (evl != null) {
                evl.handleExportingEvent("shape", currentIndex, count, t.getName());
            }
            File file = new File(outdir + File.separator + Helper.makeFileName(st.getCharacterExportFileName() + settings.getFileExtension()));
            new RetryTask(() -> ShapeExporter.lambda$exportShapes$0(settings, st, file, swf, unzoom), handler).run();
            LinkedHashSet<String> classNames = st.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue()) {
                        className = DottedChain.parseNoSuffix(className).toPrintableString(new LinkedHashSet<String>(), st.getSwf(), true);
                    }
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(className + settings.getFileExtension()));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    ret.add(classFile);
                }
                file.delete();
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("shape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == ShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$exportShapes$0(ShapeExportSettings settings, ShapeTag st, File file, SWF swf, double unzoom) throws IOException, InterruptedException {
        m = Matrix.getScaleInstance(settings.zoom);
        rect = st.getRect();
        m.translate(-rect.Xmin, -rect.Ymin);
        switch (1.$SwitchMap$com$jpexs$decompiler$flash$exporters$modes$ShapeExportMode[settings.mode.ordinal()]) {
            case 1: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var9_9 = null;
                rect2 = new ExportRectangle(st.getRect());
                rect2.xMax *= settings.zoom;
                rect2.yMax *= settings.zoom;
                rect2.xMin *= settings.zoom;
                rect2.yMin *= settings.zoom;
                exporter = new SVGExporter(rect2, settings.zoom, "shape");
                st.toSVG(exporter, -2, new CXFORMWITHALPHA(), 0, m, m);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var9_9 == null) ** GOTO lbl25
                try {
                    fos.close();
                }
                catch (Throwable rect2) {
                    var9_9.addSuppressed(rect2);
                }
                break;
lbl25:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect2) {
                    try {
                        var9_9 = rect2;
                        throw rect2;
                    }
                    catch (Throwable var12_19) {
                        if (fos != null) {
                            if (var9_9 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var13_23) {
                                    var9_9.addSuppressed(var13_23);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var12_19;
                    }
                }
            }
            case 2: 
            case 3: 
            case 4: {
                newWidth = (int)((double)rect.getWidth() * settings.zoom / 20.0) + 1;
                newHeight = (int)((double)rect.getHeight() * settings.zoom / 20.0) + 1;
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
                if (settings.mode == ShapeExportMode.BMP && (backColor = swf.getBackgroundColor().backgroundColor) != null) {
                    g = (Graphics2D)img.getGraphics();
                    g.setColor(backColor.toColor());
                    g.fillRect(0, 0, img.getWidth(), img.getHeight());
                }
                st.toImage(0, 0, 0, new RenderContext(), img, img, false, m, m, m, m, new CXFORMWITHALPHA(), unzoom, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, true);
                if (settings.mode == ShapeExportMode.PNG) {
                    ImageHelper.write(img.getBufferedImage(), ImageFormat.PNG, file);
                    break;
                }
                if (settings.mode != ShapeExportMode.WEBP) ** GOTO lbl85
                fos = new FileOutputStream(file);
                var12_20 = null;
                fos.write(WebPCodec.encodeLosslessImage((BufferedImage)img.getBufferedImage()));
                if (fos == null) break;
                if (var12_20 == null) ** GOTO lbl68
                try {
                    fos.close();
                }
                catch (Throwable var13_24) {
                    var12_20.addSuppressed(var13_24);
                }
                break;
lbl68:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var13_25) {
                    try {
                        var12_20 = var13_25;
                        throw var13_25;
                    }
                    catch (Throwable var14_32) {
                        if (fos != null) {
                            if (var12_20 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var15_34) {
                                    var12_20.addSuppressed(var15_34);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var14_32;
                    }
                }
lbl85:
                // 1 sources

                BMPFile.saveBitmap(img.getBufferedImage(), file);
                break;
            }
            case 5: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var12_21 = null;
                shp = st.getShapes();
                deltaX = -shp.getBounds((int)1).Xmin;
                deltaY = -shp.getBounds((int)1).Ymin;
                cse = new CanvasShapeExporter(st.getWindingRule(), st.getShapeNum(), null, 20.0 / settings.zoom, st.getSwf(), shp, new CXFORMWITHALPHA(), deltaX, deltaY);
                cse.export();
                needed = new HashSet<Integer>();
                needed.add(st.getCharacterId());
                st.getNeededCharactersDeep(needed);
                baos = new ByteArrayOutputStream();
                SWF.libraryToHtmlCanvas(st.getSwf(), needed, baos);
                fos.write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(st) + st.getCharacterId(), st.getRect())));
                if (fos == null) break;
                if (var12_21 == null) ** GOTO lbl111
                try {
                    fos.close();
                }
                catch (Throwable shp) {
                    var12_21.addSuppressed(shp);
                }
                break;
lbl111:
                // 1 sources

                fos.close();
                break;
                catch (Throwable shp) {
                    try {
                        var12_21 = shp;
                        throw shp;
                    }
                    catch (Throwable var19_39) {
                        if (fos != null) {
                            if (var12_21 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var20_40) {
                                    var12_21.addSuppressed(var20_40);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var19_39;
                    }
                }
            }
            case 6: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var12_22 = null;
                try {
                    new PreviewExporter().exportSwf(fos, st, null, 0, false);
                }
                catch (ActionParseException ex) {
                    Logger.getLogger(MorphShapeExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (fos == null) break;
                if (var12_22 == null) ** GOTO lbl146
                try {
                    fos.close();
                }
                catch (Throwable var13_30) {
                    var12_22.addSuppressed(var13_30);
                }
                break;
lbl146:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var13_31) {
                    try {
                        var12_22 = var13_31;
                        throw var13_31;
                    }
                    catch (Throwable var21_41) {
                        if (fos != null) {
                            if (var12_22 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var22_42) {
                                    var12_22.addSuppressed(var22_42);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var21_41;
                    }
                }
            }
        }
    }
}

