/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.morphshape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.exporters.morphshape.MorphShapeExporterBase;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;

public class CanvasMorphShapeExporter
extends MorphShapeExporterBase {
    protected static final String DRAW_COMMAND_M = "M";
    protected static final String DRAW_COMMAND_L = "L";
    protected static final String DRAW_COMMAND_Q = "Q";
    protected static final String DRAW_COMMAND_Z = "Z";
    protected String currentDrawCommand = "";
    protected double deltaX = 0.0;
    protected double deltaY = 0.0;
    protected StringBuilder pathData = new StringBuilder();
    protected StringBuilder fillData = new StringBuilder();
    protected double unitDivisor;
    protected StringBuilder shapeData = new StringBuilder();
    protected StringBuilder strokeData = new StringBuilder();
    protected Matrix fillMatrix = null;
    protected Matrix fillMatrixEnd = null;
    protected String lastGradColor = null;
    protected int repeatCnt = 0;
    protected SWF swf;
    protected StringBuilder lineFillData = null;
    protected String lineLastGradColor = null;
    protected Matrix lineFillMatrix = null;
    protected Matrix lineFillMatrixEnd = null;
    protected int lineRepeatCnt = 0;
    protected int fillWidth;
    protected int fillHeight;

    public CanvasMorphShapeExporter(int morphShapeNum, SWF swf, SHAPE shape, SHAPE endShape, ColorTransform colorTransform, double unitDivisor, int deltaX, int deltaY) {
        super(morphShapeNum, shape, endShape, colorTransform);
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.unitDivisor = unitDivisor;
        this.swf = swf;
    }

    private String getDrawJs(int width, int height, String id, RECT rect) {
        return "var originalWidth=" + width + ";\r\nvar originalHeight=" + height + ";\r\n function drawFrame(ctx,ratio){\r\n\tctx.save();\r\n\tctx.transform(canvas.width/originalWidth,0,0,canvas.height/originalHeight,0,0);\r\n\tplace(\"" + id + "\",canvas,ctx,[" + 1.0 / this.unitDivisor + ",0.0,0.0," + 1.0 / this.unitDivisor + "," + (double)(-rect.Xmin) / this.unitDivisor + "," + (double)(-rect.Ymin) / this.unitDivisor + "],ctrans,1,0,ratio,0);\r\n\tctx.restore();\r\n}\r\n";
    }

    public String getHtml(String needed, String id, RECT rect) {
        int width = (int)((double)rect.getWidth() / this.unitDivisor);
        int height = (int)((double)rect.getHeight() / this.unitDivisor);
        return CanvasShapeExporter.getHtmlPrefix(width, height) + CanvasMorphShapeExporter.getJsPrefix() + needed + this.getDrawJs(width, height, id, rect) + CanvasMorphShapeExporter.getJsSuffix(width, height) + CanvasShapeExporter.getHtmlSuffix();
    }

    private static String getJsSuffix(int width, int height) {
        StringBuilder ret = new StringBuilder();
        int step = Math.round(655.0f);
        int rate = 10;
        ret.append("var step = ").append(step).append(";\r\n");
        ret.append("var ratio = -1;\r\n");
        ret.append("function nextFrame(ctx){\r\n");
        ret.append("\tctx.clearRect(0,0,").append(width).append(",").append(height).append(");\r\n");
        ret.append("\tratio = (ratio+step)%65535;\r\n");
        ret.append("\tdrawFrame(ctx,ratio);\r\n");
        ret.append("}\r\n");
        ret.append("window.setInterval(function(){nextFrame(ctx)},").append(rate).append(");\r\n");
        ret.append(CanvasShapeExporter.getJsSuffix());
        return ret.toString();
    }

    private static String getJsPrefix() {
        String ret = CanvasShapeExporter.getJsPrefix();
        return ret;
    }

    @Override
    public void beginShape() {
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        if (close) {
            this.pathData.append(DRAW_COMMAND_Z).append(" ");
        }
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color, RGB colorEnd) {
        this.finalizePath();
        this.fillData.append("\tctx.fillStyle=").append(this.useRatioColor(color, colorEnd)).append(";\r\n");
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
        this.finalizePath();
        int REPEAT_CNT = 5;
        int n = this.repeatCnt = spreadMethod == 0 ? 0 : 5;
        if (type == 16) {
            Point start = matrix.transform(new Point(-16384 - 32768 * this.repeatCnt, 0.0));
            Point end = matrix.transform(new Point(16384 + 32768 * this.repeatCnt, 0.0));
            start.x += this.deltaX;
            start.y += this.deltaY;
            end.x += this.deltaX;
            end.y += this.deltaY;
            Point start2 = matrixEnd.transform(new Point(-16384 - 32768 * this.repeatCnt, 0.0));
            Point end2 = matrixEnd.transform(new Point(16384 + 32768 * this.repeatCnt, 0.0));
            start2.x += this.deltaX;
            start2.y += this.deltaY;
            end2.x += this.deltaX;
            end2.y += this.deltaY;
            this.fillData.append("\tvar grd=ctx.createLinearGradient(").append(this.useRatioPos(start.x, start2.x)).append(",").append(this.useRatioPos(start.y, start2.y)).append(",").append(this.useRatioPos(end.x, end2.x)).append(",").append(this.useRatioPos(end.y, end2.y)).append(");\r\n");
        } else {
            this.fillMatrix = matrix;
            this.fillMatrixEnd = matrixEnd;
            this.fillData.append("\tvar grd=ctx.createRadialGradient(").append(this.useRatioDouble(focalPointRatio * 16384.0f, focalPointRatioEnd * 16384.0f)).append(",0,0,0,0,").append(16384 + 32768 * this.repeatCnt).append(");\r\n");
        }
        int repeatTotal = this.repeatCnt * 2 + 1;
        double oneHeight = 1.0 / (double)repeatTotal;
        double pos = 0.0;
        boolean revert = false;
        if (type != 16 && spreadMethod == 1) {
            revert = true;
        }
        for (int i = 0; i < repeatTotal; ++i) {
            if (spreadMethod == 1) {
                revert = !revert;
            }
            for (int j = 0; j < gradientRecords.length; ++j) {
                GRADRECORD r = gradientRecords[j];
                GRADRECORD r2 = gradientRecordsEnd[j];
                this.fillData.append("\tvar s = ").append(this.useRatioDouble(pos + oneHeight * (double)(revert ? 255 - r.ratio : r.ratio) / 255.0, pos + oneHeight * (double)(revert ? 255 - r2.ratio : r2.ratio) / 255.0)).append(";\r\n\tif(s<0) s = 0;\r\n\tif(s>1) s = 1;\r\n");
                this.fillData.append("\tgrd.addColorStop(s,").append(this.useRatioColor(r.color, r2.color)).append(");\r\n");
                this.lastGradColor = this.useRatioColor(r.color, r2.color);
            }
            pos += oneHeight;
        }
        this.fillData.append("\tctx.fillStyle = grd;\r\n");
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, Matrix matrixEnd, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        this.finalizePath();
        ImageTag image = this.swf.getImage(bitmapId);
        if (image != null && (img = image.getImageCached()) != null) {
            this.fillWidth = img.getWidth();
            this.fillHeight = img.getHeight();
            if (colorTransform != null) {
                colorTransform.apply(img);
            }
            if (matrix != null) {
                this.fillMatrix = matrix;
                this.fillMatrixEnd = matrixEnd;
            }
            this.fillData.append("\tvar fimg = ctrans.applyToImage(imageObj").append(bitmapId).append(");\r\n");
            this.fillData.append("\tvar pat=ctx.createPattern(fimg,\"repeat\");\r\n");
            this.fillData.append("\tctx.fillStyle = pat;\r\n");
        }
    }

    @Override
    public void endFill() {
        this.finalizePath();
    }

    @Override
    public void lineStyle(double thickness, double thicknessEnd, RGB color, RGB colorEnd, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit, boolean noClose) {
        this.finalizePath();
        thickness /= 20.0;
        thicknessEnd /= 20.0;
        this.strokeData.append("\tvar scaleMode = \"").append(scaleMode).append("\";\r\n");
        if (color != null) {
            this.strokeData.append("\tctx.strokeStyle=").append(this.useRatioColor(color, colorEnd)).append(";\r\n");
        }
        this.strokeData.append("\tctx.lineWidth=").append(this.useRatioDouble(thickness, thicknessEnd)).append(";\r\n");
        switch (startCaps) {
            case 1: {
                this.strokeData.append("\tctx.lineCap=\"butt\";\r\n");
                break;
            }
            case 2: {
                this.strokeData.append("\tctx.lineCap=\"square\";\r\n");
                break;
            }
            default: {
                this.strokeData.append("\tctx.lineCap=\"round\";\r\n");
            }
        }
        switch (joints) {
            case 1: {
                this.strokeData.append("\tctx.lineJoin=\"bevel\";\r\n");
                break;
            }
            case 0: {
                this.strokeData.append("\tctx.lineJoin=\"round\";\r\n");
                break;
            }
            default: {
                this.strokeData.append("\tctx.lineJoin=\"miter\";\r\n");
                this.strokeData.append("\tctx.miterLimit=").append(miterLimit).append(";\r\n");
            }
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, GRADRECORD[] gradientRecordsEnd, Matrix matrix, Matrix matrixEnd, int spreadMethod, int interpolationMethod, float focalPointRatio, float focalPointRatioEnd) {
        this.lineFillData = new StringBuilder();
        int REPEAT_CNT = 5;
        int n = this.lineRepeatCnt = spreadMethod == 0 ? 0 : 5;
        if (type == 16) {
            Point start = matrix.transform(new Point(-16384 - 32768 * this.repeatCnt, 0.0));
            Point end = matrix.transform(new Point(16384 + 32768 * this.repeatCnt, 0.0));
            start.x += this.deltaX;
            start.y += this.deltaY;
            end.x += this.deltaX;
            end.y += this.deltaY;
            Point start2 = matrixEnd.transform(new Point(-16384 - 32768 * this.repeatCnt, 0.0));
            Point end2 = matrixEnd.transform(new Point(16384 + 32768 * this.repeatCnt, 0.0));
            start2.x += this.deltaX;
            start2.y += this.deltaY;
            end2.x += this.deltaX;
            end2.y += this.deltaY;
            this.lineFillData.append("\tvar grd=ctx.createLinearGradient(").append(this.useRatioPos(start.x, start2.x)).append(",").append(this.useRatioPos(start.y, start2.y)).append(",").append(this.useRatioPos(end.x, end2.x)).append(",").append(this.useRatioPos(end.y, end2.y)).append(");\r\n");
        } else {
            this.lineFillMatrix = matrix;
            this.lineFillMatrixEnd = matrixEnd;
            this.lineFillData.append("\tvar grd=ctx.createRadialGradient(").append(this.useRatioDouble(focalPointRatio * 16384.0f, focalPointRatioEnd * 16384.0f)).append(",0,0,0,0,").append(16384 + 32768 * this.repeatCnt).append(");\r\n");
        }
        int repeatTotal = this.lineRepeatCnt * 2 + 1;
        double oneHeight = 1.0 / (double)repeatTotal;
        double pos = 0.0;
        boolean revert = false;
        if (type != 16 && spreadMethod == 1) {
            revert = true;
        }
        for (int i = 0; i < repeatTotal; ++i) {
            if (spreadMethod == 1) {
                revert = !revert;
            }
            for (int j = 0; j < gradientRecords.length; ++j) {
                GRADRECORD r = gradientRecords[j];
                GRADRECORD r2 = gradientRecordsEnd[j];
                this.lineFillData.append("\tvar s=").append(this.useRatioDouble(pos + oneHeight * (double)(revert ? 255 - r.ratio : r.ratio) / 255.0, pos + oneHeight * (double)(revert ? 255 - r2.ratio : r2.ratio) / 255.0)).append(";\r\n");
                this.lineFillData.append("\tif(s<0) s = 0;\r\n\tif(s>1) s = 1;\r\n");
                this.lineFillData.append("\tgrd.addColorStop(s,").append(this.useRatioColor(r.color, r2.color)).append(");\r\n");
                this.lineLastGradColor = this.useRatioColor(r.color, r2.color);
            }
            pos += oneHeight;
        }
        this.lineFillData.append("\tctx.fillStyle = grd;\r\n");
        String preStrokeData = "";
        preStrokeData = preStrokeData + "\tvar lcanvas = document.createElement(\"canvas\");\r\n";
        preStrokeData = preStrokeData + "\tlcanvas.width = canvas.width;\r\n";
        preStrokeData = preStrokeData + "\tlcanvas.height=canvas.height;\r\n";
        preStrokeData = preStrokeData + "\tvar lctx = lcanvas.getContext(\"2d\");\r\n";
        preStrokeData = preStrokeData + "\tenhanceContext(lctx);\r\n";
        preStrokeData = preStrokeData + "\tlctx.applyTransforms(ctx._matrix);\r\n";
        preStrokeData = preStrokeData + "\tctx = lctx;\r\n";
        this.strokeData.insert(0, preStrokeData);
    }

    @Override
    public void moveTo(double x, double y, double x2, double y2) {
        this.currentDrawCommand = DRAW_COMMAND_M;
        this.pathData.append(this.currentDrawCommand).append(" ");
        this.pathData.append(Helper.doubleStr((x += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((x2 += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y2 += this.deltaY) / this.unitDivisor)).append(" ");
    }

    @Override
    public void lineTo(double x, double y, double x2, double y2) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_L)) {
            this.currentDrawCommand = DRAW_COMMAND_L;
            this.pathData.append(this.currentDrawCommand).append(" ");
        }
        this.pathData.append(Helper.doubleStr((x += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((x2 += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y2 += this.deltaY) / this.unitDivisor)).append(" ");
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY, double controlX2, double controlY2, double anchorX2, double anchorY2) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_Q)) {
            this.currentDrawCommand = DRAW_COMMAND_Q;
            this.pathData.append(this.currentDrawCommand).append(" ");
        }
        this.pathData.append(Helper.doubleStr((controlX += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((controlX2 += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((controlY += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((controlY2 += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorX += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorX2 += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorY += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorY2 += this.deltaY) / this.unitDivisor)).append(" ");
    }

    protected void finalizePath() {
        if (this.pathData != null && this.pathData.length() > 0) {
            this.shapeData.append("\tvar pathData=\"").append(this.pathData.toString().trim()).append("\";\r\n");
            String drawStroke = "\tdrawMorphPath(ctx,pathData,ratio,true,scaleMode);\r\n";
            String drawFill = "\tdrawMorphPath(ctx,pathData,ratio,false);\r\n";
            this.pathData = new StringBuilder();
            if (this.lineFillData != null) {
                StringBuilder preLineFillData = new StringBuilder();
                preLineFillData.append("\tvar oldctx = ctx;\r\n");
                preLineFillData.append("\tctx.save();\r\n");
                preLineFillData.append((CharSequence)this.strokeData);
                preLineFillData.append(drawStroke);
                preLineFillData.append("\tvar lfcanvas = document.createElement(\"canvas\");\r\n");
                preLineFillData.append("\tlfcanvas.width = canvas.width;\r\n");
                preLineFillData.append("\tlfcanvas.height = canvas.height;\r\n");
                preLineFillData.append("\tvar lfctx = lfcanvas.getContext(\"2d\");\r\n");
                preLineFillData.append("\tenhanceContext(lfctx);\r\n");
                preLineFillData.append("\tlfctx.applyTransforms(ctx._matrix);\r\n");
                preLineFillData.append("\tctx = lfctx;");
                if (this.lineLastGradColor != null) {
                    preLineFillData.append("\tctx.fillStyle=").append(this.lineLastGradColor).append(";\r\n ctx.fill(\"evenodd\");\r\n");
                }
                preLineFillData.append("\tctx.transform(").append(this.useRatioDouble(this.lineFillMatrix.scaleX / this.unitDivisor, this.lineFillMatrixEnd.scaleX / this.unitDivisor)).append(",").append(this.useRatioDouble(this.lineFillMatrix.rotateSkew0 / this.unitDivisor, this.lineFillMatrixEnd.rotateSkew0 / this.unitDivisor)).append(",").append(this.useRatioDouble(this.lineFillMatrix.rotateSkew1 / this.unitDivisor, this.lineFillMatrixEnd.rotateSkew1 / this.unitDivisor)).append(",").append(this.useRatioDouble(this.lineFillMatrix.scaleY / this.unitDivisor, this.lineFillMatrixEnd.scaleY / this.unitDivisor)).append(",").append(this.useRatioDouble((this.lineFillMatrix.translateX + this.deltaX) / this.unitDivisor, (this.lineFillMatrixEnd.translateX + this.deltaX) / this.unitDivisor)).append(",").append(this.useRatioDouble((this.lineFillMatrix.translateY + this.deltaY) / this.unitDivisor, (this.lineFillMatrixEnd.translateY + this.deltaY) / this.unitDivisor)).append(");\r\n");
                this.lineFillData.insert(0, preLineFillData);
                this.lineFillData.append("\tctx.fillRect(").append(-16384 - 32768 * this.lineRepeatCnt).append(",").append(-16384 - 32768 * this.lineRepeatCnt).append(",").append(32768 + 65536 * this.lineRepeatCnt).append(",").append(32768 + 65536 * this.lineRepeatCnt).append(");\r\n");
                this.lineFillData.append("\tctx = oldctx;\r\n");
                this.lineFillData.append("\tvar limgd = lctx.getImageData(0, 0, lcanvas.width, lcanvas.height);\r\n\tvar lpix = limgd.data;\r\n\tvar lfimgd = lfctx.getImageData(0, 0, lfcanvas.width, lfcanvas.height);\r\n\tvar lfpix = lfimgd.data;\r\n\tvar imgd = ctx.getImageData(0, 0, canvas.width, canvas.height);\r\n\tvar pix = imgd.data;\r\n\tfor (var i = 0; i < lpix.length; i += 4) {\r\n\t\tif(lpix[i+3]>0){ pix[i] = lfpix[i]; pix[i+1] = lfpix[i+1]; pix[i+2] = lfpix[i+2]; pix[i+3] = lfpix[i+3];}\r\n\t}\r\n\tctx.putImageData(imgd, 0, 0);\r\n");
                this.lineFillData.append("\tctx.restore();\r\n");
                this.strokeData = new StringBuilder();
            } else {
                this.pathData.append((CharSequence)this.strokeData);
            }
            if (this.fillMatrix != null) {
                this.pathData.append(drawFill);
                if (this.lastGradColor != null) {
                    this.pathData.append("\tctx.fillStyle=").append(this.lastGradColor).append(";\r\n\tctx.fill(\"evenodd\");\r\n");
                }
                this.pathData.append("\tctx.save();\r\n");
                this.pathData.append("\tctx.clip();\r\n");
                this.pathData.append("\tctx.transform(").append(this.useRatioDouble(this.fillMatrix.scaleX / this.unitDivisor, this.fillMatrixEnd.scaleX / this.unitDivisor)).append(",").append(this.useRatioDouble(this.fillMatrix.rotateSkew0 / this.unitDivisor, this.fillMatrixEnd.rotateSkew0 / this.unitDivisor)).append(",").append(this.useRatioDouble(this.fillMatrix.rotateSkew1 / this.unitDivisor, this.fillMatrixEnd.rotateSkew1 / this.unitDivisor)).append(",").append(this.useRatioDouble(this.fillMatrix.scaleY / this.unitDivisor, this.fillMatrixEnd.scaleY / this.unitDivisor)).append(",").append(this.useRatioDouble((this.fillMatrix.translateX + this.deltaX) / this.unitDivisor, (this.fillMatrixEnd.translateX + this.deltaX) / this.unitDivisor)).append(",").append(this.useRatioDouble((this.fillMatrix.translateY + this.deltaY) / this.unitDivisor, (this.fillMatrixEnd.translateY + this.deltaY) / this.unitDivisor)).append(");\r\n");
                if (this.fillWidth > 0) {
                    double s_w = (double)(this.fillWidth + 1) / (double)this.fillWidth;
                    double s_h = (double)(this.fillHeight + 1) / (double)this.fillHeight;
                    this.pathData.append("\tctx.transform(").append(s_w).append(",0,0,").append(s_h).append(",-0.5,-0.5);\r\n");
                }
                this.pathData.append((CharSequence)this.fillData);
                this.pathData.append("\tctx.fillRect(").append(-16384 - 32768 * this.repeatCnt).append(",").append(-16384 - 32768 * this.repeatCnt).append(",").append(32768 + 65536 * this.repeatCnt).append(",").append(32768 + 65536 * this.repeatCnt).append(");\r\n");
                this.pathData.append("\tctx.restore();\r\n");
                this.shapeData.append((CharSequence)this.pathData);
            } else {
                if (this.fillData != null && this.fillData.length() > 0) {
                    this.pathData.append(drawFill).append("\r\n\tctx.fill(\"evenodd\");\r\n");
                }
                this.shapeData.append((CharSequence)this.fillData).append((CharSequence)this.pathData);
            }
            if (this.strokeData != null && this.strokeData.length() > 0) {
                this.shapeData.append(drawStroke).append("\r\n");
            } else if (this.lineFillData != null) {
                this.shapeData.append((CharSequence)this.lineFillData);
            }
        }
        this.repeatCnt = 0;
        this.pathData = new StringBuilder();
        this.fillData = new StringBuilder();
        this.strokeData = new StringBuilder();
        this.fillMatrix = null;
        this.fillMatrixEnd = null;
        this.lastGradColor = null;
        this.lineRepeatCnt = 0;
        this.lineFillData = null;
        this.lineLastGradColor = null;
        this.lineFillMatrix = null;
        this.lineFillMatrixEnd = null;
        this.fillWidth = 0;
        this.fillHeight = 0;
    }

    private String useRatioPos(double a, double b) {
        return Helper.doubleStr(a / this.unitDivisor) + "+ratio*(" + Helper.doubleStr((b - a) / this.unitDivisor) + ")/" + 65535;
    }

    private String useRatioInt(int a, int b) {
        return "Math.round(" + a + "+ratio*(" + (b - a) + ")/" + 65535 + ")";
    }

    private String useRatioDouble(double a, double b) {
        return "" + a + "+ratio*(" + Helper.doubleStr(b - a) + ")/" + 65535;
    }

    public String getShapeData() {
        return this.shapeData.toString();
    }

    private String useRatioColor(RGB color, RGB colorEnd) {
        return "tocolor(ctrans.apply([" + this.useRatioInt(color.red, colorEnd.red) + "," + this.useRatioInt(color.green, colorEnd.green) + "," + this.useRatioInt(color.blue, colorEnd.blue) + ",((" + this.useRatioInt(color instanceof RGBA ? ((RGBA)color).alpha : 255, colorEnd instanceof RGBA ? ((RGBA)colorEnd).alpha : 255) + ")/255)]))";
    }

    @Override
    public void lineBitmapStyle(int bitmapId, Matrix matrix, Matrix matrixEnd, boolean repeat, boolean smooth, ColorTransform colorTransform) {
    }
}

