/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.script.ExportScriptTask;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ProgressListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AS2ScriptExporter {
    private static final Logger logger = Logger.getLogger(AS2ScriptExporter.class.getName());

    public List<File> exportActionScript2(SWF swf, AbortRetryIgnoreHandler handler, String outdir, ScriptExportSettings exportSettings, boolean parallel, EventListener evl) throws IOException {
        return this.exportAS2Scripts(handler, outdir, swf.getASMs(true), exportSettings, parallel, evl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> exportAS2Scripts(AbortRetryIgnoreHandler handler, String outdir, Map<String, ASMSource> asms, ScriptExportSettings exportSettings, boolean parallel, final EventListener evl) throws IOException {
        final ArrayList<File> ret = new ArrayList<File>();
        if (!outdir.endsWith(File.separator)) {
            outdir = outdir + File.separator;
        }
        HashMap existingNamesMap = new HashMap();
        int cnt = 1;
        final ArrayList<ExportScriptTask> tasks = new ArrayList<ExportScriptTask>();
        String[] keys = asms.keySet().toArray(new String[asms.size()]);
        HashSet<SWF> swfsThatNeedUninitializedClassTraitsDetection = new HashSet<SWF>();
        for (String key : keys) {
            ASMSource asm = asms.get(key);
            if (!asm.getSwf().needsCalculatingAS2UninitializeClassTraits(asm)) continue;
            swfsThatNeedUninitializedClassTraitsDetection.add(asm.getSwf());
        }
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void progress(int p) {
            }

            @Override
            public void status(String status) {
                if (evl != null) {
                    evl.handleEvent("uninitializedClassFields", status);
                }
            }
        };
        for (SWF swf : swfsThatNeedUninitializedClassTraitsDetection) {
            swf.getUninitializedClassFieldsDetector().addProgressListener(progressListener);
        }
        try {
            for (SWF swf : swfsThatNeedUninitializedClassTraitsDetection) {
                swf.calculateAs2UninitializedClassTraits();
            }
        }
        catch (InterruptedException ie) {
            return ret;
        }
        try {
            for (String key : keys) {
                ASMSource asm = asms.get(key);
                String currentOutDir = outdir + key + File.separator;
                ArrayList<String> existingNames = (ArrayList<String>)existingNamesMap.get(currentOutDir = new File(currentOutDir).getParentFile().toString() + File.separator);
                if (existingNames == null) {
                    existingNames = new ArrayList<String>();
                    existingNamesMap.put(currentOutDir, existingNames);
                }
                String name = Helper.makeFileName(asm.getExportFileName());
                int i = 1;
                String baseName = name;
                while (existingNames.contains(name)) {
                    name = baseName + "_" + ++i;
                }
                existingNames.add(name);
                tasks.add(new ExportScriptTask(handler, cnt++, asms.size(), name, asm, currentOutDir, exportSettings, evl));
            }
            if (!parallel || tasks.size() < 2) {
                try {
                    CancellableWorker.call("as2scriptexport", new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            for (ExportScriptTask task : tasks) {
                                if (CancellableWorker.isInterrupted()) {
                                    throw new InterruptedException();
                                }
                                ret.add(task.call());
                            }
                            return null;
                        }
                    }, Configuration.exportTimeout.get().intValue(), TimeUnit.SECONDS);
                }
                catch (TimeoutException ex) {
                    logger.log(Level.SEVERE, Helper.formatTimeToText(Configuration.exportTimeout.get()) + " ActionScript export limit reached", ex);
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.log(Level.SEVERE, "Error during AS2 export", ex);
                }
            } else {
                ExecutorService executor = Executors.newFixedThreadPool(Configuration.getParallelThreadCount());
                ArrayList<Future<File>> futureResults = new ArrayList<Future<File>>();
                for (ExportScriptTask task : tasks) {
                    Future<File> future = executor.submit(task);
                    futureResults.add(future);
                }
                try {
                    executor.shutdown();
                    if (!executor.awaitTermination(Configuration.exportTimeout.get().intValue(), TimeUnit.SECONDS)) {
                        logger.log(Level.SEVERE, "{0} ActionScript export limit reached", Helper.formatTimeToText(Configuration.exportTimeout.get()));
                        for (ExportScriptTask task : tasks) {
                            CancellableWorker.cancelThread(task.thread);
                        }
                    }
                }
                catch (InterruptedException key) {
                }
                finally {
                    executor.shutdownNow();
                }
                for (int f = 0; f < futureResults.size(); ++f) {
                    try {
                        if (!((Future)futureResults.get(f)).isDone()) continue;
                        ret.add((File)((Future)futureResults.get(f)).get());
                        continue;
                    }
                    catch (InterruptedException task) {
                        continue;
                    }
                    catch (ExecutionException ex) {
                        if (ex.getCause() instanceof InterruptedException) continue;
                        logger.log(Level.SEVERE, "Error during ActionScript export", ex);
                    }
                }
            }
            ArrayList<File> arrayList = ret;
            return arrayList;
        }
        finally {
            for (SWF swf : swfsThatNeedUninitializedClassTraitsDetection) {
                swf.getUninitializedClassFieldsDetector().removeProgressListener(progressListener);
            }
        }
    }
}

