/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Deobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.AlchemyTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructPropIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewClassIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetLexIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetOuterScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushScopeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.InitVectorAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyType;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DependencyParser {
    public static void parseDependenciesFromNS(AbcIndexing abcIndex, String ignoredCustom, ABC abc, List<Dependency> dependencies, int namespace_index, DottedChain ignorePackage, String name, DependencyType dependencyType, List<String> uses) {
        String nsVal;
        DottedChain nsimport;
        Namespace ns = abc.constants.getNamespace(namespace_index);
        if (name.isEmpty()) {
            name = "*";
        }
        DottedChain newimport = ns.getName(abc.constants);
        if ((ns.kind == 8 || ns.kind == 23) && (nsimport = abcIndex.nsValueToName(nsVal = ns.getName(abc.constants).toRawString())) != null) {
            if (nsimport.equals(AVM2Deobfuscation.BUILTIN)) {
                return;
            }
            if (!uses.contains(nsimport.getLast())) {
                uses.add(nsimport.getLast());
            }
            if (!nsimport.isEmpty()) {
                Dependency depNs = new Dependency(nsimport, DependencyType.NAMESPACE);
                if (!(ignorePackage != null && nsimport.getWithoutLast().equals(ignorePackage) || dependencies.contains(depNs))) {
                    dependencies.add(depNs);
                }
                if (ignoredCustom != null && nsVal.equals(ignoredCustom)) {
                    return;
                }
                return;
            }
        }
        if (dependencyType == DependencyType.NAMESPACE) {
            return;
        }
        if (ns.kind != 22) {
            return;
        }
        Dependency dep = new Dependency(newimport = newimport.addWithSuffix(name), dependencyType);
        if (!dependencies.contains(dep)) {
            DottedChain pkg = newimport.getWithoutLast();
            if (pkg.equals(InitVectorAVM2Item.VECTOR_PACKAGE)) {
                return;
            }
            dependencies.add(dep);
        }
    }

    public static void parseDependenciesFromMultiname(Set<String> usedDeobfuscations, AbcIndexing abcIndex, String ignoredCustom, ABC abc, List<Dependency> dependencies, Multiname m, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, DependencyType dependencyType, List<String> uses) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(m.qname_index), ignorePackage, fullyQualifiedNames, dependencyType, uses);
                }
                int[] nArray = m.params;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (i2 == 0) continue;
                    DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(i2), ignorePackage, fullyQualifiedNames, dependencyType, uses);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(usedDeobfuscations, abc, abc.constants, fullyQualifiedNames, true, true);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null && !m.doesDisplayNamespace()) {
                DependencyParser.parseDependenciesFromNS(abcIndex, ignoredCustom, abc, dependencies, m.namespace_index, ignorePackage, name, dependencyType, uses);
            }
            if (nss != null) {
                for (int n : nss.namespaces) {
                    DependencyParser.parseDependenciesFromNS(abcIndex, ignoredCustom, abc, dependencies, n, ignorePackage, nss.namespaces.length > 1 ? "" : name, dependencyType, uses);
                }
            }
        }
    }

    public static void parseDependenciesFromMethodInfo(Set<String> usedDeobfuscations, AbcIndexing abcIndex, Trait trait, int scriptIndex, int classIndex, boolean isStatic, String ignoredCustom, ABC abc, int method_index, List<Dependency> dependencies, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, List<Integer> visitedMethods, List<String> uses, Reference<Integer> numberContextRef) throws InterruptedException {
        if (method_index < 0 || method_index >= abc.method_info.size()) {
            return;
        }
        visitedMethods.add(method_index);
        if (abc.method_info.get((int)method_index).ret_type != 0) {
            DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(abc.method_info.get((int)method_index).ret_type), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE, uses);
        }
        for (int t : abc.method_info.get((int)method_index).param_types) {
            if (t == 0) continue;
            DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(t), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE, uses);
        }
        MethodBody body = abc.findBody(method_index);
        if (body != null && body.convertException == null) {
            body = body.convertMethodBodyCanUseLast(Configuration.autoDeobfuscate.get(), "", isStatic, scriptIndex, classIndex, abc, trait);
            body.traits.getDependencies(usedDeobfuscations, abcIndex, scriptIndex, classIndex, isStatic, ignoredCustom, abc, dependencies, ignorePackage, fullyQualifiedNames, uses, numberContextRef);
            for (ABCException ex : body.exceptions) {
                DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(ex.type_index), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION, uses);
            }
            boolean hasNewClass = false;
            if (classIndex == -1) {
                for (int i = 0; i < body.getCode().code.size(); ++i) {
                    AVM2Instruction ins = body.getCode().code.get(i);
                    if (!(ins.definition instanceof NewClassIns)) continue;
                    hasNewClass = true;
                    break;
                }
            }
            boolean wasNewClass = false;
            AVM2Instruction prevIns = null;
            for (int i = 0; i < body.getCode().code.size(); ++i) {
                Multiname m;
                DottedChain nimport;
                Dependency depExp;
                AVM2Instruction ins = body.getCode().code.get(i);
                if (classIndex == -1 && hasNewClass && !wasNewClass) {
                    if (!(ins.definition instanceof NewClassIns)) continue;
                    wasNewClass = true;
                    continue;
                }
                if (ins.definition instanceof GetLexIns) {
                    boolean foundNewClass = false;
                    for (int j = i + 1; j < body.getCode().code.size(); ++j) {
                        AVM2Instruction insJ = body.getCode().code.get(j);
                        if (insJ.definition instanceof NewClassIns) {
                            foundNewClass = true;
                            break;
                        }
                        if (!(ins.definition instanceof GetLexIns) && !(ins.definition instanceof PushScopeIns)) break;
                    }
                    if (foundNewClass) continue;
                }
                if (ins.definition instanceof AlchemyTypeIns && !dependencies.contains(depExp = new Dependency(nimport = AlchemyTypeIns.ALCHEMY_PACKAGE.addWithSuffix(ins.definition.instructionName), DependencyType.EXPRESSION))) {
                    dependencies.add(depExp);
                }
                if (ins.definition instanceof NewFunctionIns && ins.operands[0] != method_index && !visitedMethods.contains(ins.operands[0])) {
                    DependencyParser.parseDependenciesFromMethodInfo(usedDeobfuscations, abcIndex, trait, scriptIndex, classIndex, isStatic, ignoredCustom, abc, ins.operands[0], dependencies, ignorePackage, fullyQualifiedNames, visitedMethods, uses, numberContextRef);
                }
                if (ins.definition instanceof ConstructPropIns && (m = abc.constants.getMultiname(ins.operands[0])) != null && m.kind == 27) {
                    Dependency dep = new Dependency(DottedChain.parseNoSuffix("flash.utils.getDefinitionByName"), DependencyType.NAMESPACE);
                    dependencies.add(dep);
                }
                if (ins.definition instanceof ConstructIns && prevIns != null && prevIns.definition instanceof GetPropertyIns && (m = abc.constants.getMultiname(prevIns.operands[0])) != null && m.kind == 27) {
                    Dependency dep = new Dependency(DottedChain.parseNoSuffix("flash.utils.getDefinitionByName"), DependencyType.NAMESPACE);
                    dependencies.add(dep);
                }
                if (classIndex > -1 && ins.definition instanceof GetOuterScopeIns && ins.operands[0] > 0) {
                    DottedChain type = abc.instance_info.get(classIndex).getName(abc.constants).getNameWithNamespace(usedDeobfuscations, abc, abc.constants, true);
                    AbcIndexing.ClassIndex cls = abcIndex.findClass(new TypeItem(type), abc, scriptIndex);
                    ArrayList<AbcIndexing.ClassIndex> clsList = new ArrayList<AbcIndexing.ClassIndex>();
                    cls = cls.parent;
                    while (cls != null) {
                        clsList.add(0, cls);
                        cls = cls.parent;
                    }
                    if (ins.operands[0] < 1 + clsList.size()) {
                        AbcIndexing.ClassIndex cls2 = (AbcIndexing.ClassIndex)clsList.get(ins.operands[0] - 1);
                        DottedChain nimport2 = cls2.abc.instance_info.get(cls2.index).getName(cls2.abc.constants).getNameWithNamespace(usedDeobfuscations, cls2.abc, cls2.abc.constants, true);
                        Dependency depExp2 = new Dependency(nimport2, DependencyType.EXPRESSION);
                        if (!dependencies.contains(depExp2)) {
                            dependencies.add(depExp2);
                        }
                    }
                }
                for (int k = 0; k < ins.definition.operands.length; ++k) {
                    int m2;
                    if (ins.definition.operands[k] == 257 && (m2 = ins.operands[k]) < abc.constants.getMultinameCount()) {
                        DependencyParser.parseDependenciesFromMultiname(usedDeobfuscations, abcIndex, ignoredCustom, abc, dependencies, abc.constants.getMultiname(m2), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION, uses);
                    }
                    if (ins.definition.operands[k] != 275) continue;
                    numberContextRef.setVal(ins.operands[k]);
                }
                prevIns = ins;
            }
        }
    }
}

